/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.todo;

import cn.gitlab.kilo.jetbrains.composer.TodoItem;
import cn.gitlab.kilo.jetbrains.composer.TodoItemKt;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import cn.gitlab.kilo.jetbrains.composer.tools.todo.TodoListUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0094@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u0011H\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/todo/UpdateTodoListTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "getRequiredParameters", "", "", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "parseFlexibleTodos", "Lcn/gitlab/kilo/jetbrains/composer/TodoItem;", "input", "jsonArrayToTodos", "arr", "Lcom/google/gson/JsonArray;", "ensureTodoItem", "item", "toWireMap", "", "", "getAsJsonPrimitiveOrNull", "Lcom/google/gson/JsonPrimitive;", "Lcom/google/gson/JsonObject;", "key", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nUpdateTodoListTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateTodoListTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/todo/UpdateTodoListTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1563#2:286\n1634#2,3:287\n1563#2:290\n1634#2,3:291\n1563#2:294\n1634#2,3:295\n1563#2:298\n1634#2,3:299\n1563#2:302\n1634#2,3:303\n1#3:306\n*S KotlinDebug\n*F\n+ 1 UpdateTodoListTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/todo/UpdateTodoListTool\n*L\n28#1:286\n28#1:287,3\n32#1:290\n32#1:291,3\n40#1:294\n40#1:295,3\n56#1:298\n56#1:299,3\n66#1:302\n66#1:303,3\n*E\n"})
public final class UpdateTodoListTool
extends BaseToolExecutor {
    @NotNull
    private final Gson gson = new Gson();

    public UpdateTodoListTool() {
        super(ToolName.UPDATE_TODO_LIST);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        return CollectionsKt.listOf((Object)"todos");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext var1_1, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return "## update_todo_list\n\n**Description:**\nReplace the entire TODO list with an updated checklist reflecting the current state. Always provide the full list; the system will overwrite the previous one. This tool is designed for step-by-step task tracking, allowing you to confirm completion of each step before updating, update multiple task statuses at once (e.g., mark one as completed and start the next), and dynamically add new todos discovered during long or complex tasks.\n\n**Checklist Format:**\n- Use a single-level markdown checklist (no nesting or subtasks).\n- List todos in the intended execution order.\n- Status options:\n\t - [ ] Task description (pending)\n\t - [x] Task description (completed)\n\t - [-] Task description (in progress)\n\n**Status Rules:**\n- [ ] = pending (not started)\n- [x] = completed (fully finished, no unresolved issues)\n- [-] = in_progress (currently being worked on)\n\n**Core Principles:**\n- Before updating, always confirm which todos have been completed since the last update.\n- You may update multiple statuses in a single update (e.g., mark the previous as completed and the next as in progress).\n- When a new actionable item is discovered during a long or complex task, add it to the todo list immediately.\n- Do not remove any unfinished todos unless explicitly instructed.\n- Always retain all unfinished tasks, updating their status as needed.\n- Only mark a task as completed when it is fully accomplished (no partials, no unresolved dependencies).\n- If a task is blocked, keep it as in_progress and add a new todo describing what needs to be resolved.\n- Remove tasks only if they are no longer relevant or if the user requests deletion.\n\n**Usage Example:**\n<update_todo_list>\n<todos>\n[x] Analyze requirements\n[x] Design architecture\n[-] Implement core logic\n[ ] Write tests\n[ ] Update documentation\n</todos>\n</update_todo_list>\n\n*After completing \"Implement core logic\" and starting \"Write tests\":*\n<update_todo_list>\n<todos>\n[x] Analyze requirements\n[x] Design architecture\n[x] Implement core logic\n[-] Write tests\n[ ] Update documentation\n[ ] Add performance benchmarks\n</todos>\n</update_todo_list>\n\n**When to Use:**\n- The task is complicated or involves multiple steps or requires ongoing tracking.\n- You need to update the status of several todos at once.\n- New actionable items are discovered during task execution.\n- The user requests a todo list or provides multiple tasks.\n- The task is complex and benefits from clear, stepwise progress tracking.\n\n**When NOT to Use:**\n- There is only a single, trivial task.\n- The task can be completed in one or two simple steps.\n- The request is purely conversational or informational.\n\n**Task Management Guidelines:**\n- Mark task as completed immediately after all work of the current task is done.\n- Start the next task by marking it as in_progress.\n- Add new todos as soon as they are identified.\n- Use clear, descriptive task names.";
    }

    /*
     * WARNING - void declaration
     */
    private final List<TodoItem> parseFlexibleTodos(String input) {
        Object object;
        Object $this$parseFlexibleTodos_u24lambda_u247;
        Object $this$parseFlexibleTodos_u24lambda_u245;
        if (StringsKt.isBlank((CharSequence)input)) {
            return CollectionsKt.emptyList();
        }
        Object object2 = this;
        try {
            $this$parseFlexibleTodos_u24lambda_u245 = object2;
            boolean bl = false;
            $this$parseFlexibleTodos_u24lambda_u245 = Result.constructor-impl((Object)JsonParser.parseString((String)input));
        }
        catch (Throwable bl) {
            $this$parseFlexibleTodos_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$parseFlexibleTodos_u24lambda_u245;
        JsonElement asJson = (JsonElement)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (asJson != null && !asJson.isJsonNull()) {
            if (asJson.isJsonObject()) {
                void $this$parseFlexibleTodos_u24lambda_u246;
                JsonElement arr;
                JsonObject obj2 = asJson.getAsJsonObject();
                if (obj2.has("todos") && (arr = obj2.get("todos")).isJsonArray()) {
                    JsonArray jsonArray = arr.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    return this.jsonArrayToTodos(jsonArray);
                }
                JsonElement bl = arr = new JsonArray();
                UpdateTodoListTool updateTodoListTool = this;
                boolean bl2 = false;
                $this$parseFlexibleTodos_u24lambda_u246.add((JsonElement)obj2);
                return updateTodoListTool.jsonArrayToTodos((JsonArray)arr);
            }
            if (asJson.isJsonArray()) {
                JsonArray jsonArray = asJson.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                return this.jsonArrayToTodos(jsonArray);
            }
        }
        object2 = this;
        try {
            $this$parseFlexibleTodos_u24lambda_u247 = (UpdateTodoListTool)object2;
            boolean bl = false;
            $this$parseFlexibleTodos_u24lambda_u247 = Result.constructor-impl(TodoListUtils.INSTANCE.parseMarkdownChecklist(input));
        }
        catch (Throwable bl) {
            $this$parseFlexibleTodos_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$parseFlexibleTodos_u24lambda_u247;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        return (List)object;
    }

    private final List<TodoItem> jsonArrayToTodos(JsonArray arr) {
        List out = new ArrayList();
        Iterator iterator = arr.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            JsonObject o;
            block8: {
                block7: {
                    Object object2;
                    JsonElement el = (JsonElement)iterator2.next();
                    if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
                        String string = el.getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                        String content2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        if (!(((CharSequence)content2).length() > 0)) continue;
                        Collection collection = out;
                        String string2 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        collection.add(new TodoItem(string2, content2, TodoItem.TodoStatus.PENDING));
                        continue;
                    }
                    if (!el.isJsonObject()) continue;
                    o = el.getAsJsonObject();
                    Intrinsics.checkNotNull((Object)o);
                    object = this.getAsJsonPrimitiveOrNull(o, "id");
                    if (object == null || (object = object.getAsString()) == null) break block7;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
                    if (object != null) break block8;
                }
                String string = UUID.randomUUID().toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            Object id = object;
            Object object3 = this.getAsJsonPrimitiveOrNull(o, "content");
            if (object3 == null || (object3 = object3.getAsString()) == null) {
                JsonPrimitive jsonPrimitive = this.getAsJsonPrimitiveOrNull(o, "text");
                object3 = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
                if (object3 == null) {
                    object3 = "";
                }
            }
            String content3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
            JsonPrimitive jsonPrimitive = this.getAsJsonPrimitiveOrNull(o, "status");
            String statusStr = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
            JsonPrimitive jsonPrimitive2 = this.getAsJsonPrimitiveOrNull(o, "done");
            Boolean done = jsonPrimitive2 != null ? Boolean.valueOf(jsonPrimitive2.getAsBoolean()) : null;
            JsonPrimitive jsonPrimitive3 = this.getAsJsonPrimitiveOrNull(o, "in_progress");
            Boolean inProgress = jsonPrimitive3 != null ? Boolean.valueOf(jsonPrimitive3.getAsBoolean()) : null;
            TodoItem.TodoStatus status = TodoItemKt.mapStatus(statusStr, done, inProgress);
            if (!(((CharSequence)content3).length() > 0)) continue;
            ((Collection)out).add(new TodoItem((String)id, content3, status));
        }
        return out;
    }

    private final TodoItem ensureTodoItem(TodoItem item) {
        TodoItem.TodoStatus todoStatus;
        String content2;
        String string;
        String it = string = item.getId();
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        if (string2 == null) {
            String string3 = UUID.randomUUID().toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        String id = string2;
        String string4 = item.getContent();
        String string5 = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
        if (string5 == null) {
            string5 = content2 = "";
        }
        if ((todoStatus = item.getStatus()) == null) {
            todoStatus = TodoItem.TodoStatus.PENDING;
        }
        TodoItem.TodoStatus status = todoStatus;
        return new TodoItem(id, content2, status);
    }

    private final Map<String, Object> toWireMap(TodoItem $this$toWireMap) {
        Object object;
        Pair[] pairArray;
        block6: {
            block5: {
                pairArray = new Pair[3];
                String string = $this$toWireMap.getId();
                if (string == null) {
                    string = "";
                }
                pairArray[0] = TuplesKt.to((Object)"id", (Object)string);
                String string2 = $this$toWireMap.getContent();
                if (string2 == null) {
                    string2 = "";
                }
                pairArray[1] = TuplesKt.to((Object)"content", (Object)string2);
                object = $this$toWireMap.getStatus();
                if (object == null || (object = object.name()) == null) break block5;
                String string3 = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                object = string3;
                if (string3 != null) break block6;
            }
            object = "todo";
        }
        pairArray[2] = TuplesKt.to((Object)"status", (Object)object);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final JsonPrimitive getAsJsonPrimitiveOrNull(JsonObject $this$getAsJsonPrimitiveOrNull, String key) {
        return $this$getAsJsonPrimitiveOrNull.has(key) && $this$getAsJsonPrimitiveOrNull.get(key).isJsonPrimitive() ? $this$getAsJsonPrimitiveOrNull.getAsJsonPrimitive(key) : null;
    }
}

