/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.todo;

import cn.gitlab.kilo.jetbrains.composer.TodoItem;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0014\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/todo/TodoListUtils;", "", "<init>", "()V", "parseMarkdownChecklist", "", "Lcn/gitlab/kilo/jetbrains/composer/TodoItem;", "md", "", "todoListToMarkdown", "todos", "md5Hex", "s", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTodoListUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TodoListUtils.kt\ncn/gitlab/kilo/jetbrains/composer/tools/todo/TodoListUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1563#2:50\n1634#2,3:51\n774#2:54\n865#2,2:55\n*S KotlinDebug\n*F\n+ 1 TodoListUtils.kt\ncn/gitlab/kilo/jetbrains/composer/tools/todo/TodoListUtils\n*L\n13#1:50\n13#1:51,3\n14#1:54\n14#1:55,2\n*E\n"})
public final class TodoListUtils {
    @NotNull
    public static final TodoListUtils INSTANCE = new TodoListUtils();

    private TodoListUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TodoItem> parseMarkdownChecklist(@Nullable String md) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        CharSequence charSequence = md;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CollectionsKt.emptyList();
        }
        CharSequence charSequence2 = md;
        Regex regex = new Regex("\r?\n");
        int n = 0;
        Iterable $this$map$iv = regex.split(charSequence2, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        List result2 = new ArrayList();
        Regex pattern = new Regex("^(?:-\\s*)?\\[\\s*([ xX\\-~])\\s*]\\s+(.+)$");
        for (String line : lines) {
            String bl;
            MatchResult m;
            if (Regex.find$default((Regex)pattern, (CharSequence)line, (int)0, (int)2, null) == null) continue;
            String mark = (String)m.getGroupValues().get(1);
            String content2 = ((Object)StringsKt.trim((CharSequence)((String)m.getGroupValues().get(2)))).toString();
            Intrinsics.checkNotNullExpressionValue((Object)mark.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            int n2 = -1;
            switch (bl.hashCode()) {
                case 120: {
                    if (bl.equals("x")) {
                        n2 = 1;
                    }
                    break;
                }
                case 45: {
                    if (bl.equals("-")) {
                        n2 = 2;
                    }
                    break;
                }
                case 126: {
                    if (bl.equals("~")) {
                        n2 = 2;
                    }
                    break;
                }
            }
            TodoItem.TodoStatus status = switch (n2) {
                case 1 -> TodoItem.TodoStatus.COMPLETED;
                case 2 -> TodoItem.TodoStatus.IN_PROGRESS;
                default -> TodoItem.TodoStatus.PENDING;
            };
            String id = this.md5Hex(content2 + "|" + status);
            ((Collection)result2).add(new TodoItem(id, content2, status));
        }
        return result2;
    }

    @NotNull
    public final String todoListToMarkdown(@NotNull List<TodoItem> todos) {
        Intrinsics.checkNotNullParameter(todos, (String)"todos");
        return CollectionsKt.joinToString$default((Iterable)todos, (CharSequence)"\n", null, null, (int)0, null, TodoListUtils::todoListToMarkdown$lambda$2, (int)30, null);
    }

    private final String md5Hex(String s) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = md.digest(byArray);
        Intrinsics.checkNotNull((Object)bytes);
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, TodoListUtils::md5Hex$lambda$3, (int)30, null);
    }

    private static final CharSequence todoListToMarkdown$lambda$2(TodoItem t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String box = switch (WhenMappings.$EnumSwitchMapping$0[t.getStatus().ordinal()]) {
            case 1 -> "[x]";
            case 2 -> "[-]";
            case 3 -> "[ ]";
            default -> throw new NoWhenBranchMatchedException();
        };
        return box + " " + t.getContent();
    }

    private static final CharSequence md5Hex$lambda$3(byte b) {
        String string = "%02x";
        Object[] objectArray = new Object[]{b};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TodoItem.TodoStatus.values().length];
            try {
                nArray[TodoItem.TodoStatus.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TodoItem.TodoStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TodoItem.TodoStatus.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

