/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.memory;

import cn.gitlab.kilo.jetbrains.composer.Composer;
import cn.gitlab.kilo.jetbrains.composer.dto.ClineSay;
import cn.gitlab.kilo.jetbrains.composer.prompts.MemoryInfo;
import cn.gitlab.kilo.jetbrains.composer.prompts.ResponseUtil;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import cn.gitlab.kilo.jetbrains.editor.settings.SettingsEditorProvider;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0094@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/memory/CreateMemoryTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "memoryStorage", "Lcn/gitlab/kilo/jetbrains/config/UserMemoryStorage;", "getRequiredParameters", "", "", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "coderider-kilo-jetbrains"})
public final class CreateMemoryTool
extends BaseToolExecutor {
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final UserMemoryStorage memoryStorage = UserMemoryStorage.Companion.getInstance();

    public CreateMemoryTool() {
        super(ToolName.CREATE_MEMORY);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        Object[] objectArray = new String[]{"category", "content", "tags"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        String category = context.getParam("category");
        String content2 = context.getParam("content");
        if (category == null || content2 == null) {
            return Unit.INSTANCE;
        }
        if (this.memoryStorage.isIllegalCategory(category)) {
            Composer.say$default(context.getComposer(), ClineSay.error, category, null, null, null, null, null, null, 252, null);
            context.getComposer().pushToolResult(ResponseUtil.INSTANCE.toolError("\u751f\u6210\u8bb0\u5fc6\u5931\u8d25\uff0c\u8981\u6c42\u8bb0\u5fc6\u5185\u5bb9\u4e0e\u7f16\u7a0b\u4efb\u52a1\u65e0\u5173\u3002"), context.getBlock());
            return Unit.INSTANCE;
        }
        MemoryInfo userMemoryInfo = this.memoryStorage.getMemory(category);
        boolean isCreate = userMemoryInfo == null;
        String action = isCreate ? "created" : "updated";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tool", (Object)"memory_operation"), TuplesKt.to((Object)"action", (Object)action), TuplesKt.to((Object)"content", (Object)content2), TuplesKt.to((Object)"category", (Object)category)};
        Map sharedMessageProps = MapsKt.mapOf((Pair[])pairArray);
        if (context.isPartial()) {
            partialMessage = this.gson.toJson((Object)sharedMessageProps);
            context.getComposer().removeLastPartialMessageIfExistsWithType("ask", "tool");
            Composer.say$default(context.getComposer(), ClineSay.tool, (String)partialMessage, null, Boxing.boxBoolean((boolean)context.isPartial()), null, null, null, null, 240, null);
        } else {
            if (StringsKt.isBlank((CharSequence)content2)) {
                partialMessage = context.getComposer();
                int n = ((Composer)partialMessage).getConsecutiveMistakeCount();
                ((Composer)partialMessage).setConsecutiveMistakeCount(n + 1);
                context.getComposer().pushToolResult(Composer.sayAndCreateMissingParamError$default(context.getComposer(), "create_memory", "content", null, 4, null), context.getBlock());
                return Unit.INSTANCE;
            }
            context.getComposer().setConsecutiveMistakeCount(0);
            String completeMessage = this.gson.toJson((Object)sharedMessageProps);
            Map<String, String> map = context.getBlock().getParams();
            Intrinsics.checkNotNull(map);
            MemoryInfo newUserMemoryInfo = new MemoryInfo(map);
            MemoryInfo memoryInfo = userMemoryInfo;
            newUserMemoryInfo.setLoom(memoryInfo != null ? memoryInfo.getLoom() : true);
            MemoryInfo memoryInfo2 = userMemoryInfo;
            newUserMemoryInfo.setChat(memoryInfo2 != null ? memoryInfo2.getChat() : true);
            this.memoryStorage.putMemory(newUserMemoryInfo);
            SettingsEditorProvider.Companion.refreshMemory(context.getProject());
            context.getComposer().removeLastPartialMessageIfExistsWithType("ask", "tool");
            Composer.say$default(context.getComposer(), ClineSay.tool, completeMessage, null, Boxing.boxBoolean((boolean)false), null, null, null, null, 244, null);
            String result2 = StringsKt.trimIndent((String)("\n            Memory Create successfully:\n            - Category: " + category + "\n            - Content: " + content2 + "\n            - Tags: " + newUserMemoryInfo.getTags() + "\n\n            "));
            if (content2.length() > 1000) {
                context.getComposer().pushToolResult(result2, context.getBlock());
            } else {
                context.getComposer().pushToolResult(result2, context.getBlock());
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.trimIndent((String)("\n## create_memory\n**Description**:\n  - Store important knowledge and lessons learned in the memory database for future reference by you.\n  - **Manual Invoking** : Follow the 'Manual Memory Modify Workflow' mentioned above.\n  - **Automatic Invoking**: Follow the 'Auto Memory Analysis and modify workflow' otherwise, the tool will not be invoked.\n**Parameters**:\n- category: (required) Memory category. The available categories follow 'Memory Categories' above, which are:\n  " + UserMemoryStorage.Companion.getMemoryToolDesc() + "\n- content: (required) Content of a new or updated MEMORY. The character length of the content must not exceed one thousand.\n      -  **Memory Format:** Organize the identified memory information in the following format:\n        \"\"\"markdown\n            - <-- Memory item 1. (e.g. user's name is Alice) -->\n            - <-- Memory item 2. (e.g. user's basic working environment is MacOS) -->\n            - ...\n        \"\"\"\n- tags:\n  - (required) Keywords to associate with the MEMORY, using English comma separators. These will be used to classify, filter or retrieve the MEMORY.\n  - SHOULD NOT exceed 3 items, described in English\n  - High-distinction category identifiers, comma-separated\n  - Keep concise and clear in English keywords, that with discrimination and classify this MEMORY within its category description.\nUsage:\n<create_memory>\n<category>Your category here</category>\n<content>\nYour Memory content here\n</content>\n<tags>keyword1,keyword2,keyword3</tags>\n</create_memory>\n" + (context.getMemoryEnabled() ? "    \nExample: Requesting to create a memory\n\n<create_memory>\n<category>user_info_config</category>\n<content>\n- User prefers concise explanations and wants code examples to be well-commented.\n- They work primarily with TypeScript and React\n- User prefers functional programming patterns over class-based approaches.\n</content>\n<tags>user preferences,coding style,typescript,react</tags>\n</create_memory>" : Unit.INSTANCE) + "\n"));
    }
}

