/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.file;

import cn.gitlab.kilo.jetbrains.composer.service.FileService;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/file/WriteToFileTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "getRequiredParameters", "", "", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWriteToFileTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteToFileTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/WriteToFileTool\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,62:1\n31#2,2:63\n*S KotlinDebug\n*F\n+ 1 WriteToFileTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/WriteToFileTool\n*L\n19#1:63,2\n*E\n"})
public final class WriteToFileTool
extends BaseToolExecutor {
    public WriteToFileTool() {
        super(ToolName.WRITE_TO_FILE);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        Object[] objectArray = new String[]{"path", "content"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<FileService> serviceClass$iv = FileService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FileService fileService = (FileService)object;
        Object object2 = fileService.handleWriteOrReplaceFile(context.getBlock(), context.getComposer(), $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.trimIndent((String)("\n## write_to_file\nDescription: Request to write content to a file at the specified path. If the file exists, it will be overwritten with the provided content. If the file doesn't exist, it will be created. This tool will automatically create any directories needed to write the file.\nParameters:\n- path: (required) The path of the file to write to (relative to the current working directory " + context.getCwd() + ")\n- content: (required) The content to write to the file. ALWAYS provide the COMPLETE intended content of the file, without any truncation or omissions. You MUST include ALL parts of the file, even if they haven't been modified.\nUsage:\n<write_to_file>\n<path>File path here</path>\n<content>\nYour file content here\n</content>\n</write_to_file>\n\nExample: Requesting to create a new file\n\n<write_to_file>\n<path>src/frontend-config.json</path>\n<content>\n{\n  \"apiEndpoint\": \"https://api.example.com\",\n  \"theme\": {\n    \"primaryColor\": \"#007bff\",\n    \"secondaryColor\": \"#6c757d\",\n    \"fontFamily\": \"Arial, sans-serif\"\n  },\n  \"features\": {\n    \"darkMode\": true,\n    \"notifications\": true,\n    \"analytics\": false\n  },\n  \"version\": \"1.0.0\"\n}\n</content>\n</write_to_file>\n"));
    }
}

