/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.file;

import cn.gitlab.kilo.jetbrains.composer.service.FileService;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/file/NewRuleTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "getRequiredParameters", "", "", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRulesRoot", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nNewRuleTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewRuleTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/NewRuleTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,173:1\n1761#2,3:174\n31#3,2:177\n*S KotlinDebug\n*F\n+ 1 NewRuleTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/NewRuleTool\n*L\n38#1:174,3\n52#1:177,2\n*E\n"})
public final class NewRuleTool
extends BaseToolExecutor {
    public NewRuleTool() {
        super(ToolName.NEW_RULE);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        Object[] objectArray = new String[]{"filename", "content"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        List validSuffixes;
        String filename;
        block8: {
            String llmFilename = context.getParam("filename");
            CharSequence charSequence = llmFilename;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new IllegalArgumentException("Parameter 'filename' cannot be empty. Provide a valid filename like 'kotlin-style_auto.md'");
            }
            filename = ((Object)Paths.get(llmFilename, new String[0]).getFileName()).toString();
            Object[] objectArray = new String[]{"_auto.md", "_chat.md", "_loom.md", "_manual.md"};
            validSuffixes = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = validSuffixes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)filename, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Filename must end with: " + CollectionsKt.joinToString$default((Iterable)validSuffixes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        Path rulesRoot = this.getRulesRoot(context.getProject());
        String correctPath = ((Object)rulesRoot.resolve(filename)).toString();
        Map<String, String> map = context.getBlock().getParams();
        if (map != null) {
            map.put("filename", correctPath);
        }
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<FileService> serviceClass$iv = FileService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FileService fileService = (FileService)object;
        Object object2 = fileService.handleWriteOrReplaceFile(context.getBlock(), context.getComposer(), $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final Path getRulesRoot(Project project) {
        String string = project.getBasePath();
        if (string == null) {
            throw new IllegalStateException("No project base path");
        }
        String base = string;
        String[] stringArray = new String[]{".coderider", "rules"};
        Path rulesRoot = Paths.get(base, stringArray);
        if (!Files.exists(rulesRoot, new LinkOption[0])) {
            Files.createDirectories(rulesRoot, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)rulesRoot);
        return rulesRoot;
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return "## new_rule\nDescription: Create a new rule file to guide AI behavior. Rules are automatically loaded into future conversations.\n\nParameters:\n- filename: (required) Rule filename with required suffix. Examples: \"kotlin-style_auto.md\", \"communication-prefs_chat.md\"\n- content: (required) Complete markdown content for the rule\n\nFilename suffixes:\n- _auto.md: Always applied\n- _chat.md: Chat mode only\n- _loom.md: Loom mode only\n- _manual.md: Manual selection\n\nContent structure (recommended):\n\n## Brief overview\n[1-2 sentence description]\n\n## Communication style\n[Your preferences]\n\n## Development workflow\n[Your workflow preferences]\n\n## Coding best practices\n[Language-specific conventions]\n\n## Project context\n[Project-specific information]\n\nUsage:\n<new_rule>\n<filename>kotlin-style_auto.md</filename>\n<content>\nYour rule content here\n</content>\n</new_rule>\n\nExample: Creating a Kotlin coding style rule\n\n<new_rule>\n<filename>kotlin-style_auto.md</filename>\n<content>\n## Brief overview\nKotlin coding standards and best practices for this project.\n\n## Communication style\n- Be concise but thorough in explanations\n- Always explain why, not just what\n- Use code examples when helpful\n\n## Development workflow\n- Write tests for new features\n- Use meaningful commit messages\n- Prefer small, focused changes\n\n## Coding best practices\n- Use data classes for DTOs and simple value objects\n- Prefer val over var whenever possible\n- Use sealed classes for type-safe state representation\n- Leverage extension functions for utility methods\n- Always handle nullability explicitly with safe calls (?.)\n\n## Project context\n- This is an IntelliJ IDEA plugin using Kotlin 2.1.20\n- We follow IntelliJ Platform SDK conventions\n- Use coroutines with proper scope management\n</content>\n</new_rule>\n\nExample: Creating a communication preference rule\n\n<new_rule>\n<filename>communication-prefs_auto.md</filename>\n<content>\n## Brief overview\nMy personal communication and working style preferences.\n\n## Communication style\n- I prefer detailed explanations over brief summaries\n- Always explain your reasoning and trade-offs\n- Don't hesitate to suggest better approaches\n- Ask clarifying questions before making assumptions\n\n## Development workflow\n- Show me the plan before making major changes\n- Break complex tasks into smaller steps\n- Explain any non-obvious design decisions\n\n## Other guidelines\n- Use real examples when explaining concepts\n- Point out potential issues or edge cases\n- Suggest optimizations when you see opportunities\n</content>\n</new_rule>\n\nImportant notes:\n- Be specific and actionable, not generic\n- Focus on YOUR preferences and project context\n- Rules are cumulative - multiple can be active\n- Use descriptive filenames";
    }
}

