/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools;

import cn.gitlab.kilo.jetbrains.composer.tools.ToolDefinitions;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolRegistry;
import cn.gitlab.kilo.jetbrains.composer.tools.browser.BrowserActionTool;
import cn.gitlab.kilo.jetbrains.composer.tools.command.ExecuteCommandTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.FetchInstructionsTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.ListCodeDefinitionNamesTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.ListFilesTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.ReadFileTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.ReplaceInFileTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.SearchFilesTool;
import cn.gitlab.kilo.jetbrains.composer.tools.file.WriteToFileTool;
import cn.gitlab.kilo.jetbrains.composer.tools.interaction.AskFollowupQuestionTool;
import cn.gitlab.kilo.jetbrains.composer.tools.interaction.AttemptCompletionTool;
import cn.gitlab.kilo.jetbrains.composer.tools.interaction.PlanModeResponseTool;
import cn.gitlab.kilo.jetbrains.composer.tools.interaction.RunSlashCommandTool;
import cn.gitlab.kilo.jetbrains.composer.tools.mcp.AccessMcpResourceTool;
import cn.gitlab.kilo.jetbrains.composer.tools.mcp.UseMcpToolTool;
import cn.gitlab.kilo.jetbrains.composer.tools.memory.CreateMemoryTool;
import cn.gitlab.kilo.jetbrains.composer.tools.task.NewTaskTool;
import cn.gitlab.kilo.jetbrains.composer.tools.task.SwitchModeTool;
import cn.gitlab.kilo.jetbrains.composer.tools.todo.UpdateTodoListTool;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/ToolInitializer;", "", "<init>", "()V", "initializeTools", "", "project", "Lcom/intellij/openapi/project/Project;", "verifyToolRegistration", "", "getRegistrationStatus", "", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolName;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nToolInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolInitializer.kt\ncn/gitlab/kilo/jetbrains/composer/tools/ToolInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1740#2,3:86\n1285#2,2:89\n1299#2,4:91\n*S KotlinDebug\n*F\n+ 1 ToolInitializer.kt\ncn/gitlab/kilo/jetbrains/composer/tools/ToolInitializer\n*L\n73#1:86,3\n82#1:89,2\n82#1:91,4\n*E\n"})
public final class ToolInitializer {
    @NotNull
    public static final ToolInitializer INSTANCE = new ToolInitializer();

    private ToolInitializer() {
    }

    public final void initializeTools(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolRegistry registry = ToolRegistry.Companion.getInstance(project);
        registry.register(new AskFollowupQuestionTool());
        registry.register(new AttemptCompletionTool());
        registry.register(new PlanModeResponseTool());
        registry.register(new RunSlashCommandTool());
        registry.register(new ReadFileTool());
        registry.register(new ListFilesTool());
        registry.register(new SearchFilesTool());
        registry.register(new ListCodeDefinitionNamesTool());
        registry.register(new FetchInstructionsTool());
        registry.register(new WriteToFileTool());
        registry.register(new ReplaceInFileTool());
        registry.register(new ExecuteCommandTool());
        registry.register(new BrowserActionTool());
        registry.register(new UseMcpToolTool());
        registry.register(new AccessMcpResourceTool());
        registry.register(new CreateMemoryTool());
        registry.register(new NewTaskTool());
        registry.register(new SwitchModeTool());
        registry.register(new UpdateTodoListTool());
    }

    public final boolean verifyToolRegistration(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolRegistry registry = ToolRegistry.Companion.getInstance(project);
            List<ToolName> allTools = ToolDefinitions.INSTANCE.getAllTools();
            Iterable $this$all$iv = allTools;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ToolName it = (ToolName)((Object)element$iv);
                    boolean bl2 = false;
                    if (registry.isRegistered(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ToolName, Boolean> getRegistrationStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolRegistry registry = ToolRegistry.Companion.getInstance(project);
        Iterable $this$associateWith$iv = ToolDefinitions.INSTANCE.getAllTools();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ToolName toolName = (ToolName)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Boolean bl2 = registry.isRegistered((ToolName)it);
            map.put(t, bl2);
        }
        return result$iv;
    }
}

