/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools;

import cn.gitlab.kilo.jetbrains.composer.tools.ToolGroup;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u001b"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/ToolDefinitions;", "", "<init>", "()V", "TOOL_GROUPS", "", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolGroup;", "", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolName;", "getTOOL_GROUPS", "()Ljava/util/Map;", "ALWAYS_AVAILABLE_TOOLS", "getALWAYS_AVAILABLE_TOOLS", "()Ljava/util/List;", "EXPERIMENT_IDS", "", "getEXPERIMENT_IDS", "TOOL_DISPLAY_NAMES", "getTOOL_DISPLAY_NAMES", "getToolsInGroup", "group", "getGroupForTool", "tool", "isAlwaysAvailable", "", "getDisplayName", "getAllTools", "coderider-kilo-jetbrains"})
public final class ToolDefinitions {
    @NotNull
    public static final ToolDefinitions INSTANCE = new ToolDefinitions();
    @NotNull
    private static final Map<ToolGroup, List<ToolName>> TOOL_GROUPS;
    @NotNull
    private static final List<ToolName> ALWAYS_AVAILABLE_TOOLS;
    @NotNull
    private static final Map<ToolName, String> EXPERIMENT_IDS;
    @NotNull
    private static final Map<ToolName, String> TOOL_DISPLAY_NAMES;

    private ToolDefinitions() {
    }

    @NotNull
    public final Map<ToolGroup, List<ToolName>> getTOOL_GROUPS() {
        return TOOL_GROUPS;
    }

    @NotNull
    public final List<ToolName> getALWAYS_AVAILABLE_TOOLS() {
        return ALWAYS_AVAILABLE_TOOLS;
    }

    @NotNull
    public final Map<ToolName, String> getEXPERIMENT_IDS() {
        return EXPERIMENT_IDS;
    }

    @NotNull
    public final Map<ToolName, String> getTOOL_DISPLAY_NAMES() {
        return TOOL_DISPLAY_NAMES;
    }

    @NotNull
    public final List<ToolName> getToolsInGroup(@NotNull ToolGroup group) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        List list = TOOL_GROUPS.get((Object)group);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final ToolGroup getGroupForTool(@NotNull ToolName tool) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
            Iterable iterable = TOOL_GROUPS.entrySet();
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                List tools = (List)entry.getValue();
                if (!tools.contains((Object)tool)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (ToolGroup)((Object)entry.getKey()) : null;
    }

    public final boolean isAlwaysAvailable(@NotNull ToolName tool) {
        Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
        return ALWAYS_AVAILABLE_TOOLS.contains((Object)tool);
    }

    @NotNull
    public final String getDisplayName(@NotNull ToolName tool) {
        Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
        String string = TOOL_DISPLAY_NAMES.get((Object)tool);
        if (string == null) {
            String string2 = tool.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = StringsKt.replace$default((String)string2, (char)'_', (char)' ', (boolean)false, (int)4, null);
        }
        return string;
    }

    @NotNull
    public final List<ToolName> getAllTools() {
        return CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)TOOL_GROUPS.values()));
    }

    static {
        Object[] objectArray = new Pair[8];
        ToolName[] toolNameArray = new ToolName[]{ToolName.READ_FILE, ToolName.FETCH_INSTRUCTIONS, ToolName.SEARCH_FILES, ToolName.LIST_FILES, ToolName.LIST_CODE_DEFINITION_NAMES};
        objectArray[0] = TuplesKt.to((Object)((Object)ToolGroup.READ), (Object)CollectionsKt.listOf((Object[])toolNameArray));
        toolNameArray = new ToolName[]{ToolName.WRITE_TO_FILE, ToolName.REPLACE_IN_FILE, ToolName.NEW_RULE};
        objectArray[1] = TuplesKt.to((Object)((Object)ToolGroup.EDIT), (Object)CollectionsKt.listOf((Object[])toolNameArray));
        objectArray[2] = TuplesKt.to((Object)((Object)ToolGroup.BROWSER), (Object)CollectionsKt.listOf((Object)((Object)ToolName.BROWSER_ACTION)));
        objectArray[3] = TuplesKt.to((Object)((Object)ToolGroup.COMMAND), (Object)CollectionsKt.listOf((Object)((Object)ToolName.EXECUTE_COMMAND)));
        toolNameArray = new ToolName[]{ToolName.USE_MCP_TOOL, ToolName.ACCESS_MCP_RESOURCE};
        objectArray[4] = TuplesKt.to((Object)((Object)ToolGroup.MCP), (Object)CollectionsKt.listOf((Object[])toolNameArray));
        objectArray[5] = TuplesKt.to((Object)((Object)ToolGroup.MEMORY), (Object)CollectionsKt.listOf((Object)((Object)ToolName.CREATE_MEMORY)));
        toolNameArray = new ToolName[]{ToolName.ASK_FOLLOWUP_QUESTION, ToolName.ATTEMPT_COMPLETION};
        objectArray[6] = TuplesKt.to((Object)((Object)ToolGroup.INTERACTION), (Object)CollectionsKt.listOf((Object[])toolNameArray));
        toolNameArray = new ToolName[]{ToolName.RUN_SUB_TASK, ToolName.NEW_TASK, ToolName.UPDATE_TODO_LIST};
        objectArray[7] = TuplesKt.to((Object)((Object)ToolGroup.TASK), (Object)CollectionsKt.listOf((Object[])toolNameArray));
        TOOL_GROUPS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new ToolName[]{ToolName.ASK_FOLLOWUP_QUESTION, ToolName.ATTEMPT_COMPLETION, ToolName.SWITCH_MODE, ToolName.NEW_TASK, ToolName.UPDATE_TODO_LIST};
        ALWAYS_AVAILABLE_TOOLS = CollectionsKt.listOf((Object[])objectArray);
        EXPERIMENT_IDS = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ToolName.RUN_SLASH_COMMAND), (Object)"run_slash_command"));
        objectArray = new Pair[]{TuplesKt.to((Object)((Object)ToolName.READ_FILE), (Object)"read files"), TuplesKt.to((Object)((Object)ToolName.FETCH_INSTRUCTIONS), (Object)"fetch instructions"), TuplesKt.to((Object)((Object)ToolName.WRITE_TO_FILE), (Object)"write files"), TuplesKt.to((Object)((Object)ToolName.REPLACE_IN_FILE), (Object)"edit files"), TuplesKt.to((Object)((Object)ToolName.NEW_RULE), (Object)"create new rule"), TuplesKt.to((Object)((Object)ToolName.LIST_FILES), (Object)"list files"), TuplesKt.to((Object)((Object)ToolName.SEARCH_FILES), (Object)"search files"), TuplesKt.to((Object)((Object)ToolName.LIST_CODE_DEFINITION_NAMES), (Object)"list definitions"), TuplesKt.to((Object)((Object)ToolName.EXECUTE_COMMAND), (Object)"run commands"), TuplesKt.to((Object)((Object)ToolName.BROWSER_ACTION), (Object)"use browser"), TuplesKt.to((Object)((Object)ToolName.USE_MCP_TOOL), (Object)"use MCP tools"), TuplesKt.to((Object)((Object)ToolName.ACCESS_MCP_RESOURCE), (Object)"access MCP resources"), TuplesKt.to((Object)((Object)ToolName.ASK_FOLLOWUP_QUESTION), (Object)"ask questions"), TuplesKt.to((Object)((Object)ToolName.ATTEMPT_COMPLETION), (Object)"complete tasks"), TuplesKt.to((Object)((Object)ToolName.PLAN_MODE_RESPONSE), (Object)"respond in plan mode"), TuplesKt.to((Object)((Object)ToolName.CREATE_MEMORY), (Object)"create memories"), TuplesKt.to((Object)((Object)ToolName.RUN_SUB_TASK), (Object)"run sub-tasks"), TuplesKt.to((Object)((Object)ToolName.SWITCH_MODE), (Object)"switch modes"), TuplesKt.to((Object)((Object)ToolName.NEW_TASK), (Object)"create new task"), TuplesKt.to((Object)((Object)ToolName.UPDATE_TODO_LIST), (Object)"update todo list"), TuplesKt.to((Object)((Object)ToolName.RUN_SLASH_COMMAND), (Object)"run slash command")};
        TOOL_DISPLAY_NAMES = MapsKt.mapOf((Pair[])objectArray);
    }
}

