/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.service.diff;

import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffFileEditor;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffViewProvider;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffVirtualFile;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffVirtualFileSystem;
import cn.gitlab.kilo.jetbrains.composer.service.diff.EditType;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001bJ\u0018\u0010'\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/service/diff/DiffViewProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "update", "", "path", "", "type", "Lcn/gitlab/kilo/jetbrains/composer/service/diff/EditType;", "contentSoFar", "isFinished", "", "hideButton", "finishShowDiff", "(Ljava/lang/String;Lcn/gitlab/kilo/jetbrains/composer/service/diff/EditType;Ljava/lang/String;ZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveChanges", "Lcn/gitlab/kilo/jetbrains/composer/service/diff/DiffViewProvider$Result;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "revert", "accept", "resolveVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mustExist", "showDiffEditor", "diffVf", "Lcn/gitlab/kilo/jetbrains/composer/service/diff/DiffVirtualFile;", "showEditFile", "showDiff", "disposeDiff", "diffVirtualFile", "(Lcn/gitlab/kilo/jetbrains/composer/service/diff/DiffVirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processFileDiagnostics", "virtualFile", "getDiagonalsString", "isProblem", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "severityOrder", "", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Result", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDiffViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffViewProvider.kt\ncn/gitlab/kilo/jetbrains/composer/service/diff/DiffViewProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n4135#2,11:400\n4135#2,11:413\n11228#2:426\n11563#2,3:427\n1869#3,2:411\n1869#3,2:424\n774#3:430\n865#3,2:431\n1669#3,8:433\n1869#3,2:441\n*S KotlinDebug\n*F\n+ 1 DiffViewProvider.kt\ncn/gitlab/kilo/jetbrains/composer/service/diff/DiffViewProvider\n*L\n263#1:400,11\n272#1:413,11\n322#1:426\n322#1:427,3\n264#1:411,2\n273#1:424,2\n322#1:430\n322#1:431,2\n325#1:433,8\n346#1:441,2\n*E\n"})
public final class DiffViewProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public DiffViewProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(DiffViewProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public final Object update(@NotNull String path, @NotNull EditType type2, @NotNull String contentSoFar, boolean isFinished, boolean hideButton, boolean finishShowDiff, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, contentSoFar, this, type2, hideButton, isFinished, finishShowDiff, null){
            int label;
            final /* synthetic */ String $path;
            final /* synthetic */ String $contentSoFar;
            final /* synthetic */ DiffViewProvider this$0;
            final /* synthetic */ EditType $type;
            final /* synthetic */ boolean $hideButton;
            final /* synthetic */ boolean $isFinished;
            final /* synthetic */ boolean $finishShowDiff;
            {
                this.$path = $path;
                this.$contentSoFar = $contentSoFar;
                this.this$0 = $receiver;
                this.$type = $type;
                this.$hideButton = $hideButton;
                this.$isFinished = $isFinished;
                this.$finishShowDiff = $finishShowDiff;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Ref.ObjectRef diffVirtualFile = new Ref.ObjectRef();
                        diffVirtualFile.element = DiffVirtualFileSystem.INSTANCE.get(this.$path);
                        Ref.BooleanRef isEdited = new Ref.BooleanRef();
                        Object object2 = (DiffVirtualFile)((Object)diffVirtualFile.element);
                        if (object2 == null || (object2 = object2.getEditedText()) == null) {
                            object2 = "";
                        }
                        isEdited.element = !Intrinsics.areEqual((Object)object2, (Object)this.$contentSoFar);
                        String title = new File(this.$path).getName();
                        VirtualFile vf = DiffViewProvider.access$resolveVirtualFile(this.this$0, this.$path, true);
                        if (vf != null) {
                            String string = vf.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            byte[] byArray = vf.contentsToByteArray();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
                            byte[] byArray2 = byArray;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            Charset charset2 = charset;
                            String string2 = new String(byArray2, charset2);
                            Intrinsics.checkNotNull((Object)title);
                            FileType fileType = vf.getFileType();
                            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
                            diffVirtualFile.element = DiffVirtualFileSystem.INSTANCE.getOrCreate(string, string2, this.$contentSoFar, title, fileType, this.$type, vf, this.$hideButton, this.$isFinished);
                        }
                        if (diffVirtualFile.element != null) {
                            ((DiffVirtualFile)((Object)diffVirtualFile.element)).setEditedText(this.$contentSoFar);
                            ActionsKt.invokeLater$default(null, () -> update.2.invokeSuspend$lambda$0(this.$isFinished, this.$finishShowDiff, this.this$0, diffVirtualFile, isEdited), (int)1, null);
                            ApplicationManager.getApplication().invokeLater(() -> update.2.invokeSuspend$lambda$1(this.this$0, diffVirtualFile));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(boolean $isFinished, boolean $finishShowDiff, DiffViewProvider this$0, Ref.ObjectRef $diffVirtualFile, Ref.BooleanRef $isEdited) {
                if ($isFinished && $finishShowDiff) {
                    this$0.showDiff((DiffVirtualFile)((Object)$diffVirtualFile.element));
                } else if ($isEdited.element) {
                    this$0.showEditFile((DiffVirtualFile)((Object)$diffVirtualFile.element));
                }
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$1(DiffViewProvider this$0, Ref.ObjectRef $diffVirtualFile) {
                this$0.showDiffEditor((DiffVirtualFile)((Object)$diffVirtualFile.element));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object update$default(DiffViewProvider diffViewProvider, String string, EditType editType, String string2, boolean bl, boolean bl2, boolean bl3, Continuation continuation, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        return diffViewProvider.update(string, editType, string2, bl, bl2, bl3, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object saveChanges(@NotNull String path, @NotNull Continuation<? super Result> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(path, this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ String $path;
            final /* synthetic */ DiffViewProvider this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = diffVirtualFile = DiffVirtualFileSystem.INSTANCE.get(this.$path);
                        vf = v0 != null ? v0.getVf() : null;
                        v1 = diffVirtualFile;
                        newContent = v1 != null ? v1.getEditedText() : null;
                        v2 = diffVirtualFile;
                        originalContent = v2 != null ? v2.getOriginText() : null;
                        v3 = newContent;
                        if (v3 != null) {
                            var7_7 /* !! */  = v3;
                            if (var7_7 /* !! */ .length() == 0) {
                                $i$a$-ifEmpty-DiffViewProvider$saveChanges$2$finalText$1 = false;
                                v4 = originalContent;
                            } else {
                                v4 = var7_7 /* !! */ ;
                            }
                            v5 = (String)v4;
                        } else {
                            v5 = finalText = null;
                        }
                        if (vf != null && finalText != null) {
                            WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$1(com.intellij.openapi.vfs.VirtualFile java.lang.String ), ()V)((VirtualFile)vf, (String)finalText));
                        }
                        if (vf == null) ** GOTO lbl44
                        var7_7 /* !! */  = diffVirtualFile;
                        var8_9 = this.this$0;
                        it /* !! */  = var7_7 /* !! */ ;
                        $i$a$-let-DiffViewProvider$saveChanges$2$2 = false;
                        this.L$0 = vf;
                        this.L$1 = finalText;
                        this.label = 1;
                        v6 = DiffViewProvider.access$disposeDiff(var8_9, (DiffVirtualFile)it /* !! */ , (Continuation)this);
                        if (v6 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl43
                    }
                    case 1: {
                        $i$a$-let-DiffViewProvider$saveChanges$2$2 = false;
                        finalText = (String)this.L$1;
                        vf = (VirtualFile)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl43:
                        // 2 sources

                        ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$3(cn.gitlab.kilo.jetbrains.composer.service.diff.DiffViewProvider com.intellij.openapi.vfs.VirtualFile ), ()V)((DiffViewProvider)this.this$0, (VirtualFile)vf));
lbl44:
                        // 2 sources

                        problemsMessage = null;
                        if (!ComposerConfiguration.Companion.getInstance().getState().getIncludeDiagnosticMessages() || vf == null) ** GOTO lbl59
                        this.L$0 = vf;
                        this.L$1 = finalText;
                        this.label = 2;
                        v7 = DelayKt.delay((long)Math.max(0L, ComposerConfiguration.Companion.getInstance().getState().getWriteDelayMs()), (Continuation)((Continuation)this));
                        if (v7 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl58
                    }
                    case 2: {
                        finalText = (String)this.L$1;
                        vf = (VirtualFile)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl58:
                        // 2 sources

                        problemsMessage = this.this$0.processFileDiagnostics(vf);
lbl59:
                        // 2 sources

                        return new Result(problemsMessage, null, null, finalText, 6, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1(VirtualFile $vf, String $finalText) {
                UpdateFileSilentUtilsKt.saveText($vf, $finalText);
            }

            private static final void invokeSuspend$lambda$3(DiffViewProvider this$0, VirtualFile $vf) {
                FileEditorManager.getInstance((Project)DiffViewProvider.access$getProject$p(this$0)).openFile($vf, true);
            }
        }), $completion);
    }

    @Nullable
    public final Object revert(@NotNull String path, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, this, null){
            int label;
            final /* synthetic */ String $path;
            final /* synthetic */ DiffViewProvider this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        void $result;
                        ResultKt.throwOnFailure((Object)object);
                        DiffVirtualFile diffVirtualFile = DiffVirtualFileSystem.INSTANCE.get(this.$path);
                        if (diffVirtualFile == null) return Unit.INSTANCE;
                        VirtualFile vf = diffVirtualFile.getVf();
                        EditType editType = diffVirtualFile.getEditType();
                        String originalContent = diffVirtualFile.getOriginText();
                        String filePath = diffVirtualFile.getFilePath();
                        EditType editType2 = editType;
                        switch (revert.WhenMappings.$EnumSwitchMapping$0[editType2.ordinal()]) {
                            case 1: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> revert.2.invokeSuspend$lambda$0(vf, this.this$0));
                                this.label = 1;
                                Object object4 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                Object object5 = object4;
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object5 = $result;
                                return Unit.INSTANCE;
                            }
                            case 2: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> revert.2.invokeSuspend$lambda$1(vf, originalContent));
                                this.label = 2;
                                Object object6 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                Object object7 = object6;
                                if (object6 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object7 = $result;
                                return Unit.INSTANCE;
                            }
                            case 3: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> revert.2.invokeSuspend$lambda$2(vf, filePath, originalContent));
                                this.label = 3;
                                Object object8 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                object3 = object8;
                                if (object8 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 3: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(VirtualFile $vf, DiffViewProvider this$0) {
                block0: {
                    VirtualFile virtualFile = $vf;
                    if (virtualFile == null) break block0;
                    virtualFile.delete((Object)DiffViewProvider.access$getProject$p(this$0));
                }
            }

            private static final void invokeSuspend$lambda$1(VirtualFile $vf, String $originalContent) {
                if ($vf != null) {
                    UpdateFileSilentUtilsKt.writeText($vf, $originalContent);
                }
            }

            private static final void invokeSuspend$lambda$2(VirtualFile $vf, String $filePath, String $originalContent) {
                if ($vf == null) {
                    File file = new File($filePath);
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    File[] fileArray = new File[]{file};
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (File[])fileArray);
                    VirtualFile recreatedVf = LocalFileSystem.getInstance().findFileByIoFile(file);
                    if (recreatedVf != null) {
                        UpdateFileSilentUtilsKt.saveText(recreatedVf, $originalContent);
                    }
                } else {
                    UpdateFileSilentUtilsKt.saveText($vf, $originalContent);
                }
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object accept(@NotNull String path, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, this, null){
            int label;
            final /* synthetic */ String $path;
            final /* synthetic */ DiffViewProvider this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        void $result;
                        ResultKt.throwOnFailure((Object)object);
                        DiffVirtualFile diffVirtualFile = DiffVirtualFileSystem.INSTANCE.get(this.$path);
                        if (diffVirtualFile == null) return Unit.INSTANCE;
                        VirtualFile vf = diffVirtualFile.getVf();
                        EditType editType = diffVirtualFile.getEditType();
                        String editedText = diffVirtualFile.getEditedText();
                        String filePath = diffVirtualFile.getFilePath();
                        EditType editType2 = editType;
                        switch (accept.WhenMappings.$EnumSwitchMapping$0[editType2.ordinal()]) {
                            case 1: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> accept.2.invokeSuspend$lambda$0(vf, filePath, editedText));
                                this.label = 1;
                                Object object4 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                Object object5 = object4;
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object5 = $result;
                                return Unit.INSTANCE;
                            }
                            case 2: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> accept.2.invokeSuspend$lambda$1(vf, editedText));
                                this.label = 2;
                                Object object6 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                Object object7 = object6;
                                if (object6 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object7 = $result;
                                return Unit.INSTANCE;
                            }
                            case 3: {
                                WriteCommandAction.runWriteCommandAction((Project)DiffViewProvider.access$getProject$p(this.this$0), () -> accept.2.invokeSuspend$lambda$2(vf, this.this$0));
                                this.label = 3;
                                Object object8 = DiffViewProvider.access$disposeDiff(this.this$0, diffVirtualFile, (Continuation)this);
                                object3 = object8;
                                if (object8 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 3: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(VirtualFile $vf, String $filePath, String $editedText) {
                if ($vf == null) {
                    File file = new File($filePath);
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    File[] fileArray = new File[]{file};
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (File[])fileArray);
                    VirtualFile recreatedVf = LocalFileSystem.getInstance().findFileByIoFile(file);
                    if (recreatedVf != null) {
                        UpdateFileSilentUtilsKt.saveText(recreatedVf, $editedText);
                    }
                } else {
                    UpdateFileSilentUtilsKt.saveText($vf, $editedText);
                }
            }

            private static final void invokeSuspend$lambda$1(VirtualFile $vf, String $editedText) {
                if ($vf != null) {
                    UpdateFileSilentUtilsKt.writeText($vf, $editedText);
                }
            }

            private static final void invokeSuspend$lambda$2(VirtualFile $vf, DiffViewProvider this$0) {
                block0: {
                    VirtualFile virtualFile = $vf;
                    if (virtualFile == null) break block0;
                    virtualFile.delete((Object)DiffViewProvider.access$getProject$p(this$0));
                }
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final VirtualFile resolveVirtualFile(String path, boolean mustExist) {
        String abs = path;
        File file = new File(abs);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        if (!file.exists() && mustExist) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
        return lfs.refreshAndFindFileByIoFile(file);
    }

    public final void showDiffEditor(@NotNull DiffVirtualFile diffVf) {
        Intrinsics.checkNotNullParameter((Object)((Object)diffVf), (String)"diffVf");
        FileEditorManager fem = FileEditorManager.getInstance((Project)this.project);
        if (!fem.isFileOpen((VirtualFile)diffVf)) {
            try {
                FileEditor[] fileEditorArray = fem.openFile((VirtualFile)diffVf, true, true);
                Intrinsics.checkNotNull((Object)fileEditorArray);
            }
            catch (Exception e) {
                this.logger.error("Failed to open diff editor", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void showEditFile(@NotNull DiffVirtualFile diffVf) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)diffVf), (String)"diffVf");
        FileEditorManager fem = FileEditorManager.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = fem.getEditors((VirtualFile)diffVf);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        Object[] $this$filterIsInstance$iv = fileEditorArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DiffFileEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiffFileEditor it = (DiffFileEditor)((Object)element$iv);
            boolean bl = false;
            it.showEditFile();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void showDiff(@NotNull DiffVirtualFile diffVf) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)diffVf), (String)"diffVf");
        FileEditorManager fem = FileEditorManager.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = fem.getEditors((VirtualFile)diffVf);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        Object[] $this$filterIsInstance$iv = fileEditorArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DiffFileEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiffFileEditor it = (DiffFileEditor)((Object)element$iv);
            boolean bl = false;
            it.showDiff();
        }
    }

    private final Object disposeDiff(DiffVirtualFile diffVirtualFile, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diffVirtualFile, null){
            int label;
            final /* synthetic */ DiffViewProvider this$0;
            final /* synthetic */ DiffVirtualFile $diffVirtualFile;
            {
                this.this$0 = $receiver;
                this.$diffVirtualFile = $diffVirtualFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        FileEditor[] editors;
                        ResultKt.throwOnFailure((Object)object);
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)DiffViewProvider.access$getProject$p(this.this$0));
                        FileEditor[] fileEditorArray = fileEditorManager.getEditors((VirtualFile)this.$diffVirtualFile);
                        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
                        FileEditor[] $this$forEach$iv = editors = fileEditorArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            FileEditor element$iv;
                            FileEditor editor = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            editor.dispose();
                        }
                        fileEditorManager.closeFile((VirtualFile)this.$diffVirtualFile);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final String processFileDiagnostics(@NotNull VirtualFile virtualFile) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        StringBuilder $this$processFileDiagnostics_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$processFileDiagnostics_u24lambda_u242.append("\n## Current File Problems\n");
        $this$processFileDiagnostics_u24lambda_u242.append(this.getDiagonalsString(this.project, virtualFile));
        $this$processFileDiagnostics_u24lambda_u242.append("\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getDiagonalsString(Project project, VirtualFile virtualFile) {
        try {
            StringBuilder stringBuilder;
            Function1[] $this$distinctBy$iv;
            HighlightInfo it;
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            RangeHighlighter[] allHighlighters;
            Document document = (Document)ReadAction.compute(() -> DiffViewProvider.getDiagonalsString$lambda$3(virtualFile));
            if (document == null) {
                return "No Errors Detected";
            }
            Document document2 = document;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)project, (boolean)false);
            if (markupModel == null) {
                return "No Errors Detected";
            }
            MarkupModel markupModel2 = markupModel;
            RangeHighlighter[] rangeHighlighterArray = markupModel2.getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
            RangeHighlighter[] $this$map$iv = allHighlighters = rangeHighlighterArray;
            boolean $i$f$map = false;
            RangeHighlighter[] rangeHighlighterArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var15_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(HighlightInfo.fromRangeHighlighter((RangeHighlighter)it2));
            }
            Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            boolean $i$f$filter232 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (HighlightInfo)t;
                boolean bl = false;
                if (!this.isProblem(it)) continue;
                destination$iv$iv.add(t);
            }
            List rangeHighlights = (List)destination$iv$iv;
            Iterable $i$f$filter232 = rangeHighlights;
            boolean $i$f$distinctBy = false;
            HashSet<Triple> set$iv = new HashSet<Triple>();
            ArrayList list$iv = new ArrayList();
            for (Object t : $this$distinctBy$iv) {
                it = (HighlightInfo)t;
                boolean bl = false;
                Triple key$iv = new Triple((Object)it.getDescription(), (Object)it.startOffset, (Object)it.getSeverity());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(t);
            }
            $this$distinctBy$iv = new Function1[]{arg_0 -> DiffViewProvider.getDiagonalsString$lambda$7(this, arg_0), DiffViewProvider::getDiagonalsString$lambda$8};
            List highlights = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)list$iv, (Comparator)ComparisonsKt.compareBy((Function1[])$this$distinctBy$iv)));
            if (highlights.isEmpty()) {
                return "No Errors Detected";
            }
            int maxItems = ComposerConfiguration.Companion.getInstance().getState().getMaxDiagnosticMessages();
            int overflow = RangesKt.coerceAtLeast((int)(highlights.size() - maxItems), (int)0);
            List shown = CollectionsKt.take((Iterable)highlights, (int)maxItems);
            StringBuilder $this$getDiagonalsString_u24lambda_u2410 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getDiagonalsString_u24lambda_u2410.append("File: " + virtualFile.getName() + "\n");
            $this$getDiagonalsString_u24lambda_u2410.append("Path: " + virtualFile.getPath() + "\n\n");
            Iterable $this$forEach$iv = shown;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String string2;
                String lineColText;
                HighlightInfo info2 = (HighlightInfo)element$iv;
                boolean bl2 = false;
                int startOffset = RangesKt.coerceIn((int)info2.startOffset, (int)0, (int)document2.getTextLength());
                if (info2.startOffset >= 0 && document2.getTextLength() > 0) {
                    int line = document2.getLineNumber(startOffset) + 1;
                    int col = startOffset - document2.getLineStartOffset(line - 1) + 1;
                    v3 = "line " + line + ", col " + col;
                } else {
                    v3 = lineColText = "file-level";
                }
                if ((string2 = info2.getDescription()) == null && (string2 = info2.getToolTip()) == null) {
                    string2 = "";
                }
                String rawMessage = string2;
                String string3 = StringUtil.removeHtmlTags((String)rawMessage, (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"removeHtmlTags(...)");
                String message = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                HighlightSeverity highlightSeverity = info2.getSeverity();
                if (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR)) {
                    string = "ERROR";
                } else if (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING)) {
                    string = "WARNING";
                } else if (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING)) {
                    string = "WEAK_WARNING";
                } else if (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.INFORMATION)) {
                    string = "INFO";
                } else {
                    String string4 = info2.getSeverity().toString();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                }
                String severityLabel = string;
                $this$getDiagonalsString_u24lambda_u2410.append("- [" + severityLabel + "] " + lineColText + ": " + message + "\n");
            }
            if (overflow > 0) {
                $this$getDiagonalsString_u24lambda_u2410.append("... (" + overflow + " more not shown)\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            return "Error retrieving diagnostics: " + e.getMessage();
        }
    }

    private final boolean isProblem(HighlightInfo info2) {
        return info2.getDescription() != null && info2.getSeverity().myVal >= HighlightSeverity.WEAK_WARNING.myVal;
    }

    private final int severityOrder(HighlightSeverity severity) {
        HighlightSeverity highlightSeverity = severity;
        return Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR) ? 0 : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING) ? 1 : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING) ? 2 : 3));
    }

    private static final Document getDiagonalsString$lambda$3(VirtualFile $virtualFile) {
        return FileDocumentManager.getInstance().getDocument($virtualFile);
    }

    private static final Comparable getDiagonalsString$lambda$7(DiffViewProvider this$0, HighlightInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HighlightSeverity highlightSeverity = it.getSeverity();
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"getSeverity(...)");
        return Integer.valueOf(this$0.severityOrder(highlightSeverity));
    }

    private static final Comparable getDiagonalsString$lambda$8(HighlightInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(RangesKt.coerceAtLeast((int)it.startOffset, (int)0));
    }

    public static final /* synthetic */ VirtualFile access$resolveVirtualFile(DiffViewProvider $this, String path, boolean mustExist) {
        return $this.resolveVirtualFile(path, mustExist);
    }

    public static final /* synthetic */ Project access$getProject$p(DiffViewProvider $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$disposeDiff(DiffViewProvider $this, DiffVirtualFile diffVirtualFile, Continuation $completion) {
        return $this.disposeDiff(diffVirtualFile, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/service/diff/DiffViewProvider$Result;", "", "newProblemsMessage", "", "userEdits", "autoFormattingEdits", "finalContent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getNewProblemsMessage", "()Ljava/lang/String;", "getUserEdits", "getAutoFormattingEdits", "getFinalContent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class Result {
        @Nullable
        private final String newProblemsMessage;
        @Nullable
        private final String userEdits;
        @Nullable
        private final String autoFormattingEdits;
        @Nullable
        private final String finalContent;

        public Result(@Nullable String newProblemsMessage, @Nullable String userEdits, @Nullable String autoFormattingEdits, @Nullable String finalContent) {
            this.newProblemsMessage = newProblemsMessage;
            this.userEdits = userEdits;
            this.autoFormattingEdits = autoFormattingEdits;
            this.finalContent = finalContent;
        }

        public /* synthetic */ Result(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @Nullable
        public final String getNewProblemsMessage() {
            return this.newProblemsMessage;
        }

        @Nullable
        public final String getUserEdits() {
            return this.userEdits;
        }

        @Nullable
        public final String getAutoFormattingEdits() {
            return this.autoFormattingEdits;
        }

        @Nullable
        public final String getFinalContent() {
            return this.finalContent;
        }

        @Nullable
        public final String component1() {
            return this.newProblemsMessage;
        }

        @Nullable
        public final String component2() {
            return this.userEdits;
        }

        @Nullable
        public final String component3() {
            return this.autoFormattingEdits;
        }

        @Nullable
        public final String component4() {
            return this.finalContent;
        }

        @NotNull
        public final Result copy(@Nullable String newProblemsMessage, @Nullable String userEdits, @Nullable String autoFormattingEdits, @Nullable String finalContent) {
            return new Result(newProblemsMessage, userEdits, autoFormattingEdits, finalContent);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.newProblemsMessage;
            }
            if ((n & 2) != 0) {
                string2 = result2.userEdits;
            }
            if ((n & 4) != 0) {
                string3 = result2.autoFormattingEdits;
            }
            if ((n & 8) != 0) {
                string4 = result2.finalContent;
            }
            return result2.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Result(newProblemsMessage=" + this.newProblemsMessage + ", userEdits=" + this.userEdits + ", autoFormattingEdits=" + this.autoFormattingEdits + ", finalContent=" + this.finalContent + ")";
        }

        public int hashCode() {
            int result2 = this.newProblemsMessage == null ? 0 : this.newProblemsMessage.hashCode();
            result2 = result2 * 31 + (this.userEdits == null ? 0 : this.userEdits.hashCode());
            result2 = result2 * 31 + (this.autoFormattingEdits == null ? 0 : this.autoFormattingEdits.hashCode());
            result2 = result2 * 31 + (this.finalContent == null ? 0 : this.finalContent.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.newProblemsMessage, (Object)result2.newProblemsMessage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userEdits, (Object)result2.userEdits)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.autoFormattingEdits, (Object)result2.autoFormattingEdits)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.finalContent, (Object)result2.finalContent);
        }

        public Result() {
            this(null, null, null, null, 15, null);
        }
    }
}

