/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.service;

import cn.gitlab.kilo.jetbrains.common.Logger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.sina.weibo.agent.provider.LoggerAdapter;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000fJ\b\u0010 \u001a\u00020\u001cH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcn/gitlab/kilo/jetbrains/composer/service/JcefContentFetcher;", "Lcom/intellij/openapi/Disposable;", "url", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "query", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "isInitialized", "", "currentFuture", "Ljava/util/concurrent/CompletableFuture;", "currentUrl", "converter", "Lcom/vladsch/flexmark/html2md/converter/FlexmarkHtmlConverter;", "Lorg/jetbrains/annotations/NotNull;", "debugToolWindow", "Ljavax/swing/JComponent;", "isDebugMode", "()Z", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "executeJavaScriptWhenReady", "", "Lorg/cef/browser/CefBrowser;", "showDebugBrowser", "fetchUrlToMarkdown", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nUrlContentFetcherService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlContentFetcherService.kt\ncn/gitlab/kilo/jetbrains/composer/service/JcefContentFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
public final class JcefContentFetcher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String url;
    @Nullable
    private final Project project;
    @NotNull
    private final JBCefBrowser browser;
    @NotNull
    private final JBCefJSQuery query;
    private volatile boolean isInitialized;
    @Nullable
    private CompletableFuture<String> currentFuture;
    @Nullable
    private String currentUrl;
    @NotNull
    private final FlexmarkHtmlConverter converter;
    @Nullable
    private JComponent debugToolWindow;
    private final ExecutorService backgroundExecutor;
    @NotNull
    private static final Logger LOG = Logger.Companion.getInstance(JcefContentFetcher.class);
    public static final long FETCH_TIMEOUT_MS = 45000L;
    @NotNull
    private static final String JS_EXPRESSION_TEMPLATE = "(function() {\n    try {\n        // 1. Get the current document element and clone it to safely modify it\n        \n        let doc = document.documentElement.cloneNode(true);\n        \n        // 2. Clean up unwanted elements using native browser DOM manipulation\n        const selectors = ['script', 'style', 'nav', 'footer', 'header', 'noscript', 'iframe', 'comment'];\n        selectors.forEach(tag => {\n            doc.querySelectorAll(tag).forEach(el => el.remove());\n        });\n        \n        // 3. Get the cleaned HTML content.\n        // We typically use the body's innerHTML as the target content.\n        const htmlContent = doc.querySelector('body')?.innerHTML || doc.outerHTML;\n        \n        // 4. Return the result string. JSON.stringify ensures content (which may contain quotes) \n        // is safely passed as a string literal to the Java handler.\n        return JSON.stringify(htmlContent);\n    } catch (e) {\n        // Handle any error during cleaning or conversion\n        const errMsg = 'Error: Error during HTML extraction: ' + e.message;\n        return JSON.stringify(errMsg);\n    }\n})()\n";

    public JcefContentFetcher(@Nullable String url, @Nullable Project project) {
        this.url = url;
        this.project = project;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(true).setEnableOpenDevToolsMenuItem(true).setUrl(this.url).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.browser = jBCefBrowser;
        JBCefBrowserBase jBCefBrowserBase = (JBCefBrowserBase)this.browser;
        Intrinsics.checkNotNull((Object)jBCefBrowserBase);
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)jBCefBrowserBase);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.query = jBCefJSQuery;
        FlexmarkHtmlConverter flexmarkHtmlConverter = FlexmarkHtmlConverter.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)flexmarkHtmlConverter, (String)"build(...)");
        this.converter = flexmarkHtmlConverter;
        this.backgroundExecutor = Executors.newSingleThreadExecutor(JcefContentFetcher::backgroundExecutor$lambda$1);
        this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                CefFrame cefFrame = frame;
                LoggerAdapter.DefaultImpls.info$default(LOG, "onLoadStart called for frame: " + (cefFrame != null ? cefFrame.getURL() : null), null, 2, null);
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                CefBrowser cefBrowser = browser;
                LoggerAdapter.DefaultImpls.info$default(LOG, "onLoadingStateChange - isLoading: " + isLoading + " for URL: " + (cefBrowser != null ? cefBrowser.getURL() : null), null, 2, null);
                if (!isLoading) {
                    isInitialized = true;
                    LoggerAdapter.DefaultImpls.info$default(LOG, "JCEF Browser initialized successfully", null, 2, null);
                    this.executeJavaScriptWhenReady(browser);
                }
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                LoggerAdapter.DefaultImpls.info$default(LOG, "onLoadEnd called for URL: " + frame.getURL() + ", statusCode: " + httpStatusCode + ", isMain: " + frame.isMain(), null, 2, null);
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                block1: {
                    LoggerAdapter.DefaultImpls.info$default(LOG, "onLoadError - URL: " + failedUrl + ", Error: " + errorText + ", Code: " + errorCode, null, 2, null);
                    CompletableFuture completableFuture = currentFuture;
                    if (completableFuture == null) break block1;
                    CompletableFuture future = completableFuture;
                    boolean bl = false;
                    if (!future.isDone()) {
                        future.completeExceptionally(new RuntimeException("Load failed: " + errorText));
                    }
                }
            }
        }, this.browser.getCefBrowser());
        LoggerAdapter.DefaultImpls.info$default(LOG, "JcefContentFetcher constructor - LoadHandler registered successfully", null, 2, null);
    }

    public /* synthetic */ JcefContentFetcher(String string, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        this(string, project);
    }

    private final boolean isDebugMode() {
        return this.project != null && ApplicationManager.getApplication().isInternal();
    }

    private final void executeJavaScriptWhenReady(CefBrowser browser) {
        CompletableFuture<String> future = this.currentFuture;
        String url = this.currentUrl;
        if (future != null && url != null && !future.isDone()) {
            this.backgroundExecutor.submit(() -> JcefContentFetcher.executeJavaScriptWhenReady$lambda$3(future, this, url, browser));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showDebugBrowser(String url) {
        if (!this.isDebugMode() || this.project == null) {
            return;
        }
        try {
            void $this$showDebugBrowser_u24lambda_u244;
            JPanel jPanel;
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow("JCEF Debug");
            if (toolWindow == null) {
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
                toolWindow = toolWindowManager.registerToolWindow("JCEF Debug", false, toolWindowAnchor);
            }
            ContentFactory contentFactory = ContentFactory.getInstance();
            JPanel jPanel2 = jPanel = new JPanel();
            ContentFactory contentFactory2 = contentFactory;
            boolean bl = false;
            $this$showDebugBrowser_u24lambda_u244.add(this.browser.getComponent());
            Content content2 = contentFactory2.createContent((JComponent)jPanel, "JCEF Debug", false);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
            Content content3 = content2;
            toolWindow.getContentManager().addContent(content3);
            toolWindow.show();
            this.debugToolWindow = new JPanel();
            LoggerAdapter.DefaultImpls.info$default(LOG, "Debug browser displayed in ToolWindow for URL: " + url, null, 2, null);
        }
        catch (Exception e) {
            LOG.info("Failed to show debug browser", e);
        }
    }

    @NotNull
    public final CompletableFuture<String> fetchUrlToMarkdown() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        CharSequence charSequence = this.url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            future.completeExceptionally(new IllegalArgumentException("URL cannot be null or empty"));
            return future;
        }
        LoggerAdapter.DefaultImpls.info$default(LOG, "Starting fetch for URL: " + this.url + ", isInitialized: " + this.isInitialized, null, 2, null);
        this.currentFuture = future;
        this.currentUrl = this.url;
        this.query.addHandler(arg_0 -> JcefContentFetcher.fetchUrlToMarkdown$lambda$6(arg_0 -> JcefContentFetcher.fetchUrlToMarkdown$lambda$5(future, this, arg_0), arg_0));
        ApplicationManager.getApplication().invokeLater(() -> JcefContentFetcher.fetchUrlToMarkdown$lambda$7(this, future));
        return future;
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> JcefContentFetcher.dispose$lambda$10(this));
    }

    private static final Thread backgroundExecutor$lambda$1(Runnable r) {
        Thread thread;
        Thread $this$backgroundExecutor_u24lambda_u241_u24lambda_u240 = thread = new Thread(r, "JcefContentFetcher-DelayThread");
        boolean bl = false;
        $this$backgroundExecutor_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void executeJavaScriptWhenReady$lambda$3$lambda$2(CompletableFuture $future, JcefContentFetcher this$0, String $url, CefBrowser $browser) {
        block4: {
            if (!$future.isDone()) {
                try {
                    String string = this$0.query.inject(JS_EXPRESSION_TEMPLATE);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inject(...)");
                    String fullQueryCall = string;
                    LoggerAdapter.DefaultImpls.info$default(LOG, "Executing JavaScript for URL: " + $url, null, 2, null);
                    CefBrowser cefBrowser = $browser;
                    if (cefBrowser != null) {
                        cefBrowser.executeJavaScript(fullQueryCall, $url, 0);
                    }
                }
                catch (Exception e) {
                    LOG.info("Error executing JavaScript", e);
                    if ($future.isDone()) break block4;
                    $future.completeExceptionally(e);
                }
            }
        }
    }

    private static final void executeJavaScriptWhenReady$lambda$3(CompletableFuture $future, JcefContentFetcher this$0, String $url, CefBrowser $browser) {
        block3: {
            try {
                Thread.sleep(300L);
                ApplicationManager.getApplication().invokeLater(() -> JcefContentFetcher.executeJavaScriptWhenReady$lambda$3$lambda$2($future, this$0, $url, $browser));
            }
            catch (InterruptedException e) {
                LoggerAdapter.DefaultImpls.info$default(LOG, "JavaScript execution delay interrupted", null, 2, null);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.info("Error in delay thread", e);
                if ($future.isDone()) break block3;
                $future.completeExceptionally(e);
            }
        }
    }

    private static final JBCefJSQuery.Response fetchUrlToMarkdown$lambda$5(CompletableFuture $future, JcefContentFetcher this$0, String result2) {
        String string = result2;
        LoggerAdapter.DefaultImpls.info$default(LOG, "Received result from JavaScript: " + (string != null ? StringsKt.take((String)string, (int)100) : null), null, 2, null);
        if (result2 == null) {
            v1 = $future.completeExceptionally(new RuntimeException("Received null from JavaScript"));
        } else if (StringsKt.startsWith$default((String)result2, (String)"Error:", (boolean)false, (int)2, null)) {
            v1 = $future.completeExceptionally(new RuntimeException(result2));
        } else {
            boolean bl;
            try {
                bl = $future.complete(this$0.converter.convert(result2));
            }
            catch (Exception e) {
                bl = $future.complete(result2);
            }
            v1 = bl;
        }
        return null;
    }

    private static final JBCefJSQuery.Response fetchUrlToMarkdown$lambda$6(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void fetchUrlToMarkdown$lambda$7(JcefContentFetcher this$0, CompletableFuture $future) {
        block3: {
            try {
                if (this$0.isDebugMode()) {
                    // empty if block
                }
                this$0.browser.getCefBrowser().loadURL(this$0.url);
                this$0.browser.createImmediately();
            }
            catch (Exception e) {
                LOG.info("Error loading URL: " + this$0.url, e);
                if ($future.isDone()) break block3;
                $future.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void dispose$lambda$10(JcefContentFetcher this$0) {
        try {
            JComponent jComponent = this$0.debugToolWindow;
            if (jComponent != null) {
                JComponent debugComponent = jComponent;
                boolean bl = false;
                try {
                    Unit unit;
                    Project project = this$0.project;
                    if (project != null) {
                        Project proj = project;
                        boolean bl2 = false;
                        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(proj);
                        ToolWindow toolWindow = toolWindowManager.getToolWindow("JCEF Debug");
                        ToolWindow toolWindow2 = toolWindow;
                        if (toolWindow2 != null && (toolWindow2 = toolWindow2.getContentManager()) != null) {
                            toolWindow2.removeAllContents(true);
                        }
                        LoggerAdapter.DefaultImpls.info$default(LOG, "Debug tool window cleaned up", null, 2, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Exception e) {
                    LOG.info("Error cleaning up debug tool window", e);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this$0.debugToolWindow = null;
                }
            }
            this$0.backgroundExecutor.shutdown();
            if (!this$0.backgroundExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this$0.backgroundExecutor.shutdownNow();
            }
            this$0.query.dispose();
            this$0.browser.dispose();
            LoggerAdapter.DefaultImpls.info$default(LOG, "JcefContentFetcher disposed", null, 2, null);
        }
        catch (Exception e) {
            LOG.info("Error disposing JcefContentFetcher", e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/service/JcefContentFetcher$Companion;", "", "<init>", "()V", "LOG", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "FETCH_TIMEOUT_MS", "", "JS_EXPRESSION_TEMPLATE", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

