/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.prompts;

import cn.gitlab.kilo.jetbrains.common.CommandState;
import cn.gitlab.kilo.jetbrains.composer.prompts.MemoryInfo;
import cn.gitlab.kilo.jetbrains.composer.prompts.ProjectMemoryPrompterKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\u00012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"getMemorySection", "", "cwd", "commandState", "Lcn/gitlab/kilo/jetbrains/common/CommandState;", "forgeMemory", "getLoomMemoryFileInstructions", "getChatMemoryFileInstructions", "getUserMemoryInstructions", "userMemoryInfos", "", "Lcn/gitlab/kilo/jetbrains/composer/prompts/MemoryInfo;", "coderider-kilo-jetbrains"})
public final class MemoryServiceKt {
    @NotNull
    public static final String getMemorySection(@NotNull String cwd, @NotNull CommandState commandState) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Intrinsics.checkNotNullParameter((Object)((Object)commandState), (String)"commandState");
        StringBuilder $this$getMemorySection_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getMemorySection_u24lambda_u240.append(StringsKt.trimIndent((String)("\n " + (CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen() ? "\n====\n\nUSER MEMORY AND PROJECT MEMORY BANK\n\n" + ProjectMemoryPrompterKt.createLoomProjectMemoryPrompt(cwd, commandState) + "\n\n  # [MEMORY WORKFLOW] (\u8bb0\u5fc6\u5de5\u4f5c\u6d41)\n  > [IMPORTANT NOTES] WHEN USER ACTIVE THIS WORKFLOW MANUALLY, YOU MUST OUTPUT your analyze process to show your thinking content to help users to recognize. included in the codeblock.\n  > **Invoke condition and key points**: \n  >   - Manually memory modify: Always avaiable when user request to modify memory.\n  >   - Auto memory modify: If auto memory is enabled, the workflow will analyze the conversation context and suggest memory creation and updates.\n  >   - DO NOT use this workflow when modifying 'Project memory' (such as initializing or updating project memory by request 'Initalize project memory(\u521b\u5efa\u9879\u76ee\u8bb0\u5fc6)' or 'update project memory(\u66f4\u65b0\u9879\u76ee\u8bb0\u5fc6)' with 'overview.md'), instead, just focus on project memory only.\n\n  ## Memory Analysis and modify workflow\n  1.  **Review Conversation Context:** Carefully read the provided conversation history with user's input.\n  2.  **Identify and Extract Potential Memories:** \n      - Study and analyze the user's input and chat conversations step by step, then extract memory information that fits the defined memory categories as follows. Be clear and specific.\n      - Memory categories:\n            <!-- Output with Use user's preferred language -->\n            ### User memories Guidlines\n              - ONLY USE 'user_other_preference' FOR USER PERSONAL PREFERENCES AND INFORMATION THAT NOT RELATED TO USER INFO, TECHNICAL OR PROJECT RELATED.\n            ### User Memories Categories\n                " + UserMemoryStorage.Companion.getMemoryCategoryDesc() + "\n\n  3. **Review Existing User Memories:** \n  - Read and think of the provided existing user memories.\n      <full_user_memory_contents>\n      " + MemoryServiceKt.getLoomMemoryFileInstructions() + "\n      </full_user_memory_contents>\n\n  4.  **Analyze and Compare differences between extracted memories and existing memories**\n      - For each identified memory categories and items, determine if it is already captured or conflicts with existing memory within the same category.\n      - **Memory Creation/Incremental Memory** If there is no existing memories, propose it as a new memory item,If the identified information is related but adds detail or updates existing memory within the same category, propose it as an addition.\n      - **Memory Update/Merge **: If the identified information is already accurately captured within the same category,but with different memory point or item, propose it as an merge to the existing memory with related memory items.\n      - **Conflicting Memory:** If extracted memories conflict with existing memory. Note conflicts if necessary.\n      - **DO NOT Delete Memory:** DO NOT DELETE the existing memory unless the memory category is serious misleading and conflicts .\n      - For example, here is how you thinking, *you must output every step of the current process*\n        \"\"\"markdown\n        // Output the full content of User Memory Category you think you should modify,such as:\n        <current_user_memory_category>\n        ## user_info_config\n          - Username is \"ABC\"\n          - User's tech stack is Python\n          ...\n        </current_user_memory_category>\n\n        // If current user chat is \n        User:\"Implement user profile API with Uvicorn and FastAPI, then create a user profile page with React Next\"\n        \n        // Then you can output merge or add incremental memories like:\n        <merged_user_memory_category>\n          - Username is \"ABC\"\n          - User's tech stack is Python, and some implementations with Uvicorn and FastAPI\n          - User user React Next tech with frontend page creations\n        </merged_user_memory_category>\n        \"\"\"\n\n  5.  **Generate the entire new memories and apply modifications**    \n      - **Generate Guidelines**\n        - Generate the memories categories with content related and merged from existing memories and extracted memories.\n        - Length Limit: Keep auto-generated memories focused and totally under 1000 characters each category.\n        - Generate Wisely: Prefer updating existing memories rather than creating duplicates when possible,Don't store overly personal information unless directly relevant to coding.\n      - Invoke '<create_memory>' function with category, content and generated new memory tags related with merged memories above.\n      - YOU MUST FOLLOW THE GUIDELINES MENTIONED ABOVE THEN invoke memory modify function, DO NOT invoke function WITHOUT THINKING.\n      - Example:\n      1. **Review Conversation Context:**\n      2. **Identify and Extract Potential Memories:** \n      3. **Review Existing User Memories:** \n      4. **Analyze and Compare differences between extracted memories and existing memories**\n      5. **Generate the entire new memories and apply modifications**\n      Then:\n      \n      <create_memory>\n      <category>Tech Stack Pattern</category>\n      <content>\n        - {Current Existing memory item 1}\n        - {Current Existing memory item 2}\n        - {memory item 1}\n        - {memory item 2}\n        ...\n      </content>\n      <tags>typescript,react,frontend,testing,jest,functional-components</tags>\n      </create_memory>\n\n  ## Manually Memory modify\n  - **Determine the user's intend**: If USER asks and requests to remember or remind something (such as \"\u4ee5\u540e\u56de\u7b54XXX\", \"\u8bb0\u4f4fXXX\", \"\u56de\u7b54\u90fdXXX\", \"\u4e0d\u8981\u5fd8\u8bb0\", \"\u4e0d\u8981\u518d\u6b21\", \"don't forget XXX\", \"remember XXX\", \"Keep XXX in mind\", etc.), for something to be saved or do not do, or to create a memory, you MUST invoke memory modify function.\n  - You MUST use the current conversation content which USER requesting above as input and proceed to the **Memory Analysis and modify workflow** stage to analyze then create or update the memory if NEEDED.\n\n" + (CockpitConfiguration.Companion.getInstance().getState().getAutoMemoryOpen() ? "  ## Auto Memory Modify\n  > If you see this, AUTO MEMORY WORKFLOW is ENABLED.\n  - When auto memory is enabled, follow workflow as follows:\n    - Think step by step with '[MEMORY WORKFLOW]' , analyze and reason through the flow show bellow:\n      1. Does the current conversation contain any content worth memorizing and preserving for future use? You should automatically analyze the conversations recently to gradually build a comprehensive understanding of the developer's coding habits, project context, and preferences. This happens without explicit user requests.\n      2. Does the conversation contain any information relevant to the user memory categories? If so, list the key points.\n      3. Do user memories exist currently? How is the intersection and union relationships exist between the current conversation and user memories?  \n  \n- Create memories automatically during natural conversation flow with 'Assistant' and 'User' messages. If the 'Assistant' messages are related to the 'User' message, create a memory.\n- Based on the above judgment and conclusion, follow the '[MEMORY WORKFLOW] / Memory Analysis and modify' workflow to perform a comprehensive memory analysis and update operation.\n- [IMPORTANT NOTES] YOU MUST OUTPUT your analyze process to show your thinking and help users to recognize. If you unsure whether something should be memorized, or the content is vague or overly general, proactively ask the user whether they would like it remembered(e.g. \"Based on the conversations,I've found something valuable. Do you want me to remember this? \")\n    - After thinking follow 'MEMORY WORKFLOW', If you detect something is useful and deserve to save as memories used for the future, you can output your thinking bellow.\n    - Output your concise and brief analyzed result in markdown format, with user 'preferred language'\n    - DO NOT activate user memory modify when user request to operating project memory (such as initializing or updating project memory by request 'Initalize project memory(\u521b\u5efa\u9879\u76ee\u8bb0\u5fc6)' or 'update project memory(\u66f4\u65b0\u9879\u76ee\u8bb0\u5fc6)' with 'overview.md')." : Unit.INSTANCE) + "\n\n" : Unit.INSTANCE) + "\n  ")));
        return stringBuilder.toString();
    }

    @NotNull
    public static final String forgeMemory() {
        String chatUserMemoryInstructions = MemoryServiceKt.getChatMemoryFileInstructions();
        CharSequence charSequence = chatUserMemoryInstructions;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)("\n====\n\nUSER MEMORY\n\n" + ((Object)StringsKt.trim((CharSequence)chatUserMemoryInstructions)).toString() + "\n====\n\n    ")))).toString();
    }

    @Nullable
    public static final String getLoomMemoryFileInstructions() {
        return MemoryServiceKt.getUserMemoryInstructions(UserMemoryStorage.Companion.getInstance().getLoomMemory());
    }

    @Nullable
    public static final String getChatMemoryFileInstructions() {
        return MemoryServiceKt.getUserMemoryInstructions(UserMemoryStorage.Companion.getInstance().getChatMemory());
    }

    private static final String getUserMemoryInstructions(List<MemoryInfo> userMemoryInfos) {
        String string;
        Object object = userMemoryInfos;
        if (object == null || object.isEmpty()) {
            string = null;
        } else {
            Object $this$getUserMemoryInstructions_u24lambda_u242 = object = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append("# Previous existing Memories");
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append("## User Memories");
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append(CollectionsKt.joinToString$default((Iterable)userMemoryInfos, (CharSequence)"\n\n", null, null, (int)0, null, MemoryServiceKt::getUserMemoryInstructions$lambda$2$lambda$1, (int)30, null));
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            ((StringBuilder)$this$getUserMemoryInstructions_u24lambda_u242).append('\n');
            string = ((StringBuilder)object).toString();
        }
        return string;
    }

    private static final CharSequence getUserMemoryInstructions$lambda$2$lambda$1(MemoryInfo memoryInfo) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)memoryInfo, (String)"memoryInfo");
        String content2 = memoryInfo.getContent();
        if (!StringsKt.isBlank((CharSequence)content2)) {
            content2 = content2.length() > 1000 ? StringsKt.take((String)content2, (int)1000) : content2;
            charSequence = StringsKt.trimIndent((String)("\n        ### " + memoryInfo.getCategory() + "\n        \n        **Content** \n        " + content2 + "\n"));
        } else {
            charSequence = "";
        }
        return charSequence;
    }
}

