/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.config;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.composer.dto.ApiConfiguration;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeWithMe.ClientId;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000bJ\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bJ\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0016\u0010'\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager;", "", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "gson", "Lcom/google/gson/Gson;", "config", "Lcn/gitlab/kilo/jetbrains/composer/config/ComposerConfiguration;", "saveConfig", "", "name", "apiConfiguration", "Lcn/gitlab/kilo/jetbrains/composer/dto/ApiConfiguration;", "getConfigByName", "Lkotlin/Pair;", "getConfigById", "id", "activateConfigByName", "", "activateConfigById", "deleteConfig", "renameConfig", "oldName", "newName", "getListConfig", "", "Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$ProviderConfigMeta;", "getCurrentConfig", "generateId", "saveConfigToPasswordSafe", "", "loadConfigFromPasswordSafe", "deleteConfigFromPasswordSafe", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "updateMetadataList", "newMeta", "saveMetadataList", "list", "Companion", "ProviderConfigMeta", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProviderSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderSettingsManager.kt\ncn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1#2:246\n774#3:247\n865#3,2:248\n774#3:250\n865#3,2:251\n360#3,7:253\n*S KotlinDebug\n*F\n+ 1 ProviderSettingsManager.kt\ncn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager\n*L\n136#1:247\n136#1:248,2\n160#1:250\n160#1:251,2\n229#1:253,7\n*E\n"})
public final class ProviderSettingsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = Logger.Companion.getInstance(ProviderSettingsManager.class);
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final ComposerConfiguration config = ComposerConfiguration.Companion.getInstance();
    @NotNull
    private static final String PASSWORD_SAFE_KEY_PREFIX = "coderider.provider.config.";

    @NotNull
    public final String saveConfig(@NotNull String name, @NotNull ApiConfiguration apiConfiguration) {
        ProviderConfigMeta configMeta;
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)apiConfiguration, (String)"apiConfiguration");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (configMeta = (ProviderConfigMeta)v0)) == null || (object = ((ProviderConfigMeta)object).getId()) == null) {
            object = this.generateId();
        }
        Object id = object;
        this.saveConfigToPasswordSafe((String)id, apiConfiguration);
        ProviderConfigMeta updatedMeta = ProviderConfigMeta.Companion.fromApiConfiguration((String)id, name, apiConfiguration);
        this.updateMetadataList(updatedMeta);
        LoggerAdapter.DefaultImpls.info$default(this.logger, "Saved provider configuration: " + name + " (id: " + (String)id + ")", null, 2, null);
        return id;
    }

    @Nullable
    public final Pair<String, ApiConfiguration> getConfigByName(@NotNull String name) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return null;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        ApiConfiguration apiConfiguration = this.loadConfigFromPasswordSafe(meta.getId());
        if (apiConfiguration == null) {
            return null;
        }
        ApiConfiguration apiConfig = apiConfiguration;
        return new Pair((Object)meta.getId(), (Object)apiConfig);
    }

    @Nullable
    public final Pair<String, ApiConfiguration> getConfigById(@NotNull String id) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return null;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        ApiConfiguration apiConfiguration = this.loadConfigFromPasswordSafe(id);
        if (apiConfiguration == null) {
            return null;
        }
        ApiConfiguration apiConfig = apiConfiguration;
        return new Pair((Object)meta.getName(), (Object)apiConfig);
    }

    public final boolean activateConfigByName(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return false;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        this.config.setCurrentApiConfigName(name);
        LoggerAdapter.DefaultImpls.info$default(this.logger, "Activated provider configuration: " + name, null, 2, null);
        return true;
    }

    public final boolean activateConfigById(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return false;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        this.config.setCurrentApiConfigName(meta.getName());
        LoggerAdapter.DefaultImpls.info$default(this.logger, "Activated provider configuration: " + meta.getName() + " (id: " + id + ")", null, 2, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean deleteConfig(@NotNull String name) {
        void $this$filterTo$iv$iv;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return false;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        this.deleteConfigFromPasswordSafe(meta.getId());
        Iterable $this$filter$iv = this.getListConfig();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProviderConfigMeta it = (ProviderConfigMeta)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List updatedList = (List)destination$iv$iv;
        this.saveMetadataList(updatedList);
        if (Intrinsics.areEqual((Object)this.config.getCurrentApiConfigName(), (Object)name)) {
            this.config.setCurrentApiConfigName(null);
        }
        LoggerAdapter.DefaultImpls.info$default(this.logger, "Deleted provider configuration: " + name, null, 2, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameConfig(@NotNull String oldName, @NotNull String newName, @NotNull ApiConfiguration apiConfiguration) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)apiConfiguration, (String)"apiConfiguration");
            Iterable iterable = this.getListConfig();
            for (Object t : iterable) {
                ProviderConfigMeta it = (ProviderConfigMeta)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)oldName)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        ProviderConfigMeta providerConfigMeta = v0;
        if (providerConfigMeta == null) {
            return false;
        }
        ProviderConfigMeta meta = providerConfigMeta;
        this.saveConfig(newName, apiConfiguration);
        if (!Intrinsics.areEqual((Object)oldName, (Object)newName)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getListConfig();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProviderConfigMeta it = (ProviderConfigMeta)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)oldName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List updatedList = (List)destination$iv$iv;
            this.saveMetadataList(updatedList);
            if (Intrinsics.areEqual((Object)this.config.getCurrentApiConfigName(), (Object)oldName)) {
                this.config.setCurrentApiConfigName(newName);
            }
        }
        LoggerAdapter.DefaultImpls.info$default(this.logger, "Renamed provider configuration: " + oldName + " -> " + newName, null, 2, null);
        return true;
    }

    @NotNull
    public final List<ProviderConfigMeta> getListConfig() {
        List list;
        String string = this.config.getListApiConfigMetaJson();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String json = string;
        try {
            Type type2 = new TypeToken<List<? extends ProviderConfigMeta>>(){}.getType();
            List list2 = (List)this.gson.fromJson(json, type2);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.logger.error("Failed to parse provider config metadata", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final Pair<String, ApiConfiguration> getCurrentConfig() {
        String string = this.config.getCurrentApiConfigName();
        if (string == null) {
            return null;
        }
        String currentName = string;
        return this.getConfigByName(currentName);
    }

    private final String generateId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void saveConfigToPasswordSafe(String id, ApiConfiguration apiConfiguration) {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(id);
        Credentials credentials = new Credentials("config", this.gson.toJson((Object)apiConfiguration));
        PasswordSafe.Companion.getInstance().set(credentialAttributes, credentials);
    }

    private final ApiConfiguration loadConfigFromPasswordSafe(String id) {
        ApiConfiguration apiConfiguration;
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(id);
        String string = PasswordSafe.Companion.getInstance().getPassword(credentialAttributes);
        if (string == null) {
            return null;
        }
        String password = string;
        try {
            apiConfiguration = (ApiConfiguration)this.gson.fromJson(password, ApiConfiguration.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to parse API configuration from PasswordSafe", e);
            apiConfiguration = null;
        }
        return apiConfiguration;
    }

    private final void deleteConfigFromPasswordSafe(String id) {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(id);
        PasswordSafe.Companion.getInstance().set(credentialAttributes, null);
    }

    private final CredentialAttributes createCredentialAttributes(String id) {
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"CodeRider-Kilo", (String)(PASSWORD_SAFE_KEY_PREFIX + id)));
    }

    private final void updateMetadataList(ProviderConfigMeta newMeta) {
        int existingIndex;
        List currentList;
        block4: {
            int n;
            List $this$indexOfFirst$iv = currentList = CollectionsKt.toMutableList((Collection)this.getListConfig());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                ProviderConfigMeta it = (ProviderConfigMeta)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)newMeta.getId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = existingIndex = -1;
        }
        if (existingIndex >= 0) {
            currentList.set(existingIndex, newMeta);
        } else {
            currentList.add(newMeta);
        }
        this.saveMetadataList(currentList);
    }

    private final void saveMetadataList(List<ProviderConfigMeta> list) {
        String json = this.gson.toJson(list);
        this.config.setListApiConfigMetaJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$Companion;", "", "<init>", "()V", "instance", "Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager;", "getInstance", "()Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager;", "PASSWORD_SAFE_KEY_PREFIX", "", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nProviderSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderSettingsManager.kt\ncn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,245:1\n40#2,3:246\n*S KotlinDebug\n*F\n+ 1 ProviderSettingsManager.kt\ncn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$Companion\n*L\n29#1:246,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProviderSettingsManager getInstance() {
            boolean $i$f$service = false;
            Class<ProviderSettingsManager> serviceClass$iv = ProviderSettingsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProviderSettingsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0089\u0001\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006/"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$ProviderConfigMeta;", "", "id", "", "name", "apiProvider", "apiModelId", "liteLlmModelId", "openRouterModelId", "openAiModelId", "ollamaModelId", "lmStudioModelId", "requestyModelId", "togetherModelId", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getApiProvider", "getApiModelId", "getLiteLlmModelId", "getOpenRouterModelId", "getOpenAiModelId", "getOllamaModelId", "getLmStudioModelId", "getRequestyModelId", "getTogetherModelId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "coderider-kilo-jetbrains"})
    public static final class ProviderConfigMeta {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @Nullable
        private final String apiProvider;
        @Nullable
        private final String apiModelId;
        @Nullable
        private final String liteLlmModelId;
        @Nullable
        private final String openRouterModelId;
        @Nullable
        private final String openAiModelId;
        @Nullable
        private final String ollamaModelId;
        @Nullable
        private final String lmStudioModelId;
        @Nullable
        private final String requestyModelId;
        @Nullable
        private final String togetherModelId;

        public ProviderConfigMeta(@NotNull String id, @NotNull String name, @Nullable String apiProvider, @Nullable String apiModelId, @Nullable String liteLlmModelId, @Nullable String openRouterModelId, @Nullable String openAiModelId, @Nullable String ollamaModelId, @Nullable String lmStudioModelId, @Nullable String requestyModelId, @Nullable String togetherModelId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
            this.apiProvider = apiProvider;
            this.apiModelId = apiModelId;
            this.liteLlmModelId = liteLlmModelId;
            this.openRouterModelId = openRouterModelId;
            this.openAiModelId = openAiModelId;
            this.ollamaModelId = ollamaModelId;
            this.lmStudioModelId = lmStudioModelId;
            this.requestyModelId = requestyModelId;
            this.togetherModelId = togetherModelId;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getApiProvider() {
            return this.apiProvider;
        }

        @Nullable
        public final String getApiModelId() {
            return this.apiModelId;
        }

        @Nullable
        public final String getLiteLlmModelId() {
            return this.liteLlmModelId;
        }

        @Nullable
        public final String getOpenRouterModelId() {
            return this.openRouterModelId;
        }

        @Nullable
        public final String getOpenAiModelId() {
            return this.openAiModelId;
        }

        @Nullable
        public final String getOllamaModelId() {
            return this.ollamaModelId;
        }

        @Nullable
        public final String getLmStudioModelId() {
            return this.lmStudioModelId;
        }

        @Nullable
        public final String getRequestyModelId() {
            return this.requestyModelId;
        }

        @Nullable
        public final String getTogetherModelId() {
            return this.togetherModelId;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.apiProvider;
        }

        @Nullable
        public final String component4() {
            return this.apiModelId;
        }

        @Nullable
        public final String component5() {
            return this.liteLlmModelId;
        }

        @Nullable
        public final String component6() {
            return this.openRouterModelId;
        }

        @Nullable
        public final String component7() {
            return this.openAiModelId;
        }

        @Nullable
        public final String component8() {
            return this.ollamaModelId;
        }

        @Nullable
        public final String component9() {
            return this.lmStudioModelId;
        }

        @Nullable
        public final String component10() {
            return this.requestyModelId;
        }

        @Nullable
        public final String component11() {
            return this.togetherModelId;
        }

        @NotNull
        public final ProviderConfigMeta copy(@NotNull String id, @NotNull String name, @Nullable String apiProvider, @Nullable String apiModelId, @Nullable String liteLlmModelId, @Nullable String openRouterModelId, @Nullable String openAiModelId, @Nullable String ollamaModelId, @Nullable String lmStudioModelId, @Nullable String requestyModelId, @Nullable String togetherModelId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ProviderConfigMeta(id, name, apiProvider, apiModelId, liteLlmModelId, openRouterModelId, openAiModelId, ollamaModelId, lmStudioModelId, requestyModelId, togetherModelId);
        }

        public static /* synthetic */ ProviderConfigMeta copy$default(ProviderConfigMeta providerConfigMeta, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n, Object object) {
            if ((n & 1) != 0) {
                string = providerConfigMeta.id;
            }
            if ((n & 2) != 0) {
                string2 = providerConfigMeta.name;
            }
            if ((n & 4) != 0) {
                string3 = providerConfigMeta.apiProvider;
            }
            if ((n & 8) != 0) {
                string4 = providerConfigMeta.apiModelId;
            }
            if ((n & 0x10) != 0) {
                string5 = providerConfigMeta.liteLlmModelId;
            }
            if ((n & 0x20) != 0) {
                string6 = providerConfigMeta.openRouterModelId;
            }
            if ((n & 0x40) != 0) {
                string7 = providerConfigMeta.openAiModelId;
            }
            if ((n & 0x80) != 0) {
                string8 = providerConfigMeta.ollamaModelId;
            }
            if ((n & 0x100) != 0) {
                string9 = providerConfigMeta.lmStudioModelId;
            }
            if ((n & 0x200) != 0) {
                string10 = providerConfigMeta.requestyModelId;
            }
            if ((n & 0x400) != 0) {
                string11 = providerConfigMeta.togetherModelId;
            }
            return providerConfigMeta.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        }

        @NotNull
        public String toString() {
            return "ProviderConfigMeta(id=" + this.id + ", name=" + this.name + ", apiProvider=" + this.apiProvider + ", apiModelId=" + this.apiModelId + ", liteLlmModelId=" + this.liteLlmModelId + ", openRouterModelId=" + this.openRouterModelId + ", openAiModelId=" + this.openAiModelId + ", ollamaModelId=" + this.ollamaModelId + ", lmStudioModelId=" + this.lmStudioModelId + ", requestyModelId=" + this.requestyModelId + ", togetherModelId=" + this.togetherModelId + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.apiProvider == null ? 0 : this.apiProvider.hashCode());
            result2 = result2 * 31 + (this.apiModelId == null ? 0 : this.apiModelId.hashCode());
            result2 = result2 * 31 + (this.liteLlmModelId == null ? 0 : this.liteLlmModelId.hashCode());
            result2 = result2 * 31 + (this.openRouterModelId == null ? 0 : this.openRouterModelId.hashCode());
            result2 = result2 * 31 + (this.openAiModelId == null ? 0 : this.openAiModelId.hashCode());
            result2 = result2 * 31 + (this.ollamaModelId == null ? 0 : this.ollamaModelId.hashCode());
            result2 = result2 * 31 + (this.lmStudioModelId == null ? 0 : this.lmStudioModelId.hashCode());
            result2 = result2 * 31 + (this.requestyModelId == null ? 0 : this.requestyModelId.hashCode());
            result2 = result2 * 31 + (this.togetherModelId == null ? 0 : this.togetherModelId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProviderConfigMeta)) {
                return false;
            }
            ProviderConfigMeta providerConfigMeta = (ProviderConfigMeta)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)providerConfigMeta.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)providerConfigMeta.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.apiProvider, (Object)providerConfigMeta.apiProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.apiModelId, (Object)providerConfigMeta.apiModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.liteLlmModelId, (Object)providerConfigMeta.liteLlmModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.openRouterModelId, (Object)providerConfigMeta.openRouterModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.openAiModelId, (Object)providerConfigMeta.openAiModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ollamaModelId, (Object)providerConfigMeta.ollamaModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lmStudioModelId, (Object)providerConfigMeta.lmStudioModelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestyModelId, (Object)providerConfigMeta.requestyModelId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.togetherModelId, (Object)providerConfigMeta.togetherModelId);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$ProviderConfigMeta$Companion;", "", "<init>", "()V", "fromApiConfiguration", "Lcn/gitlab/kilo/jetbrains/composer/config/ProviderSettingsManager$ProviderConfigMeta;", "id", "", "name", "config", "Lcn/gitlab/kilo/jetbrains/composer/dto/ApiConfiguration;", "coderider-kilo-jetbrains"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ProviderConfigMeta fromApiConfiguration(@NotNull String id, @NotNull String name, @NotNull ApiConfiguration config2) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                return new ProviderConfigMeta(id, name, config2.getApiProvider(), config2.getApiModelId(), config2.getLiteLlmModelId(), config2.getOpenRouterModelId(), config2.getOpenAiModelId(), config2.getOllamaModelId(), config2.getLmStudioModelId(), config2.getRequestyModelId(), config2.getTogetherModelId());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

