/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.config;

import cn.gitlab.kilo.jetbrains.composer.config.ComposerTaskStorage;
import cn.gitlab.kilo.jetbrains.composer.dto.HistoryItem;
import cn.gitlab.kilo.jetbrains.composer.dto.TaskInfo;
import com.google.gson.Gson;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.io.Closeable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="coderider-kilo.ComposerTaskStorage", storages={@Storage(value="coderider-kilo/coderider-composer/index.xml")})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000234B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0006J\b\u0010$\u001a\u00020\u0018H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u000e\u0010'\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0006J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u001e\u00100\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060*H\u0002J\u0018\u00102\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020,0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage$TaskIndex;", "<init>", "()V", "taskDir", "", "gson", "Lcom/google/gson/Gson;", "DEBOUNCE_DELAY_MS", "", "taskMap", "Ljava/util/concurrent/ConcurrentMap;", "Lcn/gitlab/kilo/jetbrains/composer/dto/TaskInfo;", "pendingWrites", "Ljava/io/File;", "Lkotlinx/coroutines/Job;", "debounceScope", "Lkotlinx/coroutines/CoroutineScope;", "rw", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "index", "getState", "loadState", "", "state", "getTasks", "", "getHistoryItemList", "", "Lcn/gitlab/kilo/jetbrains/composer/dto/HistoryItem;", "getTask", "id", "putTask", "taskInfo", "removeTask", "lazyLoadMissing", "getTaskInternal", "taskFile", "getTaskFileSize", "fileFlows", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "fileMutex", "Lkotlinx/coroutines/sync/Mutex;", "atomicWrite", "target", "content", "startWriter", "flow", "doAtomicWrite", "TaskIndex", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nComposerTaskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerTaskStorage.kt\ncn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1563#2:209\n1634#2,3:210\n1869#2,2:214\n1#3:213\n*S KotlinDebug\n*F\n+ 1 ComposerTaskStorage.kt\ncn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage\n*L\n84#1:209\n84#1:210,3\n115#1:214,2\n*E\n"})
public final class ComposerTaskStorage
implements PersistentStateComponent<TaskIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String taskDir = PathManager.getConfigPath() + "/coderider-composer-tasks";
    @NotNull
    private final Gson gson = new Gson();
    private final long DEBOUNCE_DELAY_MS;
    @NotNull
    private final ConcurrentMap<String, TaskInfo> taskMap = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentMap<File, Job> pendingWrites = new ConcurrentHashMap();
    @NotNull
    private final CoroutineScope debounceScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
    @NotNull
    private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
    @NotNull
    private TaskIndex index = new TaskIndex();
    @NotNull
    private final ConcurrentHashMap<File, MutableSharedFlow<String>> fileFlows = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<File, Mutex> fileMutex = new ConcurrentHashMap();

    public ComposerTaskStorage() {
        this.DEBOUNCE_DELAY_MS = 1000L;
    }

    @NotNull
    public TaskIndex getState() {
        return this.index;
    }

    public void loadState(@NotNull TaskIndex state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.index = state;
    }

    @NotNull
    public final Map<String, TaskInfo> getTasks() {
        this.lazyLoadMissing();
        return MapsKt.toMap((Map)this.taskMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HistoryItem> getHistoryItemList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTasks().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TaskInfo taskInfo = (TaskInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHistoryItem());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final TaskInfo getTask(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        TaskInfo taskInfo = (TaskInfo)this.taskMap.get(id);
        if (taskInfo == null) {
            TaskInfo taskInfo2 = this.getTaskInternal(id);
            if (taskInfo2 != null) {
                TaskInfo taskInfo3;
                TaskInfo it = taskInfo3 = taskInfo2;
                boolean bl = false;
                ((Map)this.taskMap).put(id, it);
                taskInfo = taskInfo3;
            } else {
                taskInfo = null;
            }
        }
        return taskInfo;
    }

    public final void putTask(@NotNull TaskInfo taskInfo) {
        Intrinsics.checkNotNullParameter((Object)taskInfo, (String)"taskInfo");
        String id = taskInfo.getHistoryItem().getId();
        ((Map)this.taskMap).put(id, taskInfo);
        this.index.getTaskIds().add(id);
        File file = this.taskFile(id);
        String string = this.gson.toJson((Object)taskInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        this.atomicWrite(file, string);
    }

    public final void removeTask(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Job job = (Job)this.pendingWrites.remove(this.taskFile(id));
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.taskFile(id).delete();
        this.taskMap.remove(id);
        this.index.getTaskIds().remove(id);
    }

    private final void lazyLoadMissing() {
        if (this.taskMap.size() >= this.index.getTaskIds().size()) {
            return;
        }
        Set unloaded = SetsKt.minus(this.index.getTaskIds(), (Iterable)this.taskMap.keySet());
        Iterable $this$forEach$iv = unloaded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskInfo it;
            String id = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)id);
            if (this.getTaskInternal(id) == null) continue;
            boolean bl2 = false;
            ((Map)this.taskMap).put(id, it);
        }
    }

    private final TaskInfo getTaskInternal(String id) {
        Object object;
        File file = this.taskFile(id);
        if (!file.exists()) {
            return null;
        }
        Object object2 = this;
        try {
            ComposerTaskStorage $this$getTaskInternal_u24lambda_u244 = object2;
            boolean bl = false;
            Gson gson = $this$getTaskInternal_u24lambda_u244.gson;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            object = Result.constructor-impl((Object)((TaskInfo)gson.fromJson(FilesKt.readText((File)file, (Charset)charset), TaskInfo.class)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (TaskInfo)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private final File taskFile(String id) {
        File file;
        File $this$taskFile_u24lambda_u245 = file = new File(this.taskDir);
        boolean bl = false;
        $this$taskFile_u24lambda_u245.mkdirs();
        File dir = file;
        return new File(dir, id + ".json");
    }

    public final long getTaskFileSize(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        File file = this.taskFile(id);
        return file.exists() ? file.length() : 0L;
    }

    private final void atomicWrite(File target, String content2) {
        MutableSharedFlow mutableSharedFlow = this.fileFlows.computeIfAbsent(target, arg_0 -> ComposerTaskStorage.atomicWrite$lambda$8(arg_0 -> ComposerTaskStorage.atomicWrite$lambda$7(this, target, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableSharedFlow, (String)"computeIfAbsent(...)");
        MutableSharedFlow flow = mutableSharedFlow;
        flow.tryEmit((Object)content2);
    }

    private final void startWriter(File target, MutableSharedFlow<String> flow) {
        BuildersKt.launch$default((CoroutineScope)this.debounceScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(flow, this, target, null){
            int label;
            final /* synthetic */ MutableSharedFlow<String> $flow;
            final /* synthetic */ ComposerTaskStorage this$0;
            final /* synthetic */ File $target;
            {
                this.$flow = $flow;
                this.this$0 = $receiver;
                this.$target = $target;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.debounce((Flow)((Flow)this.$flow), (long)ComposerTaskStorage.access$getDEBOUNCE_DELAY_MS$p(this.this$0)).collect(new FlowCollector(this.this$0, this.$target){
                            final /* synthetic */ ComposerTaskStorage this$0;
                            final /* synthetic */ File $target;
                            {
                                this.this$0 = $receiver;
                                this.$target = $target;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object emit(String var1_1, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof startWriter.emit.1)) ** GOTO lbl-1000
                                var13_3 = $completion;
                                if ((var13_3.label & -2147483648) != 0) {
                                    var13_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        Object L$2;
                                        Object L$3;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ startWriter.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ComposerTaskStorage.access$getFileMutex$p(this.this$0).computeIfAbsent(this.$target, (Function<Object, Mutex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, emit$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lkotlinx/coroutines/sync/Mutex;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, emit$lambda$0(java.io.File ), (Ljava/io/File;)Lkotlinx/coroutines/sync/Mutex;)()));
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"computeIfAbsent(...)");
                                        var4_7 = mutex = v0;
                                        var6_8 = this.this$0;
                                        var7_9 = this.$target;
                                        owner$iv = null;
                                        $i$f$withLock = false;
                                        $continuation.L$0 = latest;
                                        $continuation.L$1 = $this$withLock_u24default$iv;
                                        $continuation.L$2 = var6_8;
                                        $continuation.L$3 = var7_9;
                                        $continuation.label = 1;
                                        v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                                        if (v1 == var14_5) {
                                            return var14_5;
                                        }
                                        ** GOTO lbl38
                                    }
                                    case 1: {
                                        $i$f$withLock = false;
                                        var7_9 = (File)$continuation.L$3;
                                        var6_8 = (ComposerTaskStorage)$continuation.L$2;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                                        latest = (String)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl38:
                                        // 2 sources

                                        try {
                                            $i$a$-withLock$default-ComposerTaskStorage$startWriter$1$1$1 = false;
                                            ComposerTaskStorage.access$doAtomicWrite(var6_8, var7_9, latest);
                                            var10_14 = Unit.INSTANCE;
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            private static final Mutex emit$lambda$0(File it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return MutexKt.Mutex$default((boolean)false, (int)1, null);
                            }

                            private static final Mutex emit$lambda$1(Function1 $tmp0, Object p0) {
                                return (Mutex)$tmp0.invoke(p0);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAtomicWrite(File target, String content2) {
        Path tmpPath = new File(target.getAbsolutePath() + ".tmp").toPath();
        try {
            CopyOption[] copyOptionArray;
            Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            object = FileChannel.open(tmpPath, object);
            Throwable throwable = null;
            try {
                FileChannel ch = (FileChannel)object;
                boolean bl = false;
                String string = content2;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                ch.write(ByteBuffer.wrap(byArray));
                ch.force(true);
                copyOptionArray = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            try {
                object = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
                object = Files.move(tmpPath, target.toPath(), (CopyOption[])object);
            }
            catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                object = Files.move(tmpPath, target.toPath(), copyOptionArray);
            }
        }
        catch (Exception e) {
            tmpPath.toFile().delete();
            throw e;
        }
    }

    private static final MutableSharedFlow atomicWrite$lambda$7(ComposerTaskStorage this$0, File $target, File it) {
        MutableSharedFlow mutableSharedFlow;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableSharedFlow it2 = mutableSharedFlow = SharedFlowKt.MutableSharedFlow((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it2);
        this$0.startWriter($target, (MutableSharedFlow<String>)it2);
        return mutableSharedFlow;
    }

    private static final MutableSharedFlow atomicWrite$lambda$8(Function1 $tmp0, Object p0) {
        return (MutableSharedFlow)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$getDEBOUNCE_DELAY_MS$p(ComposerTaskStorage $this) {
        return $this.DEBOUNCE_DELAY_MS;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getFileMutex$p(ComposerTaskStorage $this) {
        return $this.fileMutex;
    }

    public static final /* synthetic */ void access$doAtomicWrite(ComposerTaskStorage $this, File target, String content2) {
        $this.doAtomicWrite(target, content2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage$Companion;", "", "<init>", "()V", "instance", "Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage;", "getInstance", "()Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage;", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nComposerTaskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerTaskStorage.kt\ncn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,208:1\n40#2,3:209\n*S KotlinDebug\n*F\n+ 1 ComposerTaskStorage.kt\ncn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage$Companion\n*L\n205#1:209,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComposerTaskStorage getInstance() {
            boolean $i$f$service = false;
            Class<ComposerTaskStorage> serviceClass$iv = ComposerTaskStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ComposerTaskStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/config/ComposerTaskStorage$TaskIndex;", "", "<init>", "()V", "taskIds", "", "", "getTaskIds", "()Ljava/util/Set;", "setTaskIds", "(Ljava/util/Set;)V", "coderider-kilo-jetbrains"})
    public static final class TaskIndex {
        @NotNull
        private volatile Set<String> taskIds;

        public TaskIndex() {
            ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
            this.taskIds = keySetView;
        }

        @NotNull
        public final Set<String> getTaskIds() {
            return this.taskIds;
        }

        public final void setTaskIds(@NotNull Set<String> set2) {
            Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
            this.taskIds = set2;
        }
    }
}

