/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer;

import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.composer.ComposerProvider;
import cn.gitlab.kilo.jetbrains.composer.State;
import cn.gitlab.kilo.jetbrains.composer.config.AutoApprovalSettings;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerTaskStorage;
import cn.gitlab.kilo.jetbrains.composer.config.ProviderSettingsManager;
import cn.gitlab.kilo.jetbrains.composer.dto.ApiConfiguration;
import cn.gitlab.kilo.jetbrains.composer.dto.BrowserSettings;
import cn.gitlab.kilo.jetbrains.composer.dto.ChatSettings;
import cn.gitlab.kilo.jetbrains.composer.dto.HistoryItem;
import cn.gitlab.kilo.jetbrains.composer.dto.ModelInfo;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerMode;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerModeManager;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"DEFAULT_API_CONFIGURATION", "Lcn/gitlab/kilo/jetbrains/composer/dto/ApiConfiguration;", "getState", "Lcn/gitlab/kilo/jetbrains/composer/State;", "project", "Lcom/intellij/openapi/project/Project;", "hasFileBasedSystemPromptOverride", "", "mode", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateService.kt\ncn/gitlab/kilo/jetbrains/composer/StateServiceKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,168:1\n31#2,2:169\n31#2,2:171\n31#2,2:173\n*S KotlinDebug\n*F\n+ 1 StateService.kt\ncn/gitlab/kilo/jetbrains/composer/StateServiceKt\n*L\n119#1:169,2\n134#1:171,2\n138#1:173,2\n*E\n"})
public final class StateServiceKt {
    @NotNull
    private static final ApiConfiguration DEFAULT_API_CONFIGURATION = new ApiConfiguration("openai", "gpt-4o", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "medium", null);

    @NotNull
    public static final State getState(@NotNull Project project) {
        int n;
        ApiConfiguration apiConfiguration;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComposerConfiguration config2 = ComposerConfiguration.Companion.getInstance();
        AutoApprovalSettings autoApprovalSettings = config2.getAutoApprovalSettings();
        String mode = null;
        mode = config2.getState().getMode();
        ModelsConfiguration.ModelConfig currentModel = ModelsConfiguration.Companion.getInstance().getCurrentLoomModel();
        LLMParam llmParam = currentModel.getParams(false);
        Object object2 = llmParam;
        ModelInfo modelInfo = new ModelInfo(object2 != null && (object2 = ((LLMParam)object2).getContextWindow()) != null && (object2 = (String)object2.get("output")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 8192, (object = llmParam) != null && (object = ((LLMParam)object).getContextWindow()) != null && (object = (String)object.get("input")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 200000, null, null, null, null, null, null, null, null, 1020, null);
        ProviderSettingsManager providerManager = ProviderSettingsManager.Companion.getInstance();
        Pair<String, ApiConfiguration> currentConfig = providerManager.getCurrentConfig();
        if (currentConfig != null) {
            ModelInfo modelInfo2;
            ApiConfiguration apiConfiguration2 = (ApiConfiguration)currentConfig.getSecond();
            String string = ((ApiConfiguration)currentConfig.getSecond()).getOpenAiModelId();
            if (string == null) {
                string = currentModel.getKey();
            }
            if ((modelInfo2 = ((ApiConfiguration)currentConfig.getSecond()).getOpenAiCustomModelInfo()) == null) {
                modelInfo2 = modelInfo;
            }
            apiConfiguration = ApiConfiguration.copy$default(apiConfiguration2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, string, null, modelInfo2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -10485761, 511, null);
        } else {
            apiConfiguration = ApiConfiguration.copy$default(DEFAULT_API_CONFIGURATION, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, currentModel.getKey(), null, modelInfo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -10485761, 511, null);
        }
        ApiConfiguration apiConfiguration3 = apiConfiguration;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ComposerModeManager> serviceClass$iv = ComposerModeManager.class;
        Object object3 = $this$service$iv.getService(serviceClass$iv);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ComposerModeManager composerModeManager = (ComposerModeManager)object3;
        List<ComposerMode> customModes = composerModeManager.getAllCustomModes();
        ComposerMode composerMode = composerModeManager.getModeBySlug(mode);
        if (composerMode == null) {
            boolean bl = false;
            ComposerConfiguration.Companion.getInstance().getState().setMode("code");
            mode = "code";
            composerMode = Unit.INSTANCE;
        }
        boolean hasSystemPromptOverride = StateServiceKt.hasFileBasedSystemPromptOverride(project, mode);
        boolean showTaskTimeline = config2.getShowTaskTimeline();
        List<HistoryItem> taskHistory = ComposerTaskStorage.Companion.getInstance().getHistoryItemList();
        ComponentManager $this$service$iv2 = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<ComposerProvider> serviceClass$iv2 = ComposerProvider.class;
        Object object4 = $this$service$iv2.getService(serviceClass$iv2);
        if (object4 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        int currentVersion = ((ComposerProvider)object4).getTaskHistoryVersion();
        if (currentVersion == 0 && !((Collection)taskHistory).isEmpty()) {
            ComponentManager $this$service$iv3 = (ComponentManager)project;
            boolean $i$f$service3 = false;
            Class<ComposerProvider> serviceClass$iv3 = ComposerProvider.class;
            Object object5 = $this$service$iv3.getService(serviceClass$iv3);
            if (object5 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv3, serviceClass$iv3);
            }
            ((ComposerProvider)object5).initializeTaskHistoryVersion();
            n = 1;
        } else {
            n = currentVersion;
        }
        int effectiveVersion = n;
        return new State(apiConfiguration3, null, ComposerConfiguration.Companion.getInstance().getState().getCustomInstructions(), taskHistory, autoApprovalSettings, BrowserSettings.Companion.getDEFAULT(), new ChatSettings(mode, showTaskTimeline), null, null, null, null, null, true, customModes, effectiveVersion, hasSystemPromptOverride);
    }

    public static final boolean hasFileBasedSystemPromptOverride(@NotNull Project project, @NotNull String mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        String string = project.getBasePath();
        if (string == null) {
            return false;
        }
        String cwd = string;
        String[] stringArray = new String[]{".crkilo", "system-prompt-" + mode};
        File file = Paths.get(cwd, stringArray).toFile();
        return file.exists();
    }
}

