/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.client;

import cn.gitlab.kilo.jetbrains.actions.CodeRiderPluginActionsKt;
import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.GitlabOAuthTokenResponse;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.LogKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.factories.CockpitWidgetFactoryKt;
import cn.gitlab.kilo.jetbrains.services.CodeRiderStatus;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.sina.weibo.agent.actions.VSCodeCommandActionsKt;
import com.sina.weibo.agent.plugin.WecoderPlugin;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.awt.Window;
import java.io.Closeable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0015\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\u0006\u0010\u0016\u001a\u00020\u0012\u001a\b\u0010\u0017\u001a\u00020\u0012H\u0002\u001a \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u001a(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002\u001a\u0017\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010$\u001a\b\u0010%\u001a\u0004\u0018\u00010\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "FORM_MEDIA_TYPE", "GITLAB_PAT_HEADER", "", "GITLAB_OAUTH_HEADER", "OAUTH_REDIRECT_URI", "OAUTH_MAX_REFRESH_ATTEMPTS", "", "oauthRefreshLock", "", "coderiderClient", "Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;", "getCoderiderClient", "()Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;", "setCoderiderClient", "(Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;)V", "logout", "", "project", "Lcom/intellij/openapi/project/Project;", "refreshOtherProjects", "logUserOut", "refreshGitlabOAuthTokenIfExpired", "refreshGitlabOAuthTokenWithRetry", "Lcn/gitlab/kilo/jetbrains/client/GitlabOAuthTokenResponse;", "gitlabHost", "clientId", "initialRefreshToken", "exchangeGitlabRefreshToken", "client", "Lokhttp3/OkHttpClient;", "refreshToken", "calculateGitlabExpiresAtSeconds", "", "response", "(Lcn/gitlab/kilo/jetbrains/client/GitlabOAuthTokenResponse;)Ljava/lang/Long;", "getCoderiderAuthToken", "coderider-kilo-jetbrains"})
public final class CoderiderClientKt {
    @NotNull
    private static final MediaType JSON_MEDIA_TYPE = MediaType.Companion.get("application/json; charset=utf-8");
    @NotNull
    private static final MediaType FORM_MEDIA_TYPE = MediaType.Companion.get("application/x-www-form-urlencoded");
    @NotNull
    private static final String GITLAB_PAT_HEADER = "PRIVATE-TOKEN";
    @NotNull
    private static final String GITLAB_OAUTH_HEADER = "X-Access-Token";
    @NotNull
    private static final String OAUTH_REDIRECT_URI = "http://localhost:8203";
    private static final int OAUTH_MAX_REFRESH_ATTEMPTS = 5;
    @NotNull
    private static final Object oauthRefreshLock = new Object();
    @NotNull
    private static CoderiderClient coderiderClient = new CoderiderClient(null, 1, null);

    @NotNull
    public static final CoderiderClient getCoderiderClient() {
        return coderiderClient;
    }

    public static final void setCoderiderClient(@NotNull CoderiderClient coderiderClient) {
        Intrinsics.checkNotNullParameter((Object)coderiderClient, (String)"<set-?>");
        CoderiderClientKt.coderiderClient = coderiderClient;
    }

    public static final void logout(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwingUtilities.invokeLater(() -> CoderiderClientKt.logout$lambda$0(project));
    }

    public static final void logout() {
        SwingUtilities.invokeLater(CoderiderClientKt::logout$lambda$1);
    }

    public static final void refreshOtherProjects(@Nullable Project project) {
        ThemeUtilKt.webLaunchInScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Project[] projects;
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                            Project[] projectArray2 = projects = projectArray;
                            Project project = this.$project;
                            boolean $i$f$filter = false;
                            void var6_9 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            int n = ((void)$this$filterTo$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                                boolean bl = false;
                                if (!(!Intrinsics.areEqual((Object)it, (Object)project) && !it.isDisposed())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Project p = (Project)element$iv;
                                boolean bl = false;
                                try {
                                    Intrinsics.checkNotNull((Object)p);
                                    WecoderPlugin.Companion.getInstance(p).reset();
                                    LoggerAdapter.DefaultImpls.info$default(LogKt.getLogger(), "Triggered reset for project: " + p.getName(), null, 2, null);
                                }
                                catch (Throwable e) {
                                    LogKt.getLogger().warn("Failed to reset project: " + p.getName(), e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            LogKt.getLogger().warn("Error while notifying other projects to reset", e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ void refreshOtherProjects$default(Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        CoderiderClientKt.refreshOtherProjects(project);
    }

    public static final void logUserOut() {
        CockpitConfiguration.PluginState state;
        CockpitConfiguration.PluginState $this$logUserOut_u24lambda_u242 = state = CockpitConfiguration.Companion.getInstance().getState();
        boolean bl = false;
        $this$logUserOut_u24lambda_u242.setGitlabAccessToken(null);
        $this$logUserOut_u24lambda_u242.setUserName(null);
        $this$logUserOut_u24lambda_u242.setUserId(null);
        $this$logUserOut_u24lambda_u242.setCoderiderAuthToken(null);
        $this$logUserOut_u24lambda_u242.setCoderiderAuthTokenExpiredAt(null);
        if (!$this$logUserOut_u24lambda_u242.getSavePAT()) {
            $this$logUserOut_u24lambda_u242.setGitlabPAT(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshGitlabOAuthTokenIfExpired() {
        CockpitConfiguration configuration = CockpitConfiguration.Companion.getInstance();
        if (!configuration.isOAuthLogin()) {
            return;
        }
        CockpitConfiguration.PluginState state = configuration.getState();
        Long l = state.getGitlabAccessTokenExpiresAt();
        if (l == null) {
            return;
        }
        long expiresAtSeconds = l;
        long nowSeconds = System.currentTimeMillis() / (long)1000;
        if (expiresAtSeconds > nowSeconds) {
            return;
        }
        Object object = oauthRefreshLock;
        synchronized (object) {
            boolean bl = false;
            Long refreshedExpiresAt = state.getGitlabAccessTokenExpiresAt();
            long currentSeconds = System.currentTimeMillis() / (long)1000;
            if (refreshedExpiresAt != null && refreshedExpiresAt > currentSeconds) {
                return;
            }
            String refreshToken = state.getGitlabRefreshToken();
            String clientId = state.getGitlabOAuthClientId();
            String gitlabHost = state.getGitlabHost();
            CharSequence charSequence = refreshToken;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)clientId) == null || StringsKt.isBlank((CharSequence)charSequence) || StringsKt.isBlank((CharSequence)gitlabHost)) {
                LoggerAdapter.DefaultImpls.warn$default(coderiderClient.getLogger(), "GitLab OAuth token expired but refresh parameters are missing.", null, 2, null);
                return;
            }
            GitlabOAuthTokenResponse tokenResponse = CoderiderClientKt.refreshGitlabOAuthTokenWithRetry(gitlabHost, clientId, refreshToken);
            Long expiresAt = CoderiderClientKt.calculateGitlabExpiresAtSeconds(tokenResponse);
            if (expiresAt == null) {
                throw new CustomException("OAuth refresh token response is missing expires information.");
            }
            state.setGitlabAccessToken(tokenResponse.getAccessToken());
            state.setGitlabRefreshToken(tokenResponse.getRefreshToken());
            state.setGitlabAccessTokenExpiresAt(expiresAt);
            CoderiderClient.refreshMetaData$default(coderiderClient, 0, 0L, 3, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final GitlabOAuthTokenResponse refreshGitlabOAuthTokenWithRetry(String gitlabHost, String clientId, String initialRefreshToken) {
        Throwable throwable;
        Throwable lastError = null;
        String refreshToken = initialRefreshToken;
        OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().build();
        for (int attempt = 1; attempt < 6; ++attempt) {
            try {
                LoggerAdapter.DefaultImpls.info$default(coderiderClient.getLogger(), "\u5c1d\u8bd5\u7b2c" + attempt + "\u6b21\u5237\u65b0token: " + refreshToken + " instanceUrl " + gitlabHost + " clientId " + clientId, null, 2, null);
                return CoderiderClientKt.exchangeGitlabRefreshToken(client, gitlabHost, clientId, refreshToken);
            }
            catch (Throwable e) {
                lastError = e;
                coderiderClient.getLogger().warn("\u7b2c" + attempt + "\u6b21\u5237\u65b0token\u5931\u8d25: " + refreshToken, e);
                if (attempt == 5) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                String string = CockpitConfiguration.Companion.getInstance().getState().getGitlabRefreshToken();
                if (string == null) {
                    string = refreshToken;
                }
                refreshToken = string;
                continue;
            }
        }
        if ((throwable = lastError) == null) {
            throwable = new CustomException("Failed to refresh GitLab OAuth token.");
        }
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final GitlabOAuthTokenResponse exchangeGitlabRefreshToken(OkHttpClient client, String gitlabHost, String clientId, String refreshToken) {
        String tokenUrl = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)gitlabHost)).toString(), (CharSequence)"/") + "/oauth/token";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)clientId), TuplesKt.to((Object)"redirect_uri", (Object)OAUTH_REDIRECT_URI), TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"refresh_token", (Object)refreshToken)};
        RequestBody body = RequestBody.Companion.create(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"&", null, null, (int)0, null, CoderiderClientKt::exchangeGitlabRefreshToken$lambda$4, (int)30, null), FORM_MEDIA_TYPE);
        Request request = new Request.Builder().url(tokenUrl).post(body).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            String responseBody;
            Response response = (Response)closeable;
            boolean bl = false;
            ResponseBody responseBody2 = response.body();
            String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
            if (!response.isSuccessful() || responseBody == null) {
                throw new CustomException("OAuth token refresh failed: " + response.code() + " " + response.message());
            }
            GitlabOAuthTokenResponse tokenResponse = (GitlabOAuthTokenResponse)new Gson().fromJson(responseBody, GitlabOAuthTokenResponse.class);
            CharSequence charSequence = tokenResponse.getAccessToken();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new CustomException("OAuth token refresh failed: empty access token");
            }
            charSequence = tokenResponse.getRefreshToken();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new CustomException("OAuth token refresh failed: empty refresh token");
            }
            Intrinsics.checkNotNull((Object)tokenResponse);
            GitlabOAuthTokenResponse gitlabOAuthTokenResponse = tokenResponse;
            return gitlabOAuthTokenResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Long calculateGitlabExpiresAtSeconds(GitlabOAuthTokenResponse response) {
        Long l = response.getExpiresIn();
        if (l == null) {
            return null;
        }
        long expiresIn = l;
        Long l2 = response.getCreatedAt();
        long createdAt = l2 != null ? l2 : System.currentTimeMillis() / (long)1000;
        return createdAt + expiresIn;
    }

    @Nullable
    public static final String getCoderiderAuthToken() {
        CoderiderClientKt.refreshGitlabOAuthTokenIfExpired();
        Instant currentInstant = LocalDateTime.now(ZoneOffset.UTC).atZone(ZoneOffset.UTC).toInstant();
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        if (CockpitConfiguration.Companion.getInstance().needLogin()) {
            return null;
        }
        if (CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthToken() == null) {
            CoderiderClient.refreshMetaData$default(coderiderClient, 0, 0L, 3, null);
        } else {
            Instant expiredInstant;
            String tokenExpiry;
            String string = tokenExpiry = CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthTokenExpiredAt();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = LocalDateTime.parse(it, formatter).atZone(ZoneOffset.UTC).toInstant();
            } else {
                v1 = expiredInstant = null;
            }
            if (expiredInstant != null && currentInstant.isAfter(expiredInstant)) {
                CoderiderClient.refreshMetaData$default(coderiderClient, 0, 0L, 3, null);
            }
        }
        return CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthToken();
    }

    private static final void logout$lambda$0(Project $project) {
        try {
            VSCodeCommandActionsKt.executeCommand("coderider-kilo.settings.logout", $project, new Object[0], false);
            CoderiderClientKt.refreshOtherProjects($project);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CoderiderClientKt.logUserOut();
        Window window = SwingUtilities.getWindowAncestor(CodeRiderPluginActionsKt.getMainPanel());
        if (window != null) {
            window.dispose();
        }
        CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.NEEDS_LOGIN);
        CoderiderTrackClient.INSTANCE.clearEvent();
    }

    private static final void logout$lambda$1() {
        try {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
            VSCodeCommandActionsKt.executeCommand("coderider-kilo.settings.logout", project, new Object[0], false);
            CoderiderClientKt.refreshOtherProjects(project);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CoderiderClientKt.logUserOut();
        Window window = SwingUtilities.getWindowAncestor(CodeRiderPluginActionsKt.getMainPanel());
        if (window != null) {
            window.dispose();
        }
        CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.NEEDS_LOGIN);
        CoderiderTrackClient.INSTANCE.clearEvent();
    }

    private static final CharSequence exchangeGitlabRefreshToken$lambda$4(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ MediaType access$getJSON_MEDIA_TYPE$p() {
        return JSON_MEDIA_TYPE;
    }
}

