/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.client;

import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.client.DeleteIdeCommandRequest;
import cn.gitlab.kilo.jetbrains.client.ErrorResponse;
import cn.gitlab.kilo.jetbrains.client.GetCommandsRequest;
import cn.gitlab.kilo.jetbrains.client.GetIdeCommandListResponseItem;
import cn.gitlab.kilo.jetbrains.client.GetIdeCommandResponse;
import cn.gitlab.kilo.jetbrains.client.GetUserMemoryReq;
import cn.gitlab.kilo.jetbrains.client.GetUserMemoryResponse;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseCreateReq;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseDeleteReq;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseModifyResp;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseNameUpdateReq;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseUpdateReq;
import cn.gitlab.kilo.jetbrains.client.PostIdeCommandCreateRequest;
import cn.gitlab.kilo.jetbrains.client.PostIdeCommandCreateResponse;
import cn.gitlab.kilo.jetbrains.client.PutIdeCommandUpdateRequest;
import cn.gitlab.kilo.jetbrains.client.PutIdeCommandUpdateResponse;
import cn.gitlab.kilo.jetbrains.client.RetrieveRagRequest;
import cn.gitlab.kilo.jetbrains.client.RetrieveRagResponse;
import cn.gitlab.kilo.jetbrains.client.RuleEpListResponse;
import cn.gitlab.kilo.jetbrains.client.RuleEpResponse;
import cn.gitlab.kilo.jetbrains.client.TokenResponse;
import cn.gitlab.kilo.jetbrains.client.UpsertRulePersonalReq;
import cn.gitlab.kilo.jetbrains.client.UpsertRulePersonalResponse;
import cn.gitlab.kilo.jetbrains.client.UpsertUserMemoryReq;
import cn.gitlab.kilo.jetbrains.client.UpsertUserMemoryResponse;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.ModelConfig;
import cn.gitlab.kilo.jetbrains.common.PublicModelConfig;
import cn.gitlab.kilo.jetbrains.common.Rag;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003lmnB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u001a\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J\"\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\b\u0010)\u001a\u00020 H\u0002J\"\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020 J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001H\u0002J\u000e\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020 2\u0006\u00106\u001a\u00020\u0003J\u000e\u00107\u001a\u00020 2\u0006\u00103\u001a\u000208J\u000e\u00109\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010:\u001a\u00020 J\u0006\u0010;\u001a\u00020<J\u0018\u0010=\u001a\u00020>2\u0006\u00100\u001a\u00020\u00032\u0006\u0010?\u001a\u00020@H\u0002J\u001e\u0010A\u001a\u00020\u00032\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030CH\u0002J\u0010\u0010D\u001a\u0004\u0018\u00010E2\u0006\u00103\u001a\u00020FJ\u0010\u0010G\u001a\u0004\u0018\u00010H2\u0006\u00103\u001a\u00020IJ\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u00101\u001a\u00020MJ\u0010\u0010N\u001a\u0004\u0018\u00010O2\u0006\u00103\u001a\u00020PJ\u000e\u0010Q\u001a\u00020 2\u0006\u00103\u001a\u00020RJ\u0010\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020\u0003J7\u0010V\u001a\u00020W2\b\b\u0002\u0010X\u001a\u00020\"2\b\b\u0002\u0010Y\u001a\u00020\"2\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010\\J\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0003J\b\u0010`\u001a\u0004\u0018\u00010\u0003J\u0010\u0010a\u001a\u0004\u0018\u00010\u00032\u0006\u0010b\u001a\u00020\u0003J\b\u0010c\u001a\u0004\u0018\u00010\u0003J\u0006\u0010d\u001a\u00020 J\u0006\u0010e\u001a\u00020 J\u0010\u0010f\u001a\u00020g2\b\u00101\u001a\u0004\u0018\u00010hJ\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020j0K2\b\u00101\u001a\u0004\u0018\u00010kR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;", "", "host", "", "<init>", "(Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "client", "Lokhttp3/OkHttpClient;", "gson", "Lcom/google/gson/Gson;", "state", "Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;", "gitlabToken", "gitlabAuthHeaderName", "withGitlabAuth", "Lokhttp3/Request$Builder;", "buildAuthJwtUrl", "inviteCode", "retrieveRagDocuments", "Lcn/gitlab/kilo/jetbrains/client/RetrieveRagResponse;", "request", "Lcn/gitlab/kilo/jetbrains/client/RetrieveRagRequest;", "terminateKnowledgeBase", "Lcn/gitlab/kilo/jetbrains/client/CoderiderClient$TerminateResponse;", "projectId", "refreshMetaData", "", "maxRetries", "", "initialDelayMs", "", "loginWithGitlabToken", "token", "isOAuth", "", "refreshToken", "refreshTokenWithGitlabToken", "handleErrorResponse", "response", "Lokhttp3/Response;", "syncRagConfig", "doKnowledgeBaseModify", "url", "payload", "updateKnowledgeBaseName", "req", "Lcn/gitlab/kilo/jetbrains/client/KnowledgeBaseNameUpdateReq;", "updateKnowledgeBase", "kbProjectId", "createKnowledgeBase", "Lcn/gitlab/kilo/jetbrains/client/KnowledgeBaseCreateReq;", "deleteKnowledgeBase", "syncModelConfig", "queryPublicConfig", "Lcn/gitlab/kilo/jetbrains/common/PublicModelConfig;", "createAuthenticatedPostRequest", "Lokhttp3/Request;", "requestBody", "Lokhttp3/RequestBody;", "createQueryString", "params", "", "postIdeCommandCreate", "Lcn/gitlab/kilo/jetbrains/client/PostIdeCommandCreateResponse;", "Lcn/gitlab/kilo/jetbrains/client/PostIdeCommandCreateRequest;", "getIdeCommandById", "Lcn/gitlab/kilo/jetbrains/client/GetIdeCommandResponse;", "Lcn/gitlab/kilo/jetbrains/client/CoderiderClient$GetIdeCommandRequest;", "getIdeCommandList", "", "Lcn/gitlab/kilo/jetbrains/client/GetIdeCommandListResponseItem;", "Lcn/gitlab/kilo/jetbrains/client/GetCommandsRequest;", "putIdeCommandUpdate", "Lcn/gitlab/kilo/jetbrains/client/PutIdeCommandUpdateResponse;", "Lcn/gitlab/kilo/jetbrains/client/PutIdeCommandUpdateRequest;", "deleteIdeCommand", "Lcn/gitlab/kilo/jetbrains/client/DeleteIdeCommandRequest;", "getRuleEp", "Lcn/gitlab/kilo/jetbrains/client/RuleEpResponse;", "ruleId", "getRuleEpList", "Lcn/gitlab/kilo/jetbrains/client/RuleEpListResponse;", "page", "itemsPerPage", "ruleName", "status", "(IILjava/lang/String;Ljava/lang/Integer;)Lcn/gitlab/kilo/jetbrains/client/RuleEpListResponse;", "postUpsertRulePersonal", "Lcn/gitlab/kilo/jetbrains/client/UpsertRulePersonalResponse;", "content", "getRulePersonal", "getDocument", "docType", "getDevflowConfig", "syncTrackConfig", "syncDevflowConfig", "postUpsertUserMemory", "Lcn/gitlab/kilo/jetbrains/client/UpsertUserMemoryResponse;", "Lcn/gitlab/kilo/jetbrains/client/UpsertUserMemoryReq;", "getUserMemory", "Lcn/gitlab/kilo/jetbrains/client/GetUserMemoryResponse;", "Lcn/gitlab/kilo/jetbrains/client/GetUserMemoryReq;", "TerminateResponse", "GetIdeCommandRequest", "RulePersonalResponse", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCoderiderClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoderiderClient.kt\ncn/gitlab/kilo/jetbrains/client/CoderiderClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1014:1\n774#2:1015\n865#2,2:1016\n1563#2:1018\n1634#2,3:1019\n1208#2,2:1023\n1236#2,4:1025\n2756#2:1040\n1#3:1022\n1#3:1041\n504#4,7:1029\n126#5:1036\n153#5,3:1037\n*S KotlinDebug\n*F\n+ 1 CoderiderClient.kt\ncn/gitlab/kilo/jetbrains/client/CoderiderClient\n*L\n250#1:1015\n250#1:1016,2\n251#1:1018\n251#1:1019,3\n318#1:1023,2\n318#1:1025,4\n425#1:1040\n425#1:1041\n374#1:1029,7\n375#1:1036\n375#1:1037,3\n*E\n"})
public final class CoderiderClient {
    @Nullable
    private final String host;
    @NotNull
    private final Logger logger;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Gson gson;
    @NotNull
    private final CockpitConfiguration.PluginState state;

    public CoderiderClient(@Nullable String host) {
        this.host = host;
        this.logger = Logger.Companion.getInstance("CoderiderClient");
        this.client = ClientUtilsKt.generateOkHttpClientBuilder().connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();
        this.gson = new Gson();
        this.state = CockpitConfiguration.Companion.getInstance().getState();
    }

    public /* synthetic */ CoderiderClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = CockpitConfiguration.Companion.getInstance().getState().getCoderiderServerHost();
        }
        this(string);
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    private final String gitlabToken() {
        String string = this.state.getGitlabAccessToken();
        if (string == null) {
            string = this.state.getGitlabPAT();
        }
        return string;
    }

    private final String gitlabAuthHeaderName() {
        CharSequence charSequence = this.state.getGitlabAccessToken();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? "X-Access-Token" : (!((charSequence = (CharSequence)this.state.getGitlabPAT()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? "PRIVATE-TOKEN" : null);
    }

    private final Request.Builder withGitlabAuth(Request.Builder $this$withGitlabAuth) {
        String token = this.gitlabToken();
        String headerName = this.gitlabAuthHeaderName();
        CharSequence charSequence = token;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)headerName) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$withGitlabAuth.header(headerName, token);
        }
        return $this$withGitlabAuth;
    }

    private final String buildAuthJwtUrl(String inviteCode) {
        String baseUrl = this.host + "/api/v1/auth/jwt";
        CharSequence charSequence = inviteCode;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return baseUrl;
        }
        return HttpUrl.Companion.get(baseUrl).newBuilder().addQueryParameter("invite_code", inviteCode).build().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RetrieveRagResponse retrieveRagDocuments(@NotNull RetrieveRagRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String url = this.host + "/api/v1/rag/retriever";
        String string = this.gson.toJson((Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        Request request2 = this.withGitlabAuth(new Request.Builder().url(url).post(requestBody)).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken()).build();
        Closeable closeable = (Closeable)this.client.newCall(request2).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new RuntimeException("Failed to retrieve RAG documents: " + response.code());
            }
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IOException("Empty response body");
            }
            Object responseBody = object;
            Object object2 = this.gson.fromJson((String)responseBody, RetrieveRagResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            RetrieveRagResponse retrieveRagResponse = (RetrieveRagResponse)object2;
            return retrieveRagResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TerminateResponse terminateKnowledgeBase(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String url = this.host + "/api/v1/rag/terminate";
        String string = this.gson.toJson((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"kb_id", (Object)projectId)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        Request request = this.withGitlabAuth(new Request.Builder().url(url).post(requestBody)).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken()).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new RuntimeException("Failed to terminate knowledge base: " + response.code());
            }
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IOException("Empty response body");
            }
            Object responseBody = object;
            Object object2 = this.gson.fromJson((String)responseBody, TerminateResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            TerminateResponse terminateResponse = (TerminateResponse)object2;
            return terminateResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void refreshMetaData(int maxRetries, long initialDelayMs) {
        int attempt = 0;
        long delayMs = initialDelayMs;
        while (true) {
            try {
                this.refreshToken();
                this.syncModelConfig();
                this.syncRagConfig();
                this.syncDevflowConfig();
                this.syncTrackConfig();
                return;
            }
            catch (CustomException e) {
                throw e;
            }
            catch (Throwable e) {
                if (++attempt > maxRetries) {
                    throw e;
                }
                e.printStackTrace();
                this.logger.warn("refreshMetaData attempt #" + attempt + " failed, retrying in " + delayMs + "ms", e);
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                delayMs = RangesKt.coerceAtMost((long)(delayMs * (long)2), (long)8000L);
                continue;
            }
            break;
        }
    }

    public static /* synthetic */ void refreshMetaData$default(CoderiderClient coderiderClient, int n, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        if ((n2 & 2) != 0) {
            l = 500L;
        }
        coderiderClient.refreshMetaData(n, l);
    }

    public final void loginWithGitlabToken(@NotNull String token, boolean isOAuth, @Nullable String inviteCode) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.refreshTokenWithGitlabToken(token, isOAuth, inviteCode);
        this.syncModelConfig();
        this.syncRagConfig();
        this.syncDevflowConfig();
        this.syncTrackConfig();
    }

    public static /* synthetic */ void loginWithGitlabToken$default(CoderiderClient coderiderClient, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        coderiderClient.loginWithGitlabToken(string, bl, string2);
    }

    private final void refreshToken() {
        String string = this.gitlabToken();
        if (string == null) {
            return;
        }
        String token = string;
        CharSequence charSequence = this.state.getGitlabAccessToken();
        boolean isOAuth = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        this.refreshTokenWithGitlabToken(token, isOAuth, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshTokenWithGitlabToken(String token, boolean isOAuth, String inviteCode) {
        String url = this.buildAuthJwtUrl(inviteCode);
        RequestBody requestBody = RequestBody.Companion.create("", CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        String headerName = isOAuth ? "X-Access-Token" : "PRIVATE-TOKEN";
        Request request = new Request.Builder().post(requestBody).header(headerName, token).url(url).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (response.isSuccessful()) {
                String responseBody;
                ResponseBody responseBody2 = response.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (responseBody != null) {
                    long l;
                    TokenResponse tokenResponse = (TokenResponse)this.gson.fromJson(responseBody, TokenResponse.class);
                    try {
                        l = LocalDateTime.parse(tokenResponse.getTokenExpiresAt(), DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to parse tokenExpiresAt: " + tokenResponse.getTokenExpiresAt(), e);
                        throw new CustomException("Invalid tokenExpiresAt format");
                    }
                    long expiredAt = l;
                    long now = System.currentTimeMillis();
                    if (expiredAt <= now) {
                        throw new CustomException("Received expired token from CodeRider server, expiredAt=" + expiredAt + ", now=" + now);
                    }
                    CockpitConfiguration.PluginState $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242 = this.state;
                    boolean bl2 = false;
                    $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setCoderiderAuthToken(tokenResponse.getToken());
                    $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setCoderiderAuthTokenExpiredAt(tokenResponse.getTokenExpiresAt());
                    $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setUserId(tokenResponse.getGitlabUserID());
                    $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setGitlabDistinctId(tokenResponse.getGitlabId());
                    $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setUserName(tokenResponse.getGitlabUserName());
                    if (this.host != null) {
                        $this$refreshTokenWithGitlabToken_u24lambda_u243_u24lambda_u242.setCoderiderServerHost(this.host);
                    }
                } else {
                    LoggerAdapter.DefaultImpls.error$default(this.logger, "CodeRider JWT body is null", null, 2, null);
                }
            } else {
                this.handleErrorResponse(response);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void handleErrorResponse(Response response) {
        String string;
        ResponseBody responseBody = response.body();
        String errorBody = responseBody != null ? responseBody.string() : null;
        try {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(errorBody, ErrorResponse.class);
            String string2 = errorResponse.getDetail();
            if (string2 == null) {
                string2 = response.message();
            }
            string = string2;
        }
        catch (Exception e) {
            String string3 = errorBody;
            if (string3 == null) {
                string3 = response.message();
            }
            string = string3;
        }
        String errorMessage = string;
        throw new CustomException(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void syncRagConfig() {
        try {
            String url = this.host + "/api/v1/rag/status";
            Request request = this.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
            Closeable closeable = (Closeable)this.client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Object object;
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    this.handleErrorResponse(response);
                }
                if ((object = response.body()) == null || (object = object.string()) == null) {
                    throw new IOException("Empty response body");
                }
                Object responseBody = object;
                Type ragListType2 = new TypeToken<List<? extends Rag>>(){}.getType();
                List rags2 = (List)this.gson.fromJson((String)responseBody, ragListType2);
                CockpitConfiguration.Companion.getInstance().setRags(rags2);
                if (CockpitConfiguration.Companion.getInstance().getSelectedRags() == null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Rag it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNull((Object)rags2);
                    Iterable $this$filter$iv = rags2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Rag)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)"DONE")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List doneRags = (List)destination$iv$iv;
                    $this$filter$iv = doneRags;
                    CockpitConfiguration cockpitConfiguration = CockpitConfiguration.Companion.getInstance();
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Rag)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(it.toRagSelectItem());
                    }
                    cockpitConfiguration.setSelectedRags((List)destination$iv$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            CockpitConfiguration.Companion.getInstance().setRags(CollectionsKt.emptyList());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doKnowledgeBaseModify(String url, Object payload) {
        String string = this.gson.toJson(payload);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        Closeable closeable = (Closeable)this.client.newCall(this.createAuthenticatedPostRequest(url, RequestBody.Companion.create(string, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p()))).execute();
        Throwable throwable = null;
        try {
            Object object;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                this.handleErrorResponse(response);
            }
            if ((object = response.body()) == null || (object = object.string()) == null) {
                throw new IOException("Empty response body");
            }
            Object responseBody = object;
            KnowledgeBaseModifyResp resp = (KnowledgeBaseModifyResp)this.gson.fromJson((String)responseBody, KnowledgeBaseModifyResp.class);
            if (!Intrinsics.areEqual((Object)resp.getSuccess(), (Object)"true")) {
                throw new CustomException(resp.getMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void updateKnowledgeBaseName(@NotNull KnowledgeBaseNameUpdateReq req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        this.doKnowledgeBaseModify(this.host + "/api/v1/rag/name/update", req);
    }

    public final void updateKnowledgeBase(@NotNull String kbProjectId) {
        Intrinsics.checkNotNullParameter((Object)kbProjectId, (String)"kbProjectId");
        this.doKnowledgeBaseModify(this.host + "/api/v1/rag/update", new KnowledgeBaseUpdateReq(kbProjectId));
    }

    public final void createKnowledgeBase(@NotNull KnowledgeBaseCreateReq req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        this.doKnowledgeBaseModify(this.host + "/api/v1/rag/create", req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteKnowledgeBase(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String url = this.host + "/api/v1/rag/delete";
        String string = this.gson.toJson((Object)new KnowledgeBaseDeleteReq(projectId));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        Request request = this.createAuthenticatedPostRequest(url, requestBody);
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                this.handleErrorResponse(response);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void syncModelConfig() {
        block28: {
            try {
                String url = this.host + "/api/v1/config";
                Request request = new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken()).build();
                Closeable closeable = (Closeable)this.client.newCall(request).execute();
                Throwable throwable = null;
                try {
                    String string;
                    String string2;
                    Object object;
                    Object v4;
                    Object it;
                    Object object22;
                    Iterable iterable;
                    ModelsConfiguration.Config config2;
                    ModelsConfiguration.Config $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                    ModelConfig config3;
                    block25: {
                        Object v3;
                        Iterable iterable2;
                        block24: {
                            Object v2;
                            block23: {
                                Object v1;
                                block22: {
                                    Object object3;
                                    Response response = (Response)closeable;
                                    boolean bl = false;
                                    if (!response.isSuccessful()) {
                                        this.handleErrorResponse(response);
                                    }
                                    if ((object3 = response.body()) == null || (object3 = object3.string()) == null) {
                                        throw new IOException("Empty response body");
                                    }
                                    Object responseBody = object3;
                                    config3 = (ModelConfig)this.gson.fromJson((String)responseBody, ModelConfig.class);
                                    CockpitConfiguration.PluginState $this$syncModelConfig_u24lambda_u2419_u24lambda_u249 = this.state;
                                    boolean bl2 = false;
                                    LoggerAdapter.DefaultImpls.info$default(this.logger, "User auth status synced. name=" + $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.getUserName() + ", id=" + $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.getUserId() + ", GitLab Host=" + $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.getGitlabHost() + ", CodeRider Host=" + $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.getCoderiderServerHost(), null, 2, null);
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.setGitlabProjectPath(config3.getGitlabProjectPath());
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.setGitlabHost(config3.getGitlabInstanceHost());
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.setRagServerEndpoint(config3.getRagServerEndpoint());
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.setDashboardOpen(config3.getDashboardOpen());
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u249.setRegistryHost(config3.getModelRegistryHost());
                                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418 = ModelsConfiguration.Companion.getInstance().getState();
                                    boolean bl3 = false;
                                    iterable2 = config3.getChatModels();
                                    config2 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                                    iterable = iterable2;
                                    for (Object object22 : iterable) {
                                        it = (String)object22;
                                        boolean bl4 = false;
                                        if (!StringsKt.startsWith$default((String)it, (String)"maas", (boolean)false, (int)2, null)) continue;
                                        v1 = object22;
                                        break block22;
                                    }
                                    v1 = null;
                                }
                                config2.setMaasChatModel(v1);
                                iterable2 = config3.getChatModels();
                                config2 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                                iterable = iterable2;
                                for (Object object22 : iterable) {
                                    it = (String)object22;
                                    boolean bl = false;
                                    if (!StringsKt.startsWith$default((String)it, (String)"server", (boolean)false, (int)2, null)) continue;
                                    v2 = object22;
                                    break block23;
                                }
                                v2 = null;
                            }
                            config2.setServerChatModel(v2);
                            iterable2 = config3.getCodeCompletionModels();
                            config2 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                            iterable = iterable2;
                            for (Object object22 : iterable) {
                                it = (String)object22;
                                boolean bl = false;
                                if (!StringsKt.startsWith$default((String)it, (String)"maas", (boolean)false, (int)2, null)) continue;
                                v3 = object22;
                                break block24;
                            }
                            v3 = null;
                        }
                        config2.setMaasCodeModel(v3);
                        iterable2 = config3.getCodeCompletionModels();
                        config2 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                        iterable = iterable2;
                        for (Object object22 : iterable) {
                            it = (String)object22;
                            boolean bl = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"server", (boolean)false, (int)2, null)) continue;
                            v4 = object22;
                            break block25;
                        }
                        v4 = null;
                    }
                    config2.setServerCodeModel(v4);
                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418.setDefaultCodeModel(config3.getDefaultCodeModel());
                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418.setDefaultLoomModel(config3.getDefaultLoomModel());
                    ModelsConfiguration.Config config4 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                    List<String> list = config3.getLoomModels();
                    if (list != null) {
                        String string3;
                        block26: {
                            iterable = list;
                            config2 = config4;
                            object = iterable;
                            object22 = object.iterator();
                            while (object22.hasNext()) {
                                it = object22.next();
                                String it2 = it;
                                boolean bl = false;
                                if (!StringsKt.startsWith$default((String)it2, (String)"maas", (boolean)false, (int)2, null)) continue;
                                string3 = it;
                                break block26;
                            }
                            string3 = null;
                        }
                        config4 = config2;
                        string2 = string3;
                    } else {
                        string2 = null;
                    }
                    config4.setMaasLoomModel(string2);
                    ModelsConfiguration.Config config5 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                    List<String> list2 = config3.getLoomModels();
                    if (list2 != null) {
                        Object object4;
                        block27: {
                            iterable = list2;
                            config2 = config5;
                            object = iterable;
                            object22 = object.iterator();
                            while (object22.hasNext()) {
                                it = object22.next();
                                String it3 = it;
                                boolean bl = false;
                                if (!StringsKt.startsWith$default((String)it3, (String)"server", (boolean)false, (int)2, null)) continue;
                                object4 = it;
                                break block27;
                            }
                            object4 = null;
                        }
                        config5 = config2;
                        string = (String)object4;
                    } else {
                        string = null;
                    }
                    config5.setServerLoomModel(string);
                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418.setCustomModelAvailable(config3.getCustomModelAvailable());
                    $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418.setMaasModels(config3.getMaasModels());
                    List<LLMParam> list3 = config3.getLlmModelParams();
                    if (list3 != null) {
                        void $this$associateByTo$iv$iv;
                        void $this$associateBy$iv;
                        List<LLMParam> params = list3;
                        boolean bl = false;
                        it = params;
                        ModelsConfiguration.Config config6 = $this$syncModelConfig_u24lambda_u2419_u24lambda_u2418;
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        void var20_27 = $this$associateBy$iv;
                        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            void it4;
                            LLMParam lLMParam = (LLMParam)element$iv$iv;
                            Map map = destination$iv$iv;
                            boolean bl5 = false;
                            String string4 = it4.getName();
                            if (string4 == null) {
                                string4 = "";
                            }
                            map.put(string4, element$iv$iv);
                        }
                        config6.setLlmParams(destination$iv$iv);
                    }
                    ModelsConfiguration.updateModels$default(ModelsConfiguration.Companion.getInstance(), null, 1, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LoggerAdapter.DefaultImpls.warn$default(this.logger, e.getMessage(), null, 2, null);
                String string = e.getMessage();
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"License Invalid", (boolean)false, (int)2, null) : false;
                if (!bl) break block28;
                throw new CustomException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PublicModelConfig queryPublicConfig() {
        PublicModelConfig publicModelConfig;
        String url = this.host + "/api/v1/public/config";
        Request request = new Request.Builder().url(url).get().build();
        try {
            PublicModelConfig publicModelConfig2;
            Closeable closeable = (Closeable)this.client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    throw new CustomException(response.message());
                }
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    throw new IOException("Empty response body");
                }
                Object responseBody = object;
                PublicModelConfig config2 = (PublicModelConfig)this.gson.fromJson((String)responseBody, PublicModelConfig.class);
                CockpitConfiguration.Companion.getInstance().getState().setGitlabHost(config2.getGitlabInstanceHost());
                CockpitConfiguration.Companion.getInstance().getState().setSecurityStatement(config2.getSecurityStatement());
                CharSequence charSequence = config2.getGitlabPatUrl();
                CockpitConfiguration.Companion.getInstance().getState().setGitlabPatUrl((String)(charSequence == null || charSequence.length() == 0 ? CockpitConfiguration.Companion.getInstance().getState().getGitlabHost() + "/-/user_settings/personal_access_tokens" : config2.getGitlabPatUrl()));
                LoggerAdapter.DefaultImpls.info$default(this.logger, "CodeRider connected to server successfully.", null, 2, null);
                publicModelConfig2 = config2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            publicModelConfig = publicModelConfig2;
            Intrinsics.checkNotNull((Object)publicModelConfig);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return publicModelConfig;
    }

    private final Request createAuthenticatedPostRequest(String url, RequestBody requestBody) {
        return this.withGitlabAuth(new Request.Builder().url(url).post(requestBody).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
    }

    /*
     * WARNING - void declaration
     */
    private final String createQueryString(Map<String, String> params) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$filterValues$iv = params;
        boolean $i$f$filterValues = false;
        Map<String, String> result$iv = new LinkedHashMap();
        for (Map.Entry<String, String> entry$iv : $this$filterValues$iv.entrySet()) {
            String it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PostIdeCommandCreateResponse postIdeCommandCreate(@NotNull PostIdeCommandCreateRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        String url = this.host + "/api/v1/instruction/create";
        String jsonBody = this.gson.toJson((Object)req);
        Intrinsics.checkNotNull((Object)jsonBody);
        RequestBody requestBody = RequestBody.Companion.create(jsonBody, MediaType.Companion.get("application/json"));
        Request request = this.createAuthenticatedPostRequest(url, requestBody);
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            PostIdeCommandCreateResponse postIdeCommandCreateResponse = (PostIdeCommandCreateResponse)this.gson.fromJson(responseBody != null ? responseBody.string() : null, PostIdeCommandCreateResponse.class);
            return postIdeCommandCreateResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final GetIdeCommandResponse getIdeCommandById(@NotNull GetIdeCommandRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        String url = this.host + "/api/v1/instruction/get" + this.createQueryString(req.toMap());
        Request request = this.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            GetIdeCommandResponse getIdeCommandResponse = (GetIdeCommandResponse)this.gson.fromJson(responseBody != null ? responseBody.string() : null, GetIdeCommandResponse.class);
            return getIdeCommandResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<GetIdeCommandListResponseItem> getIdeCommandList(@NotNull GetCommandsRequest payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        HttpUrl url = HttpUrl.Companion.get(this.host + "/api/v1/instructions").newBuilder().addQueryParameter("page", String.valueOf(payload.getPage())).addQueryParameter("items_per_page", String.valueOf(payload.getItemsPerPage())).addQueryParameter("sort_by", payload.getSortBy()).addQueryParameter("sort_order", payload.getSortOrder()).addQueryParameter("name", payload.getName()).build();
        Request request = this.withGitlabAuth(new Request.Builder().url(url).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).get().build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Iterable iterable;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            Object object = this.gson.fromJson(JsonParser.parseString((String)(responseBody != null ? responseBody.string() : null)).getAsJsonObject().get("data"), GetIdeCommandListResponseItem[].class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            Iterable $this$onEach$iv = ArraysKt.toList((Object[])((Object[])object));
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl2 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                GetIdeCommandListResponseItem it = (GetIdeCommandListResponseItem)element$iv;
                boolean bl3 = false;
                it.setEnabled(true);
            }
            List list = (List)iterable;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PutIdeCommandUpdateResponse putIdeCommandUpdate(@NotNull PutIdeCommandUpdateRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        String url = this.host + "/api/v1/instruction/update";
        String jsonBody = this.gson.toJson((Object)req);
        Intrinsics.checkNotNull((Object)jsonBody);
        RequestBody requestBody = RequestBody.Companion.create(jsonBody, MediaType.Companion.get("application/json"));
        Request request = this.withGitlabAuth(new Request.Builder().url(url).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).put(requestBody).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            PutIdeCommandUpdateResponse putIdeCommandUpdateResponse = (PutIdeCommandUpdateResponse)this.gson.fromJson(responseBody != null ? responseBody.string() : null, PutIdeCommandUpdateResponse.class);
            return putIdeCommandUpdateResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteIdeCommand(@NotNull DeleteIdeCommandRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        String url = this.host + "/api/v1/instruction/delete" + this.createQueryString(req.toMap());
        Request request = Request.Builder.delete$default((Request.Builder)this.withGitlabAuth(new Request.Builder().url(url).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())), null, (int)1, null).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RuleEpResponse getRuleEp(@NotNull String ruleId) {
        RuleEpResponse ruleEpResponse;
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        String url = this.host + "/api/v1/rule_ep/get?id=" + ruleId;
        Request request = this.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            ruleEpResponse = (RuleEpResponse)this.gson.fromJson(responseBody != null ? responseBody.string() : null, RuleEpResponse.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return ruleEpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RuleEpListResponse getRuleEpList(int page, int itemsPerPage, @Nullable String ruleName, @Nullable Integer status) {
        RuleEpListResponse ruleEpListResponse;
        HttpUrl.Builder builder2;
        HttpUrl.Builder $this$getRuleEpList_u24lambda_u2432 = builder2 = HttpUrl.Companion.get(this.host + "/api/v1/rule_ep/list").newBuilder().addQueryParameter("page", String.valueOf(page)).addQueryParameter("items_per_page", String.valueOf(itemsPerPage));
        boolean bl = false;
        String string = ruleName;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getRuleEpList_u24lambda_u2432.addQueryParameter("rule_name", it);
        }
        Integer n = status;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            $this$getRuleEpList_u24lambda_u2432.addQueryParameter("status", String.valueOf(it));
        }
        String url = builder2.build().toString();
        Request request = this.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).header("accept", "application/json").build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl4 = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            String responseStr = responseBody != null ? responseBody.string() : null;
            RuleEpListResponse ruleEpListResponse2 = (RuleEpListResponse)this.gson.fromJson(responseStr, RuleEpListResponse.class);
            ruleEpListResponse = ruleEpListResponse2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ruleEpListResponse, (String)"use(...)");
        return ruleEpListResponse;
    }

    public static /* synthetic */ RuleEpListResponse getRuleEpList$default(CoderiderClient coderiderClient, int n, int n2, String string, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 1;
        }
        if ((n4 & 2) != 0) {
            n2 = 100;
        }
        if ((n4 & 4) != 0) {
            string = null;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        return coderiderClient.getRuleEpList(n, n2, string, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UpsertRulePersonalResponse postUpsertRulePersonal(@NotNull String content2) {
        UpsertRulePersonalReq payload;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String string = CockpitConfiguration.Companion.getInstance().getState().getUserId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            int n = Integer.parseInt(it);
            String string2 = CockpitConfiguration.Companion.getInstance().getState().getUserName();
            if (string2 == null) {
                string2 = "";
            }
            v3 = new UpsertRulePersonalReq(n, string2, content2, 1);
        } else {
            v3 = payload = null;
        }
        if (payload == null) {
            throw new IOException("User not logged in");
        }
        String url = this.host + "/api/v1/rule_personal/upsert";
        String string3 = this.gson.toJson((Object)payload);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string3, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        Request request = this.createAuthenticatedPostRequest(url, requestBody);
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Object object;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                this.handleErrorResponse(response);
            }
            if ((object = response.body()) == null || (object = object.string()) == null) {
                throw new IOException("Empty response body");
            }
            Object responseBody = object;
            Object object2 = this.gson.fromJson((String)responseBody, UpsertRulePersonalResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            UpsertRulePersonalResponse upsertRulePersonalResponse = (UpsertRulePersonalResponse)object2;
            return upsertRulePersonalResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getRulePersonal() {
        Object object;
        Object $this$getRulePersonal_u24lambda_u2437;
        Object object2 = this;
        try {
            RulePersonalResponse rulePersonalResponse;
            $this$getRulePersonal_u24lambda_u2437 = object2;
            boolean bl = false;
            String string = CockpitConfiguration.Companion.getInstance().getState().getUserId();
            if (string == null) {
                return null;
            }
            int userId = Integer.parseInt(string);
            String url = ((CoderiderClient)$this$getRulePersonal_u24lambda_u2437).host + "/api/v1/rule_personal/get?gitlab_user_id=" + userId;
            Request request = super.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
            Closeable closeable = (Closeable)((CoderiderClient)$this$getRulePersonal_u24lambda_u2437).client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl2 = false;
                if (!response.isSuccessful()) {
                    String string2 = "";
                    return string2;
                }
                Object object3 = response.body();
                if (object3 == null || (object3 = object3.string()) == null) {
                    throw new IOException("Empty response body");
                }
                Object responseBody = object3;
                rulePersonalResponse = (RulePersonalResponse)((CoderiderClient)$this$getRulePersonal_u24lambda_u2437).gson.fromJson((String)responseBody, RulePersonalResponse.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$getRulePersonal_u24lambda_u2437 = Result.constructor-impl((Object)rulePersonalResponse.getRuleContent());
        }
        catch (Throwable bl) {
            $this$getRulePersonal_u24lambda_u2437 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getRulePersonal_u24lambda_u2437;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = "";
        }
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getDocument(@NotNull String docType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)docType, (String)"docType");
        String url = this.host + "/api/v1/doc/get" + this.createQueryString(MapsKt.mapOf((Pair)TuplesKt.to((Object)"doc_type", (Object)docType)));
        Request request = this.withGitlabAuth(new Request.Builder().url(url).get().header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).build();
        try {
            String string;
            object = (Closeable)this.client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)object;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    this.handleErrorResponse(response);
                }
                ResponseBody responseBody = response.body();
                string = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (Exception e) {
            LoggerAdapter.DefaultImpls.warn$default(this.logger, "Failed to get document: " + e.getMessage(), null, 2, null);
            object = null;
        }
        return object;
    }

    @Nullable
    public final String getDevflowConfig() {
        String string;
        try {
            String jsonStr = this.getDocument("devflow_config");
            JsonObject jsonObject2 = JsonParser.parseString((String)jsonStr).getAsJsonObject();
            JsonElement jsonElement = jsonObject2.get("doc_content");
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public final void syncTrackConfig() {
        TrackService.INSTANCE.registerSuperProperties();
    }

    public final void syncDevflowConfig() {
        String devflowConfig = this.getDevflowConfig();
        if (devflowConfig != null) {
            ComposerConfiguration.Companion.getInstance().getState().setDevflowPrompt(devflowConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UpsertUserMemoryResponse postUpsertUserMemory(@Nullable UpsertUserMemoryReq payload) {
        if (payload == null) {
            throw new IOException("User not logged in");
        }
        String url = this.host + "/api/v1/user_memory/upsert";
        String string = this.gson.toJson((Object)payload);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, CoderiderClientKt.access$getJSON_MEDIA_TYPE$p());
        Request request = this.createAuthenticatedPostRequest(url, requestBody);
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Object object;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                this.handleErrorResponse(response);
            }
            if ((object = response.body()) == null || (object = object.string()) == null) {
                throw new IOException("Empty response body");
            }
            Object responseBody = object;
            Object object2 = this.gson.fromJson((String)responseBody, UpsertUserMemoryResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            UpsertUserMemoryResponse upsertUserMemoryResponse = (UpsertUserMemoryResponse)object2;
            return upsertUserMemoryResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<GetUserMemoryResponse> getUserMemory(@Nullable GetUserMemoryReq payload) {
        if (payload == null) {
            throw new IOException("User not logged in");
        }
        String url = this.host + "/api/v1/user_memory/get?gitlab_user_id=" + payload.getGitlabUserId() + "&memory_env=" + payload.getMemoryEnv();
        Request request = this.withGitlabAuth(new Request.Builder().url(url).header("Authorization", "Bearer " + CoderiderClientKt.getCoderiderAuthToken())).get().build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            List list = CollectionsKt.toList((Iterable)((Map)this.gson.fromJson(JsonParser.parseString((String)(responseBody != null ? responseBody.string() : null)).getAsJsonObject().get("memories"), (TypeToken)new TypeToken<Map<String, GetUserMemoryResponse>>(){})).values());
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public CoderiderClient() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\tJ\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/client/CoderiderClient$GetIdeCommandRequest;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "toMap", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class GetIdeCommandRequest {
        @NotNull
        private final String id;

        public GetIdeCommandRequest(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Map<String, String> toMap() {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)this.id));
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final GetIdeCommandRequest copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new GetIdeCommandRequest(id);
        }

        public static /* synthetic */ GetIdeCommandRequest copy$default(GetIdeCommandRequest getIdeCommandRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = getIdeCommandRequest.id;
            }
            return getIdeCommandRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "GetIdeCommandRequest(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetIdeCommandRequest)) {
                return false;
            }
            GetIdeCommandRequest getIdeCommandRequest = (GetIdeCommandRequest)other;
            return Intrinsics.areEqual((Object)this.id, (Object)getIdeCommandRequest.id);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003JO\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0016\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0016\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006#"}, d2={"Lcn/gitlab/kilo/jetbrains/client/CoderiderClient$RulePersonalResponse;", "", "id", "", "gitlabUserId", "gitlabUsername", "", "ruleContent", "status", "createdAt", "updatedAt", "<init>", "(IILjava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getId", "()I", "getGitlabUserId", "getGitlabUsername", "()Ljava/lang/String;", "getRuleContent", "getStatus", "getCreatedAt", "getUpdatedAt", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "coderider-kilo-jetbrains"})
    public static final class RulePersonalResponse {
        private final int id;
        @SerializedName(value="gitlab_user_id")
        private final int gitlabUserId;
        @SerializedName(value="gitlab_username")
        @NotNull
        private final String gitlabUsername;
        @SerializedName(value="rule_content")
        @NotNull
        private final String ruleContent;
        @SerializedName(value="status")
        private final int status;
        @SerializedName(value="created_at")
        @NotNull
        private final String createdAt;
        @SerializedName(value="updated_at")
        @NotNull
        private final String updatedAt;

        public RulePersonalResponse(int id, int gitlabUserId, @NotNull String gitlabUsername, @NotNull String ruleContent, int status, @NotNull String createdAt, @NotNull String updatedAt) {
            Intrinsics.checkNotNullParameter((Object)gitlabUsername, (String)"gitlabUsername");
            Intrinsics.checkNotNullParameter((Object)ruleContent, (String)"ruleContent");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
            this.id = id;
            this.gitlabUserId = gitlabUserId;
            this.gitlabUsername = gitlabUsername;
            this.ruleContent = ruleContent;
            this.status = status;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
        }

        public final int getId() {
            return this.id;
        }

        public final int getGitlabUserId() {
            return this.gitlabUserId;
        }

        @NotNull
        public final String getGitlabUsername() {
            return this.gitlabUsername;
        }

        @NotNull
        public final String getRuleContent() {
            return this.ruleContent;
        }

        public final int getStatus() {
            return this.status;
        }

        @NotNull
        public final String getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        public final int component1() {
            return this.id;
        }

        public final int component2() {
            return this.gitlabUserId;
        }

        @NotNull
        public final String component3() {
            return this.gitlabUsername;
        }

        @NotNull
        public final String component4() {
            return this.ruleContent;
        }

        public final int component5() {
            return this.status;
        }

        @NotNull
        public final String component6() {
            return this.createdAt;
        }

        @NotNull
        public final String component7() {
            return this.updatedAt;
        }

        @NotNull
        public final RulePersonalResponse copy(int id, int gitlabUserId, @NotNull String gitlabUsername, @NotNull String ruleContent, int status, @NotNull String createdAt, @NotNull String updatedAt) {
            Intrinsics.checkNotNullParameter((Object)gitlabUsername, (String)"gitlabUsername");
            Intrinsics.checkNotNullParameter((Object)ruleContent, (String)"ruleContent");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
            return new RulePersonalResponse(id, gitlabUserId, gitlabUsername, ruleContent, status, createdAt, updatedAt);
        }

        public static /* synthetic */ RulePersonalResponse copy$default(RulePersonalResponse rulePersonalResponse, int n, int n2, String string, String string2, int n3, String string3, String string4, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = rulePersonalResponse.id;
            }
            if ((n4 & 2) != 0) {
                n2 = rulePersonalResponse.gitlabUserId;
            }
            if ((n4 & 4) != 0) {
                string = rulePersonalResponse.gitlabUsername;
            }
            if ((n4 & 8) != 0) {
                string2 = rulePersonalResponse.ruleContent;
            }
            if ((n4 & 0x10) != 0) {
                n3 = rulePersonalResponse.status;
            }
            if ((n4 & 0x20) != 0) {
                string3 = rulePersonalResponse.createdAt;
            }
            if ((n4 & 0x40) != 0) {
                string4 = rulePersonalResponse.updatedAt;
            }
            return rulePersonalResponse.copy(n, n2, string, string2, n3, string3, string4);
        }

        @NotNull
        public String toString() {
            return "RulePersonalResponse(id=" + this.id + ", gitlabUserId=" + this.gitlabUserId + ", gitlabUsername=" + this.gitlabUsername + ", ruleContent=" + this.ruleContent + ", status=" + this.status + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.id);
            result2 = result2 * 31 + Integer.hashCode(this.gitlabUserId);
            result2 = result2 * 31 + this.gitlabUsername.hashCode();
            result2 = result2 * 31 + this.ruleContent.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.status);
            result2 = result2 * 31 + this.createdAt.hashCode();
            result2 = result2 * 31 + this.updatedAt.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RulePersonalResponse)) {
                return false;
            }
            RulePersonalResponse rulePersonalResponse = (RulePersonalResponse)other;
            if (this.id != rulePersonalResponse.id) {
                return false;
            }
            if (this.gitlabUserId != rulePersonalResponse.gitlabUserId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gitlabUsername, (Object)rulePersonalResponse.gitlabUsername)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ruleContent, (Object)rulePersonalResponse.ruleContent)) {
                return false;
            }
            if (this.status != rulePersonalResponse.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createdAt, (Object)rulePersonalResponse.createdAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedAt, (Object)rulePersonalResponse.updatedAt);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcn/gitlab/kilo/jetbrains/client/CoderiderClient$TerminateResponse;", "", "terminated", "", "", "revoked", "failed", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getTerminated", "()Ljava/util/List;", "getRevoked", "getFailed", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class TerminateResponse {
        @NotNull
        private final List<String> terminated;
        @NotNull
        private final List<String> revoked;
        @NotNull
        private final List<String> failed;

        public TerminateResponse(@NotNull List<String> terminated, @NotNull List<String> revoked, @NotNull List<String> failed) {
            Intrinsics.checkNotNullParameter(terminated, (String)"terminated");
            Intrinsics.checkNotNullParameter(revoked, (String)"revoked");
            Intrinsics.checkNotNullParameter(failed, (String)"failed");
            this.terminated = terminated;
            this.revoked = revoked;
            this.failed = failed;
        }

        @NotNull
        public final List<String> getTerminated() {
            return this.terminated;
        }

        @NotNull
        public final List<String> getRevoked() {
            return this.revoked;
        }

        @NotNull
        public final List<String> getFailed() {
            return this.failed;
        }

        @NotNull
        public final List<String> component1() {
            return this.terminated;
        }

        @NotNull
        public final List<String> component2() {
            return this.revoked;
        }

        @NotNull
        public final List<String> component3() {
            return this.failed;
        }

        @NotNull
        public final TerminateResponse copy(@NotNull List<String> terminated, @NotNull List<String> revoked, @NotNull List<String> failed) {
            Intrinsics.checkNotNullParameter(terminated, (String)"terminated");
            Intrinsics.checkNotNullParameter(revoked, (String)"revoked");
            Intrinsics.checkNotNullParameter(failed, (String)"failed");
            return new TerminateResponse(terminated, revoked, failed);
        }

        public static /* synthetic */ TerminateResponse copy$default(TerminateResponse terminateResponse, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = terminateResponse.terminated;
            }
            if ((n & 2) != 0) {
                list2 = terminateResponse.revoked;
            }
            if ((n & 4) != 0) {
                list3 = terminateResponse.failed;
            }
            return terminateResponse.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "TerminateResponse(terminated=" + this.terminated + ", revoked=" + this.revoked + ", failed=" + this.failed + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.terminated).hashCode();
            result2 = result2 * 31 + ((Object)this.revoked).hashCode();
            result2 = result2 * 31 + ((Object)this.failed).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminateResponse)) {
                return false;
            }
            TerminateResponse terminateResponse = (TerminateResponse)other;
            if (!Intrinsics.areEqual(this.terminated, terminateResponse.terminated)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.revoked, terminateResponse.revoked)) {
                return false;
            }
            return Intrinsics.areEqual(this.failed, terminateResponse.failed);
        }
    }
}

