/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventRecord
implements Serializable {
    private static final long serialVersionUID = -2327319579147636283L;
    private final Map<String, Object> propertyMap;
    private final String eventName;
    private final String distinctId;
    private final Boolean isLoginId;

    private EventRecord(String eventName, String distinctId, Boolean isLoginId, Map<String, Object> propertyMap) {
        this.eventName = eventName;
        this.distinctId = distinctId;
        this.isLoginId = isLoginId;
        this.propertyMap = propertyMap;
    }

    public String toString() {
        return "EventRecord{propertyMap=" + this.propertyMap + ", eventName='" + this.eventName + '\'' + ", distinctId='" + this.distinctId + '\'' + ", isLoginId='" + this.isLoginId + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Boolean getIsLoginId() {
        return this.isLoginId;
    }

    public static class Builder {
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String eventName;
        private String distinctId;
        private Boolean isLoginId;

        private Builder() {
        }

        public EventRecord build() throws InvalidArgumentException {
            if (this.eventName == null) {
                throw new InvalidArgumentException("The eventName is empty.");
            }
            if (this.distinctId == null) {
                throw new InvalidArgumentException("The distinctId is empty.");
            }
            if (this.isLoginId == null) {
                throw new InvalidArgumentException("The isLoginId is empty.");
            }
            return new EventRecord(this.eventName, this.distinctId, this.isLoginId, this.propertyMap);
        }

        public Builder setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder setDistinctId(String distinctId) {
            this.distinctId = distinctId;
            return this;
        }

        public Builder isLoginId(Boolean loginId) {
            this.isLoginId = loginId;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

