/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import io.ktor.server.config.HoconDecoder;
import io.ktor.server.config.HoconMapDecoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\fJ\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lio/ktor/server/config/HoconListDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/typesafe/config/ConfigList;", "list", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Lcom/typesafe/config/ConfigList;Lkotlinx/serialization/modules/SerializersModule;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "", "decodeValue", "()Ljava/lang/Object;", "", "decodeString", "()Ljava/lang/String;", "enumDescriptor", "decodeEnum", "", "decodeLong", "()J", "", "decodeDouble", "()D", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "Lcom/typesafe/config/ConfigList;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "elementIndex", "I", "Lcom/typesafe/config/ConfigValue;", "getCurrentElement", "()Lcom/typesafe/config/ConfigValue;", "currentElement", "ktor-server-core"})
public final class HoconListDecoder
extends AbstractDecoder {
    @NotNull
    private final ConfigList list;
    @NotNull
    private final SerializersModule serializersModule;
    private int elementIndex;

    public HoconListDecoder(@NotNull ConfigList list, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.list = list;
        this.serializersModule = serializersModule;
    }

    public /* synthetic */ HoconListDecoder(ConfigList configList, SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
        }
        this(configList, serializersModule);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final ConfigValue getCurrentElement() {
        Object object = this.list.get(this.elementIndex - 1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ConfigValue)object;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.elementIndex < this.list.size()) {
            int n2 = this.elementIndex;
            this.elementIndex = n2 + 1;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public Object decodeValue() {
        Object object = this.getCurrentElement().unwrapped();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unwrapped(...)");
        return object;
    }

    @NotNull
    public String decodeString() {
        return this.getCurrentElement().unwrapped().toString();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return enumDescriptor.getElementIndex(this.decodeString());
    }

    public long decodeLong() {
        long l;
        Object value = this.getCurrentElement().unwrapped();
        if (value instanceof Integer) {
            l = ((Number)value).intValue();
        } else if (value instanceof Long) {
            l = ((Number)value).longValue();
        } else {
            throw new SerializationException("Cannot decode Long from " + value);
        }
        return l;
    }

    public double decodeDouble() {
        double d;
        Object value = ((ConfigValue)this.list.get(this.elementIndex - 1)).unwrapped();
        if (value instanceof Integer) {
            d = ((Number)value).intValue();
        } else if (value instanceof Long) {
            d = ((Number)value).longValue();
        } else if (value instanceof Double) {
            d = ((Number)value).doubleValue();
        } else {
            throw new SerializationException("Cannot decode Double from " + value);
        }
        return d;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        Intrinsics.checkNotNull((Object)serialKind, (String)"null cannot be cast to non-null type kotlinx.serialization.descriptors.StructureKind");
        StructureKind structureKind = (StructureKind)serialKind;
        if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.LIST.INSTANCE)) {
            ConfigValue configValue = this.getCurrentElement();
            ConfigList configList = configValue instanceof ConfigList ? (ConfigList)configValue : null;
            if (configList == null) {
                throw new SerializationException("Expected a ConfigList but got " + this.getCurrentElement());
            }
            compositeDecoder = (CompositeDecoder)new HoconListDecoder(configList, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.MAP.INSTANCE)) {
            ConfigValue configValue = this.getCurrentElement();
            ConfigObject configObject = configValue instanceof ConfigObject ? (ConfigObject)configValue : null;
            if (configObject == null || (configObject = configObject.toConfig()) == null) {
                throw new SerializationException("Expected a ConfigObject but got " + this.getCurrentElement());
            }
            compositeDecoder = (CompositeDecoder)new HoconMapDecoder((Config)configObject, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            ConfigValue configValue = this.getCurrentElement();
            ConfigObject configObject = configValue instanceof ConfigObject ? (ConfigObject)configValue : null;
            if (configObject == null || (configObject = configObject.toConfig()) == null) {
                throw new SerializationException("Expected a ConfigObject but got " + this.getCurrentElement());
            }
            compositeDecoder = (CompositeDecoder)new HoconDecoder((Config)configObject, "", this.getSerializersModule());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compositeDecoder;
    }
}

