/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.webview;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.webview.WebViewInstance;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/sina/weibo/agent/webview/DragDropHandler;", "", "webViewInstance", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "targetComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/sina/weibo/agent/webview/WebViewInstance;Ljavax/swing/JComponent;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "setupDragAndDrop", "", "isShiftKeyPressed", "", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "notifyDragState", "isDragging", "handleFileDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "insertFilePathsIntoTextarea", "files", "", "Ljava/io/File;", "hasFileList", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDragDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragDropHandler.kt\ncom/sina/weibo/agent/webview/DragDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1563#2:332\n1634#2,3:333\n1563#2:336\n1634#2,3:337\n*S KotlinDebug\n*F\n+ 1 DragDropHandler.kt\ncom/sina/weibo/agent/webview/DragDropHandler\n*L\n129#1:332\n129#1:333,3\n155#1:336\n155#1:337,3\n*E\n"})
public final class DragDropHandler {
    @NotNull
    private final WebViewInstance webViewInstance;
    @NotNull
    private final JComponent targetComponent;
    @NotNull
    private final Logger logger;

    public DragDropHandler(@NotNull WebViewInstance webViewInstance, @NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)webViewInstance, (String)"webViewInstance");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        this.webViewInstance = webViewInstance;
        this.targetComponent = targetComponent;
        Logger logger = Logger.getInstance(DragDropHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final void setupDragAndDrop() {
        this.logger.info("Setting up drag and drop support for WebView (VSCode-compatible)");
        DropTarget dropTarget2 = new DropTarget(this.targetComponent, new DropTargetAdapter(this){
            final /* synthetic */ DragDropHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drag enter detected");
                if (DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) && DragDropHandler.access$hasFileList(this.this$0, dtde)) {
                    dtde.acceptDrag(1);
                    DragDropHandler.access$notifyDragState(this.this$0, true);
                    DragDropHandler.access$getLogger$p(this.this$0).info("Drag accepted - Shift key pressed and files detected");
                } else {
                    dtde.rejectDrag();
                    DragDropHandler.access$getLogger$p(this.this$0).info("Drag rejected - " + (!DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) ? "Shift key not pressed" : "no files detected"));
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                if (DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) && DragDropHandler.access$hasFileList(this.this$0, dtde)) {
                    dtde.acceptDrag(1);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent dte) {
                Intrinsics.checkNotNullParameter((Object)dte, (String)"dte");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drag exit detected");
                DragDropHandler.access$notifyDragState(this.this$0, false);
            }

            public void drop(DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drop event detected");
                DragDropHandler.access$handleFileDrop(this.this$0, dtde);
            }
        });
        this.logger.info("Drag and drop setup completed");
    }

    private final boolean isShiftKeyPressed(DropTargetDragEvent dtde) {
        return true;
    }

    private final void notifyDragState(boolean isDragging) {
        try {
            String jsCode = StringsKt.trimIndent((String)("\n                (function() {\n                    console.log('Setting drag state:', " + isDragging + ");\n                    const textareas = document.querySelectorAll('textarea, [contenteditable=\"true\"]');\n                    if (" + isDragging + ") {\n                        textareas.forEach(textarea => {\n                            textarea.style.border = '2px dashed #007acc';\n                            textarea.style.backgroundColor = 'rgba(0, 122, 204, 0.1)';\n                            textarea.setAttribute('data-dragging', 'true');\n                        });\n                    } else {\n                        textareas.forEach(textarea => {\n                            textarea.style.border = '';\n                            textarea.style.backgroundColor = '';\n                            textarea.removeAttribute('data-dragging');\n                        });\n                    }\n                })();\n            "));
            this.webViewInstance.executeJavaScript(jsCode);
        }
        catch (Exception e) {
            this.logger.error("Failed to notify drag state", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFileDrop(DropTargetDropEvent dtde) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.logger.info("Processing drop event");
            if (!this.hasFileList(dtde)) {
                this.logger.info("Drop rejected: No file list in transferable");
                dtde.rejectDrop();
                this.notifyDragState(false);
                return;
            }
            dtde.acceptDrop(1);
            Transferable transferable = dtde.getTransferable();
            Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
            List fileList = (List)object;
            Iterable iterable = fileList;
            Logger logger = this.logger;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            logger.info("Files dropped: " + (List)destination$iv$iv);
            if (!((Collection)fileList).isEmpty()) {
                this.insertFilePathsIntoTextarea(fileList);
                dtde.dropComplete(true);
            } else {
                this.logger.warn("No valid files found in drop event");
                dtde.dropComplete(false);
            }
            this.notifyDragState(false);
        }
        catch (Exception e) {
            this.logger.error("Error handling file drop", (Throwable)e);
            dtde.dropComplete(false);
            this.notifyDragState(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void insertFilePathsIntoTextarea(List<? extends File> files) {
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = files;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(file.getAbsolutePath());
            }
            List filePaths = (List)destination$iv$iv;
            this.logger.info("Forwarding drag drop event to VSCode native handler: " + filePaths.size() + " files");
            String jsCode = StringsKt.trimIndent((String)("\n                (function() {\n                    console.log('Simulating native drag drop event for VSCode');\n                    \n                    // Find target textarea\n                    const textareas = document.querySelectorAll('textarea, [contenteditable=\"true\"], input[type=\"text\"]');\n                    console.log('Found textareas:', textareas.length);\n                    \n                    if (textareas.length === 0) {\n                        console.warn('No suitable textarea found');\n                        return false;\n                    }\n                    \n                    // Select target textarea\n                    let targetTextarea = document.activeElement;\n                    if (!targetTextarea || !['TEXTAREA', 'INPUT'].includes(targetTextarea.tagName)) {\n                        targetTextarea = textareas[0];\n                    }\n                    \n                    if (!targetTextarea) {\n                        console.warn('No valid target textarea found');\n                        return false;\n                    }\n                    \n                    console.log('Target textarea found:', targetTextarea.tagName);\n                    \n                    // Build file path data\n                    const filePaths = [" + CollectionsKt.joinToString$default((Iterable)filePaths, (CharSequence)", ", null, null, (int)0, null, DragDropHandler::insertFilePathsIntoTextarea$lambda$2, (int)30, null) + "];\n                    \n                    console.log('File paths to insert:', filePaths);\n                    \n                    // Create mock File objects\n                    const mockFiles = filePaths.map(path => ({\n                        name: path.split('/').pop() || path.split('\\\\\\\\').pop() || 'unknown',\n                        path: path,\n                        type: '',\n                        size: 0,\n                        lastModified: Date.now(),\n                        webkitRelativePath: ''\n                    }));\n                    \n                    // Create mock FileList object\n                    const mockFileList = {\n                        length: mockFiles.length,\n                        item: function(index) {\n                            return mockFiles[index] || null;\n                        },\n                        [Symbol.iterator]: function* () {\n                            for (let i = 0; i < this.length; i++) {\n                                yield this.item(i);\n                            }\n                        }\n                    };\n                    \n                    // Add array index access to FileList\n                    mockFiles.forEach((file, index) => {\n                        mockFileList[index] = file;\n                    });\n                    \n                    // Create mock DataTransferItem objects\n                    const mockItems = mockFiles.map(file => ({\n                        kind: 'file',\n                        type: file.type,\n                        getAsFile: function() {\n                            return file;\n                        },\n                        getAsString: function(callback) {\n                            if (callback) callback(file.path);\n                        }\n                    }));\n                    \n                    // Create mock DataTransferItemList object\n                    const mockItemList = {\n                        length: mockItems.length,\n                        item: function(index) {\n                            return mockItems[index] || null;\n                        },\n                        [Symbol.iterator]: function* () {\n                            for (let i = 0; i < this.length; i++) {\n                                yield this.item(i);\n                            }\n                        }\n                    };\n                    \n                    // Add array index access to ItemList\n                    mockItems.forEach((item, index) => {\n                        mockItemList[index] = item;\n                    });\n                    \n                    console.log('Created mock FileList with', mockFileList.length, 'files');\n                    console.log('Created mock ItemList with', mockItemList.length, 'items');\n                    \n                    // Create complete DataTransfer object\n                    const mockDataTransfer = {\n                        files: mockFileList,\n                        items: mockItemList,\n                        types: ['Files', 'text/uri-list', 'text/plain'],\n                        getData: function(format) {\n                            console.log('DataTransfer.getData called with format:', format);\n                            if (format === 'text' || format === 'text/plain') {\n                                return filePaths.join('\\n');\n                            }\n                            if (format === 'text/uri-list' || format === 'application/vnd.code.uri-list') {\n                                return filePaths.map(path => 'file://' + path).join('\\n');\n                            }\n                            return '';\n                        },\n                        setData: function(format, data) {\n                            // Mock implementation\n                        },\n                        clearData: function(format) {\n                            // Mock implementation\n                        },\n                        effectAllowed: 'copy',\n                        dropEffect: 'copy'\n                    };\n                    \n                    // Create mock drop event\n                    const mockDragEvent = new Event('drop', {\n                        bubbles: true,\n                        cancelable: true\n                    });\n                    \n                    // Add required properties\n                    Object.defineProperty(mockDragEvent, 'dataTransfer', {\n                        value: mockDataTransfer,\n                        writable: false\n                    });\n                    \n                    // Simulate Shift key pressed (required by VSCode)\n                    Object.defineProperty(mockDragEvent, 'shiftKey', {\n                        value: true,\n                        writable: false\n                    });\n                    \n                    console.log('Dispatching mock drop event to textarea');\n                    \n                    // Ensure textarea is focused\n                    targetTextarea.focus();\n                    \n                    // Dispatch event to textarea for VSCode native handler\n                    const result = targetTextarea.dispatchEvent(mockDragEvent);\n                    \n                    console.log('Mock drop event dispatched, result:', result);\n                    \n                    return true;\n                })();\n            "));
            this.webViewInstance.executeJavaScript(jsCode);
        }
        catch (Exception e) {
            this.logger.error("Failed to forward drag drop event to VSCode", (Throwable)e);
        }
    }

    private final boolean hasFileList(DropTargetDragEvent dtde) {
        return dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private final boolean hasFileList(DropTargetDropEvent dtde) {
        return dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private static final CharSequence insertFilePathsIntoTextarea$lambda$2(String it) {
        return "\"" + it + "\"";
    }

    public static final /* synthetic */ Logger access$getLogger$p(DragDropHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isShiftKeyPressed(DragDropHandler $this, DropTargetDragEvent dtde) {
        return $this.isShiftKeyPressed(dtde);
    }

    public static final /* synthetic */ boolean access$hasFileList(DragDropHandler $this, DropTargetDragEvent dtde) {
        return $this.hasFileList(dtde);
    }

    public static final /* synthetic */ void access$notifyDragState(DragDropHandler $this, boolean isDragging) {
        $this.notifyDragState(isDragging);
    }

    public static final /* synthetic */ void access$handleFileDrop(DragDropHandler $this, DropTargetDropEvent dtde) {
        $this.handleFileDrop(dtde);
    }
}

