/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import com.sina.weibo.agent.util.URI;
import com.sina.weibo.agent.util.URIComponents;
import com.sina.weibo.agent.util.URIUtilKt;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tB?\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0002JB\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0013\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/sina/weibo/agent/util/URI;", "Lcom/sina/weibo/agent/util/URIComponents;", "scheme", "", "authority", "path", "query", "fragment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "strict", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getScheme", "()Ljava/lang/String;", "getAuthority", "getPath", "getQuery", "getFragment", "validate", "", "fsPath", "getFsPath", "with", "toString", "skipEncoding", "asFormatted", "equals", "other", "", "hashCode", "", "Companion", "coderider-kilo-jetbrains"})
public final class URI
implements URIComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;
    @Nullable
    private final String authority;
    @NotNull
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final String fragment;
    private static final boolean isWindows;
    @NotNull
    private static final String SLASH = "/";
    @NotNull
    private static final String EMPTY;
    @NotNull
    private static final Regex schemePattern;
    @NotNull
    private static final Regex singleSlashStart;
    @NotNull
    private static final Regex doubleSlashStart;
    @NotNull
    private static final Regex uriRegex;

    private URI(String scheme, String authority, String path, String query, String fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    @Override
    @NotNull
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getQuery() {
        return this.query;
    }

    @Override
    @Nullable
    public String getFragment() {
        return this.fragment;
    }

    private URI(String scheme, String authority, String path, String query, String fragment, boolean strict) {
        this(URIUtilKt.access$schemeFix(scheme, strict), authority, URIUtilKt.access$referenceResolution(URIUtilKt.access$schemeFix(scheme, strict), path), query, fragment);
        if (strict) {
            this.validate();
        }
    }

    private final void validate() {
        if (((CharSequence)this.getScheme()).length() == 0) {
            throw new IllegalArgumentException("[UriError]: Scheme is missing: {scheme: \"\", authority: \"" + this.getAuthority() + "\", path: \"" + this.getPath() + "\", query: \"" + this.getQuery() + "\", fragment: \"" + this.getFragment() + "\"}");
        }
        if (!schemePattern.matches((CharSequence)this.getScheme())) {
            throw new IllegalArgumentException("[UriError]: Scheme contains illegal characters.");
        }
        if (((CharSequence)this.getPath()).length() > 0) {
            String string = this.getAuthority();
            boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl) {
                if (!singleSlashStart.containsMatchIn((CharSequence)this.getPath())) {
                    throw new IllegalArgumentException("[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash (\"/\") character");
                }
            } else if (doubleSlashStart.containsMatchIn((CharSequence)this.getPath())) {
                throw new IllegalArgumentException("[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters (\"//\")");
            }
        }
    }

    @NotNull
    public final String getFsPath() {
        return URIUtilKt.access$uriToFsPath(this, false);
    }

    @NotNull
    public final URI with(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String query, @Nullable String fragment) {
        String newFragment;
        String string;
        String newQuery;
        String string2;
        String newPath;
        String string3;
        String newAuthority;
        String string4;
        String newScheme;
        String string5 = scheme;
        if (string5 == null) {
            string5 = newScheme = this.getScheme();
        }
        if ((string4 = authority) == null) {
            string4 = newAuthority = this.getAuthority();
        }
        if ((string3 = path) == null) {
            string3 = newPath = this.getPath();
        }
        if ((string2 = query) == null) {
            string2 = newQuery = this.getQuery();
        }
        if ((string = fragment) == null) {
            string = newFragment = this.getFragment();
        }
        if (Intrinsics.areEqual((Object)newScheme, (Object)this.getScheme()) && Intrinsics.areEqual((Object)newAuthority, (Object)this.getAuthority()) && Intrinsics.areEqual((Object)newPath, (Object)this.getPath()) && Intrinsics.areEqual((Object)newQuery, (Object)this.getQuery()) && Intrinsics.areEqual((Object)newFragment, (Object)this.getFragment())) {
            return this;
        }
        return new URI(newScheme, newAuthority, newPath, newQuery, newFragment);
    }

    public static /* synthetic */ URI with$default(URI uRI, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        return uRI.with(string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return this.asFormatted(false);
    }

    @NotNull
    public final String toString(boolean skipEncoding) {
        return this.asFormatted(skipEncoding);
    }

    private final String asFormatted(boolean skipEncoding) {
        Function3 encoderFn2 = !skipEncoding ? (Function3)asFormatted.encoderFn.1.INSTANCE : (Function3)asFormatted.encoderFn.2.INSTANCE;
        Object res = "";
        if (((CharSequence)this.getScheme()).length() > 0) {
            res = (String)res + this.getScheme();
            res = (String)res + ":";
        }
        String string = this.getAuthority();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl || Intrinsics.areEqual((Object)this.getScheme(), (Object)"file")) {
            res = (String)res + SLASH;
            res = (String)res + SLASH;
        }
        String string2 = this.getAuthority();
        boolean bl2 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
        if (bl2) {
            int idx = StringsKt.indexOf$default((CharSequence)this.getAuthority(), (char)'@', (int)0, (boolean)false, (int)6, null);
            if (idx != -1) {
                String string3 = this.getAuthority().substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String userinfo = string3;
                String string4 = this.getAuthority().substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String auth = string4;
                int userinfoIdx = StringsKt.lastIndexOf$default((CharSequence)userinfo, (char)':', (int)0, (boolean)false, (int)6, null);
                if (userinfoIdx == -1) {
                    res = (String)res + encoderFn2.invoke((Object)userinfo, (Object)false, (Object)false);
                } else {
                    String string5 = userinfo.substring(0, userinfoIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    res = (String)res + encoderFn2.invoke((Object)string5, (Object)false, (Object)false);
                    res = (String)res + ":";
                    String string6 = userinfo.substring(userinfoIdx + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    res = (String)res + encoderFn2.invoke((Object)string6, (Object)false, (Object)true);
                }
                res = (String)res + "@";
                String string7 = auth.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                String authorityLower = string7;
                int authorityIdx = StringsKt.lastIndexOf$default((CharSequence)authorityLower, (char)':', (int)0, (boolean)false, (int)6, null);
                if (authorityIdx == -1) {
                    res = (String)res + encoderFn2.invoke((Object)authorityLower, (Object)false, (Object)true);
                } else {
                    String string8 = authorityLower.substring(0, authorityIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                    res = (String)res + encoderFn2.invoke((Object)string8, (Object)false, (Object)true);
                    String string9 = authorityLower.substring(authorityIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                    res = (String)res + string9;
                }
            } else {
                String string10 = this.getAuthority().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
                String authorityLower = string10;
                int idx2 = StringsKt.lastIndexOf$default((CharSequence)authorityLower, (char)':', (int)0, (boolean)false, (int)6, null);
                if (idx2 == -1) {
                    res = (String)res + encoderFn2.invoke((Object)authorityLower, (Object)false, (Object)true);
                } else {
                    String string11 = authorityLower.substring(0, idx2);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                    res = (String)res + encoderFn2.invoke((Object)string11, (Object)false, (Object)true);
                    String string12 = authorityLower.substring(idx2);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"substring(...)");
                    res = (String)res + string12;
                }
            }
        }
        if (((CharSequence)this.getPath()).length() > 0) {
            Object normalizedPath = this.getPath();
            if (((String)normalizedPath).length() >= 3 && ((String)normalizedPath).charAt(0) == '/' && ((String)normalizedPath).charAt(2) == ':') {
                char code = ((String)normalizedPath).charAt(1);
                boolean bl3 = 'A' <= code ? code < '[' : false;
                if (bl3) {
                    char c = Character.toLowerCase(((String)normalizedPath).charAt(1));
                    String string13 = ((String)normalizedPath).substring(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"substring(...)");
                    normalizedPath = SLASH + c + ":" + string13;
                }
            } else if (((String)normalizedPath).length() >= 2 && ((String)normalizedPath).charAt(1) == ':') {
                char code = ((String)normalizedPath).charAt(0);
                boolean bl4 = 'A' <= code ? code < '[' : false;
                if (bl4) {
                    char c = Character.toLowerCase(((String)normalizedPath).charAt(0));
                    String string14 = ((String)normalizedPath).substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
                    normalizedPath = c + ":" + string14;
                }
            }
            res = (String)res + encoderFn2.invoke(normalizedPath, (Object)true, (Object)false);
        }
        String string15 = this.getQuery();
        boolean bl5 = string15 != null ? ((CharSequence)string15).length() > 0 : false;
        if (bl5) {
            res = (String)res + "?";
            res = (String)res + encoderFn2.invoke((Object)this.getQuery(), (Object)false, (Object)false);
        }
        String string16 = this.getFragment();
        boolean bl6 = string16 != null ? ((CharSequence)string16).length() > 0 : false;
        if (bl6) {
            res = (String)res + "#";
            res = (String)res + encoderFn2.invoke((Object)this.getFragment(), (Object)false, (Object)false);
        }
        return res;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URI)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getScheme(), (Object)((URI)other).getScheme())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPath(), (Object)((URI)other).getPath())) {
            return false;
        }
        if ((this.getAuthority() != null && !(((CharSequence)this.getAuthority()).length() == 0) || ((URI)other).getAuthority() != null && !(((CharSequence)((URI)other).getAuthority()).length() == 0)) && !Intrinsics.areEqual((Object)this.getAuthority(), (Object)((URI)other).getAuthority())) {
            return false;
        }
        if ((this.getQuery() != null && !(((CharSequence)this.getQuery()).length() == 0) || ((URI)other).getQuery() != null && !(((CharSequence)((URI)other).getQuery()).length() == 0)) && !Intrinsics.areEqual((Object)this.getQuery(), (Object)((URI)other).getQuery())) {
            return false;
        }
        return (this.getFragment() == null || ((CharSequence)this.getFragment()).length() == 0) && (((URI)other).getFragment() == null || ((CharSequence)((URI)other).getFragment()).length() == 0) || Intrinsics.areEqual((Object)this.getFragment(), (Object)((URI)other).getFragment());
    }

    public int hashCode() {
        int result2 = this.getScheme().hashCode();
        if (this.getAuthority() != null && !Intrinsics.areEqual((Object)this.getAuthority(), (Object)"")) {
            result2 = 31 * result2 + this.getAuthority().hashCode();
        }
        result2 = 31 * result2 + this.getPath().hashCode();
        if (this.getQuery() != null && !Intrinsics.areEqual((Object)this.getQuery(), (Object)"")) {
            result2 = 31 * result2 + this.getQuery().hashCode();
        }
        if (this.getFragment() != null && !Intrinsics.areEqual((Object)this.getFragment(), (Object)"")) {
            result2 = 31 * result2 + this.getFragment().hashCode();
        }
        return result2;
    }

    public /* synthetic */ URI(String scheme, String authority, String path, String query, String fragment, DefaultConstructorMarker $constructor_marker) {
        this(scheme, authority, path, query, fragment);
    }

    public /* synthetic */ URI(String scheme, String authority, String path, String query, String fragment, boolean strict, DefaultConstructorMarker $constructor_marker) {
        this(scheme, authority, path, query, fragment, strict);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        isWindows = StringsKt.contains$default((CharSequence)string2, (CharSequence)"windows", (boolean)false, (int)2, null);
        EMPTY = "";
        schemePattern = new Regex("^\\w[\\w\\d+.-]*$");
        singleSlashStart = new Regex("^/");
        doubleSlashStart = new Regex("^//");
        uriRegex = new Regex("^(([^:/?#]+?):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u0005J'\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001b\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sina/weibo/agent/util/URI$Companion;", "", "<init>", "()V", "isWindows", "", "SLASH", "", "EMPTY", "schemePattern", "Lkotlin/text/Regex;", "singleSlashStart", "doubleSlashStart", "uriRegex", "parse", "Lcom/sina/weibo/agent/util/URI;", "value", "strict", "file", "path", "Ljava/nio/file/Path;", "from", "components", "Lcom/sina/weibo/agent/util/URIComponents;", "joinPath", "uri", "pathFragments", "", "(Lcom/sina/weibo/agent/util/URI;[Ljava/lang/String;)Lcom/sina/weibo/agent/util/URI;", "percentDecode", "str", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URI parse(@NotNull String value, boolean strict) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            MatchResult matchResult = Regex.find$default((Regex)uriRegex, (CharSequence)value, (int)0, (int)2, null);
            if (matchResult == null) {
                return new URI(EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, null);
            }
            MatchResult match = matchResult;
            Object object2 = match.getGroups().get(2);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = EMPTY;
            }
            if ((object = match.getGroups().get(4)) == null || (object = object.getValue()) == null) {
                object = EMPTY;
            }
            String string = this.percentDecode((String)object);
            Object object3 = match.getGroups().get(5);
            if (object3 == null || (object3 = object3.getValue()) == null) {
                object3 = EMPTY;
            }
            String string2 = this.percentDecode((String)object3);
            Object object4 = match.getGroups().get(7);
            if (object4 == null || (object4 = object4.getValue()) == null) {
                object4 = EMPTY;
            }
            String string3 = this.percentDecode((String)object4);
            Object object5 = match.getGroups().get(9);
            if (object5 == null || (object5 = object5.getValue()) == null) {
                object5 = EMPTY;
            }
            return new URI((String)object2, string, string2, string3, this.percentDecode((String)object5), strict, null);
        }

        public static /* synthetic */ URI parse$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parse(string, bl);
        }

        @NotNull
        public final URI file(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String normalizedPath = path;
            String authority = EMPTY;
            if (isWindows) {
                normalizedPath = StringsKt.replace$default((String)normalizedPath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            }
            if (StringsKt.startsWith$default((String)normalizedPath, (String)"//", (boolean)false, (int)2, null)) {
                int idx = StringsKt.indexOf$default((CharSequence)normalizedPath, (char)'/', (int)2, (boolean)false, (int)4, null);
                if (idx == -1) {
                    String string = normalizedPath.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    authority = string;
                    normalizedPath = URI.SLASH;
                } else {
                    String string = normalizedPath.substring(2, idx);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    authority = string;
                    String string2 = normalizedPath.substring(idx);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String string3 = string2;
                    if (string2 == null) {
                        string3 = URI.SLASH;
                    }
                    normalizedPath = string3;
                }
            }
            return new URI("file", authority, normalizedPath, EMPTY, EMPTY, null);
        }

        @NotNull
        public final URI file(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.file(((Object)path).toString());
        }

        @NotNull
        public final URI from(@NotNull URIComponents components, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            return new URI(components.getScheme(), components.getAuthority(), components.getPath(), components.getQuery(), components.getFragment(), strict, null);
        }

        public static /* synthetic */ URI from$default(Companion companion, URIComponents uRIComponents, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.from(uRIComponents, bl);
        }

        @NotNull
        public final URI joinPath(@NotNull URI uri, String ... pathFragments) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)pathFragments, (String)"pathFragments");
            if (((CharSequence)uri.getPath()).length() == 0) {
                throw new IllegalArgumentException("[UriError]: cannot call joinPath on URI without path");
            }
            if (isWindows && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                String fsPath = URIUtilKt.access$uriToFsPath(uri, true);
                String joinedPath = ((Object)Paths.get(fsPath, Arrays.copyOf(pathFragments, pathFragments.length))).toString();
                string = this.file(joinedPath).getPath();
            } else {
                List fragments = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)uri.getPath()), (Object[])pathFragments);
                CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)fragments, (CharSequence)URI.SLASH, null, null, (int)0, null, null, (int)62, null);
                Regex regex = new Regex("/+");
                String string2 = URI.SLASH;
                string = regex.replace(charSequence, string2);
            }
            String newPath = string;
            return URI.with$default(uri, null, null, newPath, null, null, 27, null);
        }

        private final String percentDecode(String str) {
            Regex encodedAsHex = new Regex("(%[0-9A-Za-z][0-9A-Za-z])+");
            if (!encodedAsHex.containsMatchIn((CharSequence)str)) {
                return str;
            }
            return encodedAsHex.replace((CharSequence)str, Companion::percentDecode$lambda$0);
        }

        private static final CharSequence percentDecode$lambda$0(MatchResult match) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            try {
                charSequence = URLDecoder.decode(match.getValue(), "UTF-8");
                Intrinsics.checkNotNull((Object)charSequence);
                charSequence = charSequence;
            }
            catch (Exception e) {
                charSequence = match.getValue();
            }
            return charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

