/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.util.NodeVersion;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/sina/weibo/agent/util/NodeVersionUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getNodeVersion", "Lcom/sina/weibo/agent/util/NodeVersion;", "nodePath", "", "parseNodeVersion", "versionOutput", "isVersionSupported", "", "nodeVersion", "minRequiredVersion", "coderider-kilo-jetbrains"})
public final class NodeVersionUtil {
    @NotNull
    public static final NodeVersionUtil INSTANCE = new NodeVersionUtil();
    @NotNull
    private static final Logger LOG;

    private NodeVersionUtil() {
    }

    @Nullable
    public final NodeVersion getNodeVersion(@NotNull String nodePath) {
        NodeVersion nodeVersion;
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        try {
            String[] stringArray = new String[]{nodePath, "--version"};
            Process process2 = new ProcessBuilder(stringArray).start();
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String output = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
            process2.waitFor();
            nodeVersion = this.parseNodeVersion(output);
        }
        catch (Exception e) {
            LOG.warn("Failed to get Node.js version", (Throwable)e);
            nodeVersion = null;
        }
        return nodeVersion;
    }

    private final NodeVersion parseNodeVersion(String versionOutput) {
        NodeVersion nodeVersion;
        try {
            NodeVersion nodeVersion2;
            Regex versionRegex = new Regex("v(\\d+)\\.(\\d+)\\.(\\d+)");
            MatchResult matchResult = Regex.find$default((Regex)versionRegex, (CharSequence)((Object)StringsKt.trim((CharSequence)versionOutput)).toString(), (int)0, (int)2, null);
            if (matchResult != null) {
                int major = Integer.parseInt((String)matchResult.getGroupValues().get(1));
                int minor = Integer.parseInt((String)matchResult.getGroupValues().get(2));
                int patch = Integer.parseInt((String)matchResult.getGroupValues().get(3));
                NodeVersion nodeVersion3 = new NodeVersion(major, minor, patch, ((Object)StringsKt.trim((CharSequence)versionOutput)).toString());
                LOG.info("Node.js version: " + versionOutput + ", parsed: " + major + "." + minor + "." + patch);
                nodeVersion2 = nodeVersion3;
            } else {
                LOG.warn("Failed to parse Node.js version from output: " + versionOutput);
                nodeVersion2 = null;
            }
            nodeVersion = nodeVersion2;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse Node.js version", (Throwable)e);
            nodeVersion = null;
        }
        return nodeVersion;
    }

    public final boolean isVersionSupported(@Nullable NodeVersion nodeVersion, @NotNull NodeVersion minRequiredVersion) {
        Intrinsics.checkNotNullParameter((Object)minRequiredVersion, (String)"minRequiredVersion");
        NodeVersion nodeVersion2 = nodeVersion;
        return nodeVersion2 != null ? nodeVersion2.isGreaterOrEqualTo(minRequiredVersion) : false;
    }

    static {
        Logger logger = Logger.getInstance(NodeVersionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

