/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/sina/weibo/agent/util/NodeVersion;", "", "major", "", "minor", "patch", "original", "", "<init>", "(IIILjava/lang/String;)V", "getMajor", "()I", "getMinor", "getPatch", "getOriginal", "()Ljava/lang/String;", "compareTo", "other", "isLowerThan", "", "isGreaterOrEqualTo", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "coderider-kilo-jetbrains"})
public final class NodeVersion {
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final String original;

    public NodeVersion(int major, int minor, int patch, @NotNull String original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.original = original;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    public final int compareTo(@NotNull NodeVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.major != other.major ? this.major - other.major : (this.minor != other.minor ? this.minor - other.minor : this.patch - other.patch);
    }

    public final boolean isLowerThan(@NotNull NodeVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean isGreaterOrEqualTo(@NotNull NodeVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    @NotNull
    public String toString() {
        return this.original;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final String component4() {
        return this.original;
    }

    @NotNull
    public final NodeVersion copy(int major, int minor, int patch, @NotNull String original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return new NodeVersion(major, minor, patch, original);
    }

    public static /* synthetic */ NodeVersion copy$default(NodeVersion nodeVersion, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = nodeVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = nodeVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = nodeVersion.patch;
        }
        if ((n4 & 8) != 0) {
            string = nodeVersion.original;
        }
        return nodeVersion.copy(n, n2, n3, string);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        result2 = result2 * 31 + Integer.hashCode(this.patch);
        result2 = result2 * 31 + this.original.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeVersion)) {
            return false;
        }
        NodeVersion nodeVersion = (NodeVersion)other;
        if (this.major != nodeVersion.major) {
            return false;
        }
        if (this.minor != nodeVersion.minor) {
            return false;
        }
        if (this.patch != nodeVersion.patch) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.original, (Object)nodeVersion.original);
    }
}

