/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import com.sina.weibo.agent.util.PluginConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0005J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0007J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c\u00a8\u0006\u001d"}, d2={"Lcom/sina/weibo/agent/util/ConfigFileUtils;", "", "<init>", "()V", "getCurrentExtensionId", "", "ensureConfigDirExists", "", "loadMainConfig", "Ljava/util/Properties;", "saveMainConfig", "properties", "comment", "loadExtensionConfig", "extensionId", "saveExtensionConfig", "getMainConfigPath", "getExtensionConfigPath", "mainConfigExists", "", "extensionConfigExists", "getConfigValue", "key", "defaultValue", "setConfigValue", "value", "createDefaultMainConfig", "listExtensionConfigFiles", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nConfigFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigFileUtils.kt\ncom/sina/weibo/agent/util/ConfigFileUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,193:1\n13472#2,2:194\n*S KotlinDebug\n*F\n+ 1 ConfigFileUtils.kt\ncom/sina/weibo/agent/util/ConfigFileUtils\n*L\n180#1:194,2\n*E\n"})
public final class ConfigFileUtils {
    @NotNull
    public static final ConfigFileUtils INSTANCE = new ConfigFileUtils();

    private ConfigFileUtils() {
    }

    @Nullable
    public final String getCurrentExtensionId() {
        Properties properties = this.loadMainConfig();
        String currentExtensionId = properties.getProperty("extension.type");
        return currentExtensionId;
    }

    public final void ensureConfigDirExists() {
        try {
            File configDir = new File(PluginConstants.ConfigFiles.INSTANCE.getUserConfigDir());
            if (!configDir.exists()) {
                configDir.mkdirs();
                System.out.println((Object)("Created configuration directory: " + configDir.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to create configuration directory", e);
        }
    }

    @NotNull
    public final Properties loadMainConfig() {
        Properties properties = new Properties();
        try {
            File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getMainConfigPath());
            if (configFile.exists()) {
                properties.load(new FileInputStream(configFile));
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to load main configuration file", e);
        }
        return properties;
    }

    public final void saveMainConfig(@NotNull Properties properties, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        try {
            this.ensureConfigDirExists();
            File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getMainConfigPath());
            properties.store(new FileOutputStream(configFile), comment);
        }
        catch (IOException e) {
            throw new IOException("Failed to save main configuration file", e);
        }
    }

    public static /* synthetic */ void saveMainConfig$default(ConfigFileUtils configFileUtils, Properties properties, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "RunVSAgent Configuration";
        }
        configFileUtils.saveMainConfig(properties, string);
    }

    @NotNull
    public final Properties loadExtensionConfig(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Properties properties = new Properties();
        try {
            File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getExtensionConfigPath(extensionId));
            if (configFile.exists()) {
                properties.load(new FileInputStream(configFile));
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to load extension configuration file for: " + extensionId, e);
        }
        return properties;
    }

    public final void saveExtensionConfig(@NotNull String extensionId, @NotNull Properties properties, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        try {
            this.ensureConfigDirExists();
            File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getExtensionConfigPath(extensionId));
            properties.store(new FileOutputStream(configFile), comment);
        }
        catch (IOException e) {
            throw new IOException("Failed to save extension configuration file for: " + extensionId, e);
        }
    }

    public static /* synthetic */ void saveExtensionConfig$default(ConfigFileUtils configFileUtils, String string, Properties properties, String object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = "Extension Configuration for " + string;
        }
        configFileUtils.saveExtensionConfig(string, properties, (String)object);
    }

    @NotNull
    public final String getMainConfigPath() {
        return PluginConstants.ConfigFiles.INSTANCE.getMainConfigPath();
    }

    @NotNull
    public final String getExtensionConfigPath(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        return PluginConstants.ConfigFiles.INSTANCE.getExtensionConfigPath(extensionId);
    }

    public final boolean mainConfigExists() {
        File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getMainConfigPath());
        return configFile.exists();
    }

    public final boolean extensionConfigExists(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        File configFile = new File(PluginConstants.ConfigFiles.INSTANCE.getExtensionConfigPath(extensionId));
        return configFile.exists();
    }

    @Nullable
    public final String getConfigValue(@NotNull String key, @Nullable String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Properties properties = this.loadMainConfig();
            string = properties.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            string = defaultValue;
        }
        return string;
    }

    public static /* synthetic */ String getConfigValue$default(ConfigFileUtils configFileUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return configFileUtils.getConfigValue(string, string2);
    }

    public final void setConfigValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            Properties properties = this.loadMainConfig();
            properties.setProperty(key, value);
            ConfigFileUtils.saveMainConfig$default(this, properties, null, 2, null);
        }
        catch (Exception e) {
            throw new IOException("Failed to set configuration value: " + key, e);
        }
    }

    public final void createDefaultMainConfig() {
        Properties properties = new Properties();
        properties.setProperty("extension.type", "coderider-kilo");
        this.saveMainConfig(properties, "RunVSAgent Extension Configuration - Default Template");
    }

    @NotNull
    public final List<String> listExtensionConfigFiles() {
        List extensionIds = new ArrayList();
        try {
            File configDir = new File(PluginConstants.ConfigFiles.INSTANCE.getUserConfigDir());
            if (configDir.exists() && configDir.isDirectory()) {
                File[] files;
                if (files != null) {
                    File[] $this$forEach$iv = files = configDir.listFiles(ConfigFileUtils::listExtensionConfigFiles$lambda$0);
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String extensionId = PluginConstants.ConfigFiles.INSTANCE.getExtensionIdFromFilename(string);
                        if (extensionId == null) continue;
                        extensionIds.add(extensionId);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return extensionIds;
    }

    private static final boolean listExtensionConfigFiles$lambda$0(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return PluginConstants.ConfigFiles.INSTANCE.isExtensionConfigFile(string);
    }
}

