/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.sina.weibo.agent.actions.OpenDevToolsAction;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionConfigurationManager;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.ui.VsixUploadDialog;
import com.sina.weibo.agent.plugin.DEBUG_MODE;
import com.sina.weibo.agent.plugin.SystemObjectProvider;
import com.sina.weibo.agent.plugin.WecoderPlugin;
import com.sina.weibo.agent.plugin.WecoderPluginService;
import com.sina.weibo.agent.util.ConfigFileUtils;
import com.sina.weibo.agent.webview.DragDropHandler;
import com.sina.weibo.agent.webview.WebViewCreationCallback;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebViewManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "RunVSAgentToolWindowContent", "coderider-kilo-jetbrains"})
public final class RunVSAgentToolWindowFactory
implements ToolWindowFactory {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        WecoderPluginService pluginService = WecoderPlugin.Companion.getInstance(project);
        List titleActions = new ArrayList();
        AnAction action = ActionManager.getInstance().getAction("coderider-kilo.ToolbarGroup");
        if (action != null) {
            titleActions.add(action);
        }
        if (WecoderPluginService.Companion.getDebugMode() != DEBUG_MODE.NONE) {
            titleActions.add(new OpenDevToolsAction((Function0<WebViewInstance>)((Function0)() -> RunVSAgentToolWindowFactory.createToolWindowContent$lambda$0(project))));
        }
        toolWindow.setTitleActions(titleActions);
        RunVSAgentToolWindowContent toolWindowContent = new RunVSAgentToolWindowContent(project, toolWindow);
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content2 = contentFactory.createContent((JComponent)toolWindowContent.getContent(), "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        toolWindow.getContentManager().addContent(content3);
    }

    private static final WebViewInstance createToolWindowContent$lambda$0(Project $project) {
        return ((WebViewManager)$project.getService(WebViewManager.class)).getLatestWebView();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0001JB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0002J\b\u0010/\u001a\u00020!H\u0002J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000202H\u0002J\b\u00105\u001a\u00020!H\u0002J\u0010\u00106\u001a\u00020!2\u0006\u00104\u001a\u000202H\u0002J\b\u00107\u001a\u00020\u0013H\u0002J\b\u00108\u001a\u00020\u0013H\u0002J\u0010\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\u0019H\u0002J\b\u0010?\u001a\u00020\u0013H\u0002J\u0010\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0015H\u0002J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u0019H\u0002J\u0010\u0010F\u001a\u00020!2\u0006\u0010=\u001a\u00020\u0019H\u0002J\u0010\u0010G\u001a\u00020!2\u0006\u0010=\u001a\u00020\u0019H\u0002J\b\u0010H\u001a\u00020!H\u0002J\b\u0010I\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006K"}, d2={"Lcom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent;", "Lcom/sina/weibo/agent/webview/WebViewCreationCallback;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "webViewManager", "Lcom/sina/weibo/agent/webview/WebViewManager;", "kotlin.jvm.PlatformType", "configManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager;", "extensionManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionManager;", "contentPanel", "Ljavax/swing/JPanel;", "placeholderLabel", "Ljavax/swing/JLabel;", "statusTimer", "Ljavax/swing/Timer;", "systemInfoText", "", "pluginSelectionPanel", "configStatusPanel", "isPluginStarting", "", "isPluginRunning", "isPluginActuallyRunning", "updateStatusSubtitle", "", "detectCurrentTheme", "createSystemInfoPlainText", "copySystemInfo", "knownIssuesButton", "Ljavax/swing/JButton;", "copyButton", "buttonPanel", "dragDropHandler", "Lcom/sina/weibo/agent/webview/DragDropHandler;", "content", "getContent", "()Ljavax/swing/JPanel;", "addThemeChangeListener", "startConfigurationMonitoring", "onWebViewCreated", "instance", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "addWebViewComponent", "webView", "hideSystemInfo", "setupDragAndDropSupport", "createPluginSelectionPanel", "createPluginListPanel", "createPluginRow", "pluginInfo", "Lcom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent$PluginInfo;", "uploadVsixForPlugin", "pluginId", "pluginName", "createConfigStatusPanel", "updateConfigStatus", "statusLabel", "getThemeAdaptiveColor", "Ljava/awt/Color;", "isDarkTheme", "colorType", "applyPluginSelection", "startPluginAfterSelection", "updateUIContent", "showDebugInfo", "PluginInfo", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nRunVSAgentToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunVSAgentToolWindowFactory.kt\ncom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,980:1\n1563#2:981\n1634#2,3:982\n1869#2,2:985\n1#3:987\n*S KotlinDebug\n*F\n+ 1 RunVSAgentToolWindowFactory.kt\ncom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent\n*L\n529#1:981\n529#1:982,3\n543#1:985,2\n*E\n"})
    private static final class RunVSAgentToolWindowContent
    implements WebViewCreationCallback {
        @NotNull
        private final Project project;
        @NotNull
        private final ToolWindow toolWindow;
        @NotNull
        private final Logger logger;
        private final WebViewManager webViewManager;
        @NotNull
        private final ExtensionConfigurationManager configManager;
        @NotNull
        private final ExtensionManager extensionManager;
        @NotNull
        private final JPanel contentPanel;
        @NotNull
        private final JLabel placeholderLabel;
        @NotNull
        private final Timer statusTimer;
        @NotNull
        private final String systemInfoText;
        @NotNull
        private final JPanel pluginSelectionPanel;
        @NotNull
        private final JPanel configStatusPanel;
        private volatile boolean isPluginStarting;
        private volatile boolean isPluginRunning;
        @NotNull
        private final JButton knownIssuesButton;
        @NotNull
        private final JButton copyButton;
        @NotNull
        private final JPanel buttonPanel;
        @Nullable
        private DragDropHandler dragDropHandler;
        @NotNull
        private final JPanel content;

        /*
         * WARNING - void declaration
         */
        public RunVSAgentToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
            void $this$content_u24lambda_u247;
            JComponent $this$buttonPanel_u24lambda_u246;
            JComponent $this$copyButton_u24lambda_u245;
            JButton $this$knownIssuesButton_u24lambda_u243;
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            this.project = project;
            this.toolWindow = toolWindow;
            Logger logger = Logger.getInstance(RunVSAgentToolWindowContent.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
            this.webViewManager = (WebViewManager)this.project.getService(WebViewManager.class);
            this.configManager = ExtensionConfigurationManager.Companion.getInstance(this.project);
            this.extensionManager = ExtensionManager.Companion.getInstance(this.project);
            this.contentPanel = new JPanel(new BorderLayout());
            this.placeholderLabel = new JLabel();
            this.statusTimer = new Timer(2000, arg_0 -> RunVSAgentToolWindowContent.statusTimer$lambda$0(this, arg_0));
            this.systemInfoText = this.createSystemInfoPlainText();
            this.pluginSelectionPanel = this.createPluginSelectionPanel();
            this.configStatusPanel = this.createConfigStatusPanel();
            JButton jButton = jComponent = new JButton("\ud83d\udcda Known Issues");
            RunVSAgentToolWindowContent runVSAgentToolWindowContent = this;
            boolean bl = false;
            $this$knownIssuesButton_u24lambda_u243.setPreferredSize(new Dimension(160, 36));
            $this$knownIssuesButton_u24lambda_u243.setFont($this$knownIssuesButton_u24lambda_u243.getFont().deriveFont(14.0f));
            $this$knownIssuesButton_u24lambda_u243.setOpaque(false);
            $this$knownIssuesButton_u24lambda_u243.setFocusPainted(false);
            $this$knownIssuesButton_u24lambda_u243.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
            $this$knownIssuesButton_u24lambda_u243.addActionListener(RunVSAgentToolWindowContent::knownIssuesButton$lambda$3$lambda$2);
            runVSAgentToolWindowContent.knownIssuesButton = jComponent;
            $this$knownIssuesButton_u24lambda_u243 = jComponent = new JButton("\ud83d\udccb Copy System Info");
            runVSAgentToolWindowContent = this;
            boolean bl2 = false;
            $this$copyButton_u24lambda_u245.setPreferredSize(new Dimension(160, 36));
            $this$copyButton_u24lambda_u245.setFont($this$copyButton_u24lambda_u245.getFont().deriveFont(14.0f));
            $this$copyButton_u24lambda_u245.setOpaque(false);
            $this$copyButton_u24lambda_u245.setFocusPainted(false);
            $this$copyButton_u24lambda_u245.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
            $this$copyButton_u24lambda_u245.addActionListener(arg_0 -> RunVSAgentToolWindowContent.copyButton$lambda$5$lambda$4(this, arg_0));
            runVSAgentToolWindowContent.copyButton = jComponent;
            $this$copyButton_u24lambda_u245 = jComponent = new JPanel();
            runVSAgentToolWindowContent = this;
            boolean bl3 = false;
            ((Container)$this$buttonPanel_u24lambda_u246).setLayout(new BorderLayout());
            $this$buttonPanel_u24lambda_u246.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            $this$buttonPanel_u24lambda_u246.add((Component)this.knownIssuesButton, "West");
            $this$buttonPanel_u24lambda_u246.add((Component)this.copyButton, "East");
            runVSAgentToolWindowContent.buttonPanel = jComponent;
            $this$buttonPanel_u24lambda_u246 = jComponent = new JPanel(new BorderLayout());
            runVSAgentToolWindowContent = this;
            boolean bl4 = false;
            this.contentPanel.setLayout(new BorderLayout());
            $this$content_u24lambda_u247.add((Component)this.contentPanel, "Center");
            runVSAgentToolWindowContent.content = jComponent;
            this.updateUIContent();
            this.startConfigurationMonitoring();
            this.addThemeChangeListener();
            WebViewInstance webViewInstance = this.webViewManager.getLatestWebView();
            if (webViewInstance != null) {
                WebViewInstance webView = webViewInstance;
                boolean bl5 = false;
                ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.lambda$12$lambda$8(this, webView));
                webView.setPageLoadCallback((Function0<Unit>)((Function0)() -> RunVSAgentToolWindowContent.lambda$12$lambda$10(this)));
                if (webView.isPageLoaded()) {
                    ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.lambda$12$lambda$11(this));
                }
            } else {
                this.webViewManager.addCreationCallback(this, this.toolWindow.getDisposable());
            }
            if (this.configManager.isConfigurationLoaded() && this.configManager.isConfigurationValid() && !this.statusTimer.isRunning()) {
                this.statusTimer.start();
            }
        }

        private final boolean isPluginActuallyRunning() {
            boolean bl;
            try {
                ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(this.project);
                bl = extensionManager.isProperlyInitialized();
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        private final void updateStatusSubtitle() {
        }

        private final boolean detectCurrentTheme() {
            boolean bl;
            try {
                double brightness;
                Color background = UIManager.getColor("Panel.background");
                bl = background != null ? (brightness = (0.299 * (double)background.getRed() + 0.587 * (double)background.getGreen() + 0.114 * (double)background.getBlue()) / 255.0) < 0.5 : true;
            }
            catch (Exception e) {
                bl = true;
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final String createSystemInfoPlainText() {
            appInfo = ApplicationInfo.getInstance();
            plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.gitlab.coderider-kilo"));
            v0 /* !! */  = plugin;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getVersion()) == null) {
                v0 /* !! */  = "unknown";
            }
            pluginVersion /* !! */  = v0 /* !! */ ;
            osName = System.getProperty("os.name");
            osVersion = System.getProperty("os.version");
            osArch = System.getProperty("os.arch");
            jcefSupported = JBCefApp.isSupported();
            Intrinsics.checkNotNull((Object)osName);
            v1 = osName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)v1, (CharSequence)"linux", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)osArch);
            v2 = osArch.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"aarch64", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v3 = osArch.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"arm", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            isLinuxArm = v4;
            $this$createSystemInfoPlainText_u24lambda_u241 = var9_9 = new StringBuilder();
            $i$a$-buildString-RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent$createSystemInfoPlainText$1 = false;
            $this$createSystemInfoPlainText_u24lambda_u241.append("RunVSAgent System Information\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("=============================\n\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("\ud83d\ude80 Plugin Status: Initializing...\n\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("\ud83d\udcca System Information:\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("  \ud83d\udcbb CPU Architecture: " + osArch + "\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("  \ud83d\udda5\ufe0f Operating System: " + osName + " " + osVersion + "\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("  \ud83d\udd27 IDE Version: " + appInfo.getFullApplicationName() + " (build " + appInfo.getBuild() + ")\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("  \ud83d\udce6 Plugin Version: " + (String)pluginVersion /* !! */  + "\n");
            $this$createSystemInfoPlainText_u24lambda_u241.append("  \ud83c\udf10 JCEF Support: " + (jcefSupported != false ? "\u2713 Yes" : "\u2717 No") + "\n\n");
            if (isLinuxArm) {
                $this$createSystemInfoPlainText_u24lambda_u241.append("\u26a0\ufe0f Warning: System Not Supported\n");
                $this$createSystemInfoPlainText_u24lambda_u241.append("   Linux ARM systems are currently not supported by this plugin.\n\n");
            }
            if (!jcefSupported) {
                $this$createSystemInfoPlainText_u24lambda_u241.append("\u274c Warning: JCEF Not Supported\n");
                $this$createSystemInfoPlainText_u24lambda_u241.append("   Your IDE runtime does not support JCEF. Please use a runtime that supports JCEF.\n");
                $this$createSystemInfoPlainText_u24lambda_u241.append("   Please refer to the known issues documentation for more information.\n\n");
            }
            $this$createSystemInfoPlainText_u24lambda_u241.append("\ud83d\udca1 Tip: If this interface continues to display for a long time, you can refer to the known issues documentation to check if there are any known problems.\n");
            return var9_9.toString();
        }

        private final void copySystemInfo() {
            StringSelection stringSelection = new StringSelection(this.systemInfoText);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }

        @NotNull
        public final JPanel getContent() {
            return this.content;
        }

        private final void addThemeChangeListener() {
            try {
                MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
                MessageBus messageBus2 = messageBus;
                Disposable disposable = this.toolWindow.getDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
                MessageBusConnection connection = messageBus2.connect(disposable);
                Topic topic = LafManagerListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                connection.subscribe(topic, arg_0 -> RunVSAgentToolWindowContent.addThemeChangeListener$lambda$14(this, arg_0));
                this.logger.info("Theme change listener added successfully");
            }
            catch (Exception e) {
                this.logger.error("Failed to add theme change listener", (Throwable)e);
            }
        }

        private final void startConfigurationMonitoring() {
            Thread thread;
            Thread $this$startConfigurationMonitoring_u24lambda_u2419 = thread = new Thread(() -> RunVSAgentToolWindowContent.startConfigurationMonitoring$lambda$18(this));
            boolean bl = false;
            $this$startConfigurationMonitoring_u24lambda_u2419.setDaemon(true);
            $this$startConfigurationMonitoring_u24lambda_u2419.setName("RunVSAgent-ConfigMonitor-UI");
            $this$startConfigurationMonitoring_u24lambda_u2419.start();
        }

        @Override
        public void onWebViewCreated(@NotNull WebViewInstance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.onWebViewCreated$lambda$20(this, instance));
            instance.setPageLoadCallback((Function0<Unit>)((Function0)() -> RunVSAgentToolWindowContent.onWebViewCreated$lambda$22(this)));
        }

        private final void addWebViewComponent(WebViewInstance webView) {
            Component component;
            this.logger.info("Adding WebView component to UI: " + webView.getViewType() + "/" + webView.getViewId());
            Object[] components = this.contentPanel.getComponents();
            boolean needAdd = true;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])components);
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                if (component != webView.getBrowser().getComponent()) continue;
                needAdd = false;
            }
            if (needAdd) {
                this.contentPanel.add((Component)webView.getBrowser().getComponent(), "Center");
                iterator = ArrayIteratorKt.iterator((Object[])this.contentPanel.getComponents());
                while (iterator.hasNext()) {
                    component = (Component)iterator.next();
                    if (component == webView.getBrowser().getComponent()) continue;
                    this.contentPanel.remove(component);
                }
            }
            this.setupDragAndDropSupport(webView);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            this.logger.info("WebView component added to tool window");
        }

        private final void hideSystemInfo() {
        }

        private final void setupDragAndDropSupport(WebViewInstance webView) {
            try {
                this.logger.info("Setting up drag and drop support for WebView");
                DragDropHandler dragDropHandler = this.dragDropHandler = new DragDropHandler(webView, this.contentPanel);
                if (dragDropHandler != null) {
                    dragDropHandler.setupDragAndDrop();
                }
                this.logger.info("Drag and drop support enabled");
            }
            catch (Exception e) {
                this.logger.error("Failed to setup drag and drop support", (Throwable)e);
            }
        }

        private final JPanel createPluginSelectionPanel() {
            JButton jButton;
            JLabel jLabel;
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel $this$createPluginSelectionPanel_u24lambda_u2423 = jLabel = new JLabel("\ud83d\udd27 Select Plugin");
            boolean bl = false;
            $this$createPluginSelectionPanel_u24lambda_u2423.setFont($this$createPluginSelectionPanel_u24lambda_u2423.getFont().deriveFont(18.0f));
            $this$createPluginSelectionPanel_u24lambda_u2423.setHorizontalAlignment(0);
            $this$createPluginSelectionPanel_u24lambda_u2423.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            JLabel titleLabel = jLabel;
            JLabel $this$createPluginSelectionPanel_u24lambda_u2424 = $this$createPluginSelectionPanel_u24lambda_u2423 = new JLabel("Invalid configuration detected, please select a default plugin to continue:");
            boolean bl2 = false;
            $this$createPluginSelectionPanel_u24lambda_u2424.setFont($this$createPluginSelectionPanel_u24lambda_u2424.getFont().deriveFont(14.0f));
            $this$createPluginSelectionPanel_u24lambda_u2424.setHorizontalAlignment(0);
            $this$createPluginSelectionPanel_u24lambda_u2424.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            JLabel descLabel = $this$createPluginSelectionPanel_u24lambda_u2423;
            JPanel pluginListPanel = this.createPluginListPanel();
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BorderLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            JButton $this$createPluginSelectionPanel_u24lambda_u2426 = jButton = new JButton("\ud83d\udc1b Debug Info");
            boolean bl3 = false;
            $this$createPluginSelectionPanel_u24lambda_u2426.setPreferredSize((Dimension)JBUI.size((int)160, (int)36));
            $this$createPluginSelectionPanel_u24lambda_u2426.setFont((Font)JBFont.label().deriveFont(14.0f));
            $this$createPluginSelectionPanel_u24lambda_u2426.setFocusPainted(false);
            $this$createPluginSelectionPanel_u24lambda_u2426.setOpaque(false);
            $this$createPluginSelectionPanel_u24lambda_u2426.addActionListener(arg_0 -> RunVSAgentToolWindowContent.createPluginSelectionPanel$lambda$26$lambda$25(this, arg_0));
            JButton debugButton = jButton;
            buttonPanel.add((Component)debugButton, "West");
            panel.add((Component)titleLabel, "North");
            panel.add((Component)descLabel, "Center");
            panel.add((Component)pluginListPanel, "Center");
            panel.add((Component)buttonPanel, "South");
            return panel;
        }

        /*
         * WARNING - void declaration
         */
        private final JPanel createPluginListPanel() {
            void $this$mapTo$iv$iv;
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            List<ExtensionProvider> extensions = this.extensionManager.getAllExtensions();
            String currentExtensionId = ConfigFileUtils.INSTANCE.getCurrentExtensionId();
            Iterable $this$map$iv = extensions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void provider;
                ExtensionProvider extensionProvider = (ExtensionProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String extensionId = provider.getExtensionId();
                boolean isCurrent = Intrinsics.areEqual((Object)provider.getExtensionId(), (Object)currentExtensionId);
                boolean isAvailable = provider.isAvailable(this.project);
                collection.add(new PluginInfo(extensionId, provider.getDisplayName(), provider.getDescription(), isAvailable, isCurrent));
            }
            List plugins = (List)destination$iv$iv;
            Iterable $this$forEach$iv = plugins;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginInfo pluginInfo = (PluginInfo)element$iv;
                boolean bl = false;
                JPanel pluginRow = this.createPluginRow(pluginInfo);
                panel.add(pluginRow);
                panel.add(Box.createVerticalStrut(8));
            }
            return panel;
        }

        private final JPanel createPluginRow(PluginInfo pluginInfo) {
            JPanel jPanel;
            JPanel rowPanel = new JPanel(new BorderLayout());
            boolean isDarkTheme = this.detectCurrentTheme();
            JPanel $this$createPluginRow_u24lambda_u2429 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            $this$createPluginRow_u24lambda_u2429.setBackground(pluginInfo.isCurrent() ? (isDarkTheme ? new Color(16, 185, 129, 21) : new Color(5, 150, 105, 16)) : (isDarkTheme ? new Color(42, 42, 42, 128) : new Color(255, 255, 255, 128)));
            Color borderColor = pluginInfo.isCurrent() ? (isDarkTheme ? new Color(16, 185, 129) : new Color(5, 150, 105)) : (isDarkTheme ? new Color(64, 64, 64) : new Color(229, 231, 235));
            int borderWidth = pluginInfo.isCurrent() ? 2 : 1;
            $this$createPluginRow_u24lambda_u2429.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor, borderWidth), BorderFactory.createEmptyBorder(12, 16, 12, 16)));
            JPanel contentPanel = jPanel;
            JPanel topRowPanel = new JPanel(new BorderLayout());
            topRowPanel.setOpaque(false);
            topRowPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            String statusIcon = pluginInfo.isCurrent() ? "\ud83d\udfe2" : (pluginInfo.isAvailable() ? "\u2705" : "\u274c");
            Object nameText = pluginInfo.isCurrent() ? pluginInfo.getDisplayName() + " (Currently Running)" : pluginInfo.getDisplayName();
            JLabel $this$createPluginRow_u24lambda_u2430 = borderWidth = new JLabel(statusIcon + " " + (String)nameText);
            boolean bl2 = false;
            $this$createPluginRow_u24lambda_u2430.setFont($this$createPluginRow_u24lambda_u2430.getFont().deriveFont(15.0f).deriveFont(1));
            $this$createPluginRow_u24lambda_u2430.setForeground(pluginInfo.isAvailable() ? (isDarkTheme ? new Color(248, 250, 252) : new Color(30, 41, 59)) : (isDarkTheme ? new Color(100, 116, 139) : new Color(148, 163, 184)));
            JLabel nameLabel = borderWidth;
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.setOpaque(false);
            JButton $this$createPluginRow_u24lambda_u2432 = bl2 = new JButton("\ud83d\udce6 Install From VSIX");
            boolean bl3 = false;
            $this$createPluginRow_u24lambda_u2432.setPreferredSize((Dimension)JBUI.size((int)160, (int)36));
            $this$createPluginRow_u24lambda_u2432.setFont($this$createPluginRow_u24lambda_u2432.getFont().deriveFont(11.0f));
            $this$createPluginRow_u24lambda_u2432.setFocusPainted(false);
            $this$createPluginRow_u24lambda_u2432.setOpaque(false);
            $this$createPluginRow_u24lambda_u2432.setEnabled(true);
            $this$createPluginRow_u24lambda_u2432.setForeground(isDarkTheme ? new Color(203, 213, 225) : new Color(71, 86, 105));
            $this$createPluginRow_u24lambda_u2432.setBackground(isDarkTheme ? new Color(62, 62, 62) : new Color(241, 245, 249));
            $this$createPluginRow_u24lambda_u2432.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
            $this$createPluginRow_u24lambda_u2432.addActionListener(arg_0 -> RunVSAgentToolWindowContent.createPluginRow$lambda$32$lambda$31(this, pluginInfo, arg_0));
            JButton uploadButton = bl2;
            buttonPanel.add(Box.createHorizontalStrut(8));
            buttonPanel.add(uploadButton);
            topRowPanel.add((Component)nameLabel, "West");
            topRowPanel.add((Component)buttonPanel, "East");
            Object descriptionText = pluginInfo.isAvailable() ? pluginInfo.getDescription() : pluginInfo.getDescription() + " (Plugin unavailable, please upload VSIX file)";
            JLabel $this$createPluginRow_u24lambda_u2433 = bl3 = new JLabel((String)descriptionText);
            boolean bl4 = false;
            $this$createPluginRow_u24lambda_u2433.setFont($this$createPluginRow_u24lambda_u2433.getFont().deriveFont(12.0f));
            $this$createPluginRow_u24lambda_u2433.setForeground(pluginInfo.isAvailable() ? (isDarkTheme ? new Color(203, 213, 225) : new Color(71, 86, 105)) : (isDarkTheme ? new Color(100, 116, 139) : new Color(148, 163, 184)));
            JLabel descLabel = bl3;
            contentPanel.add((Component)topRowPanel, "North");
            contentPanel.add((Component)descLabel, "Center");
            if (pluginInfo.isAvailable()) {
                contentPanel.addMouseListener(new MouseAdapter(this, pluginInfo, contentPanel, isDarkTheme){
                    final /* synthetic */ RunVSAgentToolWindowContent this$0;
                    final /* synthetic */ PluginInfo $pluginInfo;
                    final /* synthetic */ JPanel $contentPanel;
                    final /* synthetic */ boolean $isDarkTheme;
                    {
                        this.this$0 = $receiver;
                        this.$pluginInfo = $pluginInfo;
                        this.$contentPanel = $contentPanel;
                        this.$isDarkTheme = $isDarkTheme;
                    }

                    public void mouseClicked(MouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.getClickCount() == 1) {
                            RunVSAgentToolWindowContent.access$applyPluginSelection(this.this$0, this.$pluginInfo.getId());
                        }
                    }

                    public void mouseEntered(MouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$contentPanel.setCursor(Cursor.getPredefinedCursor(12));
                        if (this.$isDarkTheme) {
                            this.$contentPanel.setBackground(new Color(30, 58, 138, 32));
                        } else {
                            this.$contentPanel.setBackground(new Color(219, 234, 254, 128));
                        }
                        this.$contentPanel.repaint();
                    }

                    public void mouseExited(MouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$contentPanel.setCursor(Cursor.getDefaultCursor());
                        if (this.$isDarkTheme) {
                            this.$contentPanel.setBackground(new Color(42, 42, 42, 128));
                        } else {
                            this.$contentPanel.setBackground(new Color(255, 255, 255, 128));
                        }
                        this.$contentPanel.repaint();
                    }
                });
            } else {
                contentPanel.setCursor(Cursor.getDefaultCursor());
            }
            rowPanel.add(contentPanel);
            Dimension pref = contentPanel.getPreferredSize();
            contentPanel.doLayout();
            Dimension computedPref = pref != null && pref.height > 0 ? pref : contentPanel.getPreferredSize();
            contentPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, computedPref.height));
            rowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, computedPref.height));
            rowPanel.setAlignmentY(0.0f);
            return rowPanel;
        }

        private final void uploadVsixForPlugin(String pluginId, String pluginName) {
            try {
                boolean success = VsixUploadDialog.Companion.show(this.project, pluginId, pluginName);
                if (success) {
                    JOptionPane.showMessageDialog(this.contentPanel, "VSIX file uploaded successfully!\nPlugin: " + pluginName + "\nYou can now launch the plugin.", "Upload Complete", 1);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to upload VSIX for plugin: " + pluginId, (Throwable)e);
                JOptionPane.showMessageDialog(this.contentPanel, "Upload failed: " + e.getMessage(), "Error", 0);
            }
        }

        private final JPanel createConfigStatusPanel() {
            JLabel jLabel;
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel $this$createConfigStatusPanel_u24lambda_u2434 = jLabel = new JLabel();
            boolean bl = false;
            $this$createConfigStatusPanel_u24lambda_u2434.setFont($this$createConfigStatusPanel_u24lambda_u2434.getFont().deriveFont(14.0f));
            $this$createConfigStatusPanel_u24lambda_u2434.setHorizontalAlignment(0);
            JLabel statusLabel = jLabel;
            this.updateConfigStatus(statusLabel);
            panel.add((Component)statusLabel, "Center");
            return panel;
        }

        private final void updateConfigStatus(JLabel statusLabel) {
            statusLabel.setText("");
        }

        private final Color getThemeAdaptiveColor(boolean isDarkTheme, String colorType) {
            Color color;
            block34: {
                block32: {
                    if (!isDarkTheme) break block32;
                    switch (colorType) {
                        case "success": {
                            color = new Color(16, 185, 129);
                            break;
                        }
                        case "warning": {
                            color = new Color(251, 191, 36);
                            break;
                        }
                        case "error": {
                            color = new Color(239, 68, 68);
                            break;
                        }
                        case "info": {
                            color = new Color(59, 130, 246);
                            break;
                        }
                        default: {
                            color = new Color(148, 163, 184);
                            break;
                        }
                    }
                    break block34;
                }
                switch (colorType) {
                    case "success": {
                        color = new Color(5, 150, 105);
                        break;
                    }
                    case "warning": {
                        color = new Color(217, 119, 6);
                        break;
                    }
                    case "error": {
                        color = new Color(220, 38, 38);
                        break;
                    }
                    case "info": {
                        color = new Color(37, 99, 235);
                        break;
                    }
                    default: {
                        color = new Color(100, 116, 139);
                    }
                }
            }
            return color;
        }

        private final void applyPluginSelection(String pluginId) {
            try {
                this.logger.info("Applying plugin selection: " + pluginId);
                this.configManager.setCurrentExtensionId(pluginId);
                if (this.configManager.isConfigurationValid()) {
                    this.startPluginAfterSelection(pluginId);
                    this.logger.info("Plugin selection applied successfully: " + pluginId);
                } else {
                    String string = this.configManager.getConfigurationError();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    String errorMsg = string;
                    String message = "\u274c Configuration Update Failed\nError: " + errorMsg + "\n\nPlease check the configuration file or try manual configuration.";
                    JOptionPane.showMessageDialog(this.contentPanel, message, "Configuration Update Failed", 0);
                    this.logger.error("Configuration is still invalid after setting extension ID: " + pluginId + ", error: " + errorMsg);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to apply plugin selection", (Throwable)e);
                String message = "\u274c Configuration Update Failed\nError: " + e.getMessage() + "\n\nPlease check file permissions or try manual configuration.";
                JOptionPane.showMessageDialog(this.contentPanel, message, "Error", 0);
            }
        }

        private final void startPluginAfterSelection(String pluginId) {
            try {
                this.logger.info("Starting plugin after selection: " + pluginId);
                this.isPluginStarting = true;
                Component component = this.configStatusPanel.getComponent(0);
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JLabel");
                this.updateConfigStatus((JLabel)component);
                ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(this.project);
                extensionManager.initialize(pluginId);
                extensionManager.initializeCurrentProvider();
                WecoderPluginService pluginService = WecoderPlugin.Companion.getInstance(this.project);
                pluginService.initialize(this.project);
                WebViewManager webViewManager = (WebViewManager)this.project.getService(WebViewManager.class);
                if (webViewManager == null) {
                    this.logger.error("WebViewManager not available");
                    throw new IllegalStateException("WebViewManager not available");
                }
                Disposer.register((Disposable)((Disposable)this.project), (Disposable)webViewManager);
                this.startConfigurationMonitoring();
                Disposer.register((Disposable)((Disposable)this.project), () -> RunVSAgentToolWindowContent.startPluginAfterSelection$lambda$35(this, pluginService, extensionManager));
                this.logger.info("Plugin started successfully after selection: " + pluginId);
                this.isPluginRunning = true;
                this.isPluginStarting = false;
                this.updateUIContent();
            }
            catch (Exception e) {
                this.logger.error("Failed to start plugin after selection", (Throwable)e);
                this.isPluginStarting = false;
                this.isPluginRunning = false;
                String message = "\u274c Plugin Startup Failed\nError: " + e.getMessage() + "\n\nPlease check plugin configuration or try restarting the IDE.";
                JOptionPane.showMessageDialog(this.contentPanel, message, "Plugin Startup Failed", 0);
            }
        }

        private final void updateUIContent() {
            if (this.isPluginStarting || this.isPluginRunning) {
                this.logger.info("Plugin is starting or running, skipping UI update");
                return;
            }
            boolean isPluginRunning = this.isPluginActuallyRunning();
            if (isPluginRunning) {
                this.logger.info("Plugin is running, keeping current UI content");
                return;
            }
            this.contentPanel.removeAll();
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }

        /*
         * WARNING - void declaration
         */
        private final void showDebugInfo() {
            Object object;
            String string;
            String string2;
            String string3;
            block5: {
                block4: {
                    void it;
                    string3 = this.configManager.isConfigurationLoaded() && this.configManager.isConfigurationValid() ? "Loaded and Valid" : "Not Loaded or Invalid";
                    string2 = this.configManager.getCurrentExtensionId();
                    if (string2 == null) {
                        string2 = "Not Set";
                    }
                    string = this.configManager.getConfigurationFilePath();
                    object = this.configManager.getConfigurationLoadTime();
                    if (object == null) break block4;
                    long l = ((Number)object).longValue();
                    String string4 = string;
                    String string5 = string2;
                    String string6 = string3;
                    boolean bl = false;
                    String string7 = String.valueOf((long)it);
                    string3 = string6;
                    string2 = string5;
                    string = string4;
                    String string8 = string7;
                    object = string8;
                    if (string8 != null) break block5;
                }
                object = "Unknown";
            }
            String debugText = StringsKt.trimIndent((String)("\n                RunVSAgent Debug Information\n                ============================\n                \n                \ud83d\ude80 Plugin Status: " + string3 + "\n                \n                \ud83d\udcdd Current Configuration: " + string2 + "\n                \n                \u2699\ufe0f Configuration File Path: " + string + "\n                \n                \ud83d\udd04 Configuration Load Time: " + (String)object + "\n                \n                \ud83d\udca1 Tip: If configuration is invalid, please check the configuration file content or try manual configuration.\n            "));
            JOptionPane.showMessageDialog(this.contentPanel, debugText, "Debug Information", 1);
        }

        private static final void statusTimer$lambda$0(RunVSAgentToolWindowContent this$0, ActionEvent it) {
            this$0.updateStatusSubtitle();
        }

        private static final void knownIssuesButton$lambda$3$lambda$2(ActionEvent it) {
            BrowserUtil.browse((String)"https://github.com/wecode-ai/RunVSAgent/blob/main/docs/KNOWN_ISSUES.md");
        }

        private static final void copyButton$lambda$5$lambda$4(RunVSAgentToolWindowContent this$0, ActionEvent it) {
            this$0.copySystemInfo();
        }

        private static final void lambda$12$lambda$8(RunVSAgentToolWindowContent this$0, WebViewInstance $webView) {
            this$0.addWebViewComponent($webView);
        }

        private static final void lambda$12$lambda$10$lambda$9(RunVSAgentToolWindowContent this$0) {
            this$0.hideSystemInfo();
        }

        private static final Unit lambda$12$lambda$10(RunVSAgentToolWindowContent this$0) {
            ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.lambda$12$lambda$10$lambda$9(this$0));
            return Unit.INSTANCE;
        }

        private static final void lambda$12$lambda$11(RunVSAgentToolWindowContent this$0) {
            this$0.hideSystemInfo();
        }

        private static final void addThemeChangeListener$lambda$14$lambda$13(RunVSAgentToolWindowContent this$0) {
            this$0.updateUIContent();
            if (this$0.configStatusPanel.getComponentCount() > 0) {
                Component component = this$0.configStatusPanel.getComponent(0);
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JLabel");
                this$0.updateConfigStatus((JLabel)component);
            }
        }

        private static final void addThemeChangeListener$lambda$14(RunVSAgentToolWindowContent this$0, LafManager it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.logger.info("Theme changed, updating UI styles");
            ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.addThemeChangeListener$lambda$14$lambda$13(this$0));
        }

        private static final void startConfigurationMonitoring$lambda$18$lambda$15(RunVSAgentToolWindowContent this$0) {
            this$0.updateUIContent();
        }

        private static final void startConfigurationMonitoring$lambda$18$lambda$16(RunVSAgentToolWindowContent this$0) {
            Component component = this$0.configStatusPanel.getComponent(0);
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JLabel");
            this$0.updateConfigStatus((JLabel)component);
        }

        private static final void startConfigurationMonitoring$lambda$18$lambda$17(RunVSAgentToolWindowContent this$0) {
            if (this$0.configManager.isConfigurationLoaded() && this$0.configManager.isConfigurationValid()) {
                if (!this$0.statusTimer.isRunning()) {
                    this$0.statusTimer.start();
                }
            } else if (this$0.statusTimer.isRunning()) {
                this$0.statusTimer.stop();
            }
        }

        private static final void startConfigurationMonitoring$lambda$18(RunVSAgentToolWindowContent this$0) {
            try {
                while (!this$0.project.isDisposed()) {
                    Thread.sleep(2000L);
                    if (this$0.project.isDisposed()) continue;
                    if (this$0.isPluginStarting || this$0.isPluginRunning) {
                        this$0.logger.debug("Plugin is starting or running, skipping UI update");
                        continue;
                    }
                    boolean isPluginRunning = this$0.isPluginActuallyRunning();
                    if (!isPluginRunning) {
                        ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.startConfigurationMonitoring$lambda$18$lambda$15(this$0));
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.startConfigurationMonitoring$lambda$18$lambda$16(this$0));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.startConfigurationMonitoring$lambda$18$lambda$17(this$0));
                }
            }
            catch (InterruptedException e) {
                this$0.logger.info("Configuration monitoring interrupted");
            }
            catch (Exception e) {
                this$0.logger.error("Error in configuration monitoring", (Throwable)e);
            }
        }

        private static final void onWebViewCreated$lambda$20(RunVSAgentToolWindowContent this$0, WebViewInstance $instance) {
            this$0.addWebViewComponent($instance);
        }

        private static final void onWebViewCreated$lambda$22$lambda$21(RunVSAgentToolWindowContent this$0) {
            this$0.hideSystemInfo();
        }

        private static final Unit onWebViewCreated$lambda$22(RunVSAgentToolWindowContent this$0) {
            ApplicationManager.getApplication().invokeLater(() -> RunVSAgentToolWindowContent.onWebViewCreated$lambda$22$lambda$21(this$0));
            return Unit.INSTANCE;
        }

        private static final void createPluginSelectionPanel$lambda$26$lambda$25(RunVSAgentToolWindowContent this$0, ActionEvent it) {
            this$0.showDebugInfo();
        }

        private static final void createPluginRow$lambda$32$lambda$31(RunVSAgentToolWindowContent this$0, PluginInfo $pluginInfo, ActionEvent it) {
            this$0.uploadVsixForPlugin($pluginInfo.getId(), $pluginInfo.getDisplayName());
        }

        private static final void startPluginAfterSelection$lambda$35(RunVSAgentToolWindowContent this$0, WecoderPluginService $pluginService, ExtensionManager $extensionManager) {
            this$0.logger.info("Disposing RunVSAgent plugin for project: " + this$0.project.getName());
            $pluginService.dispose();
            $extensionManager.dispose();
            SystemObjectProvider.INSTANCE.dispose();
            this$0.isPluginRunning = false;
            this$0.isPluginStarting = false;
        }

        public static final /* synthetic */ void access$applyPluginSelection(RunVSAgentToolWindowContent $this, String pluginId) {
            $this.applyPluginSelection(pluginId);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/sina/weibo/agent/ui/RunVSAgentToolWindowFactory$RunVSAgentToolWindowContent$PluginInfo;", "", "id", "", "displayName", "description", "isAvailable", "", "isCurrent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getId", "()Ljava/lang/String;", "getDisplayName", "getDescription", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
        private static final class PluginInfo {
            @NotNull
            private final String id;
            @NotNull
            private final String displayName;
            @NotNull
            private final String description;
            private final boolean isAvailable;
            private final boolean isCurrent;

            public PluginInfo(@NotNull String id, @NotNull String displayName, @NotNull String description, boolean isAvailable, boolean isCurrent) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                this.id = id;
                this.displayName = displayName;
                this.description = description;
                this.isAvailable = isAvailable;
                this.isCurrent = isCurrent;
            }

            public /* synthetic */ PluginInfo(String string, String string2, String string3, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x10) != 0) {
                    bl2 = false;
                }
                this(string, string2, string3, bl, bl2);
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getDisplayName() {
                return this.displayName;
            }

            @NotNull
            public final String getDescription() {
                return this.description;
            }

            public final boolean isAvailable() {
                return this.isAvailable;
            }

            public final boolean isCurrent() {
                return this.isCurrent;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.displayName;
            }

            @NotNull
            public final String component3() {
                return this.description;
            }

            public final boolean component4() {
                return this.isAvailable;
            }

            public final boolean component5() {
                return this.isCurrent;
            }

            @NotNull
            public final PluginInfo copy(@NotNull String id, @NotNull String displayName, @NotNull String description, boolean isAvailable, boolean isCurrent) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                return new PluginInfo(id, displayName, description, isAvailable, isCurrent);
            }

            public static /* synthetic */ PluginInfo copy$default(PluginInfo pluginInfo, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = pluginInfo.id;
                }
                if ((n & 2) != 0) {
                    string2 = pluginInfo.displayName;
                }
                if ((n & 4) != 0) {
                    string3 = pluginInfo.description;
                }
                if ((n & 8) != 0) {
                    bl = pluginInfo.isAvailable;
                }
                if ((n & 0x10) != 0) {
                    bl2 = pluginInfo.isCurrent;
                }
                return pluginInfo.copy(string, string2, string3, bl, bl2);
            }

            @NotNull
            public String toString() {
                return "PluginInfo(id=" + this.id + ", displayName=" + this.displayName + ", description=" + this.description + ", isAvailable=" + this.isAvailable + ", isCurrent=" + this.isCurrent + ")";
            }

            public int hashCode() {
                int result2 = this.id.hashCode();
                result2 = result2 * 31 + this.displayName.hashCode();
                result2 = result2 * 31 + this.description.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.isAvailable);
                result2 = result2 * 31 + Boolean.hashCode(this.isCurrent);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PluginInfo)) {
                    return false;
                }
                PluginInfo pluginInfo = (PluginInfo)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)pluginInfo.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.displayName, (Object)pluginInfo.displayName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.description, (Object)pluginInfo.description)) {
                    return false;
                }
                if (this.isAvailable != pluginInfo.isAvailable) {
                    return false;
                }
                return this.isCurrent == pluginInfo.isCurrent;
            }
        }
    }
}

