/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.pty4j.PtyProcess;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostTerminalServiceProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostTerminalShellIntegrationProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ShellLaunchConfigDto;
import com.sina.weibo.agent.terminal.ProxyPtyProcess;
import com.sina.weibo.agent.terminal.ProxyPtyProcessCallback;
import com.sina.weibo.agent.terminal.TerminalCallbackManager;
import com.sina.weibo.agent.terminal.TerminalConfig;
import com.sina.weibo.agent.terminal.TerminalShellIntegration;
import com.sina.weibo.agent.terminal.TerminalState;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 P2\u00020\u0001:\u0001PB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&J\u0006\u0010'\u001a\u00020$J\b\u0010(\u001a\u00020$H\u0002J\b\u0010)\u001a\u00020$H\u0002J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u000103H\u0002J\b\u00104\u001a\u00020$H\u0002J\b\u00105\u001a\u00020$H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J\b\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020\u0003H\u0002J\u0010\u0010=\u001a\u00020$2\b\b\u0002\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020$J\b\u0010A\u001a\u00020$H\u0002J\b\u0010B\u001a\u00020$H\u0002J\b\u0010C\u001a\u00020$H\u0002J\u0018\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020\u00032\b\b\u0002\u0010F\u001a\u00020?J\b\u0010G\u001a\u00020$H\u0002J\b\u0010H\u001a\u00020$H\u0002J\u0010\u0010I\u001a\u00020$2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020$H\u0002J\b\u0010M\u001a\u00020$H\u0002J\b\u0010N\u001a\u00020$H\u0016J\b\u0010O\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalInstance;", "Lcom/intellij/openapi/Disposable;", "extHostTerminalId", "", "numericId", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/sina/weibo/agent/terminal/TerminalConfig;", "rpcProtocol", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;", "<init>", "(Ljava/lang/String;ILcom/intellij/openapi/project/Project;Lcom/sina/weibo/agent/terminal/TerminalConfig;Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;)V", "getExtHostTerminalId", "()Ljava/lang/String;", "getNumericId", "()I", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "terminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "shellWidget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "state", "Lcom/sina/weibo/agent/terminal/TerminalState;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "terminalShellIntegration", "Lcom/sina/weibo/agent/terminal/TerminalShellIntegration;", "callbackManager", "Lcom/sina/weibo/agent/terminal/TerminalCallbackManager;", "addTerminalCloseCallback", "", "callback", "Lkotlin/Function0;", "initialize", "registerToProjectDisposer", "performInitialization", "setupShellIntegration", "finalizeInitialization", "handleInitialText", "createTerminalWidget", "createCustomRunner", "Lorg/jetbrains/plugins/terminal/LocalTerminalDirectRunner;", "createStartupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "buildShellCommand", "", "initializeWidgets", "setupTerminalCloseListener", "createProxyPtyProcess", "Lcom/pty4j/PtyProcess;", "originalProcess", "createRawDataCallback", "Lcom/sina/weibo/agent/terminal/ProxyPtyProcessCallback;", "sendRawDataToExtHost", "data", "show", "preserveFocus", "", "hide", "showTerminalToolWindow", "addToTerminalToolWindow", "hideTerminalToolWindow", "sendText", "text", "shouldExecute", "notifyTerminalOpened", "notifyShellIntegrationChange", "notifyEnvironmentVariableChange", "extHostTerminalShellIntegrationProxy", "Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostTerminalShellIntegrationProxy;", "onTerminalClosed", "notifyTerminalClosed", "dispose", "cleanupResources", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTerminalInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalInstance.kt\ncom/sina/weibo/agent/terminal/TerminalInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,689:1\n1#2:690\n37#3:691\n36#3,3:692\n37#3:695\n36#3,3:696\n*S KotlinDebug\n*F\n+ 1 TerminalInstance.kt\ncom/sina/weibo/agent/terminal/TerminalInstance\n*L\n483#1:691\n483#1:692,3\n484#1:695\n484#1:696,3\n*E\n"})
public final class TerminalInstance
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String extHostTerminalId;
    private final int numericId;
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalConfig config;
    @NotNull
    private final IRPCProtocol rpcProtocol;
    @NotNull
    private final Logger logger;
    @Nullable
    private TerminalWidget terminalWidget;
    @Nullable
    private ShellTerminalWidget shellWidget;
    @NotNull
    private final TerminalState state;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TerminalShellIntegration terminalShellIntegration;
    @NotNull
    private final TerminalCallbackManager callbackManager;
    @NotNull
    private static final String DEFAULT_TERMINAL_NAME = "roo-cline";
    @NotNull
    private static final String TERMINAL_TOOL_WINDOW_ID = "Terminal";

    public TerminalInstance(@NotNull String extHostTerminalId, int numericId, @NotNull Project project, @NotNull TerminalConfig config2, @NotNull IRPCProtocol rpcProtocol) {
        Intrinsics.checkNotNullParameter((Object)extHostTerminalId, (String)"extHostTerminalId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)rpcProtocol, (String)"rpcProtocol");
        this.extHostTerminalId = extHostTerminalId;
        this.numericId = numericId;
        this.project = project;
        this.config = config2;
        this.rpcProtocol = rpcProtocol;
        Logger logger = Logger.getInstance(TerminalInstance.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.state = new TerminalState();
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.terminalShellIntegration = new TerminalShellIntegration(this.extHostTerminalId, this.numericId, this.rpcProtocol);
        this.callbackManager = new TerminalCallbackManager();
    }

    @NotNull
    public final String getExtHostTerminalId() {
        return this.extHostTerminalId;
    }

    public final int getNumericId() {
        return this.numericId;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addTerminalCloseCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbackManager.addCloseCallback(callback);
    }

    public final void initialize() {
        this.state.checkCanInitialize(this.extHostTerminalId);
        try {
            this.logger.info("\ud83d\ude80 Initializing terminal instance: " + this.extHostTerminalId + " (numericId: " + this.numericId + ")");
            this.registerToProjectDisposer();
            ApplicationManager.getApplication().invokeAndWait(() -> TerminalInstance.initialize$lambda$0(this));
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to initialize terminal instance: " + this.extHostTerminalId, (Throwable)e);
            throw e;
        }
    }

    private final void registerToProjectDisposer() {
        try {
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
            this.logger.info("\u2705 Terminal instance registered to project Disposer: " + this.extHostTerminalId);
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to register terminal instance to project Disposer: " + this.extHostTerminalId, (Throwable)e);
            throw e;
        }
    }

    private final void performInitialization() {
        try {
            this.createTerminalWidget();
            this.setupShellIntegration();
            this.finalizeInitialization();
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to initialize terminal in EDT thread: " + this.extHostTerminalId, (Throwable)e);
            throw e;
        }
    }

    private final void setupShellIntegration() {
        this.terminalShellIntegration.setupShellIntegration();
    }

    private final void finalizeInitialization() {
        this.state.markInitialized();
        this.logger.info("\u2705 Terminal instance initialization complete: " + this.extHostTerminalId);
        this.addToTerminalToolWindow();
        this.notifyTerminalOpened();
        this.notifyShellIntegrationChange();
        this.handleInitialText();
    }

    private final void handleInitialText() {
        block0: {
            String string = this.config.getInitialText();
            if (string == null) break block0;
            String initialText = string;
            boolean bl = false;
            this.sendText(initialText, false);
        }
    }

    private final void createTerminalWidget() {
        try {
            LocalTerminalDirectRunner customRunner = this.createCustomRunner();
            ShellStartupOptions startupOptions = this.createStartupOptions();
            this.logger.info("\ud83d\ude80 Calling startShellTerminalWidget...");
            this.terminalWidget = customRunner.startShellTerminalWidget((Disposable)this, startupOptions, false);
            Object object = this.terminalWidget;
            this.logger.info("\u2705 startShellTerminalWidget call complete, returned widget: " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
            this.initializeWidgets();
            this.setupTerminalCloseListener();
            this.logger.info("\u2705 Terminal widget created successfully");
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to create terminal widget", (Throwable)e);
            throw e;
        }
    }

    private final LocalTerminalDirectRunner createCustomRunner() {
        Project project = this.project;
        return new LocalTerminalDirectRunner(this, project){
            final /* synthetic */ TerminalInstance this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public PtyProcess createProcess(ShellStartupOptions options) {
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                TerminalInstance.access$getLogger$p(this.this$0).info("\ud83d\udd27 Custom createProcess method called...");
                TerminalInstance.access$getLogger$p(this.this$0).info("Startup options: " + options);
                PtyProcess ptyProcess = super.createProcess(options);
                Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"createProcess(...)");
                PtyProcess originalProcess = ptyProcess;
                TerminalInstance.access$getLogger$p(this.this$0).info("\u2705 Original Process created: " + originalProcess.getClass().getName());
                return TerminalInstance.access$createProxyPtyProcess(this.this$0, originalProcess);
            }

            protected TerminalWidget createShellTerminalWidget(Disposable parent, ShellStartupOptions startupOptions) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
                TerminalInstance.access$getLogger$p(this.this$0).info("\ud83d\udd27 Custom createShellTerminalWidget method called...");
                TerminalWidget terminalWidget = super.createShellTerminalWidget(parent, startupOptions);
                Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"createShellTerminalWidget(...)");
                return terminalWidget;
            }

            public ShellStartupOptions configureStartupOptions(ShellStartupOptions baseOptions) {
                Intrinsics.checkNotNullParameter((Object)baseOptions, (String)"baseOptions");
                TerminalInstance.access$getLogger$p(this.this$0).info("\ud83d\udd27 Custom configureStartupOptions method called...");
                ShellStartupOptions shellStartupOptions = super.configureStartupOptions(baseOptions);
                Intrinsics.checkNotNullExpressionValue((Object)shellStartupOptions, (String)"configureStartupOptions(...)");
                return shellStartupOptions;
            }
        };
    }

    private final ShellStartupOptions createStartupOptions() {
        List<String> fullShellCommand = this.buildShellCommand();
        this.logger.info("\ud83d\udd27 Shell config: shellPath=" + this.config.getShellPath() + ", shellArgs=" + this.config.getShellArgs());
        this.logger.info("\ud83d\udd27 Full shell command: " + fullShellCommand);
        ShellStartupOptions.Builder builder2 = new ShellStartupOptions.Builder();
        String string = this.config.getCwd();
        if (string == null) {
            string = this.project.getBasePath();
        }
        return builder2.workingDirectory(string).shellCommand(fullShellCommand).build();
    }

    private final List<String> buildShellCommand() {
        Object it;
        List list;
        List $this$buildShellCommand_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String string = this.config.getShellPath();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$buildShellCommand_u24lambda_u244.add(it);
        }
        List<String> list2 = this.config.getShellArgs();
        if (list2 != null) {
            it = list2;
            boolean bl3 = false;
            $this$buildShellCommand_u24lambda_u244.addAll((Collection)it);
        }
        List it2 = list = CollectionsKt.build((List)list);
        boolean bl4 = false;
        return !((Collection)it2).isEmpty() ? list : null;
    }

    private final void initializeWidgets() {
        TerminalWidget terminalWidget = this.terminalWidget;
        Intrinsics.checkNotNull((Object)terminalWidget);
        JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)terminalWidget);
        ShellTerminalWidget shellTerminalWidget = jBTerminalWidget instanceof ShellTerminalWidget ? (ShellTerminalWidget)jBTerminalWidget : null;
        if (shellTerminalWidget == null) {
            throw new IllegalStateException("Cannot get ShellTerminalWidget");
        }
        this.shellWidget = shellTerminalWidget;
        TerminalWidget terminalWidget2 = this.terminalWidget;
        Intrinsics.checkNotNull((Object)terminalWidget2);
        terminalWidget2.getTerminalTitle().change(arg_0 -> TerminalInstance.initializeWidgets$lambda$6(this, arg_0));
    }

    private final void setupTerminalCloseListener() {
        try {
            TerminalWidget terminalWidget = this.terminalWidget;
            Intrinsics.checkNotNull((Object)terminalWidget);
            Disposer.register((Disposable)((Disposable)terminalWidget), () -> TerminalInstance.setupTerminalCloseListener$lambda$7(this));
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to set terminal close event listener: " + this.extHostTerminalId, (Throwable)e);
        }
    }

    private final PtyProcess createProxyPtyProcess(PtyProcess originalProcess) {
        this.logger.info("\ud83d\udd27 Creating proxy PtyProcess to intercept input/output streams...");
        ProxyPtyProcessCallback rawDataCallback = this.createRawDataCallback();
        return new ProxyPtyProcess(originalProcess, rawDataCallback);
    }

    private final ProxyPtyProcessCallback createRawDataCallback() {
        return new ProxyPtyProcessCallback(this){
            final /* synthetic */ TerminalInstance this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRawData(String data, String streamType) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)streamType, (String)"streamType");
                TerminalInstance.access$getLogger$p(this.this$0).debug("\ud83d\udce5 Raw data [" + streamType + "]: " + data.length() + " chars");
                try {
                    TerminalInstance.access$sendRawDataToExtHost(this.this$0, data);
                    TerminalInstance.access$getTerminalShellIntegration$p(this.this$0).appendRawOutput(data);
                }
                catch (Exception e) {
                    TerminalInstance.access$getLogger$p(this.this$0).error("\u274c Failed to process raw data (terminal: " + this.this$0.getExtHostTerminalId() + ")", (Throwable)e);
                }
            }
        };
    }

    private final void sendRawDataToExtHost(String data) {
        ExtHostTerminalServiceProxy extHostTerminalServiceProxy = this.rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostTerminalService());
        extHostTerminalServiceProxy.acceptTerminalProcessData(this.numericId, data);
        this.logger.debug("\u2705 Sent raw data to exthost: " + data.length() + " chars (terminal: " + this.extHostTerminalId + ")");
    }

    public final void show(boolean preserveFocus) {
        if (!this.state.canOperate()) {
            this.logger.warn("Terminal not initialized or disposed, cannot show: " + this.extHostTerminalId);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> TerminalInstance.show$lambda$8(this, preserveFocus));
    }

    public static /* synthetic */ void show$default(TerminalInstance terminalInstance, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        terminalInstance.show(bl);
    }

    public final void hide() {
        if (!this.state.canOperate()) {
            this.logger.warn("Terminal not initialized or disposed, cannot hide: " + this.extHostTerminalId);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> TerminalInstance.hide$lambda$9(this));
    }

    private final void showTerminalToolWindow() {
        try {
            ToolWindow toolWindow;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TERMINAL_TOOL_WINDOW_ID);
            if (toolWindow2 != null) {
                toolWindow2.show(null);
            }
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to show terminal tool window", (Throwable)e);
        }
    }

    private final void addToTerminalToolWindow() {
        if (this.terminalWidget == null) {
            this.logger.warn("TerminalWidget is null, cannot add to tool window");
            return;
        }
        try {
            TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance((Project)this.project);
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TERMINAL_TOOL_WINDOW_ID);
            if (toolWindow == null) {
                this.logger.warn("Terminal tool window does not exist");
                return;
            }
            TerminalWidget terminalWidget = this.terminalWidget;
            Intrinsics.checkNotNull((Object)terminalWidget);
            Content content2 = terminalToolWindowManager.newTab(toolWindow, terminalWidget);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"newTab(...)");
            Content content3 = content2;
            String string = this.config.getName();
            if (string == null) {
                string = DEFAULT_TERMINAL_NAME;
            }
            content3.setDisplayName(string);
            this.logger.info("\u2705 Added terminalWidget to Terminal tool window: " + content3.getDisplayName());
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to add terminalWidget to tool window", (Throwable)e);
        }
    }

    private final void hideTerminalToolWindow() {
        block0: {
            ToolWindow toolWindow;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TERMINAL_TOOL_WINDOW_ID);
            if (toolWindow2 == null) break block0;
            toolWindow2.hide(null);
        }
    }

    public final void sendText(@NotNull String text, boolean shouldExecute) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!this.state.canOperate()) {
            this.logger.warn("Terminal not initialized or disposed, cannot send text: " + this.extHostTerminalId);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> TerminalInstance.sendText$lambda$10(this, shouldExecute, text));
    }

    public static /* synthetic */ void sendText$default(TerminalInstance terminalInstance, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        terminalInstance.sendText(string, bl);
    }

    private final void notifyTerminalOpened() {
        try {
            this.logger.info("\ud83d\udce4 Notify exthost process terminal opened: " + this.extHostTerminalId + " (numericId: " + this.numericId + ")");
            ShellLaunchConfigDto shellLaunchConfigDto = this.config.toShellLaunchConfigDto(this.project.getBasePath());
            ExtHostTerminalServiceProxy extHostTerminalServiceProxy = this.rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostTerminalService());
            String string = this.config.getName();
            if (string == null) {
                string = DEFAULT_TERMINAL_NAME;
            }
            extHostTerminalServiceProxy.acceptTerminalOpened(this.numericId, this.extHostTerminalId, string, shellLaunchConfigDto);
            this.logger.info("\u2705 Successfully notified exthost process terminal opened: " + this.extHostTerminalId);
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to notify exthost process terminal opened: " + this.extHostTerminalId, (Throwable)e);
        }
    }

    private final void notifyShellIntegrationChange() {
        try {
            ExtHostTerminalShellIntegrationProxy extHostTerminalShellIntegrationProxy = this.rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostTerminalShellIntegration());
            extHostTerminalShellIntegrationProxy.shellIntegrationChange(this.numericId);
            this.logger.info("\u2705 Notified exthost Shell integration initialized: (terminal: " + this.extHostTerminalId + ")");
            this.notifyEnvironmentVariableChange(extHostTerminalShellIntegrationProxy);
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to notify exthost Shell integration initialized: (terminal: " + this.extHostTerminalId + ")", (Throwable)e);
        }
    }

    private final void notifyEnvironmentVariableChange(ExtHostTerminalShellIntegrationProxy extHostTerminalShellIntegrationProxy) {
        block3: {
            Map<String, String> map;
            Map<String, String> map2 = this.config.getEnv();
            if (map2 == null) break block3;
            Map<String, String> it = map = map2;
            boolean bl = false;
            map2 = !it.isEmpty() ? map : null;
            if (map2 != null) {
                Map<String, String> env = map2;
                boolean bl2 = false;
                try {
                    Collection $this$toTypedArray$iv = env.keySet();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] envKeys = thisCollection$iv.toArray(new String[0]);
                    Collection<String> $this$toTypedArray$iv2 = env.values();
                    boolean $i$f$toTypedArray2 = false;
                    Collection<String> thisCollection$iv2 = $this$toTypedArray$iv2;
                    String[] envValues = thisCollection$iv2.toArray(new String[0]);
                    extHostTerminalShellIntegrationProxy.shellEnvChange(this.numericId, envKeys, envValues, true);
                    this.logger.info("\u2705 Notified exthost environment variable change: " + env.size() + " variables (terminal: " + this.extHostTerminalId + ")");
                }
                catch (Exception e) {
                    this.logger.error("\u274c Failed to notify environment variable change: (terminal: " + this.extHostTerminalId + ")", (Throwable)e);
                }
            }
        }
    }

    private final void onTerminalClosed() {
        this.logger.info("\ud83d\udd14 Terminal closed event triggered: " + this.extHostTerminalId + " (numericId: " + this.numericId + ")");
        try {
            this.notifyTerminalClosed();
            this.callbackManager.executeCloseCallbacks();
            if (!this.state.isDisposed()) {
                this.dispose();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to handle terminal closed event: " + this.extHostTerminalId, (Throwable)e);
        }
    }

    private final void notifyTerminalClosed() {
        try {
            this.logger.info("\ud83d\udce4 Notify exthost process terminal closed: " + this.extHostTerminalId + " (numericId: " + this.numericId + ")");
            ExtHostTerminalServiceProxy extHostTerminalServiceProxy = this.rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostTerminalService());
            extHostTerminalServiceProxy.acceptTerminalClosed(this.numericId, null, this.numericId);
            this.logger.info("\u2705 Successfully notified exthost process terminal closed: " + this.extHostTerminalId);
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to notify exthost process terminal closed: " + this.extHostTerminalId, (Throwable)e);
        }
    }

    public void dispose() {
        if (this.state.isDisposed()) {
            return;
        }
        this.logger.info("\ud83e\uddf9 Disposing terminal instance: " + this.extHostTerminalId);
        try {
            this.state.markDisposed();
            this.callbackManager.clear();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
            TerminalWidget terminalWidget = this.terminalWidget;
            if (terminalWidget != null) {
                TerminalWidget widget2 = terminalWidget;
                boolean bl = false;
                try {
                    Disposer.dispose((Disposable)((Disposable)widget2));
                }
                catch (Exception e) {
                    this.logger.error("\u274c Failed to dispose terminalWidget: " + this.extHostTerminalId, (Throwable)e);
                }
            }
            this.terminalShellIntegration.dispose();
            this.cleanupResources();
            this.logger.info("\u2705 Terminal instance disposed: " + this.extHostTerminalId);
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to dispose terminal instance: " + this.extHostTerminalId, (Throwable)e);
        }
    }

    private final void cleanupResources() {
        this.terminalWidget = null;
        this.shellWidget = null;
    }

    private static final void initialize$lambda$0(TerminalInstance this$0) {
        this$0.performInitialization();
    }

    private static final Unit initializeWidgets$lambda$6(TerminalInstance this$0, TerminalTitle.State $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        String string = this$0.config.getName();
        if (string == null) {
            string = DEFAULT_TERMINAL_NAME;
        }
        $this$change.setUserDefinedTitle(string);
        return Unit.INSTANCE;
    }

    private static final void setupTerminalCloseListener$lambda$7(TerminalInstance this$0) {
        this$0.logger.info("\ud83d\udd14 TerminalWidget dispose event: " + this$0.extHostTerminalId);
        if (!this$0.state.isDisposed()) {
            this$0.onTerminalClosed();
        }
    }

    private static final void show$lambda$8(TerminalInstance this$0, boolean $preserveFocus) {
        try {
            this$0.showTerminalToolWindow();
            ShellTerminalWidget shellTerminalWidget = this$0.shellWidget;
            if (shellTerminalWidget != null) {
                shellTerminalWidget.show($preserveFocus);
            }
            this$0.logger.info("\u2705 Terminal shown: " + this$0.extHostTerminalId);
        }
        catch (Exception e) {
            this$0.logger.error("\u274c Failed to show terminal: " + this$0.extHostTerminalId, (Throwable)e);
        }
    }

    private static final void hide$lambda$9(TerminalInstance this$0) {
        try {
            this$0.hideTerminalToolWindow();
            ShellTerminalWidget shellTerminalWidget = this$0.shellWidget;
            if (shellTerminalWidget != null) {
                shellTerminalWidget.hide();
            }
            this$0.logger.info("\u2705 Terminal hidden: " + this$0.extHostTerminalId);
        }
        catch (Exception e) {
            this$0.logger.error("\u274c Failed to hide terminal: " + this$0.extHostTerminalId, (Throwable)e);
        }
    }

    private static final void sendText$lambda$10(TerminalInstance this$0, boolean $shouldExecute, String $text) {
        try {
            ShellTerminalWidget shellTerminalWidget = this$0.shellWidget;
            if (shellTerminalWidget == null) {
                return;
            }
            ShellTerminalWidget shell = shellTerminalWidget;
            if ($shouldExecute) {
                shell.executeCommand($text);
                this$0.logger.info("\u2705 Command executed: " + $text + " (terminal: " + this$0.extHostTerminalId + ")");
            } else {
                shell.writePlainMessage($text);
                this$0.logger.info("\u2705 Text sent: " + $text + " (terminal: " + this$0.extHostTerminalId + ")");
            }
        }
        catch (Exception e) {
            this$0.logger.error("\u274c Failed to send text: " + this$0.extHostTerminalId, (Throwable)e);
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(TerminalInstance $this) {
        return $this.logger;
    }

    public static final /* synthetic */ PtyProcess access$createProxyPtyProcess(TerminalInstance $this, PtyProcess originalProcess) {
        return $this.createProxyPtyProcess(originalProcess);
    }

    public static final /* synthetic */ void access$sendRawDataToExtHost(TerminalInstance $this, String data) {
        $this.sendRawDataToExtHost(data);
    }

    public static final /* synthetic */ TerminalShellIntegration access$getTerminalShellIntegration$p(TerminalInstance $this) {
        return $this.terminalShellIntegration;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalInstance$Companion;", "", "<init>", "()V", "DEFAULT_TERMINAL_NAME", "", "TERMINAL_TOOL_WINDOW_ID", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

