/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.ISocket;
import com.sina.weibo.agent.ipc.ProtocolMessage;
import com.sina.weibo.agent.ipc.ProtocolMessageType;
import com.sina.weibo.agent.ipc.SocketDiagnosticsEventType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 =2\u00020\u0001:\u0002<=B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010&\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u001c\u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0006\u0010*\u001a\u00020 J\u000e\u0010+\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020 J\u0006\u0010.\u001a\u00020 J\u0006\u0010/\u001a\u00020 J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020 H\u0002J\b\u00108\u001a\u00020\u0005H\u0002J\b\u00109\u001a\u00020 H\u0002J\u0006\u0010:\u001a\u00020;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolWriter;", "", "socket", "Lcom/sina/weibo/agent/ipc/ISocket;", "enableLogging", "", "<init>", "(Lcom/sina/weibo/agent/ipc/ISocket;Z)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isPaused", "lastWriteTime", "Ljava/util/concurrent/atomic/AtomicLong;", "queueLock", "Ljava/util/concurrent/locks/ReentrantLock;", "messageQueue", "Ljava/util/TreeMap;", "", "Lcom/sina/weibo/agent/ipc/ProtocolWriter$MessagePackage;", "specialMessageQueue", "", "nextExpectedId", "isWriteScheduled", "writeJob", "Lkotlinx/coroutines/Job;", "blockingDetectionJob", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "startBlockingDetection", "", "checkMessageBlocking", "logInfo", "message", "", "logDebug", "logWarn", "throwable", "", "logError", "dispose", "drain", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "pause", "resume", "write", "msg", "Lcom/sina/weibo/agent/ipc/ProtocolMessage;", "addMessageToQueue", "id", "data", "", "scheduleWriting", "hasDataToWrite", "writeNow", "getLastWriteTime", "", "MessagePackage", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProtocolWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolWriter.kt\ncom/sina/weibo/agent/ipc/ProtocolWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1374#2:439\n1460#2,5:440\n1374#2:445\n1460#2,5:446\n1374#2:451\n1460#2,5:452\n*S KotlinDebug\n*F\n+ 1 ProtocolWriter.kt\ncom/sina/weibo/agent/ipc/ProtocolWriter\n*L\n367#1:439\n367#1:440,5\n403#1:445\n403#1:446,5\n405#1:451\n405#1:452,5\n*E\n"})
public final class ProtocolWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ISocket socket;
    private final boolean enableLogging;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final AtomicBoolean isPaused;
    @NotNull
    private final AtomicLong lastWriteTime;
    @NotNull
    private final ReentrantLock queueLock;
    @NotNull
    private final TreeMap<Integer, MessagePackage> messageQueue;
    @NotNull
    private final List<MessagePackage> specialMessageQueue;
    private int nextExpectedId;
    @NotNull
    private AtomicBoolean isWriteScheduled;
    @Nullable
    private Job writeJob;
    @Nullable
    private Job blockingDetectionJob;
    @NotNull
    private final CoroutineScope coroutineScope;
    private static final int ACK_MESSAGE_ID = 0;
    private static final int PRIORITY_MESSAGE_ID = -1;

    public ProtocolWriter(@NotNull ISocket socket, boolean enableLogging) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        this.enableLogging = enableLogging;
        Logger logger = Logger.getInstance(ProtocolWriter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isDisposed = new AtomicBoolean(false);
        this.isPaused = new AtomicBoolean(false);
        this.lastWriteTime = new AtomicLong(0L);
        this.queueLock = new ReentrantLock();
        this.messageQueue = new TreeMap();
        this.specialMessageQueue = new ArrayList();
        this.nextExpectedId = 1;
        this.isWriteScheduled = new AtomicBoolean(false);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.startBlockingDetection();
    }

    public /* synthetic */ ProtocolWriter(ISocket iSocket, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(iSocket, bl);
    }

    private final void startBlockingDetection() {
        this.blockingDetectionJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProtocolWriter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 2 sources

                        while (!ProtocolWriter.access$isDisposed$p(this.this$0).get()) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl12
lbl11:
                            // 1 sources

                            return var3_2;
lbl12:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            ProtocolWriter.access$checkMessageBlocking(this.this$0);
                            ** GOTO lbl5
                        }
                        catch (Exception e) {
                            if (ProtocolWriter.access$isDisposed$p(this.this$0).get()) ** GOTO lbl24
                            ProtocolWriter.access$logWarn(this.this$0, "Error in blocking detection: " + e.getMessage(), e);
                        }
lbl24:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkMessageBlocking() {
        if (this.isDisposed.get()) {
            return;
        }
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!((Map)this.messageQueue).isEmpty() && !this.messageQueue.containsKey(this.nextExpectedId)) {
                Integer minId = this.messageQueue.firstKey();
                int queueSize = this.messageQueue.size();
                Set<Integer> set2 = this.messageQueue.keySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
                String queueIds = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)set2, (int)10), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                ProtocolWriter.logWarn$default(this, "Message blocking detected! Expected next ID: " + this.nextExpectedId + ", Minimum ID in queue: " + minId + ", Queue size: " + queueSize + ", Queue IDs: [" + queueIds + (queueSize > 10 ? "..." : "") + "]", null, 2, null);
                List consecutiveIds = new ArrayList();
                Integer currentId = minId;
                while (this.messageQueue.containsKey(currentId)) {
                    Integer n = currentId;
                    Intrinsics.checkNotNull((Object)n);
                    consecutiveIds.add(n);
                    currentId = currentId + 1;
                }
                if (!((Collection)consecutiveIds).isEmpty()) {
                    ProtocolWriter.logWarn$default(this, "Consecutive IDs available from " + minId + ": " + CollectionsKt.joinToString$default((Iterable)consecutiveIds, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
                }
                if (minId > this.nextExpectedId) {
                    ProtocolWriter.logWarn$default(this, "Missing message IDs: " + this.nextExpectedId + " to " + (minId - 1) + " (" + (minId - this.nextExpectedId) + " messages)", null, 2, null);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void logInfo(String message) {
        if (this.enableLogging) {
            this.logger.info(message);
        }
    }

    private final void logDebug(String message) {
        if (this.enableLogging) {
            this.logger.debug(message);
        }
    }

    private final void logWarn(String message, Throwable throwable) {
        if (this.enableLogging) {
            this.logger.warn(message, throwable);
        }
    }

    static /* synthetic */ void logWarn$default(ProtocolWriter protocolWriter, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        protocolWriter.logWarn(string, throwable);
    }

    private final void logError(String message, Throwable throwable) {
        if (this.enableLogging) {
            this.logger.error(message, throwable);
        }
    }

    static /* synthetic */ void logError$default(ProtocolWriter protocolWriter, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        protocolWriter.logError(string, throwable);
    }

    public final void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        Job job = this.blockingDetectionJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.blockingDetectionJob = null;
        try {
            this.flush();
        }
        catch (Exception e) {
            this.logWarn("Error flushing protocol writer: " + e.getMessage(), e);
        }
        Job job2 = this.writeJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.logInfo("ProtocolWriter disposed");
    }

    @Nullable
    public final Object drain(@NotNull Continuation<? super Unit> $completion) {
        this.flush();
        Object object = this.socket.drain($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void flush() {
        this.writeNow();
    }

    public final void pause() {
        this.isPaused.set(true);
    }

    public final void resume() {
        if (!this.isPaused.getAndSet(false)) {
            return;
        }
        this.scheduleWriting();
    }

    public final void write(@NotNull ProtocolMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.isDisposed.get()) {
            this.logDebug("Ignoring write request, writer is disposed");
            return;
        }
        if (msg.getType() != ProtocolMessageType.KEEP_ALIVE) {
            this.logInfo("Writing message: id=" + msg.getId() + ", ack=" + msg.getAck() + ", type=" + msg.getType() + ", data size=" + msg.getData().length);
        }
        msg.setWrittenTime(System.currentTimeMillis());
        this.lastWriteTime.set(System.currentTimeMillis());
        ByteBuffer headerBuffer = ByteBuffer.allocate(13);
        headerBuffer.put(0, (byte)msg.getType().getValue());
        headerBuffer.putInt(1, msg.getId());
        headerBuffer.putInt(5, msg.getAck());
        headerBuffer.putInt(9, msg.getData().length);
        byte[] header = headerBuffer.array();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"messageType", (Object)msg.getType().toTypeString()), TuplesKt.to((Object)"id", (Object)msg.getId()), TuplesKt.to((Object)"ack", (Object)msg.getAck()), TuplesKt.to((Object)"messageSize", (Object)msg.getData().length)};
        this.socket.traceSocketEvent(SocketDiagnosticsEventType.PROTOCOL_HEADER_WRITE, MapsKt.mapOf((Pair[])pairArray));
        this.socket.traceSocketEvent(SocketDiagnosticsEventType.PROTOCOL_MESSAGE_WRITE, msg.getData());
        byte[] combined = new byte[header.length + msg.getData().length];
        System.arraycopy(header, 0, combined, 0, header.length);
        System.arraycopy(msg.getData(), 0, combined, header.length, msg.getData().length);
        this.addMessageToQueue(msg.getId(), combined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addMessageToQueue(int id, byte[] data) {
        MessagePackage pkg = new MessagePackage(id, data);
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            switch (id) {
                case -1: 
                case 0: {
                    this.specialMessageQueue.add(pkg);
                    this.logDebug("Added special message to queue: id=" + id);
                    break;
                }
                default: {
                    Integer n = id;
                    ((Map)this.messageQueue).put(n, pkg);
                    this.logDebug("Added message to sorted queue: id=" + id + ", queue size=" + this.messageQueue.size());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.scheduleWriting();
    }

    private final void scheduleWriting() {
        if (this.isPaused.get() || this.isDisposed.get()) {
            return;
        }
        if (!this.isWriteScheduled.compareAndSet(false, true)) {
            return;
        }
        this.writeJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProtocolWriter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        try {
                            ProtocolWriter.access$writeNow(this.this$0);
                            ProtocolWriter.access$isWriteScheduled$p(this.this$0).set(false);
                            if (ProtocolWriter.access$hasDataToWrite(this.this$0)) {
                                ProtocolWriter.access$scheduleWriting(this.this$0);
                            }
                            ** GOTO lbl25
                        }
                        catch (Exception e) {
                            ProtocolWriter.access$logError(this.this$0, "Error in write job: " + e.getMessage(), e);
                            ProtocolWriter.access$isWriteScheduled$p(this.this$0).set(false);
                            if (ProtocolWriter.access$isDisposed$p(this.this$0).get() || !ProtocolWriter.access$hasDataToWrite(this.this$0)) ** GOTO lbl25
                            this.label = 1;
                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl24
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        ProtocolWriter.access$scheduleWriting(this.this$0);
lbl25:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasDataToWrite() {
        boolean bl;
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl2 = false;
            bl = !((Collection)this.specialMessageQueue).isEmpty() || !((Map)this.messageQueue).isEmpty();
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeNow() {
        byte[] byArray;
        if (this.isPaused.get() || this.isDisposed.get()) {
            return;
        }
        Lock lock = this.queueLock;
        lock.lock();
        try {
            byte[] byArray2;
            boolean bl = false;
            if (this.specialMessageQueue.isEmpty() && this.messageQueue.isEmpty()) {
                byArray2 = null;
            } else {
                byte[] specialData = null;
                if (!((Collection)this.specialMessageQueue).isEmpty()) {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = this.specialMessageQueue;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        MessagePackage it = (MessagePackage)element$iv$iv;
                        boolean bl2 = false;
                        Iterable list$iv$iv = ArraysKt.toList((byte[])it.getData());
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    specialData = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                    this.specialMessageQueue.clear();
                }
                if (this.messageQueue.isEmpty()) {
                    byArray2 = specialData;
                } else {
                    List messagesToSend = new ArrayList();
                    int currentId = this.nextExpectedId;
                    if (!this.messageQueue.containsKey(this.nextExpectedId)) {
                        this.logInfo("Waiting for message with ID=" + this.nextExpectedId + " before sending later messages, messageQueue: " + this.messageQueue.size());
                        byArray2 = specialData;
                    } else {
                        Iterable message;
                        while (this.messageQueue.containsKey(currentId)) {
                            Intrinsics.checkNotNull((Object)this.messageQueue.get(currentId));
                            messagesToSend.add(message);
                            this.messageQueue.remove(currentId);
                            ++currentId;
                        }
                        if (!((Collection)messagesToSend).isEmpty()) {
                            this.nextExpectedId = currentId;
                            this.logDebug("Next expected ID updated to " + this.nextExpectedId);
                            if (specialData != null) {
                                void $this$flatMapTo$iv$iv;
                                message = messagesToSend;
                                byte[] byArray3 = specialData;
                                boolean $i$f$flatMap = false;
                                Iterable $i$f$flatMapTo = $this$flatMap$iv;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$flatMapTo2 = false;
                                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                                    it = (MessagePackage)element$iv$iv;
                                    boolean bl3 = false;
                                    list$iv$iv = ArraysKt.toList((byte[])it.getData());
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                byArray2 = ArraysKt.plus((byte[])byArray3, (byte[])CollectionsKt.toByteArray((Collection)((List)destination$iv$iv)));
                            } else {
                                $this$flatMap$iv = messagesToSend;
                                boolean $i$f$flatMap = false;
                                Iterable $this$flatMapTo$iv$iv = $this$flatMap$iv;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$flatMapTo = false;
                                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                                    it = (MessagePackage)element$iv$iv;
                                    boolean bl4 = false;
                                    list$iv$iv = ArraysKt.toList((byte[])it.getData());
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                byArray2 = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                            }
                        } else {
                            byArray2 = specialData;
                        }
                    }
                }
            }
            byArray = byArray2;
        }
        finally {
            lock.unlock();
        }
        byte[] dataToWrite = byArray;
        if (dataToWrite != null && !(dataToWrite.length == 0)) {
            try {
                this.logInfo("Writing " + dataToWrite.length + " bytes to socket");
                this.socket.traceSocketEvent(SocketDiagnosticsEventType.PROTOCOL_WRITE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"byteLength", (Object)dataToWrite.length)));
                this.socket.write(dataToWrite);
            }
            catch (Exception e) {
                this.logError("Error writing to socket: " + e.getMessage(), e);
                if (!this.isDisposed.get()) {
                    this.isDisposed.set(true);
                }
                throw e;
            }
        }
    }

    public final long getLastWriteTime() {
        return this.lastWriteTime.get();
    }

    public static final /* synthetic */ AtomicBoolean access$isDisposed$p(ProtocolWriter $this) {
        return $this.isDisposed;
    }

    public static final /* synthetic */ void access$checkMessageBlocking(ProtocolWriter $this) {
        $this.checkMessageBlocking();
    }

    public static final /* synthetic */ void access$logWarn(ProtocolWriter $this, String message, Throwable throwable) {
        $this.logWarn(message, throwable);
    }

    public static final /* synthetic */ void access$writeNow(ProtocolWriter $this) {
        $this.writeNow();
    }

    public static final /* synthetic */ AtomicBoolean access$isWriteScheduled$p(ProtocolWriter $this) {
        return $this.isWriteScheduled;
    }

    public static final /* synthetic */ boolean access$hasDataToWrite(ProtocolWriter $this) {
        return $this.hasDataToWrite();
    }

    public static final /* synthetic */ void access$scheduleWriting(ProtocolWriter $this) {
        $this.scheduleWriting();
    }

    public static final /* synthetic */ void access$logError(ProtocolWriter $this, String message, Throwable throwable) {
        $this.logError(message, throwable);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolWriter$Companion;", "", "<init>", "()V", "ACK_MESSAGE_ID", "", "PRIORITY_MESSAGE_ID", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolWriter$MessagePackage;", "", "id", "", "data", "", "<init>", "(I[B)V", "getId", "()I", "getData", "()[B", "equals", "", "other", "hashCode", "component1", "component2", "copy", "toString", "", "coderider-kilo-jetbrains"})
    private static final class MessagePackage {
        private final int id;
        @NotNull
        private final byte[] data;

        public MessagePackage(int id, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.id = id;
            this.data = data;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessagePackage)) {
                return false;
            }
            if (this.id != ((MessagePackage)other).id) {
                return false;
            }
            return Arrays.equals(this.data, ((MessagePackage)other).data);
        }

        public int hashCode() {
            int result2 = this.id;
            result2 = 31 * result2 + Arrays.hashCode(this.data);
            return result2;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final byte[] component2() {
            return this.data;
        }

        @NotNull
        public final MessagePackage copy(int id, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new MessagePackage(id, data);
        }

        public static /* synthetic */ MessagePackage copy$default(MessagePackage messagePackage, int n, byte[] byArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = messagePackage.id;
            }
            if ((n2 & 2) != 0) {
                byArray = messagePackage.data;
            }
            return messagePackage.copy(n, byArray);
        }

        @NotNull
        public String toString() {
            return "MessagePackage(id=" + this.id + ", data=" + Arrays.toString(this.data) + ")";
        }
    }
}

