/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import com.sina.weibo.agent.ipc.ILoadEstimator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sina/weibo/agent/ipc/LoadEstimator;", "Lcom/sina/weibo/agent/ipc/ILoadEstimator;", "<init>", "()V", "lastRuns", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "load", "", "hasHighLoad", "", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nLoadEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadEstimator.kt\ncom/sina/weibo/agent/ipc/LoadEstimator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class LoadEstimator
implements ILoadEstimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] lastRuns = new long[10];
    @NotNull
    private final ScheduledExecutorService scheduler;
    private static final int HISTORY_LENGTH = 10;
    @NotNull
    private static final AtomicReference<LoadEstimator> INSTANCE = new AtomicReference();

    private LoadEstimator() {
        long now = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            this.lastRuns[i] = now - 1000L * (long)i;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(LoadEstimator::_init_$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this.scheduler = scheduledExecutorService;
        this.scheduler.scheduleAtFixedRate(() -> LoadEstimator._init_$lambda$2(this), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private final double load() {
        long now = System.currentTimeMillis();
        long historyLimit = 11000L;
        int score = 0;
        for (int i = 0; i < 10; ++i) {
            if (now - this.lastRuns[i] > historyLimit) continue;
            ++score;
        }
        return 1.0 - (double)score / (double)10;
    }

    @Override
    public boolean hasHighLoad() {
        return this.load() >= 0.5;
    }

    private static final Thread _init_$lambda$1(Runnable r) {
        Thread thread;
        Thread $this$lambda_u241_u24lambda_u240 = thread = new Thread(r, "LoadEstimator");
        boolean bl = false;
        $this$lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void _init_$lambda$2(LoadEstimator this$0) {
        for (int i = 9; 0 < i; --i) {
            this$0.lastRuns[i] = this$0.lastRuns[i - 1];
        }
        this$0.lastRuns[0] = System.currentTimeMillis();
    }

    @JvmStatic
    @NotNull
    public static final LoadEstimator getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ LoadEstimator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/sina/weibo/agent/ipc/LoadEstimator$Companion;", "", "<init>", "()V", "HISTORY_LENGTH", "", "INSTANCE", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/sina/weibo/agent/ipc/LoadEstimator;", "getInstance", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LoadEstimator getInstance() {
            LoadEstimator instance = (LoadEstimator)INSTANCE.get();
            if (instance == null) {
                instance = new LoadEstimator(null);
                if (!INSTANCE.compareAndSet(null, instance)) {
                    instance = (LoadEstimator)INSTANCE.get();
                }
            }
            LoadEstimator loadEstimator = instance;
            Intrinsics.checkNotNull((Object)loadEstimator);
            return loadEstimator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

