/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui.actions;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.jcef.JBCefApp;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostCommandsProxy;
import com.sina.weibo.agent.util.ProxyConfigUtil;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebViewManager;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\b2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/sina/weibo/agent/extensions/ui/actions/ExtensionStatusChecker;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkExtensionStatus", "", "project", "Lcom/intellij/openapi/project/Project;", "addSystemInformation", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "showStatusDialog", "status", "ExtensionStatusDialog", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionStatusChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionStatusChecker.kt\ncom/sina/weibo/agent/extensions/ui/actions/ExtensionStatusChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1869#2,2:234\n*S KotlinDebug\n*F\n+ 1 ExtensionStatusChecker.kt\ncom/sina/weibo/agent/extensions/ui/actions/ExtensionStatusChecker\n*L\n91#1:234,2\n*E\n"})
public final class ExtensionStatusChecker
extends AnAction {
    @NotNull
    private final Logger logger;

    public ExtensionStatusChecker() {
        super("Check Extension Status");
        Logger logger = Logger.getInstance(ExtensionStatusChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        String status = this.checkExtensionStatus(project2);
        this.showStatusDialog(status);
    }

    private final String checkExtensionStatus(Project project) {
        CharSequence charSequence;
        ExtensionManager extensionManager;
        StringBuilder sb = new StringBuilder();
        sb.append("\ud83d\udd0d Extension Status Check").append('\n');
        sb.append(StringsKt.repeat((CharSequence)"=", (int)50)).append('\n');
        this.addSystemInformation(sb);
        try {
            extensionManager = ExtensionManager.Companion.getInstance(project);
            ExtensionProvider currentProvider = extensionManager.getCurrentProvider();
            charSequence = sb;
            Object object = currentProvider;
            if (object == null || (object = object.getExtensionId()) == null) {
                object = "None";
            }
            ((StringBuilder)charSequence).append("\ud83d\udccb Current Extension Provider: " + (String)object).append('\n');
            charSequence = sb;
            Object object2 = currentProvider;
            if (object2 == null || (object2 = object2.getDisplayName()) == null) {
                object2 = "None";
            }
            ((StringBuilder)charSequence).append("\ud83d\udccb Current Extension Name: " + (String)object2).append('\n');
        }
        catch (Exception e) {
            sb.append("\u274c Extension Manager Error: " + e.getMessage()).append('\n');
        }
        try {
            PluginContext pluginContext = (PluginContext)project.getService(PluginContext.class);
            if (pluginContext != null) {
                sb.append("\u2705 PluginContext: Available").append('\n');
                IRPCProtocol rpcProtocol = pluginContext.getRPCProtocol();
                if (rpcProtocol != null) {
                    sb.append("\u2705 RPC Protocol: Available").append('\n');
                    ExtHostCommandsProxy commandsProxy = rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostCommands());
                    v2 = commandsProxy != null ? sb.append("\u2705 ExtHostCommands Proxy: Available").append('\n') : sb.append("\u274c ExtHostCommands Proxy: Not Available").append('\n');
                } else {
                    v2 = sb.append("\u274c RPC Protocol: Not Available").append('\n');
                }
            } else {
                v2 = sb.append("\u274c PluginContext: Not Available").append('\n');
            }
        }
        catch (Exception e) {
            sb.append("\u274c Plugin Context Error: " + e.getMessage()).append('\n');
        }
        try {
            extensionManager = ExtensionManager.Companion.getInstance(project);
            List<ExtensionProvider> availableProviders = extensionManager.getAvailableProviders();
            sb.append("\n\ud83d\udccb Available Extensions:").append('\n');
            Iterable $this$forEach$iv = availableProviders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExtensionProvider provider = (ExtensionProvider)element$iv;
                boolean bl = false;
                sb.append("  - " + provider.getExtensionId() + ": " + provider.getDisplayName()).append('\n');
            }
        }
        catch (Exception e) {
            sb.append("\u274c Error getting available extensions: " + e.getMessage()).append('\n');
        }
        try {
            WebViewManager webViewManager = (WebViewManager)project.getService(WebViewManager.class);
            if (webViewManager != null) {
                sb.append("\n\ud83c\udf10 WebView Status:").append('\n');
                WebViewInstance latestWebView = webViewManager.getLatestWebView();
                v3 = latestWebView != null ? sb.append("\u2705 Latest WebView: Available").append('\n') : sb.append("\u274c Latest WebView: Not Available").append('\n');
            } else {
                v3 = sb.append("\n\u274c WebView Manager: Not Available").append('\n');
            }
        }
        catch (Exception e) {
            sb.append("\n\u274c WebView Status Error: " + e.getMessage()).append('\n');
        }
        try {
            ProxyConfigUtil.ProxyConfig proxyConfig = ProxyConfigUtil.INSTANCE.getProxyConfig();
            sb.append("\n\ud83c\udf10 Proxy Status:").append('\n');
            String sourceDescription = switch (proxyConfig.getSource()) {
                case "ide-pac" -> "IDE Settings (PAC)";
                case "ide-http" -> "IDE Settings (HTTP Proxy)";
                case "ide-none" -> "IDE Settings (No Proxy)";
                case "env" -> "Environment Variables";
                case "none" -> "No Proxy Configuration";
                case "ide-error" -> "IDE Settings (Error)";
                case "env-error" -> "Environment Variables (Error)";
                default -> proxyConfig.getSource();
            };
            sb.append("  Source: " + sourceDescription).append('\n');
            if (proxyConfig.getHasProxy()) {
                charSequence = proxyConfig.getPacUrl();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    sb.append("  PAC URL: " + proxyConfig.getPacUrl()).append('\n');
                } else {
                    charSequence = proxyConfig.getProxyUrl();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        sb.append("  Proxy URL: " + proxyConfig.getProxyUrl()).append('\n');
                    }
                }
                charSequence = proxyConfig.getProxyExceptions();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    sb.append(" No Proxy For: " + proxyConfig.getProxyExceptions()).append('\n');
                }
            } else {
                sb.append("  No proxy configuration found").append('\n');
            }
        }
        catch (Exception e) {
            sb.append("\n\u274c Proxy Status Error: " + e.getMessage()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void addSystemInformation(StringBuilder sb) {
        try {
            appInfo = ApplicationInfo.getInstance();
            plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.gitlab.coderider-kilo"));
            v0 /* !! */  = plugin;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getVersion()) == null) {
                v0 /* !! */  = "unknown";
            }
            pluginVersion /* !! */  = v0 /* !! */ ;
            osName = System.getProperty("os.name");
            osVersion = System.getProperty("os.version");
            osArch = System.getProperty("os.arch");
            jcefSupported = JBCefApp.isSupported();
            Intrinsics.checkNotNull((Object)osName);
            v1 = osName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)v1, (CharSequence)"linux", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)osArch);
            v2 = osArch.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"aarch64", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v3 = osArch.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"arm", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            isLinuxArm = v4;
            sb.append("\n\ud83d\udcca System Information:").append('\n');
            sb.append("  \ud83d\udcbb CPU Architecture: " + osArch).append('\n');
            sb.append("  \ud83d\udda5\ufe0f Operating System: " + osName + " " + osVersion).append('\n');
            sb.append("  \ud83d\udd27 IDE Version: " + appInfo.getFullApplicationName() + " (build " + appInfo.getBuild() + ")").append('\n');
            sb.append("  \ud83d\udce6 Plugin Version: " + (String)pluginVersion /* !! */ ).append('\n');
            sb.append("  \ud83c\udf10 JCEF Support: " + (jcefSupported != false ? "\u2705 Yes" : "\u274c No")).append('\n');
            if (isLinuxArm) {
                sb.append("  \u26a0\ufe0f Warning: Linux ARM systems are currently not supported").append('\n');
            }
            if (!jcefSupported) {
                sb.append("  \u274c Warning: JCEF not supported - WebView functionality may not work").append('\n');
            }
        }
        catch (Exception e) {
            sb.append("\n\u274c System Information Error: " + e.getMessage()).append('\n');
        }
    }

    private final void showStatusDialog(String status) {
        ExtensionStatusDialog dialog = new ExtensionStatusDialog(status);
        dialog.show();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/sina/weibo/agent/extensions/ui/actions/ExtensionStatusChecker$ExtensionStatusDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "statusText", "", "<init>", "(Ljava/lang/String;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "coderider-kilo-jetbrains"})
    private static final class ExtensionStatusDialog
    extends DialogWrapper {
        @NotNull
        private final String statusText;

        public ExtensionStatusDialog(@NotNull String statusText) {
            Intrinsics.checkNotNullParameter((Object)statusText, (String)"statusText");
            super(true);
            this.statusText = statusText;
            this.setTitle("Extension Status");
            this.init();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JTextArea textArea = new JTextArea(this.statusText);
            textArea.setEditable(false);
            textArea.setFont(new JLabel().getFont());
            textArea.setBackground(new JLabel().getBackground());
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(600, 400));
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            panel.add(scrollPane);
            return panel;
        }

        @NotNull
        protected Action[] createActions() {
            AbstractAction copyAction2 = new AbstractAction(this){
                final /* synthetic */ ExtensionStatusDialog this$0;
                {
                    this.this$0 = $receiver;
                    super("Copy to Clipboard");
                }

                public void actionPerformed(ActionEvent e) {
                    StringSelection selection = new StringSelection(ExtensionStatusDialog.access$getStatusText$p(this.this$0));
                    CopyPasteManager.getInstance().setContents((Transferable)selection);
                    Messages.showInfoMessage((String)"Status information copied to clipboard!", (String)"Copied");
                }
            };
            Action[] actionArray = new Action[]{copyAction2, this.getOKAction()};
            return actionArray;
        }

        public static final /* synthetic */ String access$getStatusText$p(ExtensionStatusDialog $this) {
            return $this.statusText;
        }
    }
}

