/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.core;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.common.ExtensionChangeListener;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.ui.buttons.DynamicButtonManager;
import com.sina.weibo.agent.plugin.WecoderPluginService;
import com.sina.weibo.agent.webview.WebViewManager;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\nJ\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionSwitcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isSwitching", "", "switchingFuture", "Ljava/util/concurrent/CompletableFuture;", "switchingScope", "Lkotlinx/coroutines/CoroutineScope;", "checkServicesAvailability", "switchExtension", "extensionId", "", "forceRestart", "performExtensionSwitch", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateExtensionManager", "", "updateButtonConfiguration", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyExtensionChanged", "waitForSwitching", "cancelSwitching", "dispose", "Companion", "coderider-kilo-jetbrains"})
public final class ExtensionSwitcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger LOG;
    private volatile boolean isSwitching;
    @Nullable
    private CompletableFuture<Boolean> switchingFuture;
    @NotNull
    private final CoroutineScope switchingScope;

    public ExtensionSwitcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(ExtensionSwitcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.switchingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    private final boolean checkServicesAvailability() {
        boolean bl;
        try {
            WecoderPluginService pluginService = (WecoderPluginService)this.project.getService(WecoderPluginService.class);
            if (pluginService == null) {
                this.LOG.info("WecoderPluginService not available");
                return false;
            }
            pluginService.getProcessManager();
            pluginService.getSocketServer();
            bl = true;
        }
        catch (Exception e) {
            this.LOG.info("Error checking services availability", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final CompletableFuture<Boolean> switchExtension(@NotNull String extensionId, boolean forceRestart) {
        ExtensionProvider currentProvider;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        if (this.isSwitching) {
            this.LOG.warn("Extension switching already in progress");
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(this.project);
        ExtensionProvider targetProvider = extensionManager.getProvider(extensionId);
        if (targetProvider == null) {
            this.LOG.info("Extension provider not found: " + extensionId);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (!targetProvider.isAvailable(this.project)) {
            this.LOG.info("Extension provider not available: " + extensionId);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ExtensionProvider extensionProvider = currentProvider = extensionManager.getCurrentProvider();
        if (Intrinsics.areEqual((Object)(extensionProvider != null ? extensionProvider.getExtensionId() : null), (Object)extensionId)) {
            this.LOG.info("Already using extension provider: " + extensionId);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ExtensionProvider extensionProvider2 = currentProvider;
        this.LOG.info("Starting extension switch from " + (extensionProvider2 != null ? extensionProvider2.getExtensionId() : null) + " to " + extensionId + " (will take effect on next startup)");
        if (!this.checkServicesAvailability()) {
            this.LOG.info("Required services not available, cannot perform extension switch");
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        this.isSwitching = true;
        this.switchingFuture = new CompletableFuture();
        BuildersKt.launch$default((CoroutineScope)this.switchingScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, extensionId, forceRestart, null){
            int label;
            final /* synthetic */ ExtensionSwitcher this$0;
            final /* synthetic */ String $extensionId;
            final /* synthetic */ boolean $forceRestart;
            {
                this.this$0 = $receiver;
                this.$extensionId = $extensionId;
                this.$forceRestart = $forceRestart;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ExtensionSwitcher.access$performExtensionSwitch(this.this$0, this.$extensionId, this.$forceRestart, (Continuation)this);
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            success = (Boolean)v0;
                            v1 = ExtensionSwitcher.access$getSwitchingFuture$p(this.this$0);
                            if (v1 == null) ** GOTO lbl22
                            Boxing.boxBoolean((boolean)v1.complete(Boxing.boxBoolean((boolean)(success != false))));
                        }
                        catch (Exception e) {
                            ExtensionSwitcher.access$getLOG$p(this.this$0).info("Error during extension switching", (Throwable)e);
                            v2 = ExtensionSwitcher.access$getSwitchingFuture$p(this.this$0);
                            if (v2 != null) {
                                Boxing.boxBoolean((boolean)v2.completeExceptionally(e));
                            }
                            ** GOTO lbl37
                        }
lbl22:
                        // 2 sources

                        ExtensionSwitcher.access$setSwitching$p(this.this$0, false);
                        ** GOTO lbl37
                    }
                    {
                        finally {
                            ExtensionSwitcher.access$setSwitching$p(this.this$0, false);
                        }
                    }
lbl37:
                    // 2 sources

                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        CompletableFuture<Boolean> completableFuture = this.switchingFuture;
        Intrinsics.checkNotNull(completableFuture);
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture switchExtension$default(ExtensionSwitcher extensionSwitcher, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return extensionSwitcher.switchExtension(string, bl);
    }

    private final Object performExtensionSwitch(String extensionId, boolean forceRestart, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, extensionId, forceRestart, null){
            int label;
            final /* synthetic */ ExtensionSwitcher this$0;
            final /* synthetic */ String $extensionId;
            final /* synthetic */ boolean $forceRestart;
            {
                this.this$0 = $receiver;
                this.$extensionId = $extensionId;
                this.$forceRestart = $forceRestart;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ExtensionSwitcher.access$updateExtensionManager(this.this$0, this.$extensionId, this.$forceRestart, (Continuation)this);
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!this.$forceRestart) ** GOTO lbl38
                        this.label = 2;
                        v1 = ExtensionSwitcher.access$updateButtonConfiguration(this.this$0, this.$extensionId, (Continuation)this);
                        ** if (v1 != var4_2) goto lbl22
lbl21:
                        // 1 sources

                        return var4_2;
lbl22:
                        // 1 sources

                        ** GOTO lbl28
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        this.label = 3;
                        v2 = ExtensionSwitcher.access$notifyExtensionChanged(this.this$0, this.$extensionId, (Continuation)this);
                        ** if (v2 != var4_2) goto lbl32
lbl31:
                        // 1 sources

                        return var4_2;
lbl32:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 3: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl38:
                            // 3 sources

                            ExtensionSwitcher.access$getLOG$p(this.this$0).info("Extension switching configuration saved successfully: " + this.$extensionId + " (will take effect on next startup)");
                            var2_3 = true;
                        }
                        catch (Exception e) {
                            ExtensionSwitcher.access$getLOG$p(this.this$0).info("Failed to switch extension: " + e.getMessage(), (Throwable)e);
                            var2_3 = false;
                        }
                        return Boxing.boxBoolean((boolean)(var2_3 != false));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object updateExtensionManager(String extensionId, boolean forceRestart, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, extensionId, forceRestart, null){
            int label;
            final /* synthetic */ ExtensionSwitcher this$0;
            final /* synthetic */ String $extensionId;
            final /* synthetic */ boolean $forceRestart;
            {
                this.this$0 = $receiver;
                this.$extensionId = $extensionId;
                this.$forceRestart = $forceRestart;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(ExtensionSwitcher.access$getProject$p(this.this$0));
                        boolean success = extensionManager.setCurrentProvider(this.$extensionId, Boxing.boxBoolean((boolean)this.$forceRestart));
                        if (!success) {
                            throw new IllegalStateException("Failed to set extension provider: " + this.$extensionId);
                        }
                        ExtensionSwitcher.access$getLOG$p(this.this$0).info("Extension manager updated with new provider: " + this.$extensionId + " (configuration saved)");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object updateButtonConfiguration(String extensionId, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, extensionId, null){
            int label;
            final /* synthetic */ ExtensionSwitcher this$0;
            final /* synthetic */ String $extensionId;
            {
                this.this$0 = $receiver;
                this.$extensionId = $extensionId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            DynamicButtonManager buttonManager = DynamicButtonManager.Companion.getInstance(ExtensionSwitcher.access$getProject$p(this.this$0));
                            buttonManager.setCurrentExtension(this.$extensionId);
                            ExtensionSwitcher.access$getLOG$p(this.this$0).info("Button configuration updated for extension: " + this.$extensionId);
                        }
                        catch (Exception e) {
                            ExtensionSwitcher.access$getLOG$p(this.this$0).warn("Failed to update button configuration", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object notifyExtensionChanged(String extensionId, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, extensionId, null){
            int label;
            final /* synthetic */ ExtensionSwitcher this$0;
            final /* synthetic */ String $extensionId;
            {
                this.this$0 = $receiver;
                this.$extensionId = $extensionId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            WebViewManager webViewManager = (WebViewManager)ExtensionSwitcher.access$getProject$p(this.this$0).getService(WebViewManager.class);
                            if (webViewManager != null) {
                                ExtensionSwitcher.access$getLOG$p(this.this$0).debug("WebViewManager is available but extension change notification not implemented yet");
                            }
                        }
                        catch (Exception e) {
                            ExtensionSwitcher.access$getLOG$p(this.this$0).debug("WebViewManager not available: " + e.getMessage());
                        }
                        ((ExtensionChangeListener)ExtensionSwitcher.access$getProject$p(this.this$0).getMessageBus().syncPublisher(ExtensionChangeListener.Companion.getEXTENSION_CHANGE_TOPIC())).onExtensionChanged(this.$extensionId);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isSwitching() {
        return this.isSwitching;
    }

    @Nullable
    public final CompletableFuture<Boolean> waitForSwitching() {
        return this.switchingFuture;
    }

    public final void cancelSwitching() {
        if (this.isSwitching) {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.switchingScope, (String)"Extension switching cancelled", null, (int)2, null);
            this.isSwitching = false;
            CompletableFuture<Boolean> completableFuture = this.switchingFuture;
            if (completableFuture != null) {
                completableFuture.cancel(true);
            }
            this.LOG.info("Extension switching cancelled");
        }
    }

    public final void dispose() {
        block0: {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.switchingScope, null, (int)1, null);
            CompletableFuture<Boolean> completableFuture = this.switchingFuture;
            if (completableFuture == null) break block0;
            completableFuture.cancel(true);
        }
    }

    public static final /* synthetic */ Object access$performExtensionSwitch(ExtensionSwitcher $this, String extensionId, boolean forceRestart, Continuation $completion) {
        return $this.performExtensionSwitch(extensionId, forceRestart, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ CompletableFuture access$getSwitchingFuture$p(ExtensionSwitcher $this) {
        return $this.switchingFuture;
    }

    public static final /* synthetic */ Logger access$getLOG$p(ExtensionSwitcher $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ void access$setSwitching$p(ExtensionSwitcher $this, boolean bl) {
        $this.isSwitching = bl;
    }

    public static final /* synthetic */ Object access$updateExtensionManager(ExtensionSwitcher $this, String extensionId, boolean forceRestart, Continuation $completion) {
        return $this.updateExtensionManager(extensionId, forceRestart, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateButtonConfiguration(ExtensionSwitcher $this, String extensionId, Continuation $completion) {
        return $this.updateButtonConfiguration(extensionId, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$notifyExtensionChanged(ExtensionSwitcher $this, String extensionId, Continuation $completion) {
        return $this.notifyExtensionChanged(extensionId, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(ExtensionSwitcher $this) {
        return $this.project;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionSwitcher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/core/ExtensionSwitcher;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionSwitcher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionSwitcher extensionSwitcher = (ExtensionSwitcher)project.getService(ExtensionSwitcher.class);
            if (extensionSwitcher == null) {
                throw new IllegalStateException("ExtensionSwitcher not found".toString());
            }
            return extensionSwitcher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

