/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.core;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.util.ConfigFileUtils;
import com.sina.weibo.agent.util.PluginConstants;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0007\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\r\u0010\u0017\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u000eJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dJ\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0012\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0016J\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010&\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000eJ\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(2\u0006\u0010 \u001a\u00020\u000eJ\"\u0010)\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000e2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(J\u001e\u0010+\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(0(J\u0006\u0010,\u001a\u00020\u0016J\u0006\u0010-\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "currentExtensionId", "", "isConfigurationValid", "", "isConfigurationLoaded", "configurationLoadTime", "", "Ljava/lang/Long;", "initialize", "", "getConfigurationLoadTime", "()Ljava/lang/Long;", "getConfigurationError", "getConfigurationStatus", "getDebugInfo", "getRecoverySuggestions", "", "loadConfiguration", "validateConfiguration", "extensionId", "saveConfiguration", "reloadConfiguration", "checkConfigurationChange", "getConfigurationFilePath", "getCurrentExtensionId", "setCurrentExtensionId", "getExtensionConfiguration", "", "setExtensionConfiguration", "config", "getAllExtensionConfigurations", "createDefaultConfiguration", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionConfigurationManager.kt\ncom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,368:1\n1869#2,2:369\n1285#2,2:372\n1299#2,4:374\n1869#2,2:380\n1#3:371\n216#4,2:378\n*S KotlinDebug\n*F\n+ 1 ExtensionConfigurationManager.kt\ncom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager\n*L\n132#1:369,2\n296#1:372,2\n296#1:374,4\n331#1:380,2\n312#1:378,2\n*E\n"})
public final class ExtensionConfigurationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @Nullable
    private volatile String currentExtensionId;
    private volatile boolean isConfigurationValid;
    private volatile boolean isConfigurationLoaded;
    @Nullable
    private Long configurationLoadTime;

    public ExtensionConfigurationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(ExtensionConfigurationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final File getConfigFile() {
        return new File(PluginConstants.ConfigFiles.INSTANCE.getMainConfigPath());
    }

    public final void initialize() {
        this.logger.info("Initializing extension configuration manager");
        this.loadConfiguration();
    }

    public final boolean isConfigurationValid() {
        return this.isConfigurationValid;
    }

    public final boolean isConfigurationLoaded() {
        return this.isConfigurationLoaded;
    }

    @Nullable
    public final Long getConfigurationLoadTime() {
        return this.configurationLoadTime;
    }

    @Nullable
    public final String getConfigurationError() {
        Object object;
        if (this.isConfigurationLoaded && !this.isConfigurationValid) {
            String extensionId = this.currentExtensionId;
            object = extensionId == null ? "No extension type configured. Please set 'extension.type' in .vscode-agent file" : (StringsKt.isBlank((CharSequence)extensionId) ? "Extension type is empty. Please set a valid value for 'extension.type' in .vscode-agent file" : "Invalid extension type: '" + extensionId + "'. Please check the value of 'extension.type' in .vscode-agent file");
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final String getConfigurationStatus() {
        StringBuilder stringBuilder;
        StringBuilder $this$getConfigurationStatus_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getConfigurationStatus_u24lambda_u240.append("Configuration Status: ");
        if (this.isConfigurationLoaded) {
            if (this.isConfigurationValid) {
                String extensionId = this.currentExtensionId;
                v0 = $this$getConfigurationStatus_u24lambda_u240.append("VALID (" + extensionId + ")");
            } else {
                v0 = $this$getConfigurationStatus_u24lambda_u240.append("INVALID - " + this.getConfigurationError());
            }
        } else {
            v0 = $this$getConfigurationStatus_u24lambda_u240.append("LOADING");
        }
        $this$getConfigurationStatus_u24lambda_u240.append(" | File: " + this.getConfigurationFilePath());
        return stringBuilder.toString();
    }

    @NotNull
    public final String getDebugInfo() {
        StringBuilder stringBuilder;
        StringBuilder $this$getDebugInfo_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDebugInfo_u24lambda_u242.append("=== Configuration Debug Info ===\n");
        $this$getDebugInfo_u24lambda_u242.append("Configuration loaded: " + this.isConfigurationLoaded + "\n");
        $this$getDebugInfo_u24lambda_u242.append("Configuration valid: " + this.isConfigurationValid + "\n");
        $this$getDebugInfo_u24lambda_u242.append("Current extension ID: " + this.currentExtensionId + "\n");
        $this$getDebugInfo_u24lambda_u242.append("Config file path: " + this.getConfigurationFilePath() + "\n");
        $this$getDebugInfo_u24lambda_u242.append("Config file exists: " + this.getConfigFile().exists() + "\n");
        if (this.getConfigFile().exists()) {
            $this$getDebugInfo_u24lambda_u242.append("Config file size: " + this.getConfigFile().length() + " bytes\n");
            $this$getDebugInfo_u24lambda_u242.append("Config file last modified: " + new Date(this.getConfigFile().lastModified()) + "\n");
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(this.getConfigFile()));
                $this$getDebugInfo_u24lambda_u242.append("Config file content:\n");
                Set<String> set2 = properties.stringPropertyNames();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"stringPropertyNames(...)");
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String key = (String)element$iv;
                    boolean bl2 = false;
                    $this$getDebugInfo_u24lambda_u242.append("  " + key + " = " + properties.getProperty(key) + "\n");
                }
            }
            catch (Exception e) {
                $this$getDebugInfo_u24lambda_u242.append("Failed to read config file: " + e.getMessage() + "\n");
            }
        }
        $this$getDebugInfo_u24lambda_u242.append("Project base path: " + this.project.getBasePath() + "\n");
        $this$getDebugInfo_u24lambda_u242.append("================================");
        return stringBuilder.toString();
    }

    @NotNull
    public final List<String> getRecoverySuggestions() {
        List list;
        if (this.isConfigurationLoaded && !this.isConfigurationValid) {
            Object[] objectArray = new String[]{"1. Check if .vscode-agent file exists in project root", "2. Ensure 'extension.type' property is set to a valid extension ID", "3. Valid extension types: roo-code, cline, custom", "4. Try running 'createDefaultConfiguration()' to generate a template", "5. Check file permissions and ensure the file is readable"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void loadConfiguration() {
        try {
            this.isConfigurationLoaded = false;
            this.isConfigurationValid = false;
            this.configurationLoadTime = System.currentTimeMillis();
            if (ConfigFileUtils.INSTANCE.mainConfigExists()) {
                Properties properties = ConfigFileUtils.INSTANCE.loadMainConfig();
                this.currentExtensionId = properties.getProperty("extension.type");
                this.isConfigurationValid = this.validateConfiguration(this.currentExtensionId);
                if (this.isConfigurationValid) {
                    this.logger.info("Loaded valid configuration: current extension = " + this.currentExtensionId);
                } else {
                    this.logger.warn("Configuration loaded but invalid: extension type is null or empty");
                }
            } else {
                this.logger.warn("No configuration file found at: " + this.getConfigFile().getAbsolutePath());
                this.currentExtensionId = null;
                this.isConfigurationValid = false;
            }
            this.isConfigurationLoaded = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to load configuration", (Throwable)e);
            this.currentExtensionId = null;
            this.isConfigurationValid = false;
            this.isConfigurationLoaded = true;
        }
    }

    private final boolean validateConfiguration(String extensionId) {
        CharSequence charSequence = extensionId;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private final void saveConfiguration() {
        try {
            Properties properties = new Properties();
            String string = this.currentExtensionId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                properties.setProperty("extension.type", it);
            }
            this.logger.info("Saving configuration to file: " + this.getConfigFile().getAbsolutePath());
            this.logger.info("Configuration content: extension.type=" + this.currentExtensionId);
            ConfigFileUtils.saveMainConfig$default(ConfigFileUtils.INSTANCE, properties, null, 2, null);
            if (this.getConfigFile().exists()) {
                Properties savedProperties = new Properties();
                savedProperties.load(new FileInputStream(this.getConfigFile()));
                String savedExtensionId = savedProperties.getProperty("extension.type");
                this.logger.info("Configuration saved successfully. File content: extension.type=" + savedExtensionId);
            } else {
                this.logger.error("Configuration file was not created after save operation");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to save configuration", (Throwable)e);
            throw e;
        }
    }

    public final void reloadConfiguration() {
        this.logger.info("Reloading configuration");
        this.loadConfiguration();
    }

    public final void checkConfigurationChange() {
        try {
            long lastModified;
            if (this.getConfigFile().exists() && (lastModified = this.getConfigFile().lastModified()) > System.currentTimeMillis() - (long)5000) {
                this.logger.info("Configuration file changed, reloading...");
                this.reloadConfiguration();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error checking configuration change", (Throwable)e);
        }
    }

    @NotNull
    public final String getConfigurationFilePath() {
        String string = this.getConfigFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Nullable
    public final String getCurrentExtensionId() {
        return this.currentExtensionId;
    }

    public final void setCurrentExtensionId(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        this.logger.info("Setting current extension ID to: " + extensionId);
        this.currentExtensionId = extensionId;
        this.saveConfiguration();
        this.reloadConfiguration();
        this.logger.info("Extension ID set and configuration reloaded: " + extensionId + ", valid: " + this.isConfigurationValid);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getExtensionConfiguration(@NotNull String extensionId) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map2;
            if (ConfigFileUtils.INSTANCE.extensionConfigExists(extensionId)) {
                Properties properties = ConfigFileUtils.INSTANCE.loadExtensionConfig(extensionId);
                Set<String> set2 = properties.stringPropertyNames();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"stringPropertyNames(...)");
                Iterable $this$associateWith$iv = set2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void it;
                    String string = (String)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl = false;
                    String string2 = properties.getProperty((String)it);
                    map3.put(t, string2);
                }
                map2 = result$iv;
            } else {
                map2 = MapsKt.emptyMap();
            }
            map = map2;
        }
        catch (Exception e) {
            this.logger.warn("Failed to load extension configuration for: " + extensionId, (Throwable)e);
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public final void setExtensionConfiguration(@NotNull String extensionId, @NotNull Map<String, String> config2) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        try {
            Properties properties = new Properties();
            Map<String, String> $this$forEach$iv = config2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                properties.setProperty(key, value);
            }
            ConfigFileUtils.saveExtensionConfig$default(ConfigFileUtils.INSTANCE, extensionId, properties, null, 4, null);
            this.logger.info("Configuration saved for extension: " + extensionId);
        }
        catch (Exception e) {
            this.logger.warn("Failed to save extension configuration for: " + extensionId, (Throwable)e);
        }
    }

    @NotNull
    public final Map<String, Map<String, String>> getAllExtensionConfigurations() {
        Map configs = new LinkedHashMap();
        try {
            List<String> extensionIds = ConfigFileUtils.INSTANCE.listExtensionConfigFiles();
            Iterable $this$forEach$iv = extensionIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String extensionId = (String)element$iv;
                boolean bl = false;
                Map<String, String> config2 = this.getExtensionConfiguration(extensionId);
                if (!(!config2.isEmpty())) continue;
                configs.put(extensionId, config2);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get all extension configurations", (Throwable)e);
        }
        return configs;
    }

    public final void createDefaultConfiguration() {
        try {
            if (!ConfigFileUtils.INSTANCE.mainConfigExists()) {
                ConfigFileUtils.INSTANCE.createDefaultMainConfig();
                this.logger.info("Created default configuration file at: " + this.getConfigFile().getAbsolutePath());
                this.reloadConfiguration();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create default configuration", (Throwable)e);
        }
    }

    public final void dispose() {
        this.logger.info("Disposing extension configuration manager");
        this.saveConfiguration();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionConfigurationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionConfigurationManager extensionConfigurationManager = (ExtensionConfigurationManager)project.getService(ExtensionConfigurationManager.class);
            if (extensionConfigurationManager == null) {
                throw new IllegalStateException("ExtensionConfigurationManager not found".toString());
            }
            return extensionConfigurationManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

