/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.config;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.common.ExtensionType;
import com.sina.weibo.agent.extensions.config.ExtensionConfig;
import com.sina.weibo.agent.util.ConfigFileUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/sina/weibo/agent/extensions/config/ExtensionConfiguration;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentExtensionType", "Lcom/sina/weibo/agent/extensions/common/ExtensionType;", "extensionConfigs", "", "Lcom/sina/weibo/agent/extensions/config/ExtensionConfig;", "initialize", "", "getCurrentExtensionType", "setCurrentExtensionType", "extensionType", "getCurrentConfig", "getConfig", "loadConfiguration", "getConfiguredExtensionType", "saveCurrentExtensionType", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionConfiguration.kt\ncom/sina/weibo/agent/extensions/config/ExtensionConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1869#2,2:188\n*S KotlinDebug\n*F\n+ 1 ExtensionConfiguration.kt\ncom/sina/weibo/agent/extensions/config/ExtensionConfiguration\n*L\n48#1:188,2\n*E\n"})
public final class ExtensionConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger LOG;
    @NotNull
    private volatile ExtensionType currentExtensionType;
    @NotNull
    private final Map<ExtensionType, ExtensionConfig> extensionConfigs;

    public ExtensionConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(ExtensionConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.currentExtensionType = ExtensionType.Companion.getDefault();
        this.extensionConfigs = new LinkedHashMap();
    }

    public final void initialize() {
        this.LOG.info("Initializing extension configuration");
        Iterable $this$forEach$iv = ExtensionType.Companion.getAllTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionType extensionType = (ExtensionType)((Object)element$iv);
            boolean bl = false;
            this.loadConfiguration(extensionType);
        }
        ExtensionType configuredType = this.getConfiguredExtensionType();
        ExtensionType extensionType = configuredType;
        if (extensionType == null) {
            extensionType = ExtensionType.Companion.getDefault();
        }
        this.currentExtensionType = extensionType;
        this.LOG.info("Extension configuration initialized, current type: " + this.currentExtensionType.getCode());
    }

    @NotNull
    public final ExtensionType getCurrentExtensionType() {
        return this.currentExtensionType;
    }

    public final void setCurrentExtensionType(@NotNull ExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        this.LOG.info("Switching extension type from " + this.currentExtensionType.getCode() + " to " + extensionType.getCode());
        this.currentExtensionType = extensionType;
        this.saveCurrentExtensionType();
    }

    @NotNull
    public final ExtensionConfig getCurrentConfig() {
        return this.getConfig(this.currentExtensionType);
    }

    @NotNull
    public final ExtensionConfig getConfig(@NotNull ExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        ExtensionConfig extensionConfig = this.extensionConfigs.get((Object)extensionType);
        if (extensionConfig == null) {
            extensionConfig = ExtensionConfig.Companion.getDefault(extensionType);
        }
        return extensionConfig;
    }

    private final void loadConfiguration(ExtensionType extensionType) {
        try {
            ExtensionConfig config2 = ExtensionConfig.Companion.loadFromProperties(extensionType);
            this.extensionConfigs.put(extensionType, config2);
            this.LOG.info("Loaded configuration for " + extensionType.getCode());
        }
        catch (Exception e) {
            this.LOG.warn("Failed to load configuration for " + extensionType.getCode() + ", using default", (Throwable)e);
            this.extensionConfigs.put(extensionType, ExtensionConfig.Companion.getDefault(extensionType));
        }
    }

    private final ExtensionType getConfiguredExtensionType() {
        ExtensionType extensionType;
        try {
            Properties properties = ConfigFileUtils.INSTANCE.loadMainConfig();
            String typeCode = properties.getProperty("extension.type");
            extensionType = typeCode != null ? ExtensionType.Companion.fromCode(typeCode) : null;
        }
        catch (Exception e) {
            this.LOG.warn("Failed to read extension type configuration", (Throwable)e);
            extensionType = null;
        }
        return extensionType;
    }

    private final void saveCurrentExtensionType() {
        try {
            Properties properties = new Properties();
            properties.setProperty("extension.type", this.currentExtensionType.getCode());
            ConfigFileUtils.INSTANCE.saveMainConfig(properties, "VSCode Agent Configuration");
            this.LOG.info("Saved extension type configuration: " + this.currentExtensionType.getCode());
        }
        catch (Exception e) {
            this.LOG.info("Failed to save extension type configuration", (Throwable)e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/config/ExtensionConfiguration$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/config/ExtensionConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionConfiguration getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionConfiguration extensionConfiguration = (ExtensionConfiguration)project.getService(ExtensionConfiguration.class);
            if (extensionConfiguration == null) {
                throw new IllegalStateException("ExtensionConfiguration not found".toString());
            }
            return extensionConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

