/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.editor;

import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.editor.DocumentsAndEditorsDelta;
import com.sina.weibo.agent.editor.EditorPropertiesChangeData;
import com.sina.weibo.agent.editor.ModelChangedEvent;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostDocumentsAndEditorsProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostDocumentsProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostEditorsProxy;
import com.sina.weibo.agent.util.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fJ\u001a\u0010\"\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/sina/weibo/agent/editor/EditorStateService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "extHostDocumentsAndEditorsProxy", "Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsAndEditorsProxy;", "getExtHostDocumentsAndEditorsProxy", "()Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsAndEditorsProxy;", "setExtHostDocumentsAndEditorsProxy", "(Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsAndEditorsProxy;)V", "extHostEditorsProxy", "Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostEditorsProxy;", "getExtHostEditorsProxy", "()Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostEditorsProxy;", "setExtHostEditorsProxy", "(Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostEditorsProxy;)V", "extHostDocumentsProxy", "Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsProxy;", "getExtHostDocumentsProxy", "()Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsProxy;", "setExtHostDocumentsProxy", "(Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostDocumentsProxy;)V", "acceptDocumentsAndEditorsDelta", "", "detail", "Lcom/sina/weibo/agent/editor/DocumentsAndEditorsDelta;", "acceptEditorPropertiesChanged", "", "", "Lcom/sina/weibo/agent/editor/EditorPropertiesChangeData;", "acceptModelChanged", "Lcom/sina/weibo/agent/util/URI;", "Lcom/sina/weibo/agent/editor/ModelChangedEvent;", "coderider-kilo-jetbrains"})
public final class EditorStateService {
    @NotNull
    private final Project project;
    @Nullable
    private ExtHostDocumentsAndEditorsProxy extHostDocumentsAndEditorsProxy;
    @Nullable
    private ExtHostEditorsProxy extHostEditorsProxy;
    @Nullable
    private ExtHostDocumentsProxy extHostDocumentsProxy;

    public EditorStateService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final ExtHostDocumentsAndEditorsProxy getExtHostDocumentsAndEditorsProxy() {
        return this.extHostDocumentsAndEditorsProxy;
    }

    public final void setExtHostDocumentsAndEditorsProxy(@Nullable ExtHostDocumentsAndEditorsProxy extHostDocumentsAndEditorsProxy) {
        this.extHostDocumentsAndEditorsProxy = extHostDocumentsAndEditorsProxy;
    }

    @Nullable
    public final ExtHostEditorsProxy getExtHostEditorsProxy() {
        return this.extHostEditorsProxy;
    }

    public final void setExtHostEditorsProxy(@Nullable ExtHostEditorsProxy extHostEditorsProxy) {
        this.extHostEditorsProxy = extHostEditorsProxy;
    }

    @Nullable
    public final ExtHostDocumentsProxy getExtHostDocumentsProxy() {
        return this.extHostDocumentsProxy;
    }

    public final void setExtHostDocumentsProxy(@Nullable ExtHostDocumentsProxy extHostDocumentsProxy) {
        this.extHostDocumentsProxy = extHostDocumentsProxy;
    }

    public final void acceptDocumentsAndEditorsDelta(@NotNull DocumentsAndEditorsDelta detail) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
            IRPCProtocol protocol = PluginContext.Companion.getInstance(this.project).getRPCProtocol();
            if (this.extHostDocumentsAndEditorsProxy == null) {
                IRPCProtocol iRPCProtocol = protocol;
                this.extHostDocumentsAndEditorsProxy = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostDocumentsAndEditors()) : null;
            }
            ExtHostDocumentsAndEditorsProxy extHostDocumentsAndEditorsProxy = this.extHostDocumentsAndEditorsProxy;
            if (extHostDocumentsAndEditorsProxy == null) break block1;
            extHostDocumentsAndEditorsProxy.acceptDocumentsAndEditorsDelta(detail);
        }
    }

    public final void acceptEditorPropertiesChanged(@NotNull Map<String, EditorPropertiesChangeData> detail) {
        block2: {
            Intrinsics.checkNotNullParameter(detail, (String)"detail");
            IRPCProtocol protocol = PluginContext.Companion.getInstance(this.project).getRPCProtocol();
            if (this.extHostEditorsProxy == null) {
                IRPCProtocol iRPCProtocol = protocol;
                this.extHostEditorsProxy = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostEditors()) : null;
            }
            ExtHostEditorsProxy extHostEditorsProxy = this.extHostEditorsProxy;
            if (extHostEditorsProxy == null) break block2;
            ExtHostEditorsProxy it = extHostEditorsProxy;
            boolean bl = false;
            for (Map.Entry<String, EditorPropertiesChangeData> entry : detail.entrySet()) {
                String id = entry.getKey();
                EditorPropertiesChangeData data = entry.getValue();
                it.acceptEditorPropertiesChanged(id, data);
            }
        }
    }

    public final void acceptModelChanged(@NotNull Map<URI, ModelChangedEvent> detail) {
        block2: {
            Intrinsics.checkNotNullParameter(detail, (String)"detail");
            IRPCProtocol protocol = PluginContext.Companion.getInstance(this.project).getRPCProtocol();
            if (this.extHostDocumentsProxy == null) {
                IRPCProtocol iRPCProtocol = protocol;
                this.extHostDocumentsProxy = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostDocuments()) : null;
            }
            ExtHostDocumentsProxy extHostDocumentsProxy = this.extHostDocumentsProxy;
            if (extHostDocumentsProxy == null) break block2;
            ExtHostDocumentsProxy it = extHostDocumentsProxy;
            boolean bl = false;
            for (Map.Entry<URI, ModelChangedEvent> entry : detail.entrySet()) {
                URI uri = entry.getKey();
                ModelChangedEvent data = entry.getValue();
                it.acceptModelChanged(uri, data, data.isDirty());
            }
        }
    }
}

