/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016J\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0016\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0002J$\u0010\u001c\u001a\u00020\u00132\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\bJ\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/sina/weibo/agent/core/JtbLoginSync;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ENV_TYPE", "", "ENV_GITLAB_HOST", "ENV_CODERIDER_HOST", "ENV_PAT", "ENV_SAVE_PAT", "ENV_ACCOUNT_JSON", "PROP_PREFIX", "DEFAULT_EXTENSION_ID", "registeredProvider", "Lcom/sina/weibo/agent/core/JtbLoginSync$RegisteredProvider;", "registerPayloadProvider", "", "source", "provider", "Lkotlin/Function0;", "Lcom/sina/weibo/agent/core/JtbLoginSync$Payload;", "clearPayloadProvider", "readPayload", "readPayloadWithSource", "Lkotlin/Pair;", "apply", "env", "", "traceId", "prewriteSecrets", "payload", "prefix", "RegisteredProvider", "Payload", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nJtbLoginSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JtbLoginSync.kt\ncom/sina/weibo/agent/core/JtbLoginSync\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class JtbLoginSync {
    @NotNull
    public static final JtbLoginSync INSTANCE = new JtbLoginSync();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String ENV_TYPE = "CR_SYNCLOGIN_TYPE";
    @NotNull
    private static final String ENV_GITLAB_HOST = "CR_SYNCLOGIN_GITLAB_HOST";
    @NotNull
    private static final String ENV_CODERIDER_HOST = "CR_SYNCLOGIN_CODERIDER_HOST";
    @NotNull
    private static final String ENV_PAT = "CR_SYNCLOGIN_PAT";
    @NotNull
    private static final String ENV_SAVE_PAT = "CR_SYNCLOGIN_SAVE_PAT";
    @NotNull
    private static final String ENV_ACCOUNT_JSON = "CR_SYNCLOGIN_ACCOUNT_JSON";
    @NotNull
    private static final String PROP_PREFIX = "runvsagent.synclogin.";
    @NotNull
    private static final String DEFAULT_EXTENSION_ID = "jihu-gitlab.coderider-kilo";
    @Nullable
    private static volatile RegisteredProvider registeredProvider;

    private JtbLoginSync() {
    }

    public final void registerPayloadProvider(@NotNull String source, @NotNull Function0<Payload> provider) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        registeredProvider = new RegisteredProvider(source, provider);
        logger.info("[Perf] Registered JTB sync-login payload provider from " + source);
    }

    public final void clearPayloadProvider() {
        registeredProvider = null;
    }

    @Nullable
    public final Payload readPayload() {
        Pair<Payload, String> pair = this.readPayloadWithSource();
        return pair != null ? (Payload)pair.getFirst() : null;
    }

    private final Pair<Payload, String> readPayloadWithSource() {
        String string = System.getenv(ENV_TYPE);
        String envType = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        String string2 = System.getenv(ENV_GITLAB_HOST);
        String envGitlabHost = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        String string3 = System.getenv(ENV_CODERIDER_HOST);
        String envCoderiderHost = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
        String string4 = System.getenv(ENV_PAT);
        String envPat = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
        String string5 = System.getenv(ENV_SAVE_PAT);
        String envSavePat = string5 != null ? ((Object)StringsKt.trim((CharSequence)string5)).toString() : null;
        String envAccountJson = System.getenv(ENV_ACCOUNT_JSON);
        String string6 = System.getenv("CR_SYNCLOGIN_TYPE_EXTENSION_ID");
        String envExtensionId = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
        CharSequence charSequence = envType;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.equals((String)envType, (String)"pat", (boolean)true) || (charSequence = (CharSequence)envGitlabHost) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)envCoderiderHost) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)envPat) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            boolean bl = StringsKt.equals((String)envSavePat, (String)"true", (boolean)true);
            String string7 = envExtensionId;
            if (string7 == null) {
                string7 = DEFAULT_EXTENSION_ID;
            }
            return TuplesKt.to((Object)new Payload("pat", envGitlabHost, envCoderiderHost, envPat, bl, envAccountJson, string7), (Object)"env");
        }
        String string8 = System.getProperty("runvsagent.synclogin.type");
        String propType = string8 != null ? ((Object)StringsKt.trim((CharSequence)string8)).toString() : null;
        String string9 = System.getProperty("runvsagent.synclogin.gitlabHost");
        String propGitlabHost = string9 != null ? ((Object)StringsKt.trim((CharSequence)string9)).toString() : null;
        String string10 = System.getProperty("runvsagent.synclogin.coderiderHost");
        String propCoderiderHost = string10 != null ? ((Object)StringsKt.trim((CharSequence)string10)).toString() : null;
        String string11 = System.getProperty("runvsagent.synclogin.pat");
        String propPat = string11 != null ? ((Object)StringsKt.trim((CharSequence)string11)).toString() : null;
        String string12 = System.getProperty("runvsagent.synclogin.savePat");
        String propSavePat = string12 != null ? ((Object)StringsKt.trim((CharSequence)string12)).toString() : null;
        String propAccountJson = System.getProperty("runvsagent.synclogin.accountJson");
        String string13 = System.getProperty("runvsagent.synclogin.extensionId");
        String propExtensionId = string13 != null ? ((Object)StringsKt.trim((CharSequence)string13)).toString() : null;
        CharSequence charSequence2 = propType;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) || !StringsKt.equals((String)propType, (String)"pat", (boolean)true) || (charSequence2 = (CharSequence)propGitlabHost) == null || StringsKt.isBlank((CharSequence)charSequence2) || (charSequence2 = (CharSequence)propCoderiderHost) == null || StringsKt.isBlank((CharSequence)charSequence2) || (charSequence2 = (CharSequence)propPat) == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            boolean bl = StringsKt.equals((String)propSavePat, (String)"true", (boolean)true);
            String string14 = propExtensionId;
            if (string14 == null) {
                string14 = DEFAULT_EXTENSION_ID;
            }
            return TuplesKt.to((Object)new Payload("pat", propGitlabHost, propCoderiderHost, propPat, bl, propAccountJson, string14), (Object)"sysprop");
        }
        RegisteredProvider provider = registeredProvider;
        if (provider != null) {
            Pair pair;
            try {
                Pair pair2;
                Payload payload = (Payload)provider.getProvider().invoke();
                if (payload != null) {
                    Payload it = payload;
                    boolean bl = false;
                    pair2 = TuplesKt.to((Object)it, (Object)provider.getSource());
                } else {
                    pair2 = null;
                }
                pair = pair2;
            }
            catch (Throwable e) {
                logger.debug("Failed to read sync-login from registered provider(" + provider.getSource() + "): " + e.getMessage(), e);
                pair = null;
            }
            return pair;
        }
        return null;
    }

    public final void apply(@NotNull Map<String, String> env, @Nullable String traceId) {
        Object object;
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter(env, (String)"env");
                object = traceId;
                if (object == null) break block15;
                String it = object;
                boolean bl = false;
                String string = "[Perf][traceId=" + it + "]";
                object = string;
                if (string != null) break block16;
            }
            object = "[Perf]";
        }
        String prefix = object;
        Pair<Payload, String> pair = this.readPayloadWithSource();
        if (pair == null) {
            return;
        }
        Pair<Payload, String> pair2 = pair;
        Payload payload = (Payload)pair2.component1();
        String source = (String)pair2.component2();
        logger.info(prefix + " Using JTB sync-login payload from " + source);
        if (!env.containsKey(ENV_TYPE)) {
            env.put(ENV_TYPE, payload.getType());
        }
        if (!env.containsKey(ENV_GITLAB_HOST)) {
            env.put(ENV_GITLAB_HOST, payload.getGitlabHost());
        }
        if (!env.containsKey(ENV_CODERIDER_HOST)) {
            env.put(ENV_CODERIDER_HOST, payload.getCoderiderHost());
        }
        if (!env.containsKey(ENV_PAT)) {
            env.put(ENV_PAT, payload.getPat());
        }
        if (!env.containsKey(ENV_SAVE_PAT)) {
            env.put(ENV_SAVE_PAT, String.valueOf(payload.getSavePat()));
        }
        String string = payload.getAccountJson();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (!env.containsKey(ENV_ACCOUNT_JSON)) {
                env.put(ENV_ACCOUNT_JSON, it);
            }
        }
        logger.info(prefix + " Applied JTB sync-login env (type=" + payload.getType() + ", gitlabHost=" + payload.getGitlabHost() + ", coderiderHost=" + payload.getCoderiderHost() + ", savePat=" + payload.getSavePat() + ")");
        try {
            this.prewriteSecrets(payload, prefix);
        }
        catch (Exception e) {
            logger.warn(prefix + " Failed to prewrite JTB secrets: " + e.getMessage(), (Throwable)e);
        }
    }

    private final void prewriteSecrets(Payload payload, String prefix) {
        JsonObject extObj;
        Object it;
        JsonObject jsonObject2;
        String homeDir = System.getProperty("user.home");
        File secretsDir = new File(homeDir, ".coderider-kilo-agent");
        if (!secretsDir.exists()) {
            secretsDir.mkdirs();
        }
        File secretsFile = new File(secretsDir, "secrets.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            jsonObject2 = secretsFile.exists() && !StringsKt.isBlank((CharSequence)FilesKt.readText$default((File)secretsFile, null, (int)1, null)) ? JsonParser.parseString((String)FilesKt.readText$default((File)secretsFile, null, (int)1, null)).getAsJsonObject() : new JsonObject();
            Intrinsics.checkNotNull((Object)jsonObject2);
        }
        catch (Exception exception) {
            jsonObject2 = new JsonObject();
        }
        JsonObject jsonObject3 = jsonObject2;
        String extId = payload.getExtensionId();
        JsonObject jsonObject4 = jsonObject3.getAsJsonObject(extId);
        if (jsonObject4 == null) {
            JsonObject jsonObject5;
            it = jsonObject5 = new JsonObject();
            boolean bl = false;
            jsonObject3.add(extId, (JsonElement)it);
            jsonObject4 = extObj = jsonObject5;
        }
        if (payload.getSavePat()) {
            extObj.addProperty("coderider-kilo.gitlab.pat", payload.getPat());
        }
        String string = payload.getAccountJson();
        if (string != null) {
            it = string;
            boolean bl = false;
            extObj.addProperty("coderider-kilo.account", (String)it);
        }
        String string2 = gson.toJson((JsonElement)jsonObject3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        FilesKt.writeText$default((File)secretsFile, (String)string2, null, (int)2, null);
        logger.info(prefix + " Prewrote JTB secrets for " + extId + " (pat=" + payload.getSavePat() + ", accountJson=" + (payload.getAccountJson() != null) + ")");
    }

    static {
        Logger logger = Logger.getInstance(JtbLoginSync.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        JtbLoginSync.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003JQ\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/sina/weibo/agent/core/JtbLoginSync$Payload;", "", "type", "", "gitlabHost", "coderiderHost", "pat", "savePat", "", "accountJson", "extensionId", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getGitlabHost", "getCoderiderHost", "getPat", "getSavePat", "()Z", "getAccountJson", "getExtensionId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class Payload {
        @NotNull
        private final String type;
        @NotNull
        private final String gitlabHost;
        @NotNull
        private final String coderiderHost;
        @NotNull
        private final String pat;
        private final boolean savePat;
        @Nullable
        private final String accountJson;
        @NotNull
        private final String extensionId;

        public Payload(@NotNull String type2, @NotNull String gitlabHost, @NotNull String coderiderHost, @NotNull String pat, boolean savePat, @Nullable String accountJson, @NotNull String extensionId) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)gitlabHost, (String)"gitlabHost");
            Intrinsics.checkNotNullParameter((Object)coderiderHost, (String)"coderiderHost");
            Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
            Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
            this.type = type2;
            this.gitlabHost = gitlabHost;
            this.coderiderHost = coderiderHost;
            this.pat = pat;
            this.savePat = savePat;
            this.accountJson = accountJson;
            this.extensionId = extensionId;
        }

        public /* synthetic */ Payload(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                string6 = JtbLoginSync.DEFAULT_EXTENSION_ID;
            }
            this(string, string2, string3, string4, bl, string5, string6);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getGitlabHost() {
            return this.gitlabHost;
        }

        @NotNull
        public final String getCoderiderHost() {
            return this.coderiderHost;
        }

        @NotNull
        public final String getPat() {
            return this.pat;
        }

        public final boolean getSavePat() {
            return this.savePat;
        }

        @Nullable
        public final String getAccountJson() {
            return this.accountJson;
        }

        @NotNull
        public final String getExtensionId() {
            return this.extensionId;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.gitlabHost;
        }

        @NotNull
        public final String component3() {
            return this.coderiderHost;
        }

        @NotNull
        public final String component4() {
            return this.pat;
        }

        public final boolean component5() {
            return this.savePat;
        }

        @Nullable
        public final String component6() {
            return this.accountJson;
        }

        @NotNull
        public final String component7() {
            return this.extensionId;
        }

        @NotNull
        public final Payload copy(@NotNull String type2, @NotNull String gitlabHost, @NotNull String coderiderHost, @NotNull String pat, boolean savePat, @Nullable String accountJson, @NotNull String extensionId) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)gitlabHost, (String)"gitlabHost");
            Intrinsics.checkNotNullParameter((Object)coderiderHost, (String)"coderiderHost");
            Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
            Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
            return new Payload(type2, gitlabHost, coderiderHost, pat, savePat, accountJson, extensionId);
        }

        public static /* synthetic */ Payload copy$default(Payload payload, String string, String string2, String string3, String string4, boolean bl, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = payload.type;
            }
            if ((n & 2) != 0) {
                string2 = payload.gitlabHost;
            }
            if ((n & 4) != 0) {
                string3 = payload.coderiderHost;
            }
            if ((n & 8) != 0) {
                string4 = payload.pat;
            }
            if ((n & 0x10) != 0) {
                bl = payload.savePat;
            }
            if ((n & 0x20) != 0) {
                string5 = payload.accountJson;
            }
            if ((n & 0x40) != 0) {
                string6 = payload.extensionId;
            }
            return payload.copy(string, string2, string3, string4, bl, string5, string6);
        }

        @NotNull
        public String toString() {
            return "Payload(type=" + this.type + ", gitlabHost=" + this.gitlabHost + ", coderiderHost=" + this.coderiderHost + ", pat=" + this.pat + ", savePat=" + this.savePat + ", accountJson=" + this.accountJson + ", extensionId=" + this.extensionId + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.gitlabHost.hashCode();
            result2 = result2 * 31 + this.coderiderHost.hashCode();
            result2 = result2 * 31 + this.pat.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.savePat);
            result2 = result2 * 31 + (this.accountJson == null ? 0 : this.accountJson.hashCode());
            result2 = result2 * 31 + this.extensionId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Payload)) {
                return false;
            }
            Payload payload = (Payload)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)payload.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gitlabHost, (Object)payload.gitlabHost)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.coderiderHost, (Object)payload.coderiderHost)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pat, (Object)payload.pat)) {
                return false;
            }
            if (this.savePat != payload.savePat) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.accountJson, (Object)payload.accountJson)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extensionId, (Object)payload.extensionId);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J%\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/sina/weibo/agent/core/JtbLoginSync$RegisteredProvider;", "", "source", "", "provider", "Lkotlin/Function0;", "Lcom/sina/weibo/agent/core/JtbLoginSync$Payload;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getSource", "()Ljava/lang/String;", "getProvider", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class RegisteredProvider {
        @NotNull
        private final String source;
        @NotNull
        private final Function0<Payload> provider;

        public RegisteredProvider(@NotNull String source, @NotNull Function0<Payload> provider) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            this.source = source;
            this.provider = provider;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final Function0<Payload> getProvider() {
            return this.provider;
        }

        @NotNull
        public final String component1() {
            return this.source;
        }

        @NotNull
        public final Function0<Payload> component2() {
            return this.provider;
        }

        @NotNull
        public final RegisteredProvider copy(@NotNull String source, @NotNull Function0<Payload> provider) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            return new RegisteredProvider(source, provider);
        }

        public static /* synthetic */ RegisteredProvider copy$default(RegisteredProvider registeredProvider, String string, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                string = registeredProvider.source;
            }
            if ((n & 2) != 0) {
                function0 = registeredProvider.provider;
            }
            return registeredProvider.copy(string, function0);
        }

        @NotNull
        public String toString() {
            return "RegisteredProvider(source=" + this.source + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.source.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegisteredProvider)) {
                return false;
            }
            RegisteredProvider registeredProvider = (RegisteredProvider)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)registeredProvider.source)) {
                return false;
            }
            return Intrinsics.areEqual(this.provider, registeredProvider.provider);
        }
    }
}

