/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.core.ExtensionHostManager;
import com.sina.weibo.agent.core.ISocketServer;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.ipc.proxy.ResponsiveState;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/sina/weibo/agent/core/ExtensionUnixDomainSocketServer;", "Lcom/sina/weibo/agent/core/ISocketServer;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "udsServerChannel", "Ljava/nio/channels/ServerSocketChannel;", "udsSocketPath", "Ljava/nio/file/Path;", "clientManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/channels/SocketChannel;", "Lcom/sina/weibo/agent/core/ExtensionHostManager;", "serverThread", "Ljava/lang/Thread;", "projectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "isRunning", "", "start", "startUds", "stop", "", "dispose", "acceptUdsConnections", "handleClient", "clientChannel", "manager", "createSocketFile", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionUnixDomainSocketServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionUnixDomainSocketServer.kt\ncom/sina/weibo/agent/core/ExtensionUnixDomainSocketServer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n216#2,2:203\n1#3:205\n*S KotlinDebug\n*F\n+ 1 ExtensionUnixDomainSocketServer.kt\ncom/sina/weibo/agent/core/ExtensionUnixDomainSocketServer\n*L\n77#1:203,2\n*E\n"})
public final class ExtensionUnixDomainSocketServer
implements ISocketServer {
    @NotNull
    private final Logger logger;
    @Nullable
    private ServerSocketChannel udsServerChannel;
    @Nullable
    private Path udsSocketPath;
    @NotNull
    private final ConcurrentHashMap<SocketChannel, ExtensionHostManager> clientManagers;
    @Nullable
    private Thread serverThread;
    @NotNull
    private String projectPath;
    public Project project;
    private volatile boolean isRunning;

    public ExtensionUnixDomainSocketServer() {
        Logger logger = Logger.getInstance(ExtensionUnixDomainSocketServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.clientManagers = new ConcurrentHashMap();
        this.projectPath = "";
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Override
    @Nullable
    public String start(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (this.isRunning) {
            this.logger.info("UDS server is already running");
            Path path = this.udsSocketPath;
            return path != null ? ((Object)path).toString() : null;
        }
        this.projectPath = projectPath;
        return this.startUds();
    }

    private final String startUds() {
        try {
            Path sockPath = this.createSocketFile();
            UnixDomainSocketAddress udsAddr = UnixDomainSocketAddress.of(sockPath);
            ServerSocketChannel serverSocketChannel = this.udsServerChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            Intrinsics.checkNotNull((Object)serverSocketChannel);
            serverSocketChannel.bind(udsAddr);
            this.udsSocketPath = sockPath;
            this.isRunning = true;
            this.logger.info("[UDS] Listening on: " + sockPath);
            this.serverThread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"ExtensionUDSSocketServer", (int)0, () -> ExtensionUnixDomainSocketServer.startUds$lambda$0(this), (int)22, null);
            return ((Object)sockPath).toString();
        }
        catch (Exception e) {
            this.logger.error("[UDS] Failed to start server", (Throwable)e);
            this.stop();
            return null;
        }
    }

    @Override
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.logger.info("Stopping UDS socket server");
        Map $this$forEach$iv = this.clientManagers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ExtensionHostManager manager = (ExtensionHostManager)entry.getValue();
            try {
                manager.dispose();
            }
            catch (Exception e) {
                this.logger.warn("Failed to dispose client manager", (Throwable)e);
            }
        }
        this.clientManagers.clear();
        try {
            ServerSocketChannel serverSocketChannel = this.udsServerChannel;
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to close UDS server channel", (Throwable)e);
        }
        try {
            Path path = this.udsSocketPath;
            if (path != null) {
                Path it = path;
                boolean bl = false;
                Files.deleteIfExists(it);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to delete UDS socket file", (Throwable)e);
        }
        Thread thread = this.serverThread;
        if (thread != null) {
            thread.interrupt();
        }
        this.serverThread = null;
        this.udsServerChannel = null;
        this.udsSocketPath = null;
        this.logger.info("UDS socket server stopped");
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    public void dispose() {
        this.stop();
    }

    private final void acceptUdsConnections() {
        ServerSocketChannel serverSocketChannel = this.udsServerChannel;
        if (serverSocketChannel == null) {
            return;
        }
        ServerSocketChannel server = serverSocketChannel;
        this.logger.info("[UDS] Waiting for connections..., tid: " + Thread.currentThread().getId());
        while (this.isRunning && !Thread.currentThread().isInterrupted()) {
            try {
                SocketChannel clientChannel = server.accept();
                this.logger.info("[UDS] New client connected");
                try {
                    PluginContext traceCtx = PluginContext.Companion.getInstance(this.getProject());
                    String traceId = traceCtx.getTraceId();
                    Long traceStart = traceCtx.getTraceStartNanos();
                    if (traceId != null && traceStart != null) {
                        long deltaMs = (System.nanoTime() - traceStart) / (long)1000000;
                        this.logger.info("[Perf][traceId=" + traceId + "] Extension host connected after " + deltaMs + " ms (UDS)");
                    }
                }
                catch (Exception traceCtx) {
                    // empty catch block
                }
                Intrinsics.checkNotNull((Object)clientChannel);
                ExtensionHostManager manager = new ExtensionHostManager(clientChannel, this.projectPath, this.getProject());
                ((Map)this.clientManagers).put(clientChannel, manager);
                this.handleClient(clientChannel, manager);
            }
            catch (Exception e) {
                if (this.isRunning) {
                    this.logger.error("[UDS] Accept failed, will retry in 1s", (Throwable)e);
                    Thread.sleep(1000L);
                    continue;
                }
                this.logger.info("[UDS] Accept loop exiting (server stopped)");
                break;
            }
        }
        this.logger.info("[UDS] Accept loop terminated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleClient(SocketChannel clientChannel, ExtensionHostManager manager) {
        try {
            manager.start();
            long lastCheckTime = System.currentTimeMillis();
            int CHECK_INTERVAL = 15000;
            while (clientChannel.isConnected() && clientChannel.isOpen() && this.isRunning) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastCheckTime > (long)CHECK_INTERVAL) {
                        lastCheckTime = currentTime;
                        if (!clientChannel.isOpen()) {
                            this.logger.error("[UDS] Client channel unhealthy, closing.");
                            break;
                        }
                        ResponsiveState responsiveState = manager.getResponsiveState();
                        if (responsiveState != null) {
                            this.logger.debug("[UDS] Client RPC state: " + responsiveState);
                        }
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    this.logger.info("[UDS] Client handler interrupted, exiting loop");
                    break;
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException)) {
                this.logger.error("[UDS] Error in client handler: " + e.getMessage(), (Throwable)e);
            } else {
                this.logger.info("[UDS] Client handler interrupted during processing");
            }
        }
        finally {
            manager.dispose();
            this.clientManagers.remove(clientChannel);
            try {
                clientChannel.close();
            }
            catch (IOException e) {
                this.logger.warn("[UDS] Close client channel error", (Throwable)e);
            }
            this.logger.info("[UDS] Client channel closed and removed.");
        }
    }

    private final Path createSocketFile() {
        Path tmpDir = Paths.get("/tmp", new String[0]);
        Path sockPath = Files.createTempFile(tmpDir, "roo-cline-idea-extension-ipc-", ".sock", new FileAttribute[0]);
        Files.deleteIfExists(sockPath);
        Intrinsics.checkNotNull((Object)sockPath);
        return sockPath;
    }

    private static final Unit startUds$lambda$0(ExtensionUnixDomainSocketServer this$0) {
        this$0.acceptUdsConnections();
        return Unit.INSTANCE;
    }
}

