/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.core.ExtensionHostManager;
import com.sina.weibo.agent.core.ISocketServer;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.ipc.proxy.ResponsiveState;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\u0016\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u001aR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/sina/weibo/agent/core/ExtensionSocketServer;", "Lcom/sina/weibo/agent/core/ISocketServer;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "serverSocket", "Ljava/net/ServerSocket;", "clientManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/Socket;", "Lcom/sina/weibo/agent/core/ExtensionHostManager;", "serverThread", "Ljava/lang/Thread;", "projectPath", "", "isRunning", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "start", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "stop", "", "acceptConnections", "handleClient", "clientSocket", "manager", "isSocketHealthy", "socket", "getPort", "dispose", "connectToDebugHost", "host", "port", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionSocketServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionSocketServer.kt\ncom/sina/weibo/agent/core/ExtensionSocketServer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,325:1\n216#2,2:326\n*S KotlinDebug\n*F\n+ 1 ExtensionSocketServer.kt\ncom/sina/weibo/agent/core/ExtensionSocketServer\n*L\n98#1:326,2\n*E\n"})
public final class ExtensionSocketServer
implements ISocketServer {
    @NotNull
    private final Logger logger;
    @Nullable
    private ServerSocket serverSocket;
    @NotNull
    private final ConcurrentHashMap<Socket, ExtensionHostManager> clientManagers;
    @Nullable
    private Thread serverThread;
    @NotNull
    private String projectPath;
    private volatile boolean isRunning;
    public Project project;

    public ExtensionSocketServer() {
        Logger logger = Logger.getInstance(ExtensionSocketServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.clientManagers = new ConcurrentHashMap();
        this.projectPath = "";
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Override
    @NotNull
    public Integer start(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (this.isRunning) {
            this.logger.info("Socket server is already running");
            ServerSocket serverSocket = this.serverSocket;
            return serverSocket != null ? serverSocket.getLocalPort() : -1;
        }
        this.projectPath = projectPath;
        try {
            int port;
            ServerSocket serverSocket = this.serverSocket = new ServerSocket(0);
            int n = port = serverSocket != null ? serverSocket.getLocalPort() : -1;
            if (port <= 0) {
                this.logger.error("Failed to get valid port for socket server");
                return -1;
            }
            this.isRunning = true;
            this.logger.info("Starting socket server on port: " + port);
            this.serverThread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"ExtensionSocketServer", (int)0, () -> ExtensionSocketServer.start$lambda$0(this), (int)22, null);
            return port;
        }
        catch (Exception e) {
            this.logger.error("Failed to start socket server", (Throwable)e);
            this.stop();
            return -1;
        }
    }

    @Override
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.logger.info("Stopping socket server");
        Map $this$forEach$iv = this.clientManagers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ExtensionHostManager manager = (ExtensionHostManager)entry.getValue();
            try {
                manager.dispose();
            }
            catch (Exception e) {
                this.logger.warn("Failed to dispose client manager", (Throwable)e);
            }
        }
        this.clientManagers.clear();
        try {
            ServerSocket serverSocket = this.serverSocket;
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close server socket", (Throwable)e);
        }
        Thread thread = this.serverThread;
        if (thread != null) {
            thread.interrupt();
        }
        this.serverThread = null;
        this.serverSocket = null;
        this.logger.info("Socket server stopped");
    }

    private final void acceptConnections() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return;
        }
        ServerSocket server = serverSocket;
        this.logger.info("Socket server started, waiting for connections..., tid: " + Thread.currentThread().getId());
        while (this.isRunning && !Thread.currentThread().isInterrupted()) {
            try {
                Socket clientSocket = server.accept();
                this.logger.info("New client connected from: " + clientSocket.getInetAddress().getHostAddress());
                try {
                    PluginContext traceCtx = PluginContext.Companion.getInstance(this.getProject());
                    String traceId = traceCtx.getTraceId();
                    Long traceStart = traceCtx.getTraceStartNanos();
                    if (traceId != null && traceStart != null) {
                        long deltaMs = (System.nanoTime() - traceStart) / (long)1000000;
                        this.logger.info("[Perf][traceId=" + traceId + "] Extension host connected after " + deltaMs + " ms");
                    }
                }
                catch (Exception traceCtx) {
                    // empty catch block
                }
                clientSocket.setTcpNoDelay(true);
                Intrinsics.checkNotNull((Object)clientSocket);
                ExtensionHostManager manager = new ExtensionHostManager(clientSocket, this.projectPath, this.getProject());
                ((Map)this.clientManagers).put(clientSocket, manager);
                this.handleClient(clientSocket, manager);
            }
            catch (IOException e) {
                if (this.isRunning) {
                    this.logger.error("Error accepting client connection", (Throwable)e);
                    continue;
                }
                this.logger.info("Socket server closed");
                break;
            }
            catch (InterruptedException e) {
                this.logger.info("Socket server thread interrupted");
                break;
            }
            catch (Exception e) {
                this.logger.error("Unexpected error in accept loop", (Throwable)e);
                if (!this.isRunning) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    this.logger.info("Socket server thread interrupted during sleep");
                    break;
                }
            }
        }
        this.logger.info("Socket accept loop terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleClient(Socket clientSocket, ExtensionHostManager manager) {
        try {
            manager.start();
            long lastCheckTime = System.currentTimeMillis();
            int CHECK_INTERVAL = 15000;
            while (clientSocket.isConnected() && !clientSocket.isClosed() && this.isRunning) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastCheckTime > (long)CHECK_INTERVAL) {
                        lastCheckTime = currentTime;
                        if (!this.isSocketHealthy(clientSocket)) {
                            this.logger.error("Detected unhealthy Socket connection, closing connection");
                            break;
                        }
                        ResponsiveState responsiveState = manager.getResponsiveState();
                        if (responsiveState != null) {
                            this.logger.debug("Current RPC response state: " + responsiveState);
                        }
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    this.logger.info("Client handler thread interrupted, exiting loop");
                    break;
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException)) {
                this.logger.error("Error handling client socket: " + e.getMessage(), (Throwable)e);
            } else {
                this.logger.info("Client handler thread interrupted during processing");
            }
        }
        finally {
            manager.dispose();
            this.clientManagers.remove(clientSocket);
            if (!clientSocket.isClosed()) {
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    this.logger.warn("Failed to close client socket", (Throwable)e);
                }
            }
            this.logger.info("Client socket closed and removed");
        }
    }

    private final boolean isSocketHealthy(Socket socket) {
        boolean isHealthy;
        boolean bl = isHealthy = socket.isConnected() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
        if (!isHealthy) {
            this.logger.warn("Socket health check failed: isConnected=" + socket.isConnected() + ", isClosed=" + socket.isClosed() + ", isInputShutdown=" + socket.isInputShutdown() + ", isOutputShutdown=" + socket.isOutputShutdown());
        }
        return isHealthy;
    }

    public final int getPort() {
        ServerSocket serverSocket = this.serverSocket;
        return serverSocket != null ? serverSocket.getLocalPort() : -1;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    public void dispose() {
        this.stop();
    }

    public final boolean connectToDebugHost(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.isRunning) {
            this.logger.info("Socket server is already running, stopping first");
            this.stop();
        }
        try {
            this.logger.info("Connecting to debug host at " + host + ":" + port);
            Socket clientSocket = new Socket(host, port);
            clientSocket.setTcpNoDelay(true);
            this.isRunning = true;
            ExtensionHostManager manager = new ExtensionHostManager(clientSocket, this.projectPath, this.getProject());
            ((Map)this.clientManagers).put(clientSocket, manager);
            ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"DebugHostHandler", (int)0, () -> ExtensionSocketServer.connectToDebugHost$lambda$2(this, clientSocket, manager), (int)22, null);
            this.logger.info("Successfully connected to debug host at " + host + ":" + port);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to connect to debug host at " + host + ":" + port, (Throwable)e);
            this.stop();
            return false;
        }
    }

    private static final Unit start$lambda$0(ExtensionSocketServer this$0) {
        this$0.acceptConnections();
        return Unit.INSTANCE;
    }

    private static final Unit connectToDebugHost$lambda$2(ExtensionSocketServer this$0, Socket $clientSocket, ExtensionHostManager $manager) {
        this$0.handleClient($clientSocket, $manager);
        return Unit.INSTANCE;
    }
}

