/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.google.gson.Gson;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.core.ExtensionDescription;
import com.sina.weibo.agent.core.ExtensionHostMessageType;
import com.sina.weibo.agent.core.ExtensionManager;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.RPCManager;
import com.sina.weibo.agent.editor.EditorAndDocManager;
import com.sina.weibo.agent.extensions.config.ExtensionMetadata;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.VsixManager;
import com.sina.weibo.agent.ipc.NodeSocket;
import com.sina.weibo.agent.ipc.PersistentProtocol;
import com.sina.weibo.agent.ipc.proxy.ResponsiveState;
import com.sina.weibo.agent.util.PluginResourceUtil;
import com.sina.weibo.agent.util.URI;
import com.sina.weibo.agent.workspace.WorkspaceFileChangeManager;
import java.io.File;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u00015B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020 H\u0002J\u0016\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0002J\b\u0010+\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0005H\u0002J\b\u0010-\u001a\u00020\u0005H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0005H\u0002J\b\u00104\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/sina/weibo/agent/core/ExtensionHostManager;", "Lcom/intellij/openapi/Disposable;", "clientSocket", "Ljava/net/Socket;", "projectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/net/Socket;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "clientChannel", "Ljava/nio/channels/SocketChannel;", "(Ljava/nio/channels/SocketChannel;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "nodeSocket", "Lcom/sina/weibo/agent/ipc/NodeSocket;", "protocol", "Lcom/sina/weibo/agent/ipc/PersistentProtocol;", "rpcManager", "Lcom/sina/weibo/agent/core/RPCManager;", "extensionManager", "Lcom/sina/weibo/agent/core/ExtensionManager;", "currentExtensionProvider", "Lcom/sina/weibo/agent/extensions/config/ExtensionProvider;", "extensionIdentifier", "gson", "Lcom/google/gson/Gson;", "lastDiagnosticLogTime", "", "managerStartNanos", "start", "", "getResponsiveState", "Lcom/sina/weibo/agent/ipc/proxy/ResponsiveState;", "handleMessage", "data", "", "handleReadyMessage", "handleInitializedMessage", "createInitData", "", "", "getCurrentIDEName", "getIDEVersion", "getPluginDir", "getExtensionPath", "extensionConfig", "Lcom/sina/weibo/agent/extensions/config/ExtensionMetadata;", "uriFromPath", "Lcom/sina/weibo/agent/util/URI;", "path", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionHostManager.kt\ncom/sina/weibo/agent/core/ExtensionHostManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1#2:477\n1563#3:478\n1634#3,3:479\n1193#3,2:482\n1267#3,4:484\n*S KotlinDebug\n*F\n+ 1 ExtensionHostManager.kt\ncom/sina/weibo/agent/core/ExtensionHostManager\n*L\n328#1:478\n328#1:479,3\n329#1:482,2\n329#1:484,4\n*E\n"})
public final class ExtensionHostManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private NodeSocket nodeSocket;
    @Nullable
    private PersistentProtocol protocol;
    @Nullable
    private RPCManager rpcManager;
    @Nullable
    private ExtensionManager extensionManager;
    @Nullable
    private ExtensionProvider currentExtensionProvider;
    @Nullable
    private String extensionIdentifier;
    @NotNull
    private final Gson gson;
    private long lastDiagnosticLogTime;
    @Nullable
    private String projectPath;
    private long managerStartNanos;
    @NotNull
    private static final Logger LOG;

    public ExtensionHostManager(@NotNull Socket clientSocket, @NotNull String projectPath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)clientSocket, (String)"clientSocket");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.gson = new Gson();
        clientSocket.setTcpNoDelay(true);
        this.nodeSocket = new NodeSocket(clientSocket, "extension-host");
        this.projectPath = projectPath;
        this.project = project;
    }

    public ExtensionHostManager(@NotNull SocketChannel clientChannel, @NotNull String projectPath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)clientChannel, (String)"clientChannel");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.gson = new Gson();
        this.nodeSocket = new NodeSocket(clientChannel, "extension-host");
        this.projectPath = projectPath;
        this.project = project;
    }

    public final void start() {
        Object object;
        block8: {
            block7: {
                this.managerStartNanos = System.nanoTime();
                PluginContext traceCtx = PluginContext.Companion.getInstance(this.project);
                String traceId = traceCtx.getTraceId();
                object = traceId;
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                String string = "[Perf][traceId=" + it + "]";
                object = string;
                if (string != null) break block8;
            }
            object = "[Perf]";
        }
        String tracePrefix = object;
        try {
            com.sina.weibo.agent.extensions.core.ExtensionManager globalExtensionManager = com.sina.weibo.agent.extensions.core.ExtensionManager.Companion.getInstance(this.project);
            this.currentExtensionProvider = globalExtensionManager.getCurrentProvider();
            if (this.currentExtensionProvider == null) {
                LOG.info("No extension provider available");
                this.dispose();
                return;
            }
            this.extensionManager = new ExtensionManager();
            ExtensionProvider extensionProvider = this.currentExtensionProvider;
            Intrinsics.checkNotNull((Object)extensionProvider);
            ExtensionMetadata extensionConfig = extensionProvider.getConfiguration(this.project);
            String extensionPath = this.getExtensionPath(extensionConfig);
            if (extensionPath == null || !new File(extensionPath).exists()) {
                LOG.info("Extension path not found: " + extensionPath);
                this.dispose();
                return;
            }
            long tRegister = System.nanoTime();
            ExtensionManager extensionManager = this.extensionManager;
            Intrinsics.checkNotNull((Object)extensionManager);
            ExtensionDescription extensionDesc = extensionManager.registerExtension(extensionPath, extensionConfig);
            this.extensionIdentifier = extensionDesc.getIdentifier().getValue();
            ExtensionProvider extensionProvider2 = this.currentExtensionProvider;
            Intrinsics.checkNotNull((Object)extensionProvider2);
            LOG.info("Registered extension: " + extensionProvider2.getExtensionId());
            LOG.info(tracePrefix + " registerExtension took " + (System.nanoTime() - tRegister) / (long)1000000 + " ms");
            this.protocol = new PersistentProtocol(new PersistentProtocol.PersistentProtocolOptions(this.nodeSocket, null, null, true), (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>((Object)this){

                public final void invoke(byte[] p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ExtensionHostManager.access$handleMessage((ExtensionHostManager)this.receiver, p0);
                }
            }));
            ExtensionProvider extensionProvider3 = this.currentExtensionProvider;
            Intrinsics.checkNotNull((Object)extensionProvider3);
            LOG.info("ExtensionHostManager started successfully with extension: " + extensionProvider3.getExtensionId());
            LOG.info(tracePrefix + " ExtensionHostManager.start completed in " + (System.nanoTime() - this.managerStartNanos) / (long)1000000 + " ms");
        }
        catch (Exception e) {
            LOG.info("Failed to start ExtensionHostManager", (Throwable)e);
            this.dispose();
        }
    }

    @Nullable
    public final ResponsiveState getResponsiveState() {
        Object object;
        block5: {
            Object object2;
            String socketInfo;
            long currentTime;
            block7: {
                block6: {
                    StringBuilder stringBuilder;
                    boolean shouldLogDiagnostics;
                    currentTime = System.currentTimeMillis();
                    boolean bl = shouldLogDiagnostics = currentTime - this.lastDiagnosticLogTime > 60000L;
                    if (this.rpcManager == null) {
                        if (shouldLogDiagnostics) {
                            LOG.debug("Unable to get responsive state: RPC manager is not initialized");
                            this.lastDiagnosticLogTime = currentTime;
                        }
                        return null;
                    }
                    if (!shouldLogDiagnostics) break block5;
                    StringBuilder $this$getResponsiveState_u24lambda_u241 = stringBuilder = new StringBuilder();
                    boolean bl2 = false;
                    $this$getResponsiveState_u24lambda_u241.append("NodeSocket: ");
                    $this$getResponsiveState_u24lambda_u241.append(this.nodeSocket.isClosed() ? "closed" : "active");
                    $this$getResponsiveState_u24lambda_u241.append(", input stream: ");
                    $this$getResponsiveState_u24lambda_u241.append(this.nodeSocket.isInputClosed() ? "closed" : "normal");
                    $this$getResponsiveState_u24lambda_u241.append(", output stream: ");
                    $this$getResponsiveState_u24lambda_u241.append(this.nodeSocket.isOutputClosed() ? "closed" : "normal");
                    $this$getResponsiveState_u24lambda_u241.append(", disposed=");
                    $this$getResponsiveState_u24lambda_u241.append(this.nodeSocket.isDisposed());
                    socketInfo = stringBuilder.toString();
                    object2 = this.protocol;
                    if (object2 == null) break block6;
                    PersistentProtocol proto = object2;
                    boolean bl3 = false;
                    String string = "Protocol: " + (proto.isDisposed() ? "disposed" : "active");
                    object2 = string;
                    if (string != null) break block7;
                }
                object2 = "Protocol is null";
            }
            Object protocolInfo = object2;
            LOG.debug("Connection diagnostics: " + socketInfo + ", " + (String)protocolInfo);
            this.lastDiagnosticLogTime = currentTime;
        }
        return (object = this.rpcManager) != null && (object = ((RPCManager)object).getRPCProtocol()) != null ? object.getResponsiveState() : null;
    }

    private final void handleMessage(byte[] data) {
        block7: {
            block6: {
                if (data.length != 1) break block6;
                ExtensionHostMessageType extensionHostMessageType = ExtensionHostMessageType.Companion.fromData(data);
                switch (extensionHostMessageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[extensionHostMessageType.ordinal()]) {
                    case 1: {
                        this.handleReadyMessage();
                        break block7;
                    }
                    case 2: {
                        this.handleInitializedMessage();
                        break block7;
                    }
                    case 3: {
                        LOG.info("Received Terminate message");
                        break block7;
                    }
                    case -1: {
                        String string = Arrays.toString(data);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        LOG.debug("Received unknown message type: " + string);
                        break block7;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            LOG.debug("Received message with length " + data.length + ", not handling as extension host message");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReadyMessage() {
        block8: {
            Object object;
            long l;
            String string;
            Logger logger;
            block10: {
                block9: {
                    void it;
                    Object object2;
                    LOG.info("Received Ready message from extension host");
                    PluginContext traceCtx = PluginContext.Companion.getInstance(this.project);
                    String traceId = traceCtx.getTraceId();
                    Long traceStart = traceCtx.getTraceStartNanos();
                    long now = System.nanoTime();
                    if (traceId == null) break block8;
                    long sinceMgr = (now - this.managerStartNanos) / (long)1000000;
                    Long l2 = traceStart;
                    if (l2 != null) {
                        long it2 = ((Number)l2).longValue();
                        boolean bl = false;
                        object2 = (now - it2) / (long)1000000;
                    } else {
                        object2 = null;
                    }
                    String sinceTrace = object2;
                    logger = LOG;
                    string = traceId;
                    l = sinceMgr;
                    object = sinceTrace;
                    if (object == null) break block9;
                    long l3 = ((Number)object).longValue();
                    long l4 = l;
                    String string2 = string;
                    Logger logger2 = logger;
                    boolean bl = false;
                    String string3 = ", " + (long)it + " ms from trace start";
                    logger = logger2;
                    string = string2;
                    l = l4;
                    String string4 = string3;
                    object = string4;
                    if (string4 != null) break block10;
                }
                object = "";
            }
            logger.info("[Perf][traceId=" + string + "] Ready received after " + l + " ms from manager start" + (String)object);
        }
        try {
            Map<String, Object> initData = this.createInitData();
            LOG.info("handleReadyMessage createInitData: " + initData);
            String string = this.gson.toJson(initData);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            String string5 = string;
            byte[] byArray = string5.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] jsonData = byArray;
            PersistentProtocol persistentProtocol = this.protocol;
            if (persistentProtocol != null) {
                persistentProtocol.send(jsonData);
            }
            LOG.info("Sent initialization data to extension host");
        }
        catch (Exception e) {
            LOG.info("Failed to handle Ready message", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInitializedMessage() {
        block12: {
            Object object;
            long l;
            String string;
            Logger logger;
            block14: {
                block13: {
                    void it;
                    Object object2;
                    LOG.info("Received Initialized message from extension host");
                    PluginContext traceCtx = PluginContext.Companion.getInstance(this.project);
                    String traceId = traceCtx.getTraceId();
                    Long traceStart = traceCtx.getTraceStartNanos();
                    long now = System.nanoTime();
                    if (traceId == null) break block12;
                    long sinceMgr = (now - this.managerStartNanos) / (long)1000000;
                    Long l2 = traceStart;
                    if (l2 != null) {
                        long it2 = ((Number)l2).longValue();
                        boolean bl = false;
                        object2 = (now - it2) / (long)1000000;
                    } else {
                        object2 = null;
                    }
                    String sinceTrace = object2;
                    logger = LOG;
                    string = traceId;
                    l = sinceMgr;
                    object = sinceTrace;
                    if (object == null) break block13;
                    long l3 = ((Number)object).longValue();
                    long l4 = l;
                    String string2 = string;
                    Logger logger2 = logger;
                    boolean bl = false;
                    String string3 = ", " + (long)it + " ms from trace start";
                    logger = logger2;
                    string = string2;
                    l = l4;
                    String string4 = string3;
                    object = string4;
                    if (string4 != null) break block14;
                }
                object = "";
            }
            logger.info("[Perf][traceId=" + string + "] Initialized received after " + l + " ms from manager start" + (String)object);
        }
        try {
            PersistentProtocol persistentProtocol = this.protocol;
            if (persistentProtocol == null) {
                throw new IllegalStateException("Protocol is not initialized");
            }
            PersistentProtocol protocol = persistentProtocol;
            ExtensionManager extensionManager = this.extensionManager;
            if (extensionManager == null) {
                throw new IllegalStateException("ExtensionManager is not initialized");
            }
            ExtensionManager extensionManager2 = extensionManager;
            ExtensionProvider extensionProvider = this.currentExtensionProvider;
            if (extensionProvider == null) {
                throw new IllegalStateException("Extension provider is not initialized");
            }
            ExtensionProvider currentProvider = extensionProvider;
            RPCManager rPCManager = this.rpcManager = new RPCManager(protocol, extensionManager2, null, this.project);
            if (rPCManager != null) {
                rPCManager.startInitialize();
            }
            this.project.getService(WorkspaceFileChangeManager.class);
            ((EditorAndDocManager)this.project.getService(EditorAndDocManager.class)).initCurrentIdeaEditor();
            String string = this.extensionIdentifier;
            if (string == null) {
                throw new IllegalStateException("Extension identifier is not initialized");
            }
            String extensionId = string;
            RPCManager rPCManager2 = this.rpcManager;
            Intrinsics.checkNotNull((Object)rPCManager2);
            extensionManager2.activateExtension(extensionId, rPCManager2.getRPCProtocol()).whenComplete((arg_0, arg_1) -> ExtensionHostManager.handleInitializedMessage$lambda$8((arg_0, arg_1) -> ExtensionHostManager.handleInitializedMessage$lambda$7(currentProvider, arg_0, arg_1), arg_0, arg_1));
            LOG.info("Initialized extension host");
        }
        catch (Exception e) {
            LOG.info("Failed to handle Initialized message", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> createInitData() {
        Object object;
        List list;
        Object object2;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        Pair[] pairArray;
        int n;
        String string;
        Pair[] pairArray2;
        int n2;
        String string2;
        String pluginDir = this.getPluginDir();
        String basePath = this.projectPath;
        Pair[] pairArray3 = new Pair[15];
        pairArray3[0] = TuplesKt.to((Object)"commit", (Object)"development");
        pairArray3[1] = TuplesKt.to((Object)"version", (Object)this.getIDEVersion());
        pairArray3[2] = TuplesKt.to((Object)"quality", null);
        pairArray3[3] = TuplesKt.to((Object)"parentPid", (Object)ProcessHandle.current().pid());
        Object[] objectArray = new Pair[13];
        objectArray[0] = TuplesKt.to((Object)"isExtensionDevelopmentDebug", (Object)false);
        objectArray[1] = TuplesKt.to((Object)"appName", (Object)this.getCurrentIDEName());
        objectArray[2] = TuplesKt.to((Object)"appHost", (Object)"node");
        objectArray[3] = TuplesKt.to((Object)"appLanguage", (Object)"en");
        objectArray[4] = TuplesKt.to((Object)"appUriScheme", (Object)"vscode");
        objectArray[5] = TuplesKt.to((Object)"appRoot", (Object)this.uriFromPath(pluginDir));
        String[] stringArray = new String[]{".coderider-kilo-agent", "globalStorage"};
        objectArray[6] = TuplesKt.to((Object)"globalStorageHome", (Object)this.uriFromPath(((Object)Paths.get(System.getProperty("user.home"), stringArray)).toString()));
        stringArray = new String[]{".coderider-kilo-agent", "workspaceStorage"};
        objectArray[7] = TuplesKt.to((Object)"workspaceStorageHome", (Object)this.uriFromPath(((Object)Paths.get(System.getProperty("user.home"), stringArray)).toString()));
        objectArray[8] = TuplesKt.to((Object)"extensionDevelopmentLocationURI", null);
        objectArray[9] = TuplesKt.to((Object)"extensionTestsLocationURI", null);
        objectArray[10] = TuplesKt.to((Object)"useHostProxy", (Object)false);
        objectArray[11] = TuplesKt.to((Object)"skipWorkspaceStorageLock", (Object)false);
        objectArray[12] = TuplesKt.to((Object)"isExtensionTelemetryLoggingOnly", (Object)false);
        pairArray3[4] = TuplesKt.to((Object)"environment", (Object)MapsKt.mapOf((Pair[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)"id", (Object)"intellij-workspace"), TuplesKt.to((Object)"name", (Object)"IntelliJ Workspace"), TuplesKt.to((Object)"transient", (Object)false), TuplesKt.to((Object)"configuration", null), TuplesKt.to((Object)"isUntitled", (Object)false)};
        pairArray3[5] = TuplesKt.to((Object)"workspace", (Object)MapsKt.mapOf((Pair[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)"authority", null), TuplesKt.to((Object)"connectionData", null), TuplesKt.to((Object)"isRemote", (Object)false)};
        pairArray3[6] = TuplesKt.to((Object)"remote", (Object)MapsKt.mapOf((Pair[])objectArray));
        Pair[] pairArray4 = pairArray3;
        int n3 = 7;
        String string3 = "extensions";
        objectArray = new Pair[4];
        objectArray[0] = TuplesKt.to((Object)"versionId", (Object)1);
        Object object3 = this.extensionManager;
        if (object3 == null || (object3 = ((ExtensionManager)object3).getAllExtensionDescriptions()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        objectArray[1] = TuplesKt.to((Object)"allExtensions", (Object)object3);
        Pair[] pairArray5 = objectArray;
        int n4 = 2;
        String string4 = "myExtensions";
        Object object4 = this.extensionManager;
        if (object4 != null && (object4 = ((ExtensionManager)object4).getAllExtensionDescriptions()) != null) {
            void $this$mapTo$iv$iv;
            Iterable iterable = (Iterable)object4;
            string2 = string4;
            n2 = n4;
            pairArray2 = pairArray5;
            string = string3;
            n = n3;
            pairArray = pairArray4;
            boolean $i$f$map = false;
            void var8_14 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExtensionDescription extensionDescription = (ExtensionDescription)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(it.getIdentifier());
            }
            object2 = (List)destination$iv$iv;
            pairArray4 = pairArray;
            n3 = n;
            string3 = string;
            pairArray5 = pairArray2;
            n4 = n2;
            string4 = string2;
            list = object2;
        } else {
            list = CollectionsKt.emptyList();
        }
        pairArray5[n4] = TuplesKt.to((Object)string4, (Object)list);
        Pair[] pairArray6 = objectArray;
        int n5 = 3;
        String string5 = "activationEvents";
        Object object5 = this.extensionManager;
        if (object5 != null && (object5 = ((ExtensionManager)object5).getAllExtensionDescriptions()) != null) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            $this$map$iv = (Iterable)object5;
            string2 = string5;
            n2 = n5;
            pairArray2 = pairArray6;
            string = string3;
            n = n3;
            pairArray = pairArray4;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                ExtensionDescription ext = (ExtensionDescription)element$iv$iv;
                boolean bl = false;
                String string6 = ext.getIdentifier().getValue();
                List list2 = ext.getActivationEvents();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Pair pair = TuplesKt.to((Object)string6, list2);
                map.put(pair.getFirst(), pair.getSecond());
            }
            object2 = destination$iv$iv2;
            pairArray4 = pairArray;
            n3 = n;
            string3 = string;
            pairArray6 = pairArray2;
            n5 = n2;
            string5 = string2;
            object = object2;
        } else {
            object = MapsKt.emptyMap();
        }
        pairArray6[n5] = TuplesKt.to((Object)string5, (Object)object);
        pairArray4[n3] = TuplesKt.to((Object)string3, (Object)MapsKt.mapOf((Pair[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)"sessionId", (Object)"intellij-session"), TuplesKt.to((Object)"machineId", (Object)"intellij-machine"), TuplesKt.to((Object)"sqmId", (Object)""), TuplesKt.to((Object)"devDeviceId", (Object)""), TuplesKt.to((Object)"firstSessionDate", (Object)Instant.now().toString()), TuplesKt.to((Object)"msftInternal", (Object)false)};
        pairArray3[8] = TuplesKt.to((Object)"telemetryInfo", (Object)MapsKt.mapOf((Pair[])objectArray));
        pairArray3[9] = TuplesKt.to((Object)"logLevel", (Object)0);
        pairArray3[10] = TuplesKt.to((Object)"loggers", (Object)CollectionsKt.emptyList());
        objectArray = new String[]{"logs"};
        pairArray3[11] = TuplesKt.to((Object)"logsLocation", (Object)this.uriFromPath(((Object)Paths.get(pluginDir, (String[])objectArray)).toString()));
        pairArray3[12] = TuplesKt.to((Object)"autoStart", (Object)true);
        objectArray = new Pair[]{TuplesKt.to((Object)"includeStack", (Object)false), TuplesKt.to((Object)"logNative", (Object)false)};
        pairArray3[13] = TuplesKt.to((Object)"consoleForward", (Object)MapsKt.mapOf((Pair[])objectArray));
        pairArray3[14] = TuplesKt.to((Object)"uiKind", (Object)1);
        return MapsKt.mapOf((Pair[])pairArray3);
    }

    private final String getCurrentIDEName() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        String string = applicationInfo.getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        String fullName = applicationInfo.getFullApplicationName();
        String ideName = switch (productCode) {
            case "IC" -> "IntelliJ IDEA";
            case "IU" -> "IntelliJ IDEA";
            case "AS" -> "Android Studio";
            case "AI" -> "Android Studio";
            case "WS" -> "WebStorm";
            case "PS" -> "PhpStorm";
            case "PY" -> "PyCharm Professional";
            case "PC" -> "PyCharm Community";
            case "GO" -> "GoLand";
            case "CL" -> "CLion";
            case "RD" -> "Rider";
            case "RM" -> "RubyMine";
            case "DB" -> "DataGrip";
            case "DS" -> "DataSpell";
            default -> {
                String v2 = fullName;
                yield (v2 != null ? StringsKt.contains$default((CharSequence)v2, (CharSequence)"Android Studio", (boolean)false, (int)2, null) : false) ? "Android Studio" : "JetBrains";
            }
        };
        LOG.info("Get IDE name, productCode: " + productCode + " ideName: " + ideName + " fullName: " + fullName);
        return ideName;
    }

    private final String getIDEVersion() {
        String pluginVersion;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        String string = applicationInfo.getShortVersion();
        if (string == null) {
            string = "1.0.0";
        }
        String version = string;
        LOG.info("Get IDE version: " + version);
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.gitlab.coderider-kilo"));
        String string2 = pluginVersion = ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        if (pluginVersion != null) {
            String fullVersion = version + ", " + pluginVersion;
            LOG.info("Get IDE version and plugin version: " + fullVersion);
            return fullVersion;
        }
        return version;
    }

    private final String getPluginDir() {
        String string = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", "");
        if (string == null) {
            throw new IllegalStateException("Unable to get plugin directory");
        }
        return string;
    }

    private final String getExtensionPath(ExtensionMetadata extensionConfig) {
        Object object;
        block13: {
            block12: {
                String projectPath = this.project.getBasePath();
                String homeDir = System.getProperty("user.home");
                if (projectPath != null) {
                    Object v0;
                    block11: {
                        List possiblePaths = CollectionsKt.listOf((Object)(VsixManager.Companion.getBaseDirectory() + "/" + extensionConfig.getCodeDir()));
                        Iterable iterable = possiblePaths;
                        for (Object t : iterable) {
                            String it = (String)t;
                            boolean bl = false;
                            if (!new File(it).exists()) continue;
                            v0 = t;
                            break block11;
                        }
                        v0 = null;
                    }
                    String foundPath = v0;
                    if (foundPath != null) {
                        return foundPath;
                    }
                }
                try {
                    String pluginResourcePath = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", extensionConfig.getCodeDir());
                    if (pluginResourcePath != null && new File(pluginResourcePath).exists()) {
                        return pluginResourcePath;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to get plugin resource path for extension: " + extensionConfig.getCodeDir(), (Throwable)e);
                }
                if ((object = projectPath) == null) break block12;
                String it = object;
                boolean bl = false;
                String string = it + "/" + extensionConfig.getCodeDir();
                object = string;
                if (string != null) break block13;
            }
            object = "/tmp/" + extensionConfig.getCodeDir();
        }
        Object defaultPath = object;
        LOG.info("Using default extension path: " + (String)defaultPath);
        return defaultPath;
    }

    private final URI uriFromPath(String path) {
        return URI.Companion.file(path);
    }

    public void dispose() {
        LOG.info("Disposing ExtensionHostManager");
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.rpcManager = null;
        PersistentProtocol persistentProtocol = this.protocol;
        if (persistentProtocol != null) {
            persistentProtocol.dispose();
        }
        this.protocol = null;
        this.nodeSocket.dispose();
        LOG.info("ExtensionHostManager disposed");
    }

    private static final Unit handleInitializedMessage$lambda$7(ExtensionProvider $currentProvider, Boolean bl, Throwable error2) {
        if (error2 != null) {
            LOG.info("Failed to activate extension: " + $currentProvider.getExtensionId(), error2);
        } else {
            LOG.info("Extension activated successfully: " + $currentProvider.getExtensionId());
        }
        return Unit.INSTANCE;
    }

    private static final void handleInitializedMessage$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$handleMessage(ExtensionHostManager $this, byte[] data) {
        $this.handleMessage(data);
    }

    static {
        Logger logger = Logger.getInstance(ExtensionHostManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/sina/weibo/agent/core/ExtensionHostManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExtensionHostMessageType.values().length];
            try {
                nArray[ExtensionHostMessageType.Ready.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtensionHostMessageType.Initialized.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtensionHostMessageType.Terminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

