/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadTaskShape;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000e\u001a\u00020\n2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J4\u0010\u0015\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fH\u0016J,\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J,\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\nH\u0016J&\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\n2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J\u001f\u0010 \u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\"J+\u0010#\u001a\u00020\u00112\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0011H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadTask;", "Lcom/sina/weibo/agent/actors/MainThreadTaskShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "taskProviders", "", "", "", "taskExecutions", "", "", "createTaskId", "task", "registerTaskProvider", "", "handle", "type", "unregisterTaskProvider", "fetchTasks", "", "filter", "getTaskExecution", "value", "executeTask", "terminateTask", "id", "registerTaskSystem", "scheme", "info", "customExecutionComplete", "result", "(Ljava/lang/String;Ljava/lang/Integer;)V", "registerSupportedExecutions", "custom", "", "shell", "process", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadTask
implements MainThreadTaskShape {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, String> taskProviders;
    @NotNull
    private final Map<String, Map<String, Object>> taskExecutions;

    public MainThreadTask() {
        Logger logger = Logger.getInstance(MainThreadTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.taskProviders = new LinkedHashMap();
        this.taskExecutions = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String createTaskId(@NotNull Map<String, ? extends Object> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        try {
            this.logger.info("Creating task ID for task: " + task);
            String id = "task-" + System.currentTimeMillis() + "-" + ((Object)task).hashCode();
            this.logger.debug("Generated task ID: " + id);
            return id;
        }
        catch (Exception e) {
            this.logger.error("Failed to create task ID", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void registerTaskProvider(int handle2, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        try {
            this.logger.info("Registering task provider: handle=" + handle2 + ", type=" + type2);
            Integer n = handle2;
            this.taskProviders.put(n, type2);
        }
        catch (Exception e) {
            this.logger.error("Failed to register task provider", (Throwable)e);
        }
    }

    @Override
    public void unregisterTaskProvider(int handle2) {
        try {
            this.logger.info("Unregistering task provider: handle=" + handle2);
            this.taskProviders.remove(handle2);
        }
        catch (Exception e) {
            this.logger.error("Failed to unregister task provider", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public List<Map<String, Object>> fetchTasks(@Nullable Map<String, ? extends Object> filter2) {
        try {
            this.logger.info("Fetching tasks with filter: " + filter2);
            return CollectionsKt.emptyList();
        }
        catch (Exception e) {
            this.logger.error("Failed to get tasks", (Throwable)e);
            throw e;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getTaskExecution(@NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        try {
            Object object = value.get("id");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                object = value.get("taskId");
                string = object instanceof String ? (String)object : null;
            }
            String taskId = string;
            this.logger.info("Getting task execution for task: " + taskId);
            Pair[] pairArray = new Pair[3];
            String string2 = taskId;
            if (string2 == null) {
                string2 = "unknown-task";
            }
            pairArray[0] = TuplesKt.to((Object)"id", (Object)string2);
            pairArray[1] = TuplesKt.to((Object)"task", value);
            pairArray[2] = TuplesKt.to((Object)"active", (Object)false);
            return MapsKt.mapOf((Pair[])pairArray);
        }
        catch (Exception e) {
            this.logger.error("Failed to get task execution", (Throwable)e);
            throw e;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> executeTask(@NotNull Map<String, ? extends Object> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        try {
            Object object;
            Pair[] pairArray = task.get("id");
            String string = pairArray instanceof String ? (String)pairArray : null;
            if (string == null && (string = (object = task.get("taskId")) instanceof String ? (String)object : null) == null) {
                string = "unknown-task";
            }
            String taskId = string;
            this.logger.info("Executing task: " + taskId);
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)taskId), TuplesKt.to((Object)"task", task), TuplesKt.to((Object)"active", (Object)true)};
            Map execution = MapsKt.mapOf((Pair[])pairArray);
            this.taskExecutions.put(taskId, execution);
            return execution;
        }
        catch (Exception e) {
            this.logger.error("Failed to execute task", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void terminateTask(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.logger.info("Terminating task: " + id);
            this.taskExecutions.remove(id);
        }
        catch (Exception e) {
            this.logger.error("Failed to terminate task", (Throwable)e);
        }
    }

    @Override
    public void registerTaskSystem(@NotNull String scheme, @NotNull Map<String, ? extends Object> info2) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(info2, (String)"info");
        try {
            this.logger.info("Registering task system: scheme=" + scheme + ", info=" + info2);
        }
        catch (Exception e) {
            this.logger.error("Failed to register task system", (Throwable)e);
        }
    }

    @Override
    public void customExecutionComplete(@NotNull String id, @Nullable Integer result2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.logger.info("Custom execution complete for task: " + id + " with result: " + result2);
            Map<String, Object> map = this.taskExecutions.get(id);
            if (map != null) {
                Map<String, Object> execution = map;
                boolean bl = false;
                this.taskExecutions.put(id, MapsKt.plus(execution, (Pair)TuplesKt.to((Object)"active", (Object)false)));
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update custom execution completion status", (Throwable)e);
        }
    }

    @Override
    public void registerSupportedExecutions(@Nullable Boolean custom, @Nullable Boolean shell, @Nullable Boolean process2) {
        try {
            this.logger.info("Registering supported executions: custom=" + custom + ", shell=" + shell + ", process=" + process2);
        }
        catch (Exception e) {
            this.logger.error("Failed to register supported execution types", (Throwable)e);
        }
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadTask");
        this.taskProviders.clear();
        this.taskExecutions.clear();
    }
}

