/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadStorageShape;
import com.sina.weibo.agent.service.ExtensionStorageService;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadStorage;", "Lcom/sina/weibo/agent/actors/MainThreadStorageShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "initializeExtensionStorage", "", "shared", "", "extensionId", "", "setValue", "", "value", "registerExtensionStorageKeysToSync", "extension", "keys", "", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadStorageShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadStorageShape.kt\ncom/sina/weibo/agent/actors/MainThreadStorage\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,71:1\n40#2,3:72\n40#2,3:75\n*S KotlinDebug\n*F\n+ 1 MainThreadStorageShape.kt\ncom/sina/weibo/agent/actors/MainThreadStorage\n*L\n49#1:72,3\n55#1:75,3\n*E\n"})
public final class MainThreadStorage
implements MainThreadStorageShape {
    @NotNull
    private final Logger logger;

    public MainThreadStorage() {
        Logger logger = Logger.getInstance(MainThreadStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @Nullable
    public Object initializeExtensionStorage(boolean shared, @NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        this.logger.info("Initializing extension storage: shared=" + shared + ", extensionId=" + extensionId);
        boolean $i$f$service = false;
        Class<ExtensionStorageService> serviceClass$iv = ExtensionStorageService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExtensionStorageService storage = (ExtensionStorageService)object;
        return storage.getValue(extensionId);
    }

    @Override
    public void setValue(boolean shared, @NotNull String extensionId, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$service = false;
        Class<ExtensionStorageService> serviceClass$iv = ExtensionStorageService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExtensionStorageService storage = (ExtensionStorageService)object;
        storage.setValue(extensionId, value);
    }

    @Override
    public void registerExtensionStorageKeysToSync(@NotNull Object extension, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        String extensionId = extension instanceof Map ? ((Map)extension).get("id") + "_" + ((Map)extension).get("version") : String.valueOf(extension);
        this.logger.info("Registering extension storage keys for sync: extension=" + extensionId + ", keys=" + keys);
    }

    public void dispose() {
        this.logger.info("Dispose MainThreadStorage");
    }
}

