/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadSearchShape;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J4\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f0\u001bH\u0016J4\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f0\u001bH\u0016J\u001a\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/actors/MainThreadSearch;", "Lcom/sina/weibo/agent/actors/MainThreadSearchShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "searchProviders", "", "", "", "fileSessions", "", "Ljava/net/URI;", "textSessions", "", "", "registerFileSearchProvider", "", "handle", "scheme", "registerAITextSearchProvider", "registerTextSearchProvider", "unregisterProvider", "handleFileMatch", "session", "data", "", "handleTextMatch", "handleTelemetry", "eventName", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadSearchShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadSearchShape.kt\ncom/sina/weibo/agent/actors/MainThreadSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n1617#2,9:170\n1869#2:179\n1870#2:181\n1626#2:182\n1#3:180\n382#4,7:183\n382#4,7:190\n*S KotlinDebug\n*F\n+ 1 MainThreadSearchShape.kt\ncom/sina/weibo/agent/actors/MainThreadSearch\n*L\n118#1:170,9\n118#1:179\n118#1:181\n118#1:182\n118#1:180\n134#1:183,7\n147#1:190,7\n*E\n"})
public final class MainThreadSearch
implements MainThreadSearchShape {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, String> searchProviders;
    @NotNull
    private final Map<Integer, List<URI>> fileSessions;
    @NotNull
    private final Map<Integer, List<Map<String, Object>>> textSessions;

    public MainThreadSearch() {
        Logger logger = Logger.getInstance(MainThreadSearch.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.searchProviders = new LinkedHashMap();
        this.fileSessions = new LinkedHashMap();
        this.textSessions = new LinkedHashMap();
    }

    @Override
    public void registerFileSearchProvider(int handle2, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        try {
            this.logger.info("Registering file search provider: handle=" + handle2 + ", scheme=" + scheme);
            Integer n = handle2;
            this.searchProviders.put(n, "file:" + scheme);
        }
        catch (Exception e) {
            this.logger.error("Failed to register file search provider", (Throwable)e);
        }
    }

    @Override
    public void registerAITextSearchProvider(int handle2, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        try {
            this.logger.info("Registering AI text search provider: handle=" + handle2 + ", scheme=" + scheme);
            Integer n = handle2;
            this.searchProviders.put(n, "aitext:" + scheme);
        }
        catch (Exception e) {
            this.logger.error("Failed to register AI text search provider", (Throwable)e);
        }
    }

    @Override
    public void registerTextSearchProvider(int handle2, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        try {
            this.logger.info("Registering text search provider: handle=" + handle2 + ", scheme=" + scheme);
            Integer n = handle2;
            this.searchProviders.put(n, "text:" + scheme);
        }
        catch (Exception e) {
            this.logger.error("Failed to register text search provider", (Throwable)e);
        }
    }

    @Override
    public void unregisterProvider(int handle2) {
        try {
            this.logger.info("Unregistering provider: handle=" + handle2);
            this.searchProviders.remove(handle2);
        }
        catch (Exception e) {
            this.logger.error("Failed to unregister search provider", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleFileMatch(int handle2, int session, @NotNull List<? extends Map<String, ? extends Object>> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            Object object;
            void $this$getOrPut$iv;
            void $this$mapNotNullTo$iv$iv;
            this.logger.info("Handling file match: handle=" + handle2 + ", session=" + session + ", matches=" + data.size());
            Object $this$mapNotNull$iv = data;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                URI uRI;
                block12: {
                    URI uRI2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map uriComponents2 = (Map)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        Object v;
                        String string;
                        String query;
                        String path;
                        Object v2;
                        String authority;
                        String scheme;
                        Object v3 = uriComponents2.get("scheme");
                        if ((v3 instanceof String ? (String)v3 : null) == null) {
                            uRI = null;
                            break block12;
                        }
                        scheme = scheme;
                        Object v4 = uriComponents2.get("authority");
                        String string2 = v4 instanceof String ? (String)v4 : null;
                        if (string2 == null) {
                            string2 = authority = "";
                        }
                        if (((v2 = uriComponents2.get("path")) instanceof String ? (String)v2 : null) == null) {
                            uRI = null;
                            break block12;
                        }
                        path = path;
                        Object v5 = uriComponents2.get("query");
                        String string3 = v5 instanceof String ? (String)v5 : null;
                        if (string3 == null) {
                            string3 = query = "";
                        }
                        if ((string = (v = uriComponents2.get("fragment")) instanceof String ? (String)v : null) == null) {
                            string = "";
                        }
                        String fragment = string;
                        uRI2 = new URI(scheme, authority, path, query, fragment);
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to convert URI components: " + uriComponents2, (Throwable)e);
                        uRI2 = null;
                    }
                    uRI = uRI2;
                }
                if (uRI == null) continue;
                URI it$iv$iv = uRI;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List uris = (List)destination$iv$iv;
            $this$mapNotNull$iv = this.fileSessions;
            Integer key$iv = session;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).addAll(uris);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle file match", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleTextMatch(int handle2, int session, @NotNull List<? extends Map<String, ? extends Object>> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            Object object;
            void $this$getOrPut$iv;
            this.logger.info("Handling text match: handle=" + handle2 + ", session=" + session + ", matches=" + data.size());
            Map<Integer, List<Map<String, Object>>> map = this.textSessions;
            Integer key$iv = session;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).addAll((Collection)data);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle text match", (Throwable)e);
        }
    }

    @Override
    public void handleTelemetry(@NotNull String eventName, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        try {
            this.logger.info("Handling telemetry: event=" + eventName + ", data=" + data);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle telemetry data", (Throwable)e);
        }
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadSearch");
        this.searchProviders.clear();
        this.fileSessions.clear();
        this.textSessions.clear();
    }
}

