/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadLoggerShape;
import com.sina.weibo.agent.util.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadLogger;", "Lcom/sina/weibo/agent/actors/MainThreadLoggerShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "log", "", "file", "Lcom/sina/weibo/agent/util/URI;", "messages", "", "", "flush", "createLogger", "", "options", "", "registerLogger", "deregisterLogger", "resource", "setVisibility", "visible", "", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadLogger
implements MainThreadLoggerShape {
    @NotNull
    private final Logger logger;

    public MainThreadLogger() {
        Logger logger = Logger.getInstance(MainThreadLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public void log(@NotNull URI file, @NotNull List<String> messages) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.logger.info("Logging to file: " + file);
    }

    @Override
    public void flush(@NotNull URI file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.info("Flushing log file: " + file);
    }

    @Override
    @NotNull
    public Object createLogger(@NotNull URI file, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Creating logger for file: " + file + " with options: " + options);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object registerLogger(@NotNull Map<String, ? extends Object> log) {
        Intrinsics.checkNotNullParameter(log, (String)"log");
        this.logger.info("Registering logger: " + log);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object deregisterLogger(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Deregistering logger for resource: " + resource);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object setVisibility(@NotNull String resource, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Setting visibility for resource: " + resource + " to " + visible);
        return Unit.INSTANCE;
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadLogger");
    }
}

