/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.sina.weibo.agent.actors.ConfigurationOverrides;
import com.sina.weibo.agent.actors.ConfigurationTarget;
import com.sina.weibo.agent.actors.MainThreadConfigurationShape;
import com.sina.weibo.agent.util.URI;
import com.sina.weibo.agent.util.URIComponents;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J=\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010H\u0002J)\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u001bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010!\u001a\u00020\bH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sina/weibo/agent/actors/MainThreadConfiguration;", "Lcom/sina/weibo/agent/actors/MainThreadConfigurationShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateConfigurationOption", "", "target", "", "key", "", "value", "", "overrides", "", "scopeToLanguage", "", "(ILjava/lang/String;Ljava/lang/Object;Ljava/util/Map;Ljava/lang/Boolean;)V", "removeConfigurationOption", "(ILjava/lang/String;Ljava/util/Map;Ljava/lang/Boolean;)V", "convertToConfigurationOverrides", "Lcom/sina/weibo/agent/actors/ConfigurationOverrides;", "overridesMap", "buildConfigurationKey", "baseKey", "(Ljava/lang/String;Lcom/sina/weibo/agent/actors/ConfigurationOverrides;Ljava/lang/Boolean;)Ljava/lang/String;", "getActiveProject", "Lcom/intellij/openapi/project/Project;", "storeValue", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadConfigurationShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadConfigurationShape.kt\ncom/sina/weibo/agent/actors/MainThreadConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,366:1\n1#2:367\n1310#3,2:368\n*S KotlinDebug\n*F\n+ 1 MainThreadConfigurationShape.kt\ncom/sina/weibo/agent/actors/MainThreadConfiguration\n*L\n328#1:368,2\n*E\n"})
public final class MainThreadConfiguration
implements MainThreadConfigurationShape {
    @NotNull
    private final Logger logger;

    public MainThreadConfiguration() {
        Logger logger = Logger.getInstance(MainThreadConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateConfigurationOption(int target, @NotNull String key, @Nullable Object value, @Nullable Map<String, ? extends Object> overrides, @Nullable Boolean scopeToLanguage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ConfigurationTarget configTarget = ConfigurationTarget.Companion.fromValue(target);
        ConfigurationOverrides configOverrides = this.convertToConfigurationOverrides(overrides);
        Logger logger = this.logger;
        ConfigurationTarget configurationTarget = configTarget;
        if (configurationTarget != null) {
            void it;
            ConfigurationTarget configurationTarget2 = configurationTarget;
            Logger logger2 = logger;
            boolean bl = false;
            string = ConfigurationTarget.Companion.toString((ConfigurationTarget)it);
            logger = logger2;
        } else {
            string = null;
        }
        ConfigurationOverrides configurationOverrides = configOverrides;
        ConfigurationOverrides configurationOverrides2 = configOverrides;
        logger.info("Update configuration option: target=" + string + ", key=" + key + ", value=" + value + ", overrideIdentifier=" + (configurationOverrides != null ? configurationOverrides.getOverrideIdentifier() : null) + ", resource=" + (configurationOverrides2 != null ? configurationOverrides2.getResource() : null) + ", scopeToLanguage=" + scopeToLanguage);
        String fullKey = this.buildConfigurationKey(key, configOverrides, scopeToLanguage);
        ConfigurationTarget configurationTarget3 = configTarget;
        switch (configurationTarget3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configurationTarget3.ordinal()]) {
            case 1: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                Intrinsics.checkNotNull((Object)properties);
                this.storeValue(properties, fullKey, value);
                break;
            }
            case 2: 
            case 3: {
                Project activeProject = this.getActiveProject();
                if (activeProject != null) {
                    PropertiesComponent properties = PropertiesComponent.getInstance((Project)activeProject);
                    Intrinsics.checkNotNull((Object)properties);
                    this.storeValue(properties, fullKey, value);
                    break;
                }
                this.logger.warn("Failed to save project-level configuration, no active project found");
                break;
            }
            case 4: 
            case 5: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                String userPrefixedKey = "user." + fullKey;
                Intrinsics.checkNotNull((Object)properties);
                this.storeValue(properties, userPrefixedKey, value);
                break;
            }
            default: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                String memoryPrefixedKey = "memory." + fullKey;
                Intrinsics.checkNotNull((Object)properties);
                this.storeValue(properties, memoryPrefixedKey, value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeConfigurationOption(int target, @NotNull String key, @Nullable Map<String, ? extends Object> overrides, @Nullable Boolean scopeToLanguage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ConfigurationTarget configTarget = ConfigurationTarget.Companion.fromValue(target);
        ConfigurationOverrides configOverrides = this.convertToConfigurationOverrides(overrides);
        Logger logger = this.logger;
        ConfigurationTarget configurationTarget = configTarget;
        if (configurationTarget != null) {
            void it;
            ConfigurationTarget configurationTarget2 = configurationTarget;
            Logger logger2 = logger;
            boolean bl = false;
            string = ConfigurationTarget.Companion.toString((ConfigurationTarget)it);
            logger = logger2;
        } else {
            string = null;
        }
        ConfigurationOverrides configurationOverrides = configOverrides;
        ConfigurationOverrides configurationOverrides2 = configOverrides;
        logger.info("Remove configuration option: target=" + string + ", key=" + key + ", overrideIdentifier=" + (configurationOverrides != null ? configurationOverrides.getOverrideIdentifier() : null) + ", resource=" + (configurationOverrides2 != null ? configurationOverrides2.getResource() : null) + ", scopeToLanguage=" + scopeToLanguage);
        String fullKey = this.buildConfigurationKey(key, configOverrides, scopeToLanguage);
        ConfigurationTarget configurationTarget3 = configTarget;
        switch (configurationTarget3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configurationTarget3.ordinal()]) {
            case 1: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                properties.unsetValue(fullKey);
                break;
            }
            case 2: 
            case 3: {
                Project activeProject = this.getActiveProject();
                if (activeProject != null) {
                    PropertiesComponent properties = PropertiesComponent.getInstance((Project)activeProject);
                    properties.unsetValue(fullKey);
                    break;
                }
                this.logger.warn("Failed to remove project-level configuration, no active project found");
                break;
            }
            case 4: 
            case 5: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                String userPrefixedKey = "user." + fullKey;
                properties.unsetValue(userPrefixedKey);
                break;
            }
            default: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                String memoryPrefixedKey = "memory." + fullKey;
                properties.unsetValue(memoryPrefixedKey);
            }
        }
    }

    private final ConfigurationOverrides convertToConfigurationOverrides(Map<String, ? extends Object> overridesMap) {
        Map<String, ? extends Object> map = overridesMap;
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            URI uRI;
            Object object = overridesMap.get("overrideIdentifier");
            String overrideIdentifier = object instanceof String ? (String)object : null;
            Object uriObj = overridesMap.get("resource");
            if (uriObj instanceof Map) {
                String fragment;
                Object v;
                String string;
                String query;
                Object v2;
                String string2;
                String authority;
                Object v3;
                String string3;
                String path;
                Object v4;
                String string4;
                String scheme;
                Object v5 = ((Map)uriObj).get("scheme");
                String string5 = v5 instanceof String ? (String)v5 : null;
                if (string5 == null) {
                    string5 = scheme = "";
                }
                if ((string4 = (v4 = ((Map)uriObj).get("path")) instanceof String ? (String)v4 : null) == null) {
                    string4 = path = "";
                }
                if ((string3 = (v3 = ((Map)uriObj).get("authority")) instanceof String ? (String)v3 : null) == null) {
                    string3 = authority = "";
                }
                if ((string2 = (v2 = ((Map)uriObj).get("query")) instanceof String ? (String)v2 : null) == null) {
                    string2 = query = "";
                }
                if ((string = (v = ((Map)uriObj).get("fragment")) instanceof String ? (String)v : null) == null) {
                    string = fragment = "";
                }
                if (((CharSequence)path).length() > 0) {
                    URIComponents uriComponents2 = new URIComponents(scheme, authority, path, query, fragment){
                        private final String scheme;
                        private final String authority;
                        private final String path;
                        private final String query;
                        private final String fragment;
                        {
                            this.scheme = $scheme;
                            this.authority = $authority;
                            this.path = $path;
                            this.query = $query;
                            this.fragment = $fragment;
                        }

                        public String getScheme() {
                            return this.scheme;
                        }

                        public String getAuthority() {
                            return this.authority;
                        }

                        public String getPath() {
                            return this.path;
                        }

                        public String getQuery() {
                            return this.query;
                        }

                        public String getFragment() {
                            return this.fragment;
                        }
                    };
                    uRI = URI.Companion.from$default(URI.Companion, uriComponents2, false, 2, null);
                } else {
                    uRI = null;
                }
            } else if (uriObj instanceof String) {
                URI uRI2;
                try {
                    uRI2 = URI.Companion.parse$default(URI.Companion, (String)uriObj, false, 2, null);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse URI string: " + uriObj, (Throwable)e);
                    uRI2 = null;
                }
                uRI = uRI2;
            } else {
                uRI = null;
            }
            URI resourceUri2 = uRI;
            return new ConfigurationOverrides(overrideIdentifier, resourceUri2);
        }
        catch (Exception e) {
            this.logger.error("Failed to convert configuration overrides: " + overridesMap, (Throwable)e);
            return null;
        }
    }

    private final String buildConfigurationKey(String baseKey, ConfigurationOverrides overrides, Boolean scopeToLanguage) {
        StringBuilder keyBuilder = new StringBuilder(baseKey);
        ConfigurationOverrides configurationOverrides = overrides;
        if (configurationOverrides != null) {
            ConfigurationOverrides it = configurationOverrides;
            boolean bl = false;
            String string = it.getOverrideIdentifier();
            if (string != null) {
                String identifier = string;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)scopeToLanguage, (Object)true)) {
                    keyBuilder.append(".").append(identifier);
                }
            }
            URI uRI = it.getResource();
            if (uRI != null) {
                URI uri = uRI;
                boolean bl3 = false;
                keyBuilder.append("@").append(uri.toString().hashCode());
            }
        }
        String string = keyBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Project getActiveProject() {
        Project project;
        block1: {
            Project[] openProjects;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project[] $this$firstOrNull$iv = openProjects = projectArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(it.isInitialized() && !it.isDisposed())) continue;
                project = element$iv;
                break block1;
            }
            project = null;
        }
        return project;
    }

    private final void storeValue(PropertiesComponent properties, String key, Object value) {
        Object object = value;
        if (object == null) {
            properties.unsetValue(key);
        } else if (object instanceof String) {
            properties.setValue(key, (String)value);
        } else if (object instanceof Boolean) {
            properties.setValue(key, ((Boolean)value).booleanValue());
        } else if (object instanceof Integer) {
            properties.setValue(key, ((Number)value).intValue(), 0);
        } else if (object instanceof Float) {
            properties.setValue(key, String.valueOf(((Number)value).floatValue()));
        } else if (object instanceof Double) {
            properties.setValue(key, String.valueOf(((Number)value).doubleValue()));
        } else if (object instanceof Long) {
            properties.setValue(key, String.valueOf(((Number)value).longValue()));
        } else {
            try {
                properties.setValue(key, value.toString());
            }
            catch (Exception e) {
                this.logger.error("Failed to serialize configuration value, type: " + value.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.logger.info("Releasing resources: MainThreadConfiguration");
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigurationTarget.values().length];
            try {
                nArray[ConfigurationTarget.APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationTarget.WORKSPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationTarget.WORKSPACE_FOLDER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationTarget.USER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationTarget.USER_LOCAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

