/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.utils.DiffRequest;
import cn.gitlab.kilo.jetbrains.utils.DiffUtilsKt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u001e\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\r0\u0012J\u0006\u0010\u0015\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/gitlab/kilo/jetbrains/utils/DiffService;", "", "<init>", "()V", "requestQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcn/gitlab/kilo/jetbrains/utils/DiffRequest;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "submitDiff", "", "oldText", "", "newText", "callback", "Lkotlin/Function1;", "Lkotlin/Pair;", "", "shutdown", "coderider-kilo-jetbrains"})
public final class DiffService {
    @NotNull
    public static final DiffService INSTANCE = new DiffService();
    @NotNull
    private static final BlockingQueue<DiffRequest> requestQueue = new LinkedBlockingQueue();
    @NotNull
    private static final AtomicBoolean running = new AtomicBoolean(true);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    private DiffService() {
    }

    public final void submitDiff(@NotNull CharSequence oldText, @NotNull CharSequence newText, @NotNull Function1<? super Pair<Integer, Integer>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        requestQueue.offer(new DiffRequest(oldText, newText, callback));
    }

    public final void shutdown() {
        running.set(false);
        executor.shutdownNow();
    }

    private static final void _init_$lambda$0() {
        while (running.get()) {
            try {
                DiffRequest request = requestQueue.take();
                Pair<Integer, Integer> result2 = DiffUtilsKt.diffLineCounts(request.getOldText(), request.getNewText());
                request.getCallback().invoke(result2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {}
        }
    }

    static {
        executor.submit(DiffService::_init_$lambda$0);
    }
}

