/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.FileIndexer;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.LineEdit;
import cn.gitlab.kilo.jetbrains.services.context.RecentFilesRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.TrackedFile;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001a\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/RecentFilesRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/RecentFilesRetrieverOptions;", "fileIndexer", "Lcn/gitlab/kilo/jetbrains/services/context/FileIndexer;", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "extractContextFromFile", "trackedFile", "Lcn/gitlab/kilo/jetbrains/services/context/TrackedFile;", "currentTime", "", "hasSignificantContent", "", "content", "calculateContentScore", "", "shouldUseAsContext", "currentLanguage", "targetLanguage", "getDocumentPath", "document", "Lcom/intellij/openapi/editor/Document;", "isSupportedForLanguageId", "languageId", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRecentFilesRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentFilesRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentFilesRetriever\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n31#2,2:141\n774#3:143\n865#3,2:144\n1068#3:146\n1869#3,2:147\n1068#3:149\n1788#3,4:151\n1788#3,4:155\n774#3:159\n865#3,2:160\n1#4:150\n*S KotlinDebug\n*F\n+ 1 RecentFilesRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentFilesRetriever\n*L\n22#1:141,2\n32#1:143\n32#1:144,2\n37#1:146\n42#1:147,2\n47#1:149\n98#1:151,4\n104#1:155,4\n106#1:159\n106#1:160,2\n*E\n"})
public final class RecentFilesRetriever
extends CachedRetriever {
    @NotNull
    private final Project project;
    @NotNull
    private final String identifier;
    @NotNull
    private final RecentFilesRetrieverOptions options;
    @NotNull
    private final FileIndexer fileIndexer;

    public RecentFilesRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.identifier = "RecentFiles";
        this.options = new RecentFilesRetrieverOptions(0L, 0, 0, 7, null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FileIndexer> serviceClass$iv = FileIndexer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.fileIndexer = (FileIndexer)object;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long currentTime = System.currentTimeMillis();
        String currentFilePath = this.getDocumentPath(options.getDocument());
        String currentLanguage = LanguageUtilsKt.getLanguageFromDocument(options.getDocument());
        List matches = new ArrayList();
        Collection<TrackedFile> collection = this.fileIndexer.getTrackedFiles().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TrackedFile trackedFile = (TrackedFile)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)trackedFile.getPath(), (Object)currentFilePath) && this.shouldUseAsContext(currentLanguage, trackedFile.getLanguage()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Comparable comparable;
                boolean bl;
                Object it;
                Object object;
                TrackedFile trackedFile = (TrackedFile)b;
                boolean bl2 = false;
                Iterator<T> iterator = ((Iterable)trackedFile.getEdits()).iterator();
                if (!iterator.hasNext()) {
                    object = null;
                } else {
                    it = (LineEdit)iterator.next();
                    bl = false;
                    it = ((LineEdit)it).getTimestamp();
                    while (iterator.hasNext()) {
                        Object it2 = (LineEdit)iterator.next();
                        $i$a$-maxOfOrNull-RecentFilesRetriever$doRetrieval$2$1 = false;
                        if (it.compareTo(it2 = (Comparable)Long.valueOf(((LineEdit)it2).getTimestamp())) >= 0) continue;
                        it = it2;
                    }
                    object = it;
                }
                Long l = (Long)object;
                trackedFile = (TrackedFile)a;
                Comparable comparable2 = Long.valueOf(l != null ? l : 0L);
                bl2 = false;
                iterator = ((Iterable)trackedFile.getEdits()).iterator();
                if (!iterator.hasNext()) {
                    comparable = null;
                } else {
                    it = (LineEdit)iterator.next();
                    bl = false;
                    Comparable comparable3 = Long.valueOf(((LineEdit)it).getTimestamp());
                    while (iterator.hasNext()) {
                        LineEdit it3 = (LineEdit)iterator.next();
                        $i$a$-maxOfOrNull-RecentFilesRetriever$doRetrieval$2$1 = false;
                        Comparable comparable4 = Long.valueOf(it3.getTimestamp());
                        if (comparable3.compareTo(comparable4) >= 0) continue;
                        comparable3 = comparable4;
                    }
                    comparable = comparable3;
                }
                Long l2 = (Long)comparable;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(l2 != null ? l2 : 0L));
            }
        }), (int)this.options.getMaxFiles());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedFile trackedFile = (TrackedFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)trackedFile);
            List<ContextSnippet> contextSnippets = this.extractContextFromFile(trackedFile, currentTime);
            matches.addAll((Collection)contextSnippets);
        }
        $this$sortedByDescending$iv = matches;
        $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ContextSnippet it = (ContextSnippet)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (ContextSnippet)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)20);
    }

    private final List<ContextSnippet> extractContextFromFile(TrackedFile trackedFile, long currentTime) {
        Comparable comparable;
        Document document = trackedFile.getDocument();
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String content2 = string;
        List lines = StringsKt.lines((CharSequence)content2);
        List snippets = new ArrayList();
        if (lines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterator iterator = ((Iterable)trackedFile.getEdits()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            LineEdit it = (LineEdit)iterator.next();
            boolean bl = false;
            Object object = it.getTimestamp();
            while (iterator.hasNext()) {
                Object it2 = (LineEdit)iterator.next();
                $i$a$-maxOfOrNull-RecentFilesRetriever$extractContextFromFile$mostRecentEdit$1 = false;
                if (object.compareTo(it2 = (Comparable)Long.valueOf(((LineEdit)it2).getTimestamp())) >= 0) continue;
                object = it2;
            }
            comparable = object;
        }
        Long l = (Long)comparable;
        long mostRecentEdit = l != null ? l : currentTime;
        long fileAge = currentTime - mostRecentEdit;
        double timeScore = Math.max(0.0, 1.0 - (double)fileAge / (double)this.options.getMaxAgeMs());
        int chunkSize = this.options.getWindowSize();
        int stepSize = chunkSize / 2;
        for (int startLine = 0; startLine < lines.size(); startLine += stepSize) {
            int endLine = Math.min(startLine + chunkSize, lines.size() - 1);
            List chunkLines = lines.subList(startLine, endLine + 1);
            String chunkContent = CollectionsKt.joinToString$default((Iterable)chunkLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            if (!(!StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)chunkContent)).toString())) || !this.hasSignificantContent(chunkContent)) continue;
            double contentScore = this.calculateContentScore(chunkContent);
            double finalScore = timeScore * 0.6 + contentScore * 0.4;
            snippets.add(new ContextSnippet(trackedFile.getPath(), startLine, endLine, chunkContent, finalScore, null, null, 96, null));
            if (stepSize > 0) continue;
            break;
        }
        return CollectionsKt.take((Iterable)snippets, (int)3);
    }

    private final boolean hasSignificantContent(String content2) {
        int n;
        Iterable $this$count$iv = StringsKt.lines((CharSequence)content2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int nonWhitespaceLines = n;
        return nonWhitespaceLines >= 5;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final double calculateContentScore(String content2) {
        int n;
        int nonEmptyLines;
        List lines = StringsKt.lines((CharSequence)content2);
        Iterable $this$count$iv = lines;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            return 0.3;
        }
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2 || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n2 = nonEmptyLines = count$iv;
        if (nonEmptyLines > 0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = lines;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl3 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            int n3 = 0;
            for (Object t : iterable) {
                void it;
                String $i$f$filterTo2 = (String)t;
                int n4 = n3;
                boolean bl = false;
                int n5 = it.length();
                n3 = n4 + n5;
            }
            n = n3 / nonEmptyLines;
        } else {
            n = 0;
        }
        int avgLineLength = n;
        if (nonEmptyLines < 5) {
            return 0.3;
        }
        boolean bl = 5 <= nonEmptyLines ? nonEmptyLines < 21 : false;
        if (bl) {
            boolean bl4;
            if (20 <= avgLineLength) {
                if (avgLineLength < 121) {
                    return 1.0;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) {
                return 1.0;
            }
        }
        if (21 > nonEmptyLines) return 0.6;
        if (nonEmptyLines >= 51) return 0.6;
        return 0.8;
    }

    private final boolean shouldUseAsContext(String currentLanguage, String targetLanguage) {
        if (currentLanguage == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)currentLanguage, (Object)targetLanguage)) {
            return true;
        }
        Object[] objectArray = new String[]{"html", "css", "javascript", "typescript", "jsx", "tsx"};
        Set webLanguages = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"java", "kotlin", "groovy"};
        Set jvmLanguages = SetsKt.setOf((Object[])objectArray2);
        return webLanguages.contains(currentLanguage) && webLanguages.contains(targetLanguage) ? true : jvmLanguages.contains(currentLanguage) && jvmLanguages.contains(targetLanguage);
    }

    private final String getDocumentPath(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }
}

