/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.psi.CallReference;
import cn.gitlab.kilo.jetbrains.psi.PsiUtils;
import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.ReferenceInfo;
import cn.gitlab.kilo.jetbrains.services.context.Selection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/GraphRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "isSupportedForLanguageId", "", "languageId", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGraphRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/GraphRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n1563#2:101\n1634#2,3:102\n1#3:105\n*S KotlinDebug\n*F\n+ 1 GraphRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/GraphRetriever\n*L\n24#1:97\n24#1:98,3\n38#1:101\n38#1:102,3\n*E\n"})
public final class GraphRetriever
extends CachedRetriever {
    @NotNull
    private final Project project;
    @NotNull
    private final String identifier;

    public GraphRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.identifier = "graph";
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Function0 produceRefs2 = () -> GraphRetriever.doRetrieval$lambda$2(options);
        Object object = ReadAction.nonBlocking(() -> GraphRetriever.doRetrieval$lambda$7(produceRefs2, options, this)).inSmartMode(this.project).withDocumentsCommitted(this.project).expireWith((Disposable)this.project).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (List)object;
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List doRetrieval$lambda$2(ContextRetrieverOptions $options) {
        List list;
        Selection selection = $options.getSelection();
        if (selection != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = PsiUtils.INSTANCE.getExtractedReferencesInRange($options.getPsiFile(), new Range(selection.getStart().getOffset(), selection.getEnd().getOffset()), $options.getLanguage());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void ref;
                CallReference callReference = (CallReference)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ReferenceInfo((CallReference)ref){
                    private final String definitionFilePath;
                    private final int defineStartLine;
                    private final int defineEndLine;
                    private final String definitionStr;
                    private final String symbol;
                    {
                        this.definitionFilePath = $ref.getDefinitionFilePath();
                        this.defineStartLine = $ref.getDefineStartLine();
                        this.defineEndLine = $ref.getDefineEndLine();
                        this.definitionStr = $ref.getDefinitionStr();
                        this.symbol = $ref.getSymbol();
                    }

                    public String getDefinitionFilePath() {
                        return this.definitionFilePath;
                    }

                    public int getDefineStartLine() {
                        return this.defineStartLine;
                    }

                    public int getDefineEndLine() {
                        return this.defineEndLine;
                    }

                    public String getDefinitionStr() {
                        return this.definitionStr;
                    }

                    public String getSymbol() {
                        return this.symbol;
                    }
                });
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$map$iv = PsiUtils.INSTANCE.getExtractedReferences($options.getPsiFile(), $options.getPosition().getOffset(), $options.getLanguage());
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CallReference ref = (CallReference)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ReferenceInfo(ref){
                    private final String definitionFilePath;
                    private final int defineStartLine;
                    private final int defineEndLine;
                    private final String definitionStr;
                    private final String symbol;
                    {
                        this.definitionFilePath = $ref.getDefinitionFilePath();
                        this.defineStartLine = $ref.getDefineStartLine();
                        this.defineEndLine = $ref.getDefineEndLine();
                        this.definitionStr = $ref.getDefinitionStr();
                        this.symbol = $ref.getSymbol();
                    }

                    public String getDefinitionFilePath() {
                        return this.definitionFilePath;
                    }

                    public int getDefineStartLine() {
                        return this.defineStartLine;
                    }

                    public int getDefineEndLine() {
                        return this.defineEndLine;
                    }

                    public String getDefinitionStr() {
                        return this.definitionStr;
                    }

                    public String getSymbol() {
                        return this.symbol;
                    }
                });
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final ContextSnippet doRetrieval$lambda$7$lambda$3(ReferenceInfo ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.getDefinitionFilePath();
        if (string == null) {
            return null;
        }
        String uri = string;
        return new ContextSnippet(uri, ref.getDefineStartLine(), ref.getDefineEndLine(), ref.getDefinitionStr(), 1.0, ref.getSymbol(), null, 64, null);
    }

    private static final String doRetrieval$lambda$7$lambda$4(ContextSnippet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUri() + ":" + it.getStartLine() + "-" + it.getEndLine();
    }

    private static final boolean doRetrieval$lambda$7$lambda$6(ContextRetrieverOptions $options, GraphRetriever this$0, ContextSnippet snippet) {
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)$options.getPsiFile()));
        if (virtualFile == null) {
            return true;
        }
        VirtualFile vFile = virtualFile;
        ProjectFileIndex.getInstance((Project)this$0.project).isInContent(vFile);
        boolean bl = false;
        return true;
    }

    private static final List doRetrieval$lambda$7(Function0 $produceRefs, ContextRetrieverOptions $options, GraphRetriever this$0) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)$produceRefs.invoke())), GraphRetriever::doRetrieval$lambda$7$lambda$3), GraphRetriever::doRetrieval$lambda$7$lambda$4), arg_0 -> GraphRetriever.doRetrieval$lambda$7$lambda$6($options, this$0, arg_0)));
    }
}

