/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.LineEdit;
import cn.gitlab.kilo.jetbrains.services.context.TrackedFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0011H\u0002J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u001c\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0'2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0016\u00102\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002030'H\u0016J\b\u00104\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/FileIndexer;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "maxAgeMs", "", "maxEditsPerFile", "", "editSessionTimeoutMs", "trackedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcn/gitlab/kilo/jetbrains/services/context/TrackedFile;", "getTrackedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "debounceTimers", "Lkotlinx/coroutines/Job;", "documentListeners", "Lcom/intellij/openapi/editor/Document;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "trackDocument", "", "document", "reconcileOutdatedEdits", "getDocumentPath", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "scheduleEditFinalization", "path", "trackedFile", "finalizeEditSession", "buildBeforeContent", "", "events", "minLine", "maxLine", "buildAfterContent", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileClosed", "after", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nFileIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileIndexer.kt\ncn/gitlab/kilo/jetbrains/services/context/FileIndexer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n13472#2,2:276\n1869#3:278\n774#3:279\n865#3,2:280\n1870#3:282\n1617#3,9:283\n1869#3:292\n1870#3:294\n1626#3:295\n1869#3,2:296\n1563#3:298\n1634#3,3:299\n1563#3:302\n1634#3,3:303\n1869#3,2:306\n1869#3,2:308\n1869#3,2:310\n1#4:293\n*S KotlinDebug\n*F\n+ 1 FileIndexer.kt\ncn/gitlab/kilo/jetbrains/services/context/FileIndexer\n*L\n54#1:276,2\n81#1:278\n82#1:279\n82#1:280,2\n81#1:282\n139#1:283,9\n139#1:292\n139#1:294\n139#1:295\n188#1:296,2\n207#1:298\n207#1:299,3\n214#1:302\n214#1:303,3\n241#1:306,2\n260#1:308,2\n264#1:310,2\n139#1:293\n*E\n"})
public final class FileIndexer
implements DocumentListener,
FileEditorManagerListener,
BulkFileListener,
Disposable {
    @NotNull
    private final Project project;
    private final long maxAgeMs;
    private final int maxEditsPerFile;
    private final long editSessionTimeoutMs;
    @NotNull
    private final ConcurrentHashMap<String, TrackedFile> trackedFiles;
    @NotNull
    private final ConcurrentHashMap<String, Job> debounceTimers;
    @NotNull
    private final ConcurrentHashMap<String, Document> documentListeners;
    @NotNull
    private final CoroutineScope coroutineScope;

    public FileIndexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.maxAgeMs = 600000L;
        this.maxEditsPerFile = 10;
        this.editSessionTimeoutMs = 10000L;
        this.trackedFiles = new ConcurrentHashMap();
        this.debounceTimers = new ConcurrentHashMap();
        this.documentListeners = new ConcurrentHashMap();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)this);
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        connection.subscribe(topic2, (Object)this);
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$forEach$iv = virtualFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Document document;
            VirtualFile virtualFile = (VirtualFile)element$iv;
            boolean bl = false;
            if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) continue;
            boolean bl2 = false;
            this.trackDocument(document);
        }
    }

    @NotNull
    public final ConcurrentHashMap<String, TrackedFile> getTrackedFiles() {
        return this.trackedFiles;
    }

    private final void trackDocument(Document document) {
        block3: {
            Object path;
            block2: {
                Object object = FileDocumentManager.getInstance().getFile(document);
                if (object == null || (object = object.getCanonicalPath()) == null) {
                    return;
                }
                path = object;
                String language = LanguageUtilsKt.getLanguageFromPath((String)path);
                if (!this.documentListeners.containsKey(path)) {
                    document.addDocumentListener((DocumentListener)this, (Disposable)this);
                    ((Map)this.documentListeners).put(path, document);
                }
                if (this.trackedFiles.containsKey(path)) break block2;
                ((Map)this.trackedFiles).put(path, new TrackedFile((String)path, language, document, null, null, 0L, 56, null));
                break block3;
            }
            TrackedFile trackedFile = this.trackedFiles.get(path);
            if (trackedFile == null) break block3;
            trackedFile.setDocument(document);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reconcileOutdatedEdits() {
        Collection<TrackedFile> collection = this.trackedFiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            TrackedFile trackedFile = (TrackedFile)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = trackedFile.getEdits();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineEdit edit = (LineEdit)element$iv$iv;
                boolean bl2 = false;
                if (!(System.currentTimeMillis() - edit.getTimestamp() < this.maxAgeMs)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validEdits = (List)destination$iv$iv;
            if (validEdits.size() == trackedFile.getEdits().size()) continue;
            trackedFile.getEdits().clear();
            trackedFile.getEdits().addAll(validEdits);
        }
    }

    private final String getDocumentPath(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile != null ? virtualFile.getCanonicalPath() : null;
    }

    public void documentChanged(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Document document = event2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String string = this.getDocumentPath(document2);
        if (string == null) {
            return;
        }
        String path = string;
        TrackedFile trackedFile = this.trackedFiles.get(path);
        if (trackedFile == null) {
            return;
        }
        TrackedFile trackedFile2 = trackedFile;
        long currentTime = System.currentTimeMillis();
        if (trackedFile2.getEditSessionStart() == 0L) {
            trackedFile2.setEditSessionStart(currentTime);
            this.scheduleEditFinalization(path, trackedFile2);
        }
        trackedFile2.getPendingChanges().add(event2);
        trackedFile2.setDocument(document2);
    }

    private final void scheduleEditFinalization(String path, TrackedFile trackedFile) {
        Job job = this.debounceTimers.get(path);
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        ((Map)this.debounceTimers).put(path, BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path, trackedFile, null){
            int label;
            final /* synthetic */ FileIndexer this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ TrackedFile $trackedFile;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$trackedFile = $trackedFile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)FileIndexer.access$getEditSessionTimeoutMs$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        FileIndexer.access$finalizeEditSession(this.this$0, this.$path, this.$trackedFile);
                        FileIndexer.access$getDebounceTimers$p(this.this$0).remove(this.$path);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeEditSession(String path, TrackedFile trackedFile) {
        void $this$mapNotNullTo$iv$iv;
        if (trackedFile.getPendingChanges().isEmpty()) {
            return;
        }
        Document document = trackedFile.getDocument();
        List<DocumentEvent> events = trackedFile.getPendingChanges();
        Iterable $this$mapNotNull$iv = events;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IntRange it$iv$iv;
            IntRange intRange;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DocumentEvent event2 = (DocumentEvent)element$iv$iv;
            boolean bl2 = false;
            try {
                int maxOffset = document.getTextLength();
                int safeStartOffset = RangesKt.coerceAtLeast((int)Math.min(event2.getOffset(), maxOffset - 1), (int)0);
                int safeEndOffset = RangesKt.coerceAtLeast((int)Math.min(event2.getOffset() + Math.max(event2.getOldLength(), event2.getNewLength()), maxOffset - 1), (int)0);
                int startLine = document.getLineNumber(safeStartOffset);
                int endLine = document.getLineNumber(safeEndOffset);
                intRange = new IntRange(startLine, endLine);
            }
            catch (IndexOutOfBoundsException e) {
                Logger.warn$default(ConstantsKt.getLogger(), "Skipping stale document event with invalid offset: " + event2.getOffset() + ", document length: " + document.getTextLength(), null, 2, null);
                intRange = null;
            }
            if (intRange == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List affectedLines = CollectionsKt.sorted((Iterable)CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)affectedLines);
        if (n == null) {
            return;
        }
        int minLine = n;
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)affectedLines);
        if (n2 == null) {
            return;
        }
        int maxLine = n2;
        List<String> beforeContent = this.buildBeforeContent(document, events, minLine, maxLine);
        List<String> afterContent = this.buildAfterContent(document, minLine, maxLine);
        if (!Intrinsics.areEqual(beforeContent, afterContent)) {
            LineEdit lineEdit = new LineEdit(trackedFile.getEditSessionStart(), minLine, maxLine, beforeContent, afterContent);
            trackedFile.getEdits().add(lineEdit);
            if (trackedFile.getEdits().size() > this.maxEditsPerFile) {
                trackedFile.getEdits().remove(0);
            }
        }
        trackedFile.getPendingChanges().clear();
        trackedFile.setEditSessionStart(0L);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> buildBeforeContent(Document document, List<? extends DocumentEvent> events, int minLine, int maxLine) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Object currentText = null;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        currentText = string;
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)events);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            DocumentEvent event2 = (DocumentEvent)element$iv2;
            boolean bl = false;
            try {
                int textLength = ((String)currentText).length();
                if (event2.getOffset() <= textLength && event2.getOffset() + event2.getNewFragment().length() <= textLength) {
                    String string2 = ((String)currentText).substring(0, event2.getOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    CharSequence charSequence = event2.getOldFragment();
                    String string3 = ((String)currentText).substring(event2.getOffset() + event2.getNewFragment().length());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String beforeText = string2 + charSequence + string3;
                    currentText = beforeText;
                    continue;
                }
                Logger.warn$default(ConstantsKt.getLogger(), "Skipping stale event in buildBeforeContent: offset=" + event2.getOffset() + ", newLength=" + event2.getNewFragment().length() + ", textLength=" + textLength, null, 2, null);
            }
            catch (StringIndexOutOfBoundsException e) {
                Logger.warn$default(ConstantsKt.getLogger(), "String operation failed in buildBeforeContent: " + e.getMessage(), null, 2, null);
            }
        }
        List lines = StringsKt.lines((CharSequence)((CharSequence)currentText));
        Iterable $this$map$iv = (Iterable)new IntRange(minLine, maxLine);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void lineNum;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(lineNum < lines.size() ? (String)lines.get((int)lineNum) : "");
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> buildAfterContent(Document document, int minLine, int maxLine) {
        void $this$mapTo$iv$iv;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List lines = StringsKt.lines((CharSequence)string);
        Iterable $this$map$iv = (Iterable)new IntRange(minLine, maxLine);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void lineNum;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(lineNum < lines.size() ? (String)lines.get((int)lineNum) : "");
        }
        return (List)destination$iv$iv;
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) break block0;
            Document document2 = document;
            boolean bl = false;
            this.reconcileOutdatedEdits();
            this.trackDocument(document2);
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        Document document = this.documentListeners.get(path);
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            document2.removeDocumentListener((DocumentListener)this);
            this.documentListeners.remove(path);
        }
        Job job = this.debounceTimers.get(path);
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.debounceTimers.remove(path);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedFile trackedFile;
            String newPath;
            String oldPath;
            VFileEvent event2 = (VFileEvent)element$iv;
            boolean bl = false;
            VFileEvent vFileEvent = event2;
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.trackedFiles.remove(((VFileDeleteEvent)event2).getFile().getUrl());
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((VFileMoveEvent)event2).getOldPath(), (String)"getOldPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)((VFileMoveEvent)event2).getFile().getPath(), (String)"getPath(...)");
            if (this.trackedFiles.get(oldPath) == null) continue;
            boolean bl2 = false;
            this.trackedFiles.remove(oldPath);
            ((Map)this.trackedFiles).put(newPath, TrackedFile.copy$default(trackedFile, newPath, null, null, null, null, 0L, 62, null));
        }
    }

    public void dispose() {
        Collection<Job> collection = this.debounceTimers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Job it = (Job)element$iv;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
        }
        this.debounceTimers.clear();
        Collection<Document> collection2 = this.documentListeners.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Document document = (Document)element$iv;
            boolean bl = false;
            document.removeDocumentListener((DocumentListener)this);
        }
        this.documentListeners.clear();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.trackedFiles.clear();
    }

    public static final /* synthetic */ long access$getEditSessionTimeoutMs$p(FileIndexer $this) {
        return $this.editSessionTimeoutMs;
    }

    public static final /* synthetic */ void access$finalizeEditSession(FileIndexer $this, String path, TrackedFile trackedFile) {
        $this.finalizeEditSession(path, trackedFile);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDebounceTimers$p(FileIndexer $this) {
        return $this.debounceTimers;
    }
}

