/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.BackendServer;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.GlobalStatus;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.LoginServerDiscovery;
import cn.gitlab.kilo.jetbrains.common.LoginViaPAT;
import cn.gitlab.kilo.jetbrains.common.MessageTip;
import cn.gitlab.kilo.jetbrains.common.Routed;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.services.GitlabHandler;
import cn.gitlab.kilo.jetbrains.services.IssueHandler;
import cn.gitlab.kilo.jetbrains.services.ProxyMessageService;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.FileUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostCommandsProxy;
import com.sina.weibo.agent.util.PromiseUtilsKt;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebviewMessageProxy;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J(\u0010\u0017\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ8\u0010\u0018\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0082@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService;", "Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "handle", "", "msg", "", "project", "Lcom/intellij/openapi/project/Project;", "webViewInstance", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/sina/weibo/agent/webview/WebViewInstance;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "injectVSUserAgent", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleDiscoverServers", "url", "handleLoginViaPAT", "PAT", "logUserIn", "execute", "syncVSLoginPAT", "gitlabHost", "coderiderHost", "pat", "savePAT", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProxyMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyMessageService.kt\ncn/gitlab/kilo/jetbrains/services/ProxyMessageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class ProxyMessageService
implements WebviewMessageProxy {
    @NotNull
    private final Logger logger = Logger.Companion.getInstance("LoginMessageService");

    @Nullable
    public final Object handle(@Nullable String msg, @NotNull Project project, @Nullable WebViewInstance webViewInstance, @NotNull Continuation<? super Boolean> $completion) {
        Object object;
        Object command;
        JsonObject jsonObject2 = JsonParser.parseString((String)msg).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        JsonObject msgJsonObject = jsonObject2;
        Object object2 = msgJsonObject.get("command");
        if (object2 == null || (object2 = object2.getAsString()) == null) {
            object2 = command = "";
        }
        if ((object = msgJsonObject.get("requestId")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object requestId = object;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        Logger.debug$default(this.logger, "command: " + (String)command + ", requestId: " + (String)requestId + ", msg: " + msg, null, 2, null);
        try {
            switch (command) {
                case "loginViaPAT": {
                    LoginViaPAT login;
                    String string3 = msg;
                    if (string3 != null) {
                        String it = string3;
                        boolean bl = false;
                        v6 = (LoginViaPAT)new Gson().fromJson(it, LoginViaPAT.class);
                    } else {
                        v6 = login = null;
                    }
                    if (login != null) {
                        this.handleLoginViaPAT(StringsKt.removeSuffix((String)login.getCoderiderHost(), (CharSequence)"/"), login.getToken(), project);
                        CockpitConfiguration.Companion.getInstance().getState().setSavePAT(login.getSavePAT());
                        if (login.getSavePAT()) {
                            CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(login.getToken());
                        }
                        CoderiderClientKt.refreshOtherProjects(project);
                    }
                    break;
                }
                case "routed": {
                    String it = msg;
                    boolean bl = false;
                    Routed routed = (Routed)new Gson().fromJson(it, Routed.class);
                    if (routed != null) {
                        Routed routed2 = routed;
                        boolean bl2 = false;
                        String string4 = System.getProperty("os.name");
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
                        String string5 = string4.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        String os2 = string5;
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"os", (Object)(SystemInfo.isMac ? "darwin" : os2)), TuplesKt.to((Object)"theme", (Object)ThemeUtilKt.getThemeIsDark())};
                        ThemeUtilKt.sendToWebview((ExtensionMessage)new GlobalStatus(null, MapsKt.mutableMapOf((Pair[])pairArray), 1, null), project);
                        if (Intrinsics.areEqual((Object)routed2.getPage(), (Object)"/issue_mr")) {
                            Logger.debug$default(this.logger, "initIssueMr begin", null, 2, null);
                            IssueHandler.INSTANCE.initIssueMr(project);
                            Logger.debug$default(this.logger, "initIssueMr end", null, 2, null);
                            return Boxing.boxBoolean((boolean)true);
                        }
                    }
                    break;
                }
                case "issueMrOpenProject": 
                case "issueMrGetIssue": 
                case "command": 
                case "issueMrGetDiff": {
                    String string6 = msg;
                    if (string6 != null) {
                        String it = string6;
                        boolean bl = false;
                        return GitlabHandler.INSTANCE.handle(project, (String)command, it);
                    }
                    break;
                }
                case "exportModelList": {
                    Logger.debug$default(this.logger, "exportModelList: Handling model export", null, 2, null);
                    JsonElement models = msgJsonObject.get("models");
                    if (models == null || models.isJsonNull()) {
                        Logger.warn$default(this.logger, "exportModelList: No model data in message payload", null, 2, null);
                        return Boxing.boxBoolean((boolean)false);
                    }
                    String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    String filename = "coderider_model_" + timestamp + ".json";
                    String string7 = new GsonBuilder().setPrettyPrinting().create().toJson(models);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                    FileUtilsKt.writeFile(project, filename, string7);
                    Logger.info$default(this.logger, "exportModelList: Successfully saved VSCode model data with " + models.getAsJsonArray().size() + " models", null, 2, null);
                    return Boxing.boxBoolean((boolean)true);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private final Object injectVSUserAgent(Project project, Continuation<? super Unit> $completion) {
        IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
        if (iRPCProtocol == null) {
            throw new IllegalStateException("RPC protocol is null; cannot inject UA");
        }
        IRPCProtocol rpc = iRPCProtocol;
        ExtHostCommandsProxy extHostCommandsProxy = rpc.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostCommands());
        if (extHostCommandsProxy == null) {
            throw new IllegalStateException("ExtHostCommands proxy not found; cannot inject UA");
        }
        ExtHostCommandsProxy proxy = extHostCommandsProxy;
        String ua = ClientUtilsKt.getSystemInfo();
        Object[] objectArray = new Object[]{ua};
        Object object = PromiseUtilsKt.await(proxy.executeContributedCommand("coderider-kilo.setUserAgent", objectArray), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void handleDiscoverServers(String url, Project project) {
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(url));
        CoderiderClientKt.getCoderiderClient().queryPublicConfig();
        CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
        String gitlabUrl = state.getGitlabHost();
        LoginServerDiscovery msg = new LoginServerDiscovery(null, new BackendServer(null, gitlabUrl, 1, null), 1, null);
        ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
    }

    private final void handleLoginViaPAT(String url, String PAT, Project project) {
        String tempUrl = url;
        if (tempUrl.equals("https://jihulab.com")) {
            tempUrl = "https://coderider.jihulab.com";
        }
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(tempUrl));
        try {
            CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(PAT);
            CoderiderClient.refreshMetaData$default(CoderiderClientKt.getCoderiderClient(), 0, 0L, 3, null);
        }
        catch (CustomException e) {
            Object message = "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage();
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"License Invalid", (boolean)false, (int)2, null) : false;
            if (bl) {
                message = I18nKt.getMessage("enterprise.coderider.license.invalid");
            }
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", (String)message, 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage(), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
            return;
        }
        this.logUserIn();
        Logger.info$default(this.logger, "command: handleLoginViaPAT, User Login Success!,url:" + url, null, 2, null);
    }

    private final void logUserIn() {
        TrackService.INSTANCE.activate();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object execute(@Nullable String var1_1, @NotNull Project var2_2, @NotNull WebViewInstance var3_3, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ProxyMessageService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = JsonParser.parseString((String)msg).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAsJsonObject(...)");
                msgJsonObject = v0;
                v1 /* !! */  = msgJsonObject.get("command");
                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getAsString()) == null) {
                    v1 /* !! */  = "";
                }
                $continuation.label = 1;
                v2 = this.handle((String)msg, (Project)project, (WebViewInstance)webViewInstance, (Continuation<? super Boolean>)$continuation);
                if (v2 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl26:
                // 2 sources

                v3 = (Boolean)v2;
                return Boxing.boxBoolean((boolean)(v3 != null ? v3 : false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object syncVSLoginPAT(Project project, String gitlabHost, String coderiderHost, String pat, Boolean savePAT, Continuation<? super Unit> $completion) {
        IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
        if (iRPCProtocol == null) {
            throw new IllegalStateException("RPC protocol is null; cannot sync VS login");
        }
        IRPCProtocol rpc = iRPCProtocol;
        ExtHostCommandsProxy extHostCommandsProxy = rpc.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostCommands());
        if (extHostCommandsProxy == null) {
            throw new IllegalStateException("ExtHostCommands proxy not found; cannot sync VS login");
        }
        ExtHostCommandsProxy proxy = extHostCommandsProxy;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"PAT"), TuplesKt.to((Object)"gitlabHost", (Object)gitlabHost), TuplesKt.to((Object)"coderiderHost", (Object)coderiderHost), TuplesKt.to((Object)"pat", (Object)pat), TuplesKt.to((Object)"savePAT", (Object)Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)savePAT, (Object)Boxing.boxBoolean((boolean)true))))};
        Map payload = MapsKt.mapOf((Pair[])pairArray);
        String payloadJson = new Gson().toJson((Object)payload);
        Object[] objectArray = new Object[]{payloadJson};
        Object object = PromiseUtilsKt.await(proxy.executeContributedCommand("coderider-kilo.syncLogin", objectArray), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$injectVSUserAgent(ProxyMessageService $this, Project project, Continuation $completion) {
        return $this.injectVSUserAgent(project, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$syncVSLoginPAT(ProxyMessageService $this, Project project, String gitlabHost, String coderiderHost, String pat, Boolean savePAT, Continuation $completion) {
        return $this.syncVSLoginPAT(project, gitlabHost, coderiderHost, pat, savePAT, (Continuation<? super Unit>)$completion);
    }
}

