/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.common.CustomQuery;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.services.ExtensionConfiguration;
import cn.gitlab.kilo.jetbrains.services.GitlabService;
import cn.gitlab.kilo.jetbrains.services.IssueHandlerKt;
import cn.gitlab.kilo.jetbrains.utils.GitlabUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gitlab4j.api.models.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcn/gitlab/kilo/jetbrains/services/IssueHandler;", "", "<init>", "()V", "initIssueMr", "", "project", "Lcom/intellij/openapi/project/Project;", "getExtensionConfiguration", "Lcn/gitlab/kilo/jetbrains/services/ExtensionConfiguration;", "coderider-kilo-jetbrains"})
public final class IssueHandler {
    @NotNull
    public static final IssueHandler INSTANCE = new IssueHandler();

    private IssueHandler() {
    }

    public final void initIssueMr(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String gitlabPath = GitlabUtilsKt.getGitlabPath(project);
        if (gitlabPath != null) {
            Project gitlabProject = GitlabService.INSTANCE.getProjectByPath(gitlabPath);
            if (gitlabProject != null) {
                try {
                    Pair[] pairArray = new Pair[2];
                    pairArray[0] = TuplesKt.to((Object)"type", (Object)"issueMrConfig");
                    Pair[] pairArray2 = new Pair[3];
                    pairArray2[0] = TuplesKt.to((Object)"type", (Object)"get_project");
                    Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"name", (Object)gitlabProject.getName()), TuplesKt.to((Object)"rootFsPath", (Object)project.getBasePath()), TuplesKt.to((Object)"assignProject", null)};
                    pairArray2[1] = TuplesKt.to((Object)"project", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray3)));
                    pairArray2[2] = TuplesKt.to((Object)"customQueries", this.getExtensionConfiguration().getCustomQueries());
                    pairArray[1] = TuplesKt.to((Object)"config", (Object)MapsKt.mapOf((Pair[])pairArray2));
                    ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), project);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Pair[] e = new Pair[3];
                    e[0] = TuplesKt.to((Object)"type", (Object)"issueMrConfig");
                    Pair[] pairArray = new Pair[3];
                    pairArray[0] = TuplesKt.to((Object)"type", (Object)"get_project");
                    Pair[] pairArray4 = new Pair[]{TuplesKt.to((Object)"name", (Object)(project.getName() + I18nKt.getMessage("not.hosted.on") + CockpitConfiguration.Companion.getInstance().getState().getGitlabHost())), TuplesKt.to((Object)"assignProject", (Object)true)};
                    pairArray[1] = TuplesKt.to((Object)"project", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray4)));
                    pairArray[2] = TuplesKt.to((Object)"customQueries", this.getExtensionConfiguration().getCustomQueries());
                    e[1] = TuplesKt.to((Object)"config", (Object)MapsKt.mapOf((Pair[])pairArray));
                    e[2] = TuplesKt.to((Object)"pointer", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"repository", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"rootFsPath", (Object)"")))));
                    ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])e), project);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NotNull
    public final ExtensionConfiguration getExtensionConfiguration() {
        List<CustomQuery> list = IssueHandlerKt.getDefaultCustomQuery();
        return new ExtensionConfiguration("helloworld", true, null, list);
    }
}

