/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.common.Config;
import cn.gitlab.kilo.jetbrains.common.Credentials;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.CustomQuery;
import cn.gitlab.kilo.jetbrains.common.GetDiscussionsOptions;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.PageInfo;
import cn.gitlab.kilo.jetbrains.common.PostMessage;
import cn.gitlab.kilo.jetbrains.common.ReviewParams;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.constants.GitlabContantsKt;
import cn.gitlab.kilo.jetbrains.editor.GitlabBrowserEditorKt;
import cn.gitlab.kilo.jetbrains.services.CustomQueryType;
import cn.gitlab.kilo.jetbrains.services.GsonExclusionStrategy;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.GitlabUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gitlab4j.api.models.Author;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00172\b\b\u0002\u0010\u0018\u001a\u00020\nJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u001a\u001a\u00020\u000bJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u001a\u001a\u00020\u000bJ\u001e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u000bJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\nJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\nJ\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"J\u001f\u0010+\u001a\u0002H,\"\n\b\u0000\u0010,*\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u0002H,\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u0004\u0018\u00010%J\u0016\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\n2\u0006\u0010\u001a\u001a\u000200J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020)2\u0006\u0010*\u001a\u000205J\u0016\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\"\u0010>\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\n2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\nJ2\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\nJ\u0016\u0010E\u001a\u0002032\u0006\u0010F\u001a\u00020)2\u0006\u0010*\u001a\u000205J\u0010\u0010G\u001a\u0004\u0018\u00010\u000b2\u0006\u0010A\u001a\u00020\u000bJ\u0018\u0010H\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nH\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcn/gitlab/kilo/jetbrains/services/GitlabService;", "", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "versionCache", "", "", "Lcom/google/gson/JsonObject;", "getVersionCache", "()Ljava/util/Map;", "gson", "Lcom/google/gson/Gson;", "gsonNormal", "client", "Lokhttp3/OkHttpClient;", "fetchAllPages", "", "apiResourcePath", "query", "", "resourceName", "getLabelEvents", "issuable", "getDiscussionsAndLabelEvents", "createDiffNote", "mrId", "", "body", "position", "getProjectByPath", "Lorg/gitlab4j/api/models/Project;", "path", "getFirstUserByUsername", "Lorg/gitlab4j/api/models/User;", "username", "getIssuables", "params", "Lcn/gitlab/kilo/jetbrains/common/CustomQuery;", "project", "handleCurrentUser", "S", "(Ljava/lang/String;)Ljava/lang/String;", "getCurrentUser", "normalizeAvatarUrl", "Lorg/gitlab4j/api/models/Issue;", "instanceUrl", "getIssue", "", "req", "Lcom/intellij/openapi/project/Project;", "getDiscussionsStr", "issueIid", "projectId", "getDiscussions", "options", "Lcn/gitlab/kilo/jetbrains/common/GetDiscussionsOptions;", "isMr", "", "createNote", "replyId", "getBaseAndHeadUri", "mr", "mrVersion", "file", "repositoryPath", "getMrDiff", "signal", "getMrVision", "fetch", "context", "baseUrlBuilderFrom", "Lokhttp3/HttpUrl$Builder;", "url", "Ljava/net/URL;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitlabService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabService.kt\ncn/gitlab/kilo/jetbrains/services/GitlabService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,777:1\n1869#2,2:778\n1869#2,2:780\n1869#2,2:801\n774#2:803\n865#2,2:804\n1563#2:806\n1634#2,3:807\n1563#2:810\n1634#2,3:811\n774#2:815\n865#2,2:816\n1563#2:818\n1634#2,3:819\n1563#2:822\n1634#2,3:823\n1#3:782\n504#4,7:783\n504#4,7:790\n216#5,2:797\n216#5,2:799\n40#6:814\n*S KotlinDebug\n*F\n+ 1 GitlabService.kt\ncn/gitlab/kilo/jetbrains/services/GitlabService\n*L\n69#1:778,2\n82#1:780,2\n380#1:801,2\n514#1:803\n514#1:804,2\n515#1:806\n515#1:807,3\n537#1:810\n537#1:811,3\n667#1:815\n667#1:816,2\n670#1:818\n670#1:819,3\n677#1:822\n677#1:823,3\n330#1:783,7\n350#1:790,7\n358#1:797,2\n359#1:799,2\n662#1:814\n*E\n"})
public final class GitlabService {
    @NotNull
    public static final GitlabService INSTANCE = new GitlabService();
    @NotNull
    private static final Logger logger = Logger.Companion.getInstance("GitlabService");
    @NotNull
    private static final Map<String, JsonObject> versionCache;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final Gson gsonNormal;
    @NotNull
    private static final OkHttpClient client;

    private GitlabService() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Map<String, JsonObject> getVersionCache() {
        return versionCache;
    }

    @NotNull
    public final List<JsonObject> fetchAllPages(@NotNull String apiResourcePath, @NotNull Map<String, String> query, @NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)apiResourcePath, (String)"apiResourcePath");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Credentials credentials = GitlabUtilsKt.getCredentials();
        String instanceUrl = credentials.getInstanceUrl();
        Gson gson = new Gson();
        String url = instanceUrl + "/api/v4" + apiResourcePath + GitlabUtilsKt.createQueryString(query);
        Response result2 = GitlabUtilsKt.crossFetch(url);
        GitlabUtilsKt.handleFetchError$default(url, result2, resourceName, null, 8, null);
        int totalPages = GitlabUtilsKt.getTotalPages(result2);
        int currentPage = GitlabUtilsKt.getCurrentPage(query);
        List allResults = new ArrayList();
        Object object = result2.body();
        if (object == null || (object = object.string()) == null) {
            object = "";
        }
        JsonArray currentResults = JsonParser.parseString((String)object).getAsJsonArray();
        Intrinsics.checkNotNull((Object)currentResults);
        Iterable $this$forEach$iv = (Iterable)currentResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonElement it = (JsonElement)element$iv;
            boolean bl = false;
            JsonObject jsonObject2 = it.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            allResults.add(jsonObject2);
        }
        for (int nextPage = currentPage + 1; nextPage <= totalPages; ++nextPage) {
            String nextUrl = instanceUrl + "/api/v4" + apiResourcePath + GitlabUtilsKt.createQueryString(MapsKt.plus(query, (Pair)TuplesKt.to((Object)"page", (Object)String.valueOf(nextPage))));
            Response nextResult = GitlabUtilsKt.crossFetch(nextUrl);
            GitlabUtilsKt.handleFetchError$default(url, nextResult, resourceName, null, 8, null);
            Object object2 = nextResult.body();
            if (object2 == null || (object2 = object2.string()) == null) {
                object2 = "";
            }
            JsonArray nextResults = JsonParser.parseString((String)object2).getAsJsonArray();
            Intrinsics.checkNotNull((Object)nextResults);
            Iterable $this$forEach$iv2 = (Iterable)nextResults;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                JsonElement it = (JsonElement)element$iv;
                boolean bl = false;
                JsonObject jsonObject3 = it.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"getAsJsonObject(...)");
                allResults.add(jsonObject3);
            }
        }
        return allResults;
    }

    public static /* synthetic */ List fetchAllPages$default(GitlabService gitlabService, String string, Map map, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            string2 = "resource";
        }
        return gitlabService.fetchAllPages(string, map, string2);
    }

    @NotNull
    public final List<JsonObject> getLabelEvents(@NotNull JsonObject issuable) {
        String string;
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        String type2 = GitlabBrowserEditorKt.isMr(issuable) ? "merge_requests" : "issues";
        JsonElement jsonElement = issuable.get("project_id");
        String it = string = jsonElement != null ? jsonElement.getAsString() : null;
        boolean bl = false;
        String string2 = !issuable.get("project_id").isJsonNull() ? string : null;
        JsonElement jsonElement2 = issuable.get("iid");
        it = string = jsonElement2 != null ? jsonElement2.getAsString() : null;
        String string3 = type2;
        String string4 = string2;
        boolean bl2 = false;
        boolean bl3 = !issuable.get("iid").isJsonNull();
        String labelEventsPath = "/projects/" + string4 + "/" + string3 + "/" + (bl3 ? string : null) + "/resource_label_events";
        return this.fetchAllPages(labelEventsPath, MapsKt.mapOf((Pair)TuplesKt.to((Object)"sort", (Object)"asc")), "label events");
    }

    @NotNull
    public final List<JsonObject> getDiscussionsAndLabelEvents(@NotNull JsonObject issuable) {
        List list;
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        List<JsonObject> discussions = this.getDiscussions(new GetDiscussionsOptions(issuable, null, 2, null), GitlabBrowserEditorKt.isMr(issuable));
        List<JsonObject> labelEvents = this.getLabelEvents(issuable);
        List $this$getDiscussionsAndLabelEvents_u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        $this$getDiscussionsAndLabelEvents_u24lambda_u244.addAll((Collection)discussions);
        $this$getDiscussionsAndLabelEvents_u24lambda_u244.addAll((Collection)labelEvents);
        List combinedEvents = list;
        CollectionsKt.sortWith((List)combinedEvents, (arg_0, arg_1) -> GitlabService.getDiscussionsAndLabelEvents$lambda$10(GitlabService::getDiscussionsAndLabelEvents$lambda$9, arg_0, arg_1));
        return combinedEvents;
    }

    @NotNull
    public final JsonObject createDiffNote(int mrId, @NotNull String body, @NotNull JsonObject position) {
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        try {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"issuableId", (Object)GitlabUtilsKt.getGetMrGqlId().invoke((Object)mrId)), TuplesKt.to((Object)"body", (Object)body), TuplesKt.to((Object)"position", (Object)position)};
            JsonObject result2 = GitlabUtilsKt.graphqlRequest$default(GitlabContantsKt.getCreateDiffNoteMutation(), MapsKt.mapOf((Pair[])pairArray), null, 4, null);
            JsonObject jsonObject3 = result2;
            JsonObject discussion = jsonObject3 != null && (jsonObject3 = jsonObject3.get("createDiffNote")) != null && (jsonObject3 = jsonObject3.getAsJsonObject()) != null && (jsonObject3 = jsonObject3.get("note")) != null && (jsonObject3 = jsonObject3.getAsJsonObject()) != null && (jsonObject3 = jsonObject3.get("discussion")) != null ? jsonObject3.getAsJsonObject() : null;
            if (discussion == null) {
                boolean bl = false;
                String string = "Response doesn't contain a note with discussion: " + result2;
                throw new IllegalArgumentException(string.toString());
            }
            jsonObject2 = discussion;
        }
        catch (Exception e) {
            throw new CustomException("Unable to add comment. Try again." + new Exception("MR(" + mrId + "), " + position + ", " + e.getMessage(), e));
        }
        return jsonObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Project getProjectByPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        CockpitConfiguration.PluginState configuration = CockpitConfiguration.Companion.getInstance().getState();
        String string = configuration.getGitlabPAT();
        if (string == null) {
            throw new IllegalStateException("Access token not configured");
        }
        String accessToken = string;
        URL gitlabHost = new URL(configuration.getGitlabHost());
        HttpUrl url = this.baseUrlBuilderFrom(gitlabHost).addPathSegments("api/v4/projects").addPathSegment(path).build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Closeable closeable = (Closeable)client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Project project;
                String jsonStr;
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    Logger.warn$default(logger, "Request failed: " + response.code() + " - " + response.message(), null, 2, null);
                    Project project2 = null;
                    return project2;
                }
                ResponseBody responseBody = response.body();
                String string2 = jsonStr = responseBody != null ? responseBody.string() : null;
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    project = (Project)gson.fromJson(it, Project.class);
                } else {
                    project = null;
                }
                Project project3 = project;
                return project3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            logger.info("Unexpected error occurred: " + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final User getFirstUserByUsername(@NotNull String username) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        CockpitConfiguration.PluginState configuration = CockpitConfiguration.Companion.getInstance().getState();
        String string = configuration.getGitlabPAT();
        if (string == null) {
            throw new IllegalStateException("Access token not configured");
        }
        String accessToken = string;
        URL gitlabHost = new URL(configuration.getGitlabHost());
        HttpUrl url = this.baseUrlBuilderFrom(gitlabHost).addPathSegments("api/v4/users").addQueryParameter("username", username).build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            User user;
            closeable = (Closeable)client.newCall(request).execute();
            Throwable throwable = null;
            try {
                User[] userArray;
                String jsonStr;
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Failed to fetch user: HTTP " + response.code());
                }
                ResponseBody responseBody = response.body();
                String string2 = jsonStr = responseBody != null ? responseBody.string() : null;
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    userArray = (User[])gson.fromJson(it, User[].class);
                } else {
                    userArray = null;
                }
                User[] users = userArray;
                user = users != null ? (User)ArraysKt.firstOrNull(users) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = user;
        }
        catch (IOException e) {
            e.printStackTrace();
            closeable = null;
        }
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<JsonObject> getIssuables(@NotNull CustomQuery params, @NotNull Project project) {
        String key;
        Map.Entry entry;
        Map.Entry element$iv;
        Map map;
        String searchKind;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CustomQueryType customQueryType = params.getType();
        String type2 = customQueryType != null ? customQueryType.getValue() : null;
        String scope = params.getScope();
        String state = params.getState();
        String author = params.getAuthor();
        String assignee = params.getAssignee();
        String wip = params.getWip();
        String reviewer = params.getReviewer();
        String searchIn = params.getSearchIn();
        Pair[] pairArray = new Pair[3];
        String string = type2;
        if (string == null) {
            string = "merge_requests";
        }
        pairArray[0] = TuplesKt.to((Object)"type", (Object)string);
        String string2 = scope;
        if (string2 == null) {
            string2 = "all";
        }
        pairArray[1] = TuplesKt.to((Object)"scope", (Object)string2);
        String string3 = state;
        if (string3 == null) {
            string3 = "opened";
        }
        pairArray[2] = TuplesKt.to((Object)"state", (Object)string3);
        Map config2 = MapsKt.mutableMapOf((Pair[])pairArray);
        if (Intrinsics.areEqual(config2.get("type"), (Object)"vulnerabilities") && !Intrinsics.areEqual(config2.get("scope"), (Object)"dismissed")) {
            config2.put("scope", "all");
        } else if ((Intrinsics.areEqual(config2.get("type"), (Object)"issues") || Intrinsics.areEqual(config2.get("type"), (Object)"merge_requests")) && !Intrinsics.areEqual(config2.get("scope"), (Object)"assigned_to_me") && !Intrinsics.areEqual(config2.get("scope"), (Object)"created_by_me")) {
            config2.put("scope", "all");
        }
        Object path = "";
        Pair[] pairArray2 = new Pair[1];
        Object v = config2.get("state");
        Intrinsics.checkNotNull(v);
        pairArray2[0] = TuplesKt.to((Object)"state", v);
        Map search = MapsKt.mutableMapOf((Pair[])pairArray2);
        if (Intrinsics.areEqual(config2.get("type"), (Object)"epics")) {
            if (project.getId() == null) return CollectionsKt.emptyList();
            path = "/groups/" + project.getId() + "/" + config2.get("type");
            search.put("include_ancestor_groups", "true");
        } else {
            String string4;
            if (Intrinsics.areEqual(config2.get("type"), (Object)"vulnerability_findings")) {
                string4 = "vulnerability_findings";
            } else {
                Object v2 = config2.get("type");
                Intrinsics.checkNotNull(v2);
                string4 = (String)v2;
            }
            searchKind = string4;
            path = "/projects/" + project.getId() + "/" + searchKind;
            Object v3 = config2.get("scope");
            Intrinsics.checkNotNull(v3);
            search.put("scope", v3);
        }
        if (Intrinsics.areEqual(config2.get("type"), (Object)"issues")) {
            String string5 = author;
            if (string5 != null) {
                String string6 = string5;
                boolean bl = false;
                search.put("author_username", string6);
            }
        } else {
            String string7 = author;
            if (string7 != null) {
                User authorUser;
                String string8 = string7;
                boolean bl = false;
                User user = authorUser = INSTANCE.getFirstUserByUsername(string8);
                if (user != null) {
                    User user2 = user;
                    boolean bl2 = false;
                    search.put("author_id", user2.getId().toString());
                }
            }
        }
        searchKind = assignee;
        if (Intrinsics.areEqual((Object)searchKind, (Object)"Any") || Intrinsics.areEqual((Object)searchKind, (Object)"None")) {
            search.put("assignee_id", assignee);
        } else if (assignee != null && Intrinsics.areEqual(config2.get("type"), (Object)"issues")) {
            search.put("assignee_username", assignee);
        } else if (assignee != null) {
            User user;
            User user3 = user = this.getFirstUserByUsername(assignee);
            if (user3 != null) {
                User user4 = user3;
                boolean bl = false;
                search.put("assignee_id", user4.getId().toString());
            }
        }
        String string9 = reviewer;
        if (string9 != null) {
            String string10 = string9;
            boolean bl = false;
            search.put("reviewer_username", INSTANCE.handleCurrentUser(string10));
        }
        if (searchIn != null) {
            if (Intrinsics.areEqual((Object)searchIn, (Object)"all")) {
                searchIn = "title,description";
            }
            search.put("in", searchIn);
        }
        if (!Intrinsics.areEqual(config2.get("type"), (Object)"merge_requests") || wip != null) {
            // empty if block
        }
        if (Intrinsics.areEqual(config2.get("type"), (Object)"issues")) {
            Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"confidential", (Object)params.getConfidential()), TuplesKt.to((Object)"not[labels]", params.getExcludeLabels()), TuplesKt.to((Object)"not[milestone]", (Object)params.getExcludeMilestone()), TuplesKt.to((Object)"not[author_username]", (Object)this.handleCurrentUser(params.getExcludeAuthor())), TuplesKt.to((Object)"not[assignee_username]", (Object)this.handleCurrentUser(params.getExcludeAssignee())), TuplesKt.to((Object)"not[search]", (Object)params.getExcludeSearch()), TuplesKt.to((Object)"not[in]", (Object)params.getExcludeSearchIn())};
            Map map2 = MapsKt.mapOf((Pair[])pairArray3);
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : map2.entrySet()) {
                Object it = entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        Map issueQueryParams = map;
        Pair[] $i$f$filterValues = new Pair[]{TuplesKt.to((Object)"labels", params.getLabels()), TuplesKt.to((Object)"milestone", (Object)params.getMilestone()), TuplesKt.to((Object)"search", (Object)params.getSearch()), TuplesKt.to((Object)"created_before", (Object)params.getCreatedBefore()), TuplesKt.to((Object)"created_after", (Object)params.getCreatedAfter()), TuplesKt.to((Object)"updated_before", (Object)params.getUpdatedBefore()), TuplesKt.to((Object)"updated_after", (Object)params.getUpdatedAfter()), TuplesKt.to((Object)"order_by", (Object)params.getOrderBy()), TuplesKt.to((Object)"sort", (Object)params.getSort()), TuplesKt.to((Object)"per_page", (Object)params.getMaxResults()), TuplesKt.to((Object)"report_type", params.getReportTypes()), TuplesKt.to((Object)"severity", params.getSeverityLevels()), TuplesKt.to((Object)"confidence", params.getConfidenceLevels())};
        Map $this$filterValues$iv = MapsKt.plus((Map)MapsKt.mapOf((Pair[])$i$f$filterValues), (Map)issueQueryParams);
        boolean $i$f$filterValues2 = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map3 = result$iv;
        CockpitConfiguration.PluginState configuration = CockpitConfiguration.Companion.getInstance().getState();
        String string11 = configuration.getGitlabPAT();
        if (string11 == null) {
            throw new IllegalStateException("Access token not configured");
        }
        String accessToken = string11;
        URL gitlabHost = new URL(configuration.getGitlabHost());
        HttpUrl.Builder urlBuilder = this.baseUrlBuilderFrom(gitlabHost).addPathSegments("api/v4" + (String)path);
        Map $this$forEach$iv = search;
        boolean $i$f$forEach = false;
        Object bl = $this$forEach$iv.entrySet().iterator();
        while (bl.hasNext()) {
            entry = element$iv = bl.next();
            boolean bl3 = false;
            key = (String)entry.getKey();
            String string12 = (String)entry.getValue();
            urlBuilder.addQueryParameter(key, string12.toString());
        }
        $this$forEach$iv = map3;
        $i$f$forEach = false;
        bl = $this$forEach$iv.entrySet().iterator();
        while (bl.hasNext()) {
            entry = element$iv = bl.next();
            boolean bl4 = false;
            key = (String)entry.getKey();
            Object v4 = entry.getValue();
            if (v4 == null || Intrinsics.areEqual(v4, (Object)"")) continue;
            urlBuilder.addQueryParameter(key, v4.toString());
        }
        Request request = new Request.Builder().url(urlBuilder.build()).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            List list;
            Closeable closeable = (Closeable)client.newCall(request).execute();
            bl = null;
            try {
                Response response = (Response)closeable;
                boolean bl5 = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Failed to fetch issuables: HTTP " + response.code());
                }
                ResponseBody responseBody = response.body();
                String jsonStr = responseBody != null ? responseBody.string() : null;
                JsonArray jsonArray = JsonParser.parseString((String)jsonStr).getAsJsonArray();
                List list2 = new ArrayList();
                JsonArray jsonArray2 = jsonArray;
                Intrinsics.checkNotNull((Object)jsonArray2);
                Iterable $this$forEach$iv2 = (Iterable)jsonArray2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    JsonElement it = (JsonElement)element$iv2;
                    boolean bl6 = false;
                    JsonObject jsonObject2 = it.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                    list2.add(jsonObject2);
                }
                list = list2;
            }
            catch (Throwable throwable) {
                try {
                    bl = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)closeable, bl);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)bl);
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return CollectionsKt.emptyList();
        }
    }

    public final <S extends String> S handleCurrentUser(S username) {
        Object object;
        if (Intrinsics.areEqual(username, (Object)"<current_user>")) {
            User user;
            User user2 = user = this.getCurrentUser();
            object = user2 != null ? user2.getUsername() : null;
        } else {
            object = username;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final User getCurrentUser() {
        Closeable closeable;
        CockpitConfiguration.PluginState configuration = CockpitConfiguration.Companion.getInstance().getState();
        String string = configuration.getGitlabPAT();
        if (string == null) {
            throw new IllegalStateException("Access token not configured");
        }
        String accessToken = string;
        URL gitlabHost = new URL(configuration.getGitlabHost());
        HttpUrl url = this.baseUrlBuilderFrom(gitlabHost).addPathSegments("api/v4/user").build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            User user;
            closeable = (Closeable)client.newCall(request).execute();
            Throwable throwable = null;
            try {
                User user2;
                String jsonStr;
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Failed to fetch current user: HTTP " + response.code());
                }
                ResponseBody responseBody = response.body();
                String string2 = jsonStr = responseBody != null ? responseBody.string() : null;
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    user2 = (User)gson.fromJson(it, User.class);
                } else {
                    user2 = null;
                }
                user = user2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = user;
        }
        catch (IOException e) {
            e.printStackTrace();
            closeable = null;
        }
        return closeable;
    }

    @NotNull
    public final Issue normalizeAvatarUrl(@NotNull String instanceUrl, @NotNull Issue issuable) {
        Author author;
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        Author author2 = author = issuable.getAuthor();
        CharSequence charSequence = author2 != null ? author2.getAvatarUrl() : null;
        if (charSequence == null || charSequence.length() == 0) {
            return issuable;
        }
        return issuable;
    }

    public final void getIssue(@NotNull CustomQuery req, @NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project gitlabProject = this.getProjectByPath(GitlabUtilsKt.getGitlabPath(project));
        if (gitlabProject != null) {
            List<JsonObject> issues = this.getIssuables(req, gitlabProject);
            String jsonStr = gsonNormal.toJson((Object)new PostMessage("issueMrConfig", new Config("get_issue", issues, req)));
            Intrinsics.checkNotNull((Object)jsonStr);
            ThemeUtilKt.sendToWebview(jsonStr, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getDiscussionsStr(@NotNull String issueIid, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)issueIid, (String)"issueIid");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        CockpitConfiguration.PluginState configuration = CockpitConfiguration.Companion.getInstance().getState();
        String string = configuration.getGitlabPAT();
        if (string == null) {
            throw new IllegalStateException("Access token not configured");
        }
        String accessToken = string;
        OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().build();
        String url = configuration.getGitlabHost() + "/api/v4/projects/" + projectId + "/issues/" + issueIid + "/discussions";
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Object responseBody;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IOException("Response body is null");
            }
            Object object2 = responseBody = object;
            return object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsonObject> getDiscussions(@NotNull GetDiscussionsOptions options, boolean isMr) {
        void $this$mapTo$iv$iv;
        PageInfo pageInfo;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        JsonElement it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JsonElement jsonElement;
        void it2;
        JsonElement jsonElement2;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String instanceUrl = CockpitConfiguration.Companion.getInstance().getState().getGitlabHost();
        String namespaceWithPath = GitlabUtilsKt.getNamespaceWithPath(options.getIssuable());
        String query = isMr ? GitlabContantsKt.getGetMrDiscussionsQuery() : GitlabContantsKt.getGetIssueDiscussionsQuery();
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"namespaceWithPath", (Object)namespaceWithPath);
        JsonElement jsonElement3 = jsonElement2 = options.getIssuable().get("iid");
        String string = "iid";
        int n = 1;
        Object object = pairArray;
        boolean $i$a$-takeIf-GitlabService$getDiscussions$variables$22 = false;
        boolean bl = !it2.isJsonNull();
        Object object2 = bl ? jsonElement2 : null;
        object[n] = TuplesKt.to((Object)string, (Object)(object2 != null ? object2.getAsString() : null));
        pairArray[2] = TuplesKt.to((Object)"afterCursor", (Object)options.getEndCursor());
        Map variables = MapsKt.mapOf((Pair[])pairArray);
        JsonObject jsonObject2 = GitlabUtilsKt.graphqlRequest(query, variables, instanceUrl);
        if (jsonObject2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject result2 = jsonObject2;
        JsonObject jsonObject3 = result2.get("project").getAsJsonObject();
        if (jsonObject3 == null) {
            throw new IllegalArgumentException("Project " + namespaceWithPath + " was not found.");
        }
        JsonObject project = jsonObject3;
        JsonElement jsonElement4 = project.get("issue");
        if ((jsonElement4 == null || (jsonElement4 = jsonElement4.getAsJsonObject()) == null || (jsonElement4 = jsonElement4.get("discussions")) == null || (jsonElement4 = jsonElement4.getAsJsonObject()) == null) && ((jsonElement = project.get("mergeRequest")) != null && (jsonElement = jsonElement.getAsJsonObject()) != null && (jsonElement = jsonElement.get("discussions")) != null ? jsonElement.getAsJsonObject() : (jsonElement4 = null)) == null) {
            JsonElement jsonElement5;
            JsonElement it3 = jsonElement5 = options.getIssuable().get("webUrl");
            boolean bl2 = false;
            Object object3 = !it3.isJsonNull() ? jsonElement5 : null;
            String string2 = "Discussions for issuable " + (object3 != null ? object3.getAsString() : null) + " were not found.";
            throw new IllegalArgumentException(string2);
        }
        JsonElement discussions = jsonElement4;
        JsonArray jsonArray = discussions.get("nodes").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        Iterable $i$a$-takeIf-GitlabService$getDiscussions$variables$22 = (Iterable)jsonArray;
        boolean $i$f$filter = false;
        void var13_30 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JsonElement)element$iv$iv;
            boolean bl3 = false;
            if (!it.isJsonObject()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (JsonElement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            object.add(it.getAsJsonObject());
        }
        List nodes = (List)destination$iv$iv;
        JsonElement jsonElement6 = discussions.get("pageInfo");
        if (jsonElement6 != null && (jsonElement6 = jsonElement6.getAsJsonObject()) != null) {
            JsonElement it4 = jsonElement6;
            boolean bl5 = false;
            v8 = new PageInfo(it4.get("hasNextPage").getAsBoolean(), it4.has("endCursor") && !it4.get("endCursor").isJsonNull() ? it4.get("endCursor").getAsString() : null);
        } else {
            v8 = pageInfo = new PageInfo(false, null);
        }
        if (pageInfo.getHasNextPage()) {
            List<JsonObject> remainingPages = this.getDiscussions(new GetDiscussionsOptions(options.getIssuable(), pageInfo.getEndCursor()), isMr);
            return CollectionsKt.plus((Collection)nodes, (Iterable)remainingPages);
        }
        Iterable $this$map$iv2 = nodes;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            JsonObject bl4 = (JsonObject)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl6 = false;
            object.add(GitlabUtilsKt.addHostToUrl((JsonObject)it5, namespaceWithPath, instanceUrl));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final JsonObject createNote(@NotNull JsonObject issuable, @NotNull String body, @Nullable String replyId) {
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String createNoteMutation = GitlabContantsKt.getNewCreateNoteMutation();
        Object object = new Pair[]{TuplesKt.to((Object)"issuableId", (Object)GitlabUtilsKt.getIssuableGqlId(issuable)), TuplesKt.to((Object)"body", (Object)body)};
        Object $this$createNote_u24lambda_u2438 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        String string = replyId;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$createNote_u24lambda_u2438.put("replyId", it);
        }
        if (GitlabBrowserEditorKt.isMr(issuable)) {
            JsonElement jsonElement;
            Object object2 = $this$createNote_u24lambda_u2438;
            String string2 = "mergeRequestDiffHeadSha";
            JsonElement it = jsonElement = issuable.get("sha");
            boolean bl3 = false;
            Object object3 = !it.isJsonNull() ? jsonElement : null;
            if (object3 == null || (object3 = object3.getAsString()) == null) {
                throw new IllegalArgumentException("SHA is required for merge requests");
            }
            Object object4 = object3;
            object2.put(string2, object4);
        }
        Object variables = object;
        JsonObject result2 = GitlabUtilsKt.graphqlRequest(createNoteMutation, (Map<String, ? extends Object>)variables, CockpitConfiguration.Companion.getInstance().getState().getGitlabHost());
        if (result2 == null) {
            throw new CustomException("Note creation failed: Note is null");
        }
        JsonArray errors = result2.get("createNote").getAsJsonObject().get("errors").getAsJsonArray();
        if (!errors.isEmpty()) {
            Intrinsics.checkNotNull((Object)errors);
            throw new Exception(CollectionsKt.joinToString$default((Iterable)((Iterable)errors), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        JsonObject jsonObject2 = result2.get("createNote").getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        return jsonObject2;
    }

    public static /* synthetic */ JsonObject createNote$default(GitlabService gitlabService, JsonObject jsonObject2, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return gitlabService.createNote(jsonObject2, string, string2);
    }

    @NotNull
    public final Map<String, Object> getBaseAndHeadUri(@NotNull JsonObject mr, @NotNull JsonObject mrVersion, @NotNull JsonObject file, @NotNull String repositoryPath) {
        Map<String, Object> map;
        Map<String, Object> map2;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        Intrinsics.checkNotNullParameter((Object)mrVersion, (String)"mrVersion");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        ReviewParams commonParams = new ReviewParams(null, null, repositoryPath, mr.get("project_id").getAsString(), mr.get("id").getAsString(), 3, null);
        String emptyFileUri = GitlabUtilsKt.toReviewUri(commonParams);
        JsonElement jsonElement = file.get("new_file");
        boolean bl = jsonElement != null ? jsonElement.getAsBoolean() : false;
        if (bl) {
            string2 = emptyFileUri;
        } else {
            Object object = file.get("old_path");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("old_path is missing");
            }
            Object object2 = mrVersion.get("base_commit_sha");
            if (object2 == null || (object2 = object2.getAsString()) == null) {
                throw new IllegalArgumentException("base_commit_sha is missing");
            }
            string2 = GitlabUtilsKt.toReviewUri(ReviewParams.copy$default(commonParams, (String)object, (String)object2, null, null, null, 28, null));
        }
        String baseFileUri = string2;
        JsonElement jsonElement2 = file.get("deleted_file");
        boolean bl2 = jsonElement2 != null ? jsonElement2.getAsBoolean() : false;
        if (bl2) {
            string = emptyFileUri;
        } else {
            Object object = file.get("new_path");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("new_path is missing");
            }
            Object object3 = mrVersion.get("head_commit_sha");
            if (object3 == null || (object3 = object3.getAsString()) == null) {
                throw new IllegalArgumentException("head_commit_sha is missing");
            }
            string = GitlabUtilsKt.toReviewUri(ReviewParams.copy$default(commonParams, (String)object, (String)object3, null, null, null, 28, null));
        }
        String headFileUri = string;
        Map<String, Object> emptyFileUriParams = GitlabUtilsKt.toReviewParams(commonParams);
        JsonElement jsonElement3 = file.get("new_file");
        boolean bl3 = jsonElement3 != null ? jsonElement3.getAsBoolean() : false;
        if (bl3) {
            map2 = emptyFileUriParams;
        } else {
            Object object = file.get("old_path");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("old_path is missing");
            }
            Object object4 = mrVersion.get("base_commit_sha");
            if (object4 == null || (object4 = object4.getAsString()) == null) {
                throw new IllegalArgumentException("base_commit_sha is missing");
            }
            map2 = GitlabUtilsKt.toReviewParams(ReviewParams.copy$default(commonParams, (String)object, (String)object4, null, null, null, 28, null));
        }
        Map<String, Object> baseFileObject = map2;
        JsonElement jsonElement4 = file.get("deleted_file");
        boolean bl4 = jsonElement4 != null ? jsonElement4.getAsBoolean() : false;
        if (bl4) {
            map = emptyFileUriParams;
        } else {
            Object object = file.get("new_path");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("new_path is missing");
            }
            Object object5 = mrVersion.get("head_commit_sha");
            if (object5 == null || (object5 = object5.getAsString()) == null) {
                throw new IllegalArgumentException("head_commit_sha is missing");
            }
            map = GitlabUtilsKt.toReviewParams(ReviewParams.copy$default(commonParams, (String)object, (String)object5, null, null, null, 28, null));
        }
        Map<String, Object> headFileObject = map;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"baseFileUri", (Object)baseFileUri), TuplesKt.to((Object)"headFileUri", (Object)headFileUri), TuplesKt.to((Object)"baseFileObject", baseFileObject), TuplesKt.to((Object)"headFileObject", headFileObject)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void getMrDiff(@NotNull CustomQuery signal, @NotNull com.intellij.openapi.project.Project project) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        void $this$getOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project project2 = this.getProjectByPath(GitlabUtilsKt.getGitlabPath(project));
        if (project2 == null) {
            return;
        }
        Project gitlabProject = project2;
        List<JsonObject> mrs = this.getIssuables(signal, gitlabProject);
        Object currentMr = null;
        Optional<Object> optional = mrs.stream().filter(arg_0 -> GitlabService.getMrDiff$lambda$40(arg_0 -> GitlabService.getMrDiff$lambda$39(signal, arg_0), arg_0)).findAny();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findAny(...)");
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            return;
        }
        currentMr = $this$getOrElse$iv.get();
        String string = project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        String rootFsPath = string;
        Object v2 = currentMr;
        Intrinsics.checkNotNullExpressionValue(v2, (String)"element");
        Iterable $this$filter$iv = this.getDiscussions(new GetDiscussionsOptions(v2, null, 2, null), true);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonObject it = (JsonObject)element$iv$iv;
            boolean bl = false;
            if (!GitlabUtilsKt.isTextDiffDiscussion(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List discussions = (List)destination$iv$iv;
        Iterable $this$map$iv = discussions;
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JsonObject bl = (JsonObject)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Object v3 = currentMr;
            Intrinsics.checkNotNullExpressionValue(v3, (String)"element");
            collection.add(GitlabUtilsKt.uriForDiscussion(rootFsPath, v3, (JsonObject)it).toString());
        }
        List allUrisWithComments = (List)destination$iv$iv2;
        Object v4 = currentMr;
        Intrinsics.checkNotNullExpressionValue(v4, (String)"element");
        JsonObject jsonObject2 = this.getMrVision(v4);
        Intrinsics.checkNotNull((Object)jsonObject2);
        JsonObject mrVersion = jsonObject2;
        Map<String, JsonObject> $i$f$map22 = versionCache;
        Object v6 = currentMr;
        Intrinsics.checkNotNullExpressionValue(v6, (String)"element");
        $i$f$map22.put(GitlabUtilsKt.restMrKey(v6), mrVersion);
        JsonArray jsonArray = mrVersion.getAsJsonArray("diffs");
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        Iterable $this$map$iv2 = (Iterable)jsonArray;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object it;
            void $this$getMrDiff_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447;
            JsonObject jsonObject3;
            JsonObject jsonObject4;
            Object object;
            Object headFileObject;
            Object baseFileObject;
            String headFileUri;
            String baseFileUri;
            JsonObject diff;
            block12: {
                block11: {
                    void diffElement;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    diff = diffElement.getAsJsonObject();
                    Object v8 = currentMr;
                    Intrinsics.checkNotNullExpressionValue(v8, (String)"element");
                    JsonObject jsonObject5 = v8;
                    Intrinsics.checkNotNull((Object)diff);
                    Map<String, Object> uris = INSTANCE.getBaseAndHeadUri(jsonObject5, mrVersion, diff, rootFsPath);
                    Object object2 = uris.get("baseFileUri");
                    baseFileUri = object2 != null ? object2.toString() : null;
                    Object object3 = uris.get("headFileUri");
                    headFileUri = object3 != null ? object3.toString() : null;
                    baseFileObject = uris.get("baseFileObject");
                    headFileObject = uris.get("headFileObject");
                    object = diff.get("new_path");
                    if (object == null || (object = object.getAsString()) == null) break block11;
                    Object it2 = object;
                    boolean bl3 = false;
                    String string2 = Paths.get((String)it2, new String[0]).getFileName() + " (!" + ((JsonObject)currentMr).get("iid").getAsString() + ")";
                    object = string2;
                    if (string2 != null) break block12;
                }
                object = "Unknown Diff";
            }
            Object diffName = object;
            boolean hasComment = CollectionsKt.contains((Iterable)allUrisWithComments, (Object)baseFileUri) || CollectionsKt.contains((Iterable)allUrisWithComments, (Object)headFileUri);
            JsonObject $this$getMrDiff_u24lambda_u2449_u24lambda_u2448 = jsonObject4 = diff.deepCopy();
            boolean bl = false;
            $this$getMrDiff_u24lambda_u2449_u24lambda_u2448.addProperty("hasComment", Boolean.valueOf(hasComment));
            JsonObject bl3 = jsonObject3 = new JsonObject();
            String string3 = "diffCommandParams";
            JsonObject jsonObject6 = $this$getMrDiff_u24lambda_u2449_u24lambda_u2448;
            boolean bl4 = false;
            if (baseFileObject != null) {
                boolean bl5 = false;
                $this$getMrDiff_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.add("baseFileObject", gson.toJsonTree(it));
            }
            if (headFileObject != null) {
                boolean bl6 = false;
                $this$getMrDiff_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.add("headFileObject", gson.toJsonTree(it));
            }
            $this$getMrDiff_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.addProperty("diffName", (String)diffName);
            Unit unit = Unit.INSTANCE;
            jsonObject6.add(string3, (JsonElement)jsonObject3);
            collection.add(jsonObject4);
        }
        List diffs2 = (List)destination$iv$iv3;
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)"issueMrConfig");
        Pair[] pairArray2 = new Pair[6];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)"get_diff");
        pairArray2[1] = TuplesKt.to((Object)"diffs", (Object)diffs2);
        pairArray2[2] = TuplesKt.to((Object)"sep", (Object)Paths.get("", new String[0]).getFileSystem().getSeparator());
        pairArray2[3] = TuplesKt.to((Object)"hasComment", (Object)(!((Collection)discussions).isEmpty() ? 1 : 0));
        Pair[] pairArray3 = new Pair[2];
        pairArray3[0] = TuplesKt.to((Object)"title", (Object)"Overview");
        Object[] objectArray = new Object[]{currentMr, rootFsPath};
        pairArray3[1] = TuplesKt.to((Object)"arguments", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray2[4] = TuplesKt.to((Object)"note", (Object)MapsKt.mapOf((Pair[])pairArray3));
        pairArray2[5] = TuplesKt.to((Object)"signal", (Object)signal);
        pairArray[1] = TuplesKt.to((Object)"config", (Object)MapsKt.mapOf((Pair[])pairArray2));
        ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), project);
    }

    @Nullable
    public final JsonObject getMrVision(@NotNull JsonObject mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        String mrIid = mr.get("iid").getAsString();
        String projectId = mr.get("project_id").getAsString();
        String baseUrl = CockpitConfiguration.Companion.getInstance().getState().getGitlabHost() + "/api/v4";
        String versionsPath = baseUrl + "/projects/" + projectId + "/merge_requests/" + mrIid + "/versions";
        String versionsResponse = this.fetch(versionsPath, "MR versions");
        JsonArray jsonArray = JsonParser.parseString((String)versionsResponse).getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        JsonArray versions = jsonArray;
        JsonElement jsonElement = (JsonElement)CollectionsKt.firstOrNull((Iterable)((Iterable)versions));
        if (jsonElement == null) {
            return null;
        }
        JsonElement lastVersion = jsonElement;
        String lastVersionId = lastVersion.getAsJsonObject().get("id").getAsString();
        String lastVersionPath = baseUrl + "/projects/" + projectId + "/merge_requests/" + mrIid + "/versions/" + lastVersionId;
        String lastVersionResponse = this.fetch(lastVersionPath, "MR diff");
        return JsonParser.parseString((String)lastVersionResponse).getAsJsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fetch(String path, String context) throws IOException {
        Request request = new Request.Builder().url(path).addHeader("Authorization", "Bearer " + CockpitConfiguration.Companion.getInstance().getState().getGitlabPAT()).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + context + ": " + response.code());
            }
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IOException("Empty response body for " + context);
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final HttpUrl.Builder baseUrlBuilderFrom(URL url) {
        HttpUrl.Builder builder2;
        HttpUrl.Builder builder3 = new HttpUrl.Builder();
        String string = url.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
        HttpUrl.Builder builder4 = builder3.scheme(string);
        String string2 = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
        HttpUrl.Builder $this$baseUrlBuilderFrom_u24lambda_u2451 = builder2 = builder4.host(string2);
        boolean bl = false;
        int n = url.getPort();
        boolean bl2 = 1 <= n ? n < 65536 : false;
        if (bl2) {
            $this$baseUrlBuilderFrom_u24lambda_u2451.port(url.getPort());
        }
        return builder2;
    }

    private static final int getDiscussionsAndLabelEvents$lambda$9(JsonObject a, JsonObject b) {
        int n;
        String string;
        String string2;
        Intrinsics.checkNotNull((Object)a);
        if (GitlabUtilsKt.isLabelEvent(a)) {
            it = var4_2 = a.get("created_at");
            boolean bl = false;
            Object object = !it.isJsonNull() ? var4_2 : null;
            string2 = object != null ? object.getAsString() : null;
        } else {
            it = var4_2 = a.get("createdAt");
            boolean bl = false;
            Object object = !it.isJsonNull() ? var4_2 : null;
            string2 = object != null ? object.getAsString() : null;
        }
        String aCreatedAt = string2;
        Intrinsics.checkNotNull((Object)b);
        if (GitlabUtilsKt.isLabelEvent(b)) {
            it = var5_3 = b.get("created_at");
            boolean bl = false;
            Object object = !it.isJsonNull() ? var5_3 : null;
            string = object != null ? object.getAsString() : null;
        } else {
            it = var5_3 = b.get("createdAt");
            boolean bl = false;
            Object object = !it.isJsonNull() ? var5_3 : null;
            string = object != null ? object.getAsString() : null;
        }
        String bCreatedAt = string;
        String string3 = aCreatedAt;
        if (string3 != null) {
            String string4 = bCreatedAt;
            if (string4 == null) {
                string4 = "";
            }
            n = string3.compareTo(string4);
        } else {
            n = -1;
        }
        return n;
    }

    private static final int getDiscussionsAndLabelEvents$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean getMrDiff$lambda$39(CustomQuery $signal, JsonObject it) {
        Integer n = $signal.getProjectMrId();
        return n != null && it.get("id").getAsInt() == n.intValue();
    }

    private static final boolean getMrDiff$lambda$40(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        versionCache = map;
        ExclusionStrategy[] exclusionStrategyArray = new ExclusionStrategy[]{new GsonExclusionStrategy()};
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setExclusionStrategies(exclusionStrategyArray).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GitlabService.gson = gson;
        exclusionStrategyArray = new ExclusionStrategy[]{new GsonExclusionStrategy()};
        Gson gson2 = new GsonBuilder().setExclusionStrategies(exclusionStrategyArray).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
        gsonNormal = gson2;
        client = ClientUtilsKt.generateOkHttpClientBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }
}

