/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.services.WebviewData;
import com.google.gson.Gson;
import com.intellij.DynamicBundle;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0005\u001a\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"injectEdgeWheelJS", "", "cefBrowser", "Lorg/cef/browser/CefBrowser;", "edgeWheelQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "executeInitJavaScript", "browser", "myJSQueryOpenInBrowser", "getLocaleStr", "", "coderider-kilo-jetbrains"})
public final class BrowserServiceKt {
    public static final void injectEdgeWheelJS(@Nullable CefBrowser cefBrowser, @NotNull JBCefJSQuery edgeWheelQuery) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)edgeWheelQuery, (String)"edgeWheelQuery");
            String js = StringsKt.trimIndent((String)("\n      (function() {\n        try {\n          if (window.__edgeWheelBound) return;\n          window.__edgeWheelBound = true;\n\n          const q = function(obj) { " + edgeWheelQuery.inject("JSON.stringify(obj)") + " };\n\n          function getDocScrollEl() {\n            return document.scrollingElement || document.documentElement || document.body;\n          }\n\n          function isScrollable(el) {\n            if (!el || el === document.body) return false;\n            const s = getComputedStyle(el);\n            const canY = /(auto|scroll)/.test(s.overflowY);\n            return canY && el.scrollHeight > el.clientHeight;\n          }\n\n          function getScrollTarget(start) {\n            let el = start;\n            while (el && el !== document.body) {\n              if (isScrollable(el)) return el;\n              el = el.parentElement;\n            }\n            return getDocScrollEl();\n          }\n\n          function tag(el) { return (el && el.tagName) ? el.tagName.toLowerCase() : ''; }\n\n          window.addEventListener('wheel', function(e) {\n            const scrollEl = getScrollTarget(e.target || null);\n\n            // \u53ea\u5728 tag === 'html' \u65f6\u4ee3\u7406\n            if (tag(scrollEl) !== 'html') return;\n\n            const top = scrollEl.scrollTop;\n            const view = scrollEl.clientHeight;\n            const height = scrollEl.scrollHeight;\n\n            const atTop = top <= 0;\n            const atBottom = Math.ceil(top + view) >= height;\n\n            const goingDown = e.deltaY > 0;\n            const goingUp = e.deltaY < 0;\n\n            if ((atBottom && goingDown) || (atTop && goingUp)) {\n              try { e.preventDefault(); } catch (_) {}\n              q({\n                command: 'edgeWheel',\n                dir: goingDown ? 'down' : 'up',\n                amount: Math.abs(e.deltaY)|0,\n                scrollTarget: { tag: 'html' }\n              });\n            }\n          }, { passive: false });\n        } catch(e) {}\n      })();\n    "));
            CefBrowser cefBrowser2 = cefBrowser;
            if (cefBrowser2 == null) break block0;
            cefBrowser2.executeJavaScript(js, cefBrowser.getURL(), 0);
        }
    }

    public static final void executeInitJavaScript(@Nullable CefBrowser browser, @NotNull JBCefJSQuery myJSQueryOpenInBrowser) {
        Intrinsics.checkNotNullParameter((Object)myJSQueryOpenInBrowser, (String)"myJSQueryOpenInBrowser");
        String script = StringsKt.trimIndent((String)("window.postIntellijMessage = function(msg) {\n                " + myJSQueryOpenInBrowser.inject("msg") + "\n            }"));
        CefBrowser cefBrowser = browser;
        if (cefBrowser != null) {
            cefBrowser.executeJavaScript(script, browser.getURL(), 0);
        }
        String languageHtmlScript = StringsKt.trimIndent((String)("window.getLanguage = function() {\n                return '" + BrowserServiceKt.getLocaleStr() + "'\n            }"));
        CefBrowser cefBrowser2 = browser;
        if (cefBrowser2 != null) {
            cefBrowser2.executeJavaScript(languageHtmlScript, browser.getURL(), 0);
        }
        CefBrowser cefBrowser3 = browser;
        String string = cefBrowser3 != null ? cefBrowser3.getURL() : null;
        Intrinsics.checkNotNull((Object)string);
        String webviewsAssetsUri = StringsKt.substringBeforeLast$default((String)string, (String)"/", null, (int)2, null) + "/assets";
        CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
        String loggedInUser = state.getUserName();
        WebviewData data = new WebviewData(webviewsAssetsUri, loggedInUser);
        Gson gson = new Gson();
        String webviewData = gson.toJson((Object)data);
        String configValue = StringsKt.trimIndent((String)("window.initialData = " + webviewData + ";\n        "));
        browser.executeJavaScript(configValue, browser.getURL(), 0);
    }

    @NotNull
    public static final String getLocaleStr() {
        Locale locale = DynamicBundle.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
        Locale locale2 = locale;
        String string = locale2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Hans", (boolean)false, (int)2, null)) {
            return "zh-cn";
        }
        String string2 = locale2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
        return string2;
    }
}

