/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.intellij.ui.jcef.JBCefBrowser;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0010J\u0016\u0010&\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0010J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014RE\u0010\u0015\u001a6\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0016j\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lcn/gitlab/kilo/jetbrains/services/AiCodeReviewForSingleFileHandler;", "", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "<init>", "(Lcom/intellij/ui/jcef/JBCefBrowser;)V", "getBrowser", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "cancel", "Lkotlin/Function0;", "", "getCancel", "()Lkotlin/jvm/functions/Function0;", "setCancel", "(Lkotlin/jvm/functions/Function0;)V", "head", "", "getHead", "()Ljava/lang/String;", "setHead", "(Ljava/lang/String;)V", "cache", "Ljava/util/LinkedHashMap;", "Lkotlin/Pair;", "Lcn/gitlab/kilo/jetbrains/utils/ChatParameters;", "Lcn/gitlab/kilo/jetbrains/services/GenerationCallbacks;", "Lkotlin/collections/LinkedHashMap;", "getCache", "()Ljava/util/LinkedHashMap;", "runningSet", "", "getRunningSet", "()Ljava/util/Set;", "handle", "chatParameters", "cb", "setHeader", "path", "addTask", "generateAiBatchActionsCallbacks", "responseType", "coderider-kilo-jetbrains"})
public final class AiCodeReviewForSingleFileHandler {
    @NotNull
    private final JBCefBrowser browser;
    @Nullable
    private Function0<Unit> cancel;
    @Nullable
    private String head;
    @NotNull
    private final LinkedHashMap<String, Pair<ChatParameters, GenerationCallbacks>> cache;
    @NotNull
    private final Set<String> runningSet;

    public AiCodeReviewForSingleFileHandler(@NotNull JBCefBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.browser = browser;
        this.cache = new LinkedHashMap();
        this.runningSet = new LinkedHashSet();
    }

    @NotNull
    public final JBCefBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final Function0<Unit> getCancel() {
        return this.cancel;
    }

    public final void setCancel(@Nullable Function0<Unit> function0) {
        this.cancel = function0;
    }

    @Nullable
    public final String getHead() {
        return this.head;
    }

    public final void setHead(@Nullable String string) {
        this.head = string;
    }

    @NotNull
    public final LinkedHashMap<String, Pair<ChatParameters, GenerationCallbacks>> getCache() {
        return this.cache;
    }

    @NotNull
    public final Set<String> getRunningSet() {
        return this.runningSet;
    }

    public final void handle(@NotNull ChatParameters chatParameters, @NotNull GenerationCallbacks cb) {
        Intrinsics.checkNotNullParameter((Object)chatParameters, (String)"chatParameters");
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        this.cancel = ChatHandler.getLLMClient$default(ChatHandler.INSTANCE, null, 1, null).chat(chatParameters, cb);
    }

    public final void setHeader(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.head = path;
        if (this.cache.get(path) != null && !this.runningSet.contains(path)) {
            Pair<ChatParameters, GenerationCallbacks> pair = this.cache.get(path);
            Intrinsics.checkNotNull(pair);
            Pair<ChatParameters, GenerationCallbacks> pair2 = pair;
            ChatParameters param = (ChatParameters)pair2.component1();
            GenerationCallbacks cb = (GenerationCallbacks)pair2.component2();
            this.runningSet.add(path);
            this.handle(param, cb);
        }
    }

    public final void addTask(@NotNull ChatParameters chatParameters, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)chatParameters, (String)"chatParameters");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ((Map)this.cache).put(path, new Pair((Object)chatParameters, (Object)this.generateAiBatchActionsCallbacks("aiCodeReviewForSingleFile", path)));
        if (this.head != null && Intrinsics.areEqual((Object)path, (Object)this.head)) {
            String string = this.head;
            Intrinsics.checkNotNull((Object)string);
            this.setHeader(string);
        }
    }

    private final GenerationCallbacks generateAiBatchActionsCallbacks(String responseType, String path) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)responseType), TuplesKt.to((Object)"aiResultText", null), TuplesKt.to((Object)"path", (Object)path), TuplesKt.to((Object)"status", (Object)"streaming")};
        Map response = MapsKt.mutableMapOf((Pair[])pairArray);
        return new GenerationCallbacks(response, this, path){
            final /* synthetic */ Map<String, String> $response;
            final /* synthetic */ AiCodeReviewForSingleFileHandler this$0;
            final /* synthetic */ String $path;
            {
                this.$response = $response;
                this.this$0 = $receiver;
                this.$path = $path;
            }

            public void onChange(String text, String reasonText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Map updatedResponse = MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"aiResultText", (Object)("**" + I18nKt.getMessage("content.generated.ai") + "**\n\n" + text))));
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)updatedResponse, this.this$0.getBrowser());
            }

            public void onComplete(String text, String reasonText) {
                Map completedResponse = MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"completed")));
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)completedResponse, this.this$0.getBrowser());
                this.this$0.getRunningSet().remove(this.$path);
            }

            public void onError(String text, Throwable error2) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                Map errorResponse = MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"failed")));
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)errorResponse, this.this$0.getBrowser());
                this.this$0.getRunningSet().remove(this.$path);
            }

            public void onSensitive() {
                Map sensitiveResponse = MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"sensitive")));
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)sensitiveResponse, this.this$0.getBrowser());
                this.this$0.getRunningSet().remove(this.$path);
            }

            public void metric(Long tokensIn, Long tokensOut) {
                GenerationCallbacks.DefaultImpls.metric(this, tokensIn, tokensOut);
            }
        };
    }
}

