/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.prompt;

import cn.gitlab.kilo.jetbrains.common.ChatMessage;
import cn.gitlab.kilo.jetbrains.common.Speaker;
import cn.gitlab.kilo.jetbrains.prompt.ChatPromptResult;
import cn.gitlab.kilo.jetbrains.prompt.ChatPrompter;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"forgeChatPrompt", "Lcn/gitlab/kilo/jetbrains/prompt/ChatPromptResult;", "msgs", "", "Lcn/gitlab/kilo/jetbrains/common/ChatMessage;", "useProjectMemory", "", "modelId", "", "project", "Lcom/intellij/openapi/project/Project;", "extractManualRulesFromMsgs", "", "extractManualRulesFromPrompt", "input", "coderider-kilo-jetbrains"})
public final class ChatPrompterKt {
    @NotNull
    public static final ChatPromptResult forgeChatPrompt(@NotNull List<? extends ChatMessage> msgs, boolean useProjectMemory, @NotNull String modelId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(msgs, (String)"msgs");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ChatPrompter(modelId, ChatPrompterKt.extractManualRulesFromMsgs(msgs)).prompt(msgs, useProjectMemory, project);
    }

    @NotNull
    public static final Set<String> extractManualRulesFromMsgs(@NotNull List<? extends ChatMessage> msgs) {
        Intrinsics.checkNotNullParameter(msgs, (String)"msgs");
        Set manualRules = new LinkedHashSet();
        for (ChatMessage chatMessage : msgs) {
            if (chatMessage.getSpeaker() != Speaker.human) continue;
            String string = chatMessage.getText();
            if (string == null) {
                string = "";
            }
            Set<String> manualRulesFromMsg = ChatPrompterKt.extractManualRulesFromPrompt(string);
            manualRules.addAll((Collection)manualRulesFromMsg);
        }
        return manualRules;
    }

    @NotNull
    public static final Set<String> extractManualRulesFromPrompt(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Regex regex = new Regex("<file[^>]*\\blabel=\"([^\"]+)\"[^>]*\\bpath=\"([^\"]+)\"[^>]*></file>");
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null);
        Set labels = new LinkedHashSet();
        for (MatchResult match : matches) {
            String label = (String)match.getGroupValues().get(1);
            labels.add(label);
        }
        return labels;
    }
}

